"""actionAdapter -- A base adapter for form actions"""

__author__  = 'Steve McMahon <steve@dcn.org>'
__docformat__ = 'plaintext'

from zope.interface import implements

from Products.PloneFormGen.config import PROJECTNAME

from AccessControl import ClassSecurityInfo

from Products.Archetypes.public import *
from Products.Archetypes.utils import shasattr

from Products.ATContentTypes.content.base import ATCTContent
from Products.ATContentTypes.content.schemata import ATContentTypeSchema
from Products.ATContentTypes.content.schemata import finalizeATCTSchema
from Products.ATContentTypes.content.base import registerATCT
from Products.CMFCore.permissions import View

from Products.PloneFormGen.interfaces import IPloneFormGenActionAdapter

FormAdapterSchema = ATContentTypeSchema.copy()
FormAdapterSchema['description'].schemata = 'metadata'
finalizeATCTSchema(FormAdapterSchema, folderish=True, moveDiscussion=False)


class FormActionAdapter(ATCTContent):
    """A base action adapter"""

    implements(IPloneFormGenActionAdapter)

    schema         =  FormAdapterSchema

    content_icon   = 'FormAction.gif'
    meta_type      = 'FormActionAdapter'
    portal_type    = 'FormActionAdapter'
    archetype_name = 'Form Action Adapter'

    immediate_view = 'base_view'
    default_view   = 'base_view'
    suppl_views = ()

    typeDescription= 'An adapter that supplies a form action.'

    global_allow = 0    

    security       = ClassSecurityInfo()


    def onSuccess(self, fields, REQUEST=None):
        """ called by form to invoke custom success processing """
        
        # fields will be a sequence of objects with an IPloneFormGenField interface
        
        pass
