from Products.CMFCore.permissions import setDefaultRoles
from Products.Archetypes.public import DisplayList

## The Project Name
PROJECTNAME = "PloneFormGen"

## The skins dir
SKINS_DIR = 'skins'


DEFAULT_MAILTEMPLATE_BODY = \
"""<html xmlns="http://www.w3.org/1999/xhtml">

  <head><title></title></head>

  <body>
    <p tal:content="here/body_pre | nothing" />
    <dl>
        <tal:block repeat="field options/fields">
        <tal:block tal:define="fname field/getName">
            <dt tal:content="field/widget/label" />
            <dd tal:content="python:request.form.get(fname, 'No Input')" />
        </tal:block>
        </tal:block>
    </dl>
    <p tal:content="here/body_post | nothing" />
    <pre tal:content="here/body_footer | nothing" />
  </body>
</html>
"""

MIME_LIST = DisplayList(
    (('html', 'HTML'),
     ('plain', 'TEXT'),
     ))


## Permission for content creation
ADD_CONTENT_PERMISSION = 'PloneFormGen: Add Content'
setDefaultRoles(ADD_CONTENT_PERMISSION, ('Manager', 'Owner',))

## Permission to use TALESField, ZPTField
EDIT_TALES_PERMISSION = 'PloneFormGen: Edit TALES Fields'
setDefaultRoles(EDIT_TALES_PERMISSION, ('Manager', 'Owner',))

## Permission to download saved data
DOWNLOAD_SAVED_PERMISSION = 'PloneFormGen: Download Saved Input'
setDefaultRoles(DOWNLOAD_SAVED_PERMISSION, ('Manager', 'Owner',))

## Globals variable
GLOBALS = globals()

fieldTypes = (
    'FormSelectionField',
    'FormMultiSelectionField',
    'FormLabelField',
    'FormDateField',
    'FormLinesField',
    'FormIntegerField',
    'FormBooleanField',
    'FormPasswordField',
    'FormFixedPointField',
    'FormStringField',
    'FormTextField',
    'FormRichTextField',
    'FormRichLabelField',
    'FormFileField',
)

adapterTypes = (
    'FormSaveDataAdapter',
    'FormMailerAdapter',
)

thanksTypes = (
    'FormThanksPage',
)
