## Script (Python) "languageSelectorData"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=
##title=
##
results = []

translations = {} # lang:[object, wfstate]
if context.isTranslatable():
    translations = context.getTranslations()

langtool = context.portal_languages
site_languages = langtool.listSupportedLanguages()
current_language = langtool.getPreferredLanguage()

for code, name in site_languages:
    current = code == current_language
    available = translations.has_key(code)
    alt = context.translate(msgid='label_switch_language_to',
                            default='Switch language to ${language}',
                            mapping={'language': name},
                            domain='linguaplone')
    if available:
        url = translations.get(code)[0].absolute_url()
    elif context.Language() == '':
        url = context.absolute_url()
        alt += context.translate(msgid='label_content_is_language_neutral',
                                 default=' (Content is language neutral)',
                                 domain='linguaplone')
    else:
        url = '%s/%s' % (context.absolute_url(), 'not_available_lang')
        alt += context.translate(msgid='label_content_translation_not_available',
                                 default=' (Content translation not available)',
                                 domain='linguaplone')
    url = '%s?set_language=%s' % (url, code)
    results.append({'Language':code, 'Title':name, 'current':current,
                    'available':available, 'change_url':url, 'alt':alt})
return results
