from Products.CMFCore.utils import ContentInit
from Products.CMFCore.DirectoryView import registerDirectory
from AccessControl import ModuleSecurityInfo

from Products.LinguaPlone.public import *
from Products.LinguaPlone import config
from Products.LinguaPlone import permissions
from Products.LinguaPlone.plone20 import safe_callable

# Make sure installer imports
from Products.LinguaPlone.Extensions import Install as _Install
del _Install

def initialize(context):
    # Apply monkey patches
    import patches

    # Register directory views
    registerDirectory('skins', config.GLOBALS)

    if config.INSTALL_DEMO_TYPES:
        import examples

    # Initialize content types
    content_types, constructors, ftis = process_types(
        listTypes(config.PKG_NAME), config.PKG_NAME)

    ContentInit(
        '%s Content' % config.PKG_NAME,
        content_types = content_types,
        permission = permissions.AddPortalContent,
        extra_constructors = constructors,
        fti = ftis,
    ).initialize(context)

    # Make some methods available for TTW code.
    msi = ModuleSecurityInfo('Products.LinguaPlone')
    msi.declarePublic('safe_callable')
