#################################################################################
#                                                                               #
#                       copyright (c) 2003 Ingeniweb SARL                       #
#                                                                               #
#################################################################################

"""I18N Folder main class"""


from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
import string

from Products.CMFCore.CMFCorePermissions import View, ManageProperties, ListFolderContents
from Products.CMFDefault.DublinCore import DefaultDublinCoreImpl
from Products.CMFCore.PortalContent import PortalContent
from Products.CMFPlone.PloneFolder import PloneFolder
from Products.CMFCore import CMFCorePermissions
from Products.CMFDefault import SkinnedFolder
from AccessControl import Permissions, getSecurityManager, ClassSecurityInfo, Unauthorized
    
from global_symbols import *

# I18NFolder definition
factory_type_information = {
  'id'             : 'I18NFolder',
  'portal_type'    : 'I18NFolder',
  'meta_type'      : 'I18NFolder',
  'description'    : 'A multilingual folder',
  'content_icon'   : 'i18nfolder_icon.gif',                          # Icon has to be acquired from a skin folder
  'product'        : 'I18NFolder',
  'factory'        : 'addI18NFolder',
  'immediate_view' : 'folder_contents',                          
  'filter_content_types' : 0,                                   # This is for folderish types
  'allowed_content_types': (),                                  # If filter_content_types is true, this field can hold allowed meta_types
  'actions': (
    { 'id'            : 'view'
    , 'name'          : 'View'
    , 'action'        : 'string:${folder_url}/'
    , 'permissions'   : (CMFCorePermissions.View,)
    , 'category'      : 'object'
    }
  , { 'id'            : 'local_roles'
    , 'name'          : 'Sharing'
    , 'action'        : 'string:${folder_url}/folder_localrole_form'
    , 'permissions'   : (I18NFolder_editPermission,)
    , 'category'      : 'object'
    }
  , { 'id'            : 'edit'
    , 'name'          : 'Properties'
    , 'action'        : 'string:${folder_url}/i18nfolder_edit_form'
    , 'permissions'   : (I18NFolder_editPermission,)
    , 'category'      : 'object'
    }
  , { 'id'            : 'folderlisting'
    , 'name'          : 'Folder Listing'
    , 'action'        : 'string:${folder_url}/folder_listing'
    , 'permissions'   : (CMFCorePermissions.View,)
    , 'category'      : 'object'
    , 'visible'       : 0
    }
  ),
  }

# The usual factory
def addI18NFolder(self, id, title = '', REQUEST = {}):
    """
    Factory method for an I18NFolder object
    """
    obj = I18NFolder(id, title)
    self._setObject(id, obj)

    if REQUEST.has_key('RESPONSE'):
        return REQUEST.RESPONSE.redirect('manage_main')


class I18NFolder (PloneFolder):
    """MinimalFolderishType class"""
    meta_type = factory_type_information['meta_type']                   # Has not to be the same as FTI but it is the most usual case.

    # Standard security settings
    security = ClassSecurityInfo()
    security.declareObjectProtected(CMFCorePermissions.View)            # $$$ Is this clever ? Isn't it better to make the object private ?


    # Dummy permission instanciation.
    # Permissions has to be "dummily" instanciated in order to be reachable for the factory_type_information structure.
    # In order to be very clear, we just declare each and every permission we use in this product.
    security.declareProtected(I18NFolder_editPermission, "dummyMethod_editPermission")

    # Init method
    def __init__(self, id, title=''):
        """__init__(self, id, title='')"""
        # NOTA : We shouldn't call parent's __init__ method as it would link to PortalFolder.__init__ and this
        # method sets 'self.id' and 'self.title' which is unuseful for us.
        self.id = id
        self.folder_languages = {}


    # Edit method (change this to suit your needs)
    # This edit method should only change attributes that are neither 'id' or metadatas.
    security.declareProtected(I18NFolder_editPermission, 'edit')
    def edit(self, title = '', description='', lang_code=None, REQUEST = {}):
        """
        edit(self, title = '', description='', lang_code=None, REQUEST = {}) => object modification method
        """
        
        # Get language code
        lang = lang_code
        
        if not lang:
            lang = self.getDefaultLanguage()
        
        # Build language object (title, description)
        language_object = self.getLanguageObject(lang)
        language_object['title'] = title
        language_object['description'] = description
        self.folder_languages[lang] = language_object
        
        # for persistency
        self.folder_languages = self.folder_languages

        if REQUEST is not None:
            return self.folder_contents(self, REQUEST, portal_status_message='Updated folder.')
        

    # Delete a folder language
    security.declareProtected(I18NFolder_editPermission, 'deleteFolderLanguages')
    def deleteFolderLanguages(self, lang_codes=[]):
        """
        deleteFolderLanguage(self, lang_codes=[])
        """
        
        # Delete specified language definition if exists
        for lang_code in lang_codes:
            if self.folder_languages.has_key(lang_code):
                del(self.folder_languages[lang_code])
                
        # for persistency
        self.folder_languages = self.folder_languages

    # getCurrentLanguage method
    def getCurrentLanguage(self):
        """
        getCurrentLanguage(self)
        """
        
        current_language = self.REQUEST.get('LANGUAGE', 'fr')
        
        return current_language

    # getLanguageObject method. Use fallback
    def getLanguageObject(self, lang_code=None):
        """
        getLanguageObject(self)
        """
        
        # Get current language object
        lang = lang_code
  
        use_fallback = 1
        
        if not lang:
            lang = self.getCurrentLanguage()
        else:
            use_fallback = 0
        
        langs = self.folder_languages.keys()
        
        # Fallback
        if use_fallback and lang not in langs:
            # 1 - Use default language
            lang = self.getDefaultLanguage()
            
            # 2 - Use first defined languages if exists
            if lang not in langs and len(langs) > 0:
               lang = langs[0]
            
        language_object = self.folder_languages.get(lang, None)
        
        if language_object is None:
            # Get en empty object
            language_object = {'title' : '',
                               'description' : ''}
        
        return language_object
    
    # Set title method
    def setTitle(self, title='', lang_code=None):
        """
        setTitle(self, title='', lang_code=None)
        """
        
        # Get language code
        lang = lang_code
        
        if not lang:
            lang = self.getDefaultLanguage()
        
        # Build language object
        language_object = self.getLanguageObject(lang)
        language_object['title'] = title
        self.folder_languages[lang] = language_object
        
        # for persistency
        self.folder_languages = self.folder_languages
            
    # Title method
    def Title(self, lang_code=None):
        """
        getTitle(self)
        """
        
        # Get language object
        language_object = self.getLanguageObject(lang_code)
        title = language_object['title']
        
        return title
    
    # title_or_id method    
    def title_or_id(self, lang_code=None):
        """
        title_or_id(self)
        """
        title = self.Title(lang_code)
        
        if title:
            return title
        else:
            return self.getId()
    
    
    # Set description method
    def setDescription(self, description='', lang_code=None):
        """
        setDescription(self, description='', lang_code=None)
        """
        
        # Get language code
        lang = lang_code
        
        if not lang:
            lang = self.getDefaultLanguage()
        
        # Build language object
        language_object = self.getLanguageObject(lang)
        language_object['description'] = description
        self.folder_languages[lang] = language_object
        
        # for persistency
        self.folder_languages = self.folder_languages
    
    # Description method
    def Description(self, lang_code=None):
        """
        getDescription(self)
        """
        
        # Get language object
        language_object = self.getLanguageObject(lang_code)
        description = language_object['description']
        
        return description
    
    
    # getLanguages method. Return a dictionnary of available languages
    def getLanguages(self):
        """
        getLanguages(self)
        """
        
        languages_list = []
        languages = {}
        
        # Test if portal_languages tool exists
        try:
            languages_list = self.portal_languages.listSupportedLanguages()
        except:
            # So use default languages list
            languages_list = self.availableLanguages()
        
        # Build dictionary    
        for language in languages_list:
            languages[language[0]] = language[1]
    
        return languages
        
    # getDefaultLanguage method
    def getDefaultLanguage(self):
        """
        getDefaultLanguage(self)
        """
        
        # Plone properties
        return self.portal_properties.site_properties.default_language
        
    # getDefinedLanguages method
    def getDefinedLanguages(self):
        """
        getDefinedLanguages(self)
        """
        
        defined_languages = {}
        languages = self.getLanguages()
        
        # Fill defined languages dictionnary
        for code in self.folder_languages.keys():
            try:
                defined_languages[code] = languages[code]
            except:
                pass
        return defined_languages
        
    # getUndefinedLanguages method
    def getUndefinedLanguages(self):
        """
        getUndefinedLanguages(self)
        """
        
        defined_languages = self.folder_languages.keys()
        undefined_languages = self.getLanguages()
        
        # Delete defined languages from undefined_languages
        for code in defined_languages:
            del(undefined_languages[code])
            
        return undefined_languages
    
    # This method comes from PloneFolder class.
    security.declareProtected(Permissions.access_contents_information, 'listFolderContents')
    def listFolderContents( self, spec=None, contentFilter=None, suppressHiddenFiles=0 ): 
        """
        Hook around 'contentValues' to let 'folder_contents'
        be protected.  Duplicating skip_unauthorized behavior of dtml-in.
        
        In the world of Plone we do not want to show objects that begin with a .
        So we have added a simply check.  We probably dont want to raise an
        Exception as much as we want to not show it.
        
        """

        items = self.contentValues(spec=spec, filter=contentFilter)
        l = []
        for obj in items:
            id = obj.getId()
            v = obj
            try:
                if suppressHiddenFiles and id[:1]=='.': 
                    raise Unauthorized(id, v)
                if getSecurityManager().validate(self, self, id, v):
                    l.append(obj)
            except (Unauthorized, 'Unauthorized'):
                pass
        return l

    # Add all languages in catalog
    security.declareProtected(View, 'SearchableText')
    def SearchableText(self):
        "Returns a concatination of all searchable text"
        search = []
        
        for language in self.getDefinedLanguages().keys():
            language_object = self.folder_languages.get(language, None)
            
            if language_object:
               title = language_object['title']
               description = language_object['description']
               
               if title:
                  search.append(title)
                  
               if description:
                  search.append(description)
            
        ret = string.join(search, ' ')
        
        return ret


# Class instanciation
InitializeClass(I18NFolder)


