###
# FCKEditor2-Installer-Script
###

from Products.FCKeditor import config
from Products.FCKeditor.config import *
from StringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.DirectoryView import addDirectoryViews
from Products.StandardCacheManagers.AcceleratedHTTPCacheManager import AcceleratedHTTPCacheManager

SKIN_NAME = "fckeditor"


# add FCK HTTPCache
# editor cached for all users 20 days
def install_cache(self, out):

 if 'FckHTTPCache' not in self.objectIds():
      self._setObject('FckHTTPCache',AcceleratedHTTPCacheManager('FckHTTPCache'))
      cache_settings={'anonymous_only' : 0,  'notify_urls' : (), 'interval' :1728000 } 
      self.FckHTTPCache.manage_editProps('FCK Http Cache', settings=cache_settings)
      print >>out, "Added FCKeditor HTTP Cache"





def install_plone(self, out):
    """ add FCK Editor to 'my preferences' """
    portal_props=getToolByName(self,'portal_properties')
    site_props=getattr(portal_props,'site_properties', None)
    attrname='available_editors'
    if site_props is not None:
        editors=list(site_props.getProperty(attrname)) 
        if 'FCKeditor' not in editors:
           editors.append('FCKeditor')
        if 'FCK Editor' in editors:
           editors.remove('FCK Editor')
        site_props._updateProperty(attrname, editors)        
        print >>out, "Added FCKeditor.Plone 2.2 to available editors in Plone."
    portal = getToolByName(self, 'portal_url').getPortalObject()
    try:
        portal.portal_controlpanel.registerConfiglet(**fckeditor_configlet)
        print >>out, "Added FCKeditor.Plone 2.2 configlet in Plone Control Panel."
    except:
        pass

    try:
        portal.portal_controlpanel.registerConfiglet(**fckeditor_member_prefs)
        print >>out, "Added FCKeditor member preferences in Plone Control Panel."
    except:
        pass    
    install_global_properties(self, out)
    install_member_properties(self, out)



def install_member_properties(self, out):
    mdtool = getToolByName(self, 'portal_memberdata')
    for prop, tp, val in config.memberData_properties:
        if not mdtool.hasProperty(prop):
            mdtool._setProperty(prop, val, tp)

    print >> out, "Successfully installed FCK Editor member properties."


def install_global_properties(self, out):
    # install fckeditor global properties
    if not hasattr(self.portal_properties, 'fckeditor_properties'):
        self.portal_properties.addPropertySheet(
            'fckeditor_properties', 'FCK Editor properties')

    props = self.portal_properties.fckeditor_properties
    for prop, tp, val in config.fckeditor_properties:
        if not props.hasProperty(prop):
            props._setProperty(prop, val, tp)

    print >> out, "Successfully installed FCK Editor global properties."


def install_subskin(self, out, skin_name=SKIN_NAME, globals=GLOBALS):
    skinstool=getToolByName(self, 'portal_skins')
    if skin_name not in skinstool.objectIds():
        addDirectoryViews(skinstool, 'skins', globals)

    for skinName in skinstool.getSkinSelections():
        path = skinstool.getSkinPath(skinName) 
        path = [i.strip() for i in  path.split(',')]
        try:
            if skin_name not in path:
                path.insert(path.index('custom') +1, skin_name)
        except ValueError:
            if skin_name not in path:
                path.append(skin_name)  

        path = ','.join(path)
        skinstool.addSkinSelection( skinName, path)



def install(self):
    out = StringIO()
    print >>out, "Installing FCKeditor 2.2 in your site"
    
    install_cache(self, out)

    # plone specific installation
    try:
        import Products.CMFPlone
    except ImportError:
        pass
    else:
        install_plone(self, out)

    install_subskin(self, out)

    print >>out, "FCKeditor 2.2 installation done."
    
    return out.getvalue()


def uninstall(self):
    out = StringIO()

    # remove configlet from plone control panel
    configTool = getToolByName(self, 'portal_controlpanel', None)
    if configTool:
        configTool.unregisterConfiglet('fckeditor_configlet')
        out.write('FCK Editor Configlet removed from Plone Control Panel\n')
        configTool.unregisterConfiglet('fckeditor_member_prefs')
        out.write('FCK Editor Member Preferences removed from Plone Control Panel\n')
