# (C) Copyright 2005 Nuxeo SARL <http://nuxeo.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Id: test_proxybtree.py 21936 2005-05-30 15:06:48Z atchertchian $
"""Tests for the btree proxies."""

import unittest
from Products.BTreeFolder2.tests.testBTreeFolder2 import BTreeFolder2Tests

from Products.CPSCore.ProxyBase import ProxyBTreeFolder
from Products.CPSCore.ProxyBase import ProxyBTreeFolderishDocument


class ProxyBTreeFolderTest(BTreeFolder2Tests):

    def setUp(self):
        self.f = ProxyBTreeFolder('root')
        ff = ProxyBTreeFolder('item')
        self.f._setOb(ff.id, ff)
        self.ff = self.f._getOb(ff.id)

    def testCheckId(self):
        self.assertEqual(self.f._checkId('xyz'), None)

    def test_proxy_presence(self):
        # XXX: test if proxy exists, using __nonzero__ method
        proxy = ProxyBTreeFolder('truc')
        self.assert_(proxy)

    # skip base testWrapped test
    def testWrapped(self):
        pass


class ProxyBTreeFolderishDocumentTest(BTreeFolder2Tests):

    def setUp(self):
        self.f = ProxyBTreeFolderishDocument('root')
        ff = ProxyBTreeFolderishDocument('item')
        self.f._setOb(ff.id, ff)
        self.ff = self.f._getOb(ff.id)

    def testCheckId(self):
        self.assertEqual(self.f._checkId('xyz'), None)

    def test_proxy_presence(self):
        # XXX: test if proxy exists, using __nonzero__ method
        proxy = ProxyBTreeFolderishDocument('tt')
        self.assert_(proxy)

    # skip base testWrapped test
    def testWrapped(self):
        pass


def test_suite():
    return unittest.TestSuite((
        unittest.makeSuite(ProxyBTreeFolderTest),
        unittest.makeSuite(ProxyBTreeFolderishDocumentTest),
        ))

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
