##parameters=redirect=0, REQUEST=None

mcat = context.Localizer.cpscalendar
if not int(redirect):
    if REQUEST:
        REQUEST = context.REQUEST

    mtool = context.portal_membership
    if not mtool.checkPermission('View', context):
        # Not authorized but we don't want to raise this error
        # since CMF will redirect it to the login form
        # and we want basic HTTP auth here
        RESPONSE = REQUEST.RESPONSE
        realm = RESPONSE.realm
        RESPONSE.setStatus(401)
        RESPONSE.setHeader('WWW-Authenticate', 'basic realm="%s"' % realm, 1)
        RESPONSE.setBody("""<html>
<head><title>Unauthorized</title></head>
<body>
You are not authorized to access this ressource
</body>
</html>""")
        return

ical_conv = '%Y%m%dT%H%M%SZ'
ical_date_conv = '%Y%m%d'

def icalvalue(s):
    return unicode('\\,'.join(s.split(',')), 'latin1').encode('UTF-8')

header = """BEGIN:VCALENDAR
CALSCALE:GREGORIAN
X-WR-TIMEZONE;VALUE=TEXT:Europe/Paris
PRODID:-//Nuxeo//CPSCalendar 0.1//EN
X-WR-CALNAME;VALUE=TEXT:%s
X-WR-RELCALID;VALUE=TEXT:%s
VERSION:2.0
""" % (icalvalue(mcat(context.title_or_id())), context.absolute_url())

footer = """\
END:VCALENDAR
"""

message = header

events = context.objectValues('Event')
dtstamp = DateTime('UTC')
timezone = dtstamp.localZone()

event_header = """\
BEGIN:VEVENT
DTSTAMP:%s
""" % (dtstamp.strftime(ical_conv), )

event_footer = """\
END:VEVENT
"""

for event in events:
    eventfrom = event.from_date.toZone('UTC').strftime(ical_conv)
    eventto = event.to_date.toZone('UTC').strftime(ical_conv)
    
    message += event_header

    message += """\
SUMMARY:%s
UID:%s
""" % (icalvalue(mcat(event.title_or_id())), event.absolute_url())

    if event.location:
        message += """\
LOCATION:%s
""" % (icalvalue(event.location), )

    if event.event_type == 'event_allday':
        message += """\
DTSTART;VALUE=DATE:%s
DTEND;VALUE=DATE:%s
""" % (event.from_date.strftime(ical_date_conv),
        (event.to_date+1).strftime(ical_date_conv))
    elif event.event_type == 'event_tofrom':
        message += """\
DTSTART:%s
DTEND:%s
""" % (eventfrom, eventto)
    elif event.event_type == "event_recurring":
        message += 'DTSTART:%s\nRRULE:FREQ=' % eventfrom
        if event.recurrence_period == 'period_daily':
            message += 'DAILY;'
        elif event.recurrence_period == 'period_weekly':
            message += 'WEEKLY;'
        elif event.recurrence_period == 'period_monthly':
            message += 'MONTHLY;'
        elif event.recurrence_period == 'period_quarterly':
            message += 'MONTLY;PERIOD=3;'
        elif event.recurrence_period == 'period_yearly':
            message += 'YEARLY;'
        else:
            raise "Unknown recurrance period", event.recurrence_period
        message += 'UNTIL=%s\n' % (eventto)
            

    message += event_footer

message += footer

#OK, it seems to have worked fine. Set the content type and return
if REQUEST is not None:
    REQUEST.RESPONSE.setHeader('Content-Type', 'text/calendar')

return message
