# -*- coding: iso-8859-1 -*-

"""
ATSchemaEditorNG

(C) 2003,2004, Andreas Jung, ZOPYX Software Development and Consulting
and Contributors
D-72070 T�bingen, Germany

Contact: andreas@andreas-jung.com

License: see LICENSE.txt

$Id: config.py 9433 2005-07-08 01:24:40Z rafrombrc $
"""
from Products.Archetypes.Field import *
from Products.Archetypes.Widget import *
from Products.Archetypes.Storage import *

SKINS_DIR = 'skins'
GLOBALS = globals()
PROJECT_NAME = PKG_NAME = 'ATSchemaEditorNG'
TOOL_NAME = 'schema_editor_tool'

# Permissions
ManageSchemaPermission = 'ATSE: Manage schema'

# Update mode
# True: Schema Editor changes are not persistent.
# The Schema of the object is kept in sync with
# the one defined on the filesystem.
# ATTENTION: Setting this property to True can
# lead to a complete data loss!!
# Never activate it on production systems
ALWAYS_SYNC_SCHEMA_FROM_DISC = False

# constants used for the 'atse_managed' field attribute
ATSE_MANAGED_FULL = 1
ATSE_MANAGED_NONE = 0

#XXX merge these into one data structure, duh

TYPE_MAP = {
'StringField':     StringField,
'IntegerField':    IntegerField,
'FloatField':      FloatField,
'FixedPointField': FixedPointField,
'BooleanField':    BooleanField,
'LinesField':      LinesField,
'DateTimeField':   DateTimeField,
'ReferenceField':  ReferenceField,
'ComputedField':   ComputedField,
'ImageField':      ImageField,
}

FIELD_INFO = ('StringField',
              'IntegerField',
              'FloatField',
              'FixedPointField',
              'LinesField',
              'DateTimeField',
              'BooleanField',
              'ReferenceField',
              'ComputedField',
              'ImageField')

WIDGET_REGISTRY_INFO = (
('String',      {'widget':StringWidget(), 'visible':True, 'useVocab':False}),
('Textarea',    {'widget':TextAreaWidget(), 'visible':True, 'useVocab':False,
                 'size_macro':'here/atse_macros/macros/row_col_size'}),
('Radio',       {'widget':SelectionWidget(format='radio'), 'visible':True,
                 'useVocab':True}),
('Select',      {'widget':SelectionWidget(format='select'), 'visible':True,
                 'useVocab':True}),
('Flex',        {'widget':SelectionWidget(format='flex'), 'visible':True,
                 'useVocab':True, 'size_macro':'here/atse_macros/macros/row_col_size'}),
('Lines',       {'widget':LinesWidget(), 'visible':True, 'useVocab':False}),
('Calendar',    {'widget':CalendarWidget(), 'visible':True, 'useVocab':False}),
('Boolean',     {'widget':BooleanWidget(), 'visible':True, 'useVocab':False}),
('MultiSelect', {'widget':MultiSelectionWidget(), 'visible':True, 'useVocab':True}),
('Richtext',    {'widget':RichWidget(), 'visible':True, 'useVocab':False}),
('Password',    {'widget':PasswordWidget(), 'visible':True, 'useVocab':False}),
('Visual',      {'widget':VisualWidget(), 'visible':True, 'useVocab':False}),
('Epoz',        {'widget':EpozWidget(), 'visible':True, 'useVocab':False}),
('Picklist',    {'widget':PicklistWidget(), 'visible':True, 'useVocab':True}),
('InAndOut',    {'widget':InAndOutWidget(), 'visible':True, 'useVocab':True}),
('Image',       {'widget':ImageWidget(), 'visible':True, 'useVocab':False}),
('Integer',     {'widget':IntegerWidget(), 'visible':False, 'useVocab':False}),
('Decimal',     {'widget':DecimalWidget(), 'visible':False, 'useVocab':False}),
('Keywords',    {'widget':KeywordWidget(), 'visible':False, 'useVocab':False}),
('Reference',   {'widget':ReferenceWidget(), 'visible':False, 'useVocab':False}),
('Computed',    {'widget':ComputedWidget()}),
)

STORAGE_REGISTRY_INFO = (
  ('Attribute', {'storage':AttributeStorage(), 'visible':True}),
)
