package Zim::GUI::PropertiesDialog;

use strict;
use File::BaseDir qw/xdg_data_files xdg_data_dirs xdg_data_home/;
use Gtk2;
use Zim::Utils;
use Zim::GUI::Component;

our $VERSION = '0.23';
our @ISA = qw/Zim::GUI::Component/;

=head1 NAME

Zim::GUI::PropertiesDialog - dialog for zim

=head1 DESCRIPTION

This module contains the preferences dialog for zim.
It is autoloaded when needed.

=head1 METHODS

=over 4

=item C<show()>

Present the dialog.

=cut

sub show {
	my $self = shift;
	my $app = $self->{app};
	my $settings = $self->{app}{settings};
	
	my $dialog = Gtk2::Dialog->new(
		__("Properties"), $app->{window}, #. dialog title
	       	[qw/destroy-with-parent no-separator/],
		'gtk-help'   => 'help',
		'gtk-cancel' => 'cancel',
		'gtk-ok'     => 'ok',
	);
	$dialog->set_resizable(0);
	
	my $tabs = Gtk2::Notebook->new;
	$dialog->vbox->add($tabs);
	
	## Notebook tab
	my $vbox1 = Gtk2::VBox->new(0,5);
	$vbox1->set_border_width(5);
	$tabs->append_page($vbox1, 'Notebook');
	
	my @fields = qw/name icon home file_root/;
	my %data = (
		name        => [__('Name'),          'string' ], #. input
		icon        => [__('Icon'),          'file'   ], #. input
		home        => [__('Home Page'),     'page'   ], #. input
		file_root   => [__('Document Root'), 'dir'    ], #. input
	);

	my $config = $self->{app}{notebook}->config;
	push @{$data{$_}}, $$config{$_} for keys %data; # set values

	my ($table, $entries) = $self->new_form(\@fields, \%data, $dialog);

	my $checkbox = Gtk2::CheckButton->new(
		__('Slow file system') ); #. check box
	$checkbox->set_active($$config{slow_fs});
	$table->attach_defaults($checkbox, 0,1, 4,5);

	$vbox1->pack_start($table,0,1,0);
	
	## Show it all
	$dialog->show_all;
	while ($_ = $dialog->run) {
		if ($_ eq 'help') {
			$app->ShowHelp(':zim:usage:properties');
			next;
		}
		last unless $_ eq 'ok';
		
		for my $i (0 .. $#fields) {
			my $string = $$entries[$i]->get_text;
			my $k = $fields[$i];
			if ($k eq 'icon' or $k eq 'file_root') {
				$string = Zim::File->rel_path(
					$string, $self->{app}{notebook}{dir}
					) || $string;
			}
			$$config{$k} = $string;
		}
		$$config{'slow_fs'} = $checkbox->get_active || 0;
		$self->{app}{notebook}->save;
		$self->{app}->set_home($$config{home})
			if defined $$config{home};

		last;
	}
	$dialog->destroy;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

