require Test::Simple;
use strict;

my %API = (
	read_pages => {
		modules => [qw/Zim Zim::Selection/],
		methods => [qw/
			list_pages
			resolve_name resolve_page get_page
		/],
		#get_selection search
	},
	write_pages => {
		modules => [qw/Zim Zim::Repository Zim::Repository::Files/],
		methods => [qw/copy_page move_page delete_page/],
	},
);

open LIST, 'MANIFEST' or die $!;
while (<LIST>) {
	chomp;
	s#^lib/## or next;
	s#\.\w+##;
	s#/#::#g;
	push @{$API{read_pages}{modules}}, $_
		if m#^Zim::Repository#;
}
close LIST;

my $t = 0;
$t += scalar @{$_->{modules}} for values %API;
Test::Simple->import(tests => $t);

for my $api (keys %API) {
	my @m = @{$API{$api}{methods}};
	for my $mod (@{$API{$api}{modules}}) {
		eval "require $mod"; die $@ if $@;
		my $report = '';
		for my $m (@m) {
			$report .= "#\tFailed $m\(\)\n" unless $mod->can($m);
		}
		warn "# $mod fails '$api' API\n", $report if length $report;
		ok($report eq '', "$mod supports '$api' API");
	}
}

