package Zim::GUI::SearchDialog;

use strict;
use Gtk2;
use Gtk2::SimpleList;

our $VERSION = '0.17';

=head1 NAME

Zim::GUI::SearchDialog - simple module

=head1 SYNOPSIS

FIXME simple code example

=head1 DESCRIPTION

FIXME descriptve text

=head1 METHODS

=over 4

=item C<new()>

Simple constructor

=cut

sub new {
	my ($class, %self) = @_;
	bless \%self, $class;
}

=item C<show()>

=cut

sub show {
	my $self = shift;
	my $query = shift;
	
	## Setup dialog
	my $dialog = Gtk2::Dialog->new(
		'Search - Zim', $self->{app}{window},
		[qw/destroy-with-parent no-separator/],
		'gtk-help'   => 'help',
		'gtk-close' => 'close',
	);
	$dialog->set_border_width(5);
	$dialog->set_default_size(250,300);
	$dialog->set_icon($self->{app}{window}->get_icon);
	
	my $vbox = Gtk2::VBox->new(0,5);
	$vbox->set_border_width(12);
	$dialog->vbox->pack_start($vbox, 0,1,0);
	
	my $hbox = Gtk2::HBox->new(0,5);
	$vbox->add($hbox);

	$hbox->add( Gtk2::Label->new('Search:') );
	my $string_entry = Gtk2::Entry->new();
	$string_entry->signal_connect(
		activate => sub { $dialog->response('ok') } );
	$hbox->add( $string_entry );
	my $find_button = Gtk2::Button->new_from_stock('gtk-find');
	$find_button->signal_connect(clicked => sub { $dialog->response('ok') } );
	$hbox->add($find_button);

	my $case_box = Gtk2::CheckButton->new_with_label('Match Case');
	$vbox->add($case_box);
	my $word_box = Gtk2::CheckButton->new_with_label('Whole word');
	$vbox->add($word_box);
	
	my $swindow = Gtk2::ScrolledWindow->new();
	$swindow->set_policy('automatic', 'automatic');
	$swindow->set_shadow_type('in');
	$dialog->vbox->add($swindow);
	
	my $list = Gtk2::SimpleList->new(Page => 'text', Rank => 'int');
	$list->get_column(0)->set_expand(1);
	$list->get_column(0)->set_sort_column_id(0);
	$list->get_column(1)->set_sort_column_id(1);
	$list->get_model->set_sort_column_id(1 => 'descending');
	$list->signal_connect(button_release_event => \&on_button_release_event);
	$swindow->add($list);
	
	$dialog->signal_connect(response => sub {
		my ($dialog, $response) = @_;
		#warn "$response\n";
		$self->{position} = [ $dialog->get_position ];

		if ($response eq 'help') {
			$self->{app}->ShowHelp(':zim:usage:searching');
			return;
		}
		elsif ($response ne 'ok') {
			$dialog->destroy;
			$self->{dialog} = undef;
			return;
		}

		my $query = {
			string => $string_entry->get_text,
			case   => $case_box->get_active,
			word   => $word_box->get_active,
		} ;
		return unless $$query{string} =~ /\S/;
		if ($$query{string} =~ /:/) { # back links - FIXME does not belong here
			my $page = $self->{app}{repository}->resolve_page($$query{string});
			return unless $page;
			@{$list->{data}} = map [$_, 1], $page->_list_backlinks();
		}
		else {
			@{$list->{data}} = ();
			my $callback = sub {
				push @{$list->{data}}, @_ if @_;
				while (Gtk2->events_pending) {
					Gtk2->main_iteration_do(0);
				}
			};
			$self->{app}{repository}->search($query, $callback);
		}
	} );

	$list->signal_connect(row_activated => sub {
		my ($i) = $list->get_selected_indices;
		my ($name) = @{$list->{data}[$i]};
		$self->{app}->link_clicked($name);
	} );

	if (length $query) {
		$string_entry->set_text($query);
		$dialog->response('ok');
	}
	
	$dialog->show_all;
	$dialog->move( @{$self->{position}} ) if $self->{position};
	$self->{dialog} = $dialog;
}

=item C<hide()>

=cut

sub hide {
	return unless $_[0]->{dialog};
	$_[0]->{position} = [ $_[0]->{dialog}->get_position ];
	$_[0]->{dialog}->destroy;
	$_[0]->{dialog} = undef;
}

=item C<search(QUERY)>

=cut

sub search {
	my $self = shift;
	$self->show(@_);
}

sub on_button_release_event {
	my ($slist, $event) = @_;
	return 0 if $event->type ne 'button-release';
	
	my ($x, $y) = $event->get_coords;
	my ($path, $column) = $slist->get_path_at_pos($x, $y);
	return 0 unless $path;
	
	if ($event->button == 1) { # single-click navigation
		return 0 unless $slist->get_selection->path_is_selected($path);
		$slist->row_activated($path, $column);
	}
	
	return 0;
}


1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

