use Test::Simple tests => 7;

use Zim::Repository::Files;
use File::Spec;

$Zim::CODESET = 'utf8';

my $dir = File::Spec->rel2abs( File::Spec->catdir(qw/t repository/) );
my $rep = Zim::Repository::Files->new(undef, '', $dir);

ok($rep->{format} eq 'wiki');

ok($rep->file('foo:bar')->path eq File::Spec->catfile($dir, qw/foo bar.txt/),
	'filename 1' );

my $page = $rep->get_page(':foo:bar');
ok($page->status eq 'new', 'status new page');
ok(@{$page->get_parse_tree} > 2, 'template');
ok($page->{format} eq 'Zim::Formats::Wiki', 'format');

ok($rep->file('Test:wiki')->path eq File::Spec->catfile($dir, qw/Test_files wiki.txt/),
	'filename 2' );

ok($rep->resolve_page('test:WIKI')->name eq ':Test:wiki', 'resolve_page');

#$page = $rep->open_page('test:utf8-acchars');

