package Zim::Components::SearchDialog;

use strict;
use Gtk2;
use Gtk2::SimpleList;

our $VERSION = '0.15';

=head1 NAME

Zim::Components::SearchDialog - simple module

=head1 SYNOPSIS

FIXME simple code example

=head1 DESCRIPTION

FIXME descriptve text

=head1 EXPORT

None by default.

=head1 METHODS

=over 4

=item C<new()>

Simple constructor

=cut

sub new {
	my ($class, %self) = @_;
	bless \%self, $class;
}

=item C<show()>

=cut

sub show {
	my $self = shift;
	my $query = shift;
	
	## Setup dialog
	my $dialog = Gtk2::Dialog->new(
		'Search - Zim', $self->{app}{window},
		[qw/destroy-with-parent no-separator/],
		#'gtk-help'   => 'help',
		'gtk-cancel' => 'cancel',
		'gtk-find'   => 'ok',
	);
	$dialog->set_border_width(5);
	$dialog->set_default_size(1,275);
	$dialog->set_icon($self->{app}{window}->get_icon);
	
	my $table = Gtk2::Table->new(1, 2);
	$table->set_border_width(5);
	$table->set_row_spacings(5);
	$table->set_col_spacings(12);
	$dialog->vbox->pack_start($table, 0,1,0);

	my %entries;
	my $label = Gtk2::Label->new('Search:');
	my $entry = Gtk2::Entry->new();
	$entry->signal_connect(activate => sub { $dialog->response('ok') });
	$table->attach_defaults($label, 0,1, 0,1);
	$table->attach_defaults($entry, 1,2, 0,1);
	$entries{search} = $entry;

	$dialog->show_all;
	$dialog->move( @{$self->{position}} ) if $self->{position};

	my $swindow = Gtk2::ScrolledWindow->new();
	$swindow->set_policy('automatic', 'automatic');
	$swindow->set_shadow_type('in');
	$dialog->vbox->add($swindow);
	
	my $list = Gtk2::SimpleList->new(Page => 'text', Rank => 'int');
	$list->get_column(0)->set_expand(1);
	$list->get_column(0)->set_sort_column_id(0);
	$list->get_column(1)->set_sort_column_id(1);
	$list->get_model->set_sort_column_id(1 => 'descending');
	$swindow->add($list);
	
	$dialog->signal_connect(response => sub {
		my ($dialog, $response) = @_;
		#warn "$response\n";
		$self->{position} = [ $dialog->get_position ];
		return $dialog->destroy unless $response eq 'ok';

		my $query = $entries{search}->get_text;
		$list->show;
		@{$list->{data}} = ($query =~ /:/)
			? (map [$_, 1], $self->{app}{repository}->resolve_page($query)->_list_backlinks())
			: $self->{app}{repository}->search($query) ;
	} );

	$list->signal_connect(row_activated => sub {
		my ($i) = $list->get_selected_indices;
		my ($name) = @{$list->{data}[$i]};
		$self->{app}->link_clicked($name);
	} );

	$self->{dialog} = $dialog;
	$dialog->show_all;
	
	if (length $query) {
		$entry->set_text($query);
		$dialog->response('ok');
	}
}

=item C<hide()>

=cut

sub hide {
	return unless $_[0]->{dialog};
	$_[0]->{position} = [ $_[0]->{dialog}->get_position ];
	$_[0]->{dialog}->destroy;
	$_[0]->{dialog} = undef;
}

=item C<search(QUERY)>

=cut

sub search {
	my $self = shift;
	$self->show(@_);
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

