use Test::Simple tests => 6;

use Zim::Repository;
use File::Spec;

my $dir = File::Spec->rel2abs( File::Spec->catdir(qw/t repository/) );
my $rep = Zim::Repository->new('', $dir);

ok($rep->{formatter} eq 'Zim::Formats::Wiki');


ok($rep->filename('foo:bar') eq File::Spec->catfile($dir, qw/foo bar.txt/),
	'filename 1' );

my $page = $rep->load_page('foo:bar');
ok($page->status eq 'new', 'status new page');
ok(@{$page->parse_tree} > 2, 'template');

ok($rep->filename('Test:wiki') eq File::Spec->catfile($dir, qw/Test_files wiki.txt/),
	'filename 2' );

ok($rep->resolve_page('test:WIKI') eq ':Test:wiki', 'resolve_page');
