/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import IceInternal.LocatorInfo;
import IceInternal.LocatorTable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class LocatorManager {
    private Hashtable _table = new Hashtable();
    private Hashtable _locatorTables = new Hashtable();

    LocatorManager() {
    }

    synchronized void destroy() {
        Enumeration enumeration = this._table.elements();
        while (enumeration.hasMoreElements()) {
            LocatorInfo locatorInfo = (LocatorInfo)enumeration.nextElement();
            locatorInfo.destroy();
        }
        this._table.clear();
        this._locatorTables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorInfo get(LocatorPrx locatorPrx) {
        if (locatorPrx == null) {
            return null;
        }
        LocatorPrx locatorPrx2 = LocatorPrxHelper.uncheckedCast(locatorPrx.ice_locator(null));
        LocatorManager locatorManager = this;
        synchronized (locatorManager) {
            LocatorInfo locatorInfo = (LocatorInfo)this._table.get(locatorPrx2);
            if (locatorInfo == null) {
                LocatorTable locatorTable = (LocatorTable)this._locatorTables.get(locatorPrx2.ice_getIdentity());
                if (locatorTable == null) {
                    locatorTable = new LocatorTable();
                    this._locatorTables.put(locatorPrx2.ice_getIdentity(), locatorTable);
                }
                locatorInfo = new LocatorInfo(locatorPrx2, locatorTable);
                this._table.put(locatorPrx2, locatorInfo);
            }
            return locatorInfo;
        }
    }
}

