// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

#include <Ice/Ice.h>
#include <TestI.h>
#include <TestCommon.h>

#if defined(ICE_USE_OPENSSL)
#  include <IceSSL/OpenSSL.h>
#endif

DEFINE_TEST("server")

using namespace std;

int
run(int argc, char** argv, const Ice::CommunicatorPtr& communicator)
{
    string testdir;
#if !defined(__APPLE__) || TARGET_OS_IPHONE == 0
    if(argc < 2)
    {
        cerr << "Usage: " << argv[0] << " testdir" << endl;
        return 1;
    }
    testdir = string(argv[1]) + "/../certs";
#else
    testdir = "certs";
#endif

    communicator->getProperties()->setProperty("TestAdapter.Endpoints", getTestEndpoint(communicator, 0, "tcp"));
    Ice::ObjectAdapterPtr adapter = communicator->createObjectAdapter("TestAdapter");
    Ice::Identity id = Ice::stringToIdentity("factory");
    adapter->add(ICE_MAKE_SHARED(ServerFactoryI, testdir), id);
    adapter->activate();
    TEST_READY
    communicator->waitForShutdown();
    return EXIT_SUCCESS;
}

int
main(int argc, char* argv[])
{
#ifdef ICE_STATIC_LIBS
    Ice::registerIceSSL(false);
    Ice::registerIceWS(true);
#endif

    int status;
    Ice::CommunicatorPtr communicator;

    try
    {
        Ice::InitializationData initData = getTestInitData(argc, argv);
        communicator = Ice::initialize(argc, argv, initData);
        status = run(argc, argv, communicator);
    }
    catch(const Ice::Exception& ex)
    {
        cerr << ex << endl;
        status = EXIT_FAILURE;
    }

    if(communicator)
    {
        communicator->destroy();
    }

    return status;
}
