RB_PACKAGES=\
  libzeroc-ice-ruby1.8

RB_PREFIX=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr
RB_RBDIR = $(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)$(shell ruby1.8 -e \
	'require "rbconfig"; puts Config::expand("$$(rubylibdir)")')
RB_LIBDIR = $(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)$(shell ruby1.8 -e \
	'require "rbconfig"; puts Config::expand("$$(archdir)")')

debian/stamp-build-rb:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	RUBY=ruby1.8 \
	OPTIMIZE=$(OPTIMIZE) UNAME=$(UNAME) \
	LP64=yes lp64suffix= \
	prefix=/usr -j $(PROCESSORS)
debian/stamp-build-rb:: debian/stamp-build-cpp
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C rb all; \
	fi
	:> $@

debian/stamp-install-rb:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	RUBY=ruby1.8 \
	LP64=yes lp64suffix= UNAME=$(UNAME) \
	prefix=$(RB_PREFIX) \
	install_rubydir=$(RB_RBDIR) \
	install_rblibdir=$(RB_LIBDIR) \
	install_slicedir=$(RB_PREFIX)/share/Ice-$(V)/slice -j $(PROCESSORS)
debian/stamp-install-rb::
	-mkdir -p $(RB_RBDIR) $(RB_LIBDIR)
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C rb install ; \
	fi
	:> $@

.PHONY: build/rb install/rb

build/rb:: debian/stamp-build-cpp debian/stamp-build-rb
install/rb:: debian/stamp-install-rb

$(patsubst %,build/%,$(RB_PACKAGES)) :: build/% : build/rb
$(patsubst %,install/%,$(RB_PACKAGES)) :: install/% : install/rb

clean::
	$(MAKE) UNAME=$(UNAME) -C rb clean
	$(RM) debian/stamp-build-rb debian/stamp-install-rb
