#!/usr/bin/env python
# **********************************************************************
#
# Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

import os, sys

for toplevel in [".", "..", "../..", "../../..", "../../../.."]:
    toplevel = os.path.normpath(toplevel)
    if os.path.exists(os.path.join(toplevel, "python", "Ice.py")):
        break
else:
    raise "can't find toplevel directory!"

import Ice
Ice.loadSlice('Test.ice')
import Test, AllTests

class TestClient(Ice.Application):
    def run(self, args):
        obj = AllTests.allTests(self.communicator(), False)
        obj.shutdown()
        return 0

app = TestClient()
sys.exit(app.main(sys.argv))
