/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.PluginInitializationException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class Context {
    private CipherExpression[] _ciphers;
    private boolean _allCiphers;
    private boolean _noCiphers;
    private SSLContext _ctx;
    private KeyStore _keys;
    private KeyStore _certs;
    static final /* synthetic */ boolean $assertionsDisabled;

    Context(String ciphers, String keystore, String password, String keystorePassword, String certs, String certsPassword, SecureRandom rand) throws GeneralSecurityException {
        ArrayList<CipherExpression> cipherList = new ArrayList<CipherExpression>();
        if (ciphers.length() > 0) {
            String[] expr = ciphers.split("[ \t]+");
            for (int i = 0; i < expr.length; ++i) {
                PluginInitializationException ex;
                if (expr[i].equals("ALL")) {
                    if (i != 0) {
                        ex = new PluginInitializationException();
                        ex.reason = "IceSSL: `ALL' must be first in cipher list `" + ciphers + "'";
                        throw ex;
                    }
                    this._allCiphers = true;
                    continue;
                }
                if (expr[i].equals("NONE")) {
                    if (i != 0) {
                        ex = new PluginInitializationException();
                        ex.reason = "IceSSL: `NONE' must be first in cipher list `" + ciphers + "'";
                        throw ex;
                    }
                    this._noCiphers = true;
                    continue;
                }
                CipherExpression ce = new CipherExpression();
                String exp = expr[i];
                if (exp.charAt(0) == '!') {
                    ce.not = true;
                    if (exp.length() > 1) {
                        exp = exp.substring(1);
                    } else {
                        PluginInitializationException ex2 = new PluginInitializationException();
                        ex2.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                        throw ex2;
                    }
                }
                if (exp.charAt(0) == '(') {
                    if (!exp.endsWith(")")) {
                        PluginInitializationException ex3 = new PluginInitializationException();
                        ex3.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                        throw ex3;
                    }
                    try {
                        ce.re = Pattern.compile(exp.substring(1, exp.length() - 2));
                    }
                    catch (PatternSyntaxException ex4) {
                        PluginInitializationException e = new PluginInitializationException();
                        e.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                        e.initCause(ex4);
                        throw e;
                    }
                } else {
                    ce.cipher = exp;
                }
                cipherList.add(ce);
            }
            this._ciphers = new CipherExpression[cipherList.size()];
            cipherList.toArray(this._ciphers);
        }
        String ksType = KeyStore.getDefaultType();
        KeyManager[] keyManagers = null;
        if (keystore != null && keystore.length() > 0) {
            this._keys = KeyStore.getInstance(ksType);
            try {
                char[] pass = null;
                if (keystorePassword != null && keystorePassword.length() > 0) {
                    pass = keystorePassword.toCharArray();
                }
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(keystore));
                this._keys.load(bis, pass);
            }
            catch (IOException ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to load keystore from `" + keystore + "'";
                e.initCause(ex);
                throw e;
            }
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(this._keys, password.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        TrustManager[] trustManagers = null;
        if (certs != null && certs.length() > 0) {
            this._certs = KeyStore.getInstance(ksType);
            try {
                char[] pass = null;
                if (certsPassword != null && certsPassword.length() > 0) {
                    pass = certsPassword.toCharArray();
                }
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certs));
                this._certs.load(bis, pass);
            }
            catch (IOException ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to load keystore from `" + certs + "'";
                e.initCause(ex);
                throw e;
            }
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(this._certs);
            trustManagers = tmf.getTrustManagers();
        }
        this._ctx = SSLContext.getInstance("SSL");
        this._ctx.init(keyManagers, trustManagers, rand);
    }

    SSLContext sslContext() {
        return this._ctx;
    }

    String[] filterCiphers(String[] supportedCiphers, String[] defaultCiphers) {
        int i;
        LinkedList<String> result = new LinkedList<String>();
        if (this._allCiphers) {
            for (i = 0; i < supportedCiphers.length; ++i) {
                result.add(supportedCiphers[i]);
            }
        } else if (!this._noCiphers) {
            for (i = 0; i < defaultCiphers.length; ++i) {
                result.add(defaultCiphers[i]);
            }
        }
        if (this._ciphers != null) {
            for (i = 0; i < this._ciphers.length; ++i) {
                CipherExpression ce = this._ciphers[i];
                if (ce.not) {
                    Iterator e = result.iterator();
                    while (e.hasNext()) {
                        String cipher = (String)e.next();
                        if (ce.cipher != null) {
                            if (!ce.cipher.equals(cipher)) continue;
                            e.remove();
                            continue;
                        }
                        if (!$assertionsDisabled && ce.re == null) {
                            throw new AssertionError();
                        }
                        Matcher m = ce.re.matcher(cipher);
                        if (!m.find()) continue;
                        e.remove();
                    }
                    continue;
                }
                if (ce.cipher != null) {
                    result.add(0, ce.cipher);
                    continue;
                }
                if (!$assertionsDisabled && ce.re == null) {
                    throw new AssertionError();
                }
                for (int j = 0; j < supportedCiphers.length; ++j) {
                    Matcher m = ce.re.matcher(supportedCiphers[j]);
                    if (!m.find()) continue;
                    result.add(0, supportedCiphers[j]);
                }
            }
        }
        String[] arr = new String[result.size()];
        result.toArray(arr);
        return arr;
    }

    static {
        $assertionsDisabled = !Context.class.desiredAssertionStatus();
    }

    private static class CipherExpression {
        boolean not;
        String cipher;
        Pattern re;

        private CipherExpression() {
        }
    }
}

