/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.Logger;
import Ice.MarshalException;
import Ice.NoEndpointException;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceUtil.StringUtil;
import java.util.Map;

public class IndirectReference
extends RoutableReference {
    private String _adapterId;
    private String _connectionId = "";
    private LocatorInfo _locatorInfo;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndirectReference(Instance inst, Communicator com, Identity ident, Map ctx, String fs, int md, boolean sec, String adptid, RouterInfo rtrInfo, LocatorInfo locInfo, boolean collocationOpt) {
        super(inst, com, ident, ctx, fs, md, sec, rtrInfo, collocationOpt);
        this._adapterId = adptid;
        this._locatorInfo = locInfo;
    }

    public final LocatorInfo getLocatorInfo() {
        return this._locatorInfo;
    }

    public final String getAdapterId() {
        return this._adapterId;
    }

    public EndpointI[] getEndpoints() {
        return new EndpointI[0];
    }

    public Reference changeLocator(LocatorPrx newLocator) {
        if (newLocator == null) {
            return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), new EndpointI[0], this.getRouterInfo(), this.getCollocationOptimization());
        }
        LocatorInfo newLocatorInfo = this.getInstance().locatorManager().get(newLocator);
        if (newLocatorInfo == this._locatorInfo || this._locatorInfo != null && newLocatorInfo != null && newLocatorInfo.equals(this._locatorInfo)) {
            return this;
        }
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        r._locatorInfo = newLocatorInfo;
        return this;
    }

    public Reference changeCompress(boolean newCompress) {
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        if (this._locatorInfo != null) {
            LocatorPrx newLocator = LocatorPrxHelper.uncheckedCast(this._locatorInfo.getLocator().ice_compress(newCompress));
            r._locatorInfo = this.getInstance().locatorManager().get(newLocator);
        }
        return r;
    }

    public Reference changeTimeout(int newTimeout) {
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        if (this._locatorInfo != null) {
            LocatorPrx newLocator = LocatorPrxHelper.uncheckedCast(this._locatorInfo.getLocator().ice_timeout(newTimeout));
            r._locatorInfo = this.getInstance().locatorManager().get(newLocator);
        }
        return r;
    }

    public Reference changeConnectionId(String id) {
        if (this._connectionId.equals(id)) {
            return this;
        }
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        r._connectionId = id;
        return r;
    }

    public Reference changeAdapterId(String newAdapterId) {
        if (this._adapterId.equals(newAdapterId)) {
            return this;
        }
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        r._adapterId = newAdapterId;
        return r;
    }

    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        if (newEndpoints == null || newEndpoints.length == 0) {
            return this;
        }
        return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), newEndpoints, this.getRouterInfo(), this.getCollocationOptimization());
    }

    public void streamWrite(BasicStream s) throws MarshalException {
        super.streamWrite(s);
        s.writeSize(0);
        s.writeString(this._adapterId);
    }

    public String toString() {
        String result = super.toString();
        if (this._adapterId.length() == 0) {
            return result;
        }
        StringBuffer s = new StringBuffer();
        s.append(result);
        s.append(" @ ");
        String a = StringUtil.escapeString(this._adapterId, null);
        if (StringUtil.findFirstOf(a, " \t\n\r") != -1) {
            s.append('\"');
            s.append(a);
            s.append('\"');
        } else {
            s.append(a);
        }
        return s.toString();
    }

    public ConnectionI getConnection(BooleanHolder comp) {
        ConnectionI connection;
        while (true) {
            EndpointI[] endpts = super.getRoutedEndpoints();
            BooleanHolder cached = new BooleanHolder(false);
            if (endpts.length == 0 && this._locatorInfo != null) {
                endpts = this._locatorInfo.getEndpoints(this, cached);
            }
            for (int i = 0; i < endpts.length; ++i) {
                endpts[i] = endpts[i].connectionId(this._connectionId);
            }
            EndpointI[] filteredEndpoints = this.filterEndpoints(endpts);
            if (filteredEndpoints.length == 0) {
                NoEndpointException ex = new NoEndpointException();
                ex.proxy = this.toString();
                throw ex;
            }
            try {
                OutgoingConnectionFactory factory = this.getInstance().outgoingConnectionFactory();
                connection = factory.create(filteredEndpoints, comp);
                if (!$assertionsDisabled && connection == null) {
                    throw new AssertionError();
                }
            }
            catch (LocalException ex) {
                if (this.getRouterInfo() == null) {
                    if (!$assertionsDisabled && this._locatorInfo == null) {
                        throw new AssertionError();
                    }
                    this._locatorInfo.clearCache(this);
                    if (cached.value) {
                        TraceLevels traceLevels = this.getInstance().traceLevels();
                        Logger logger = this.getInstance().logger();
                        if (traceLevels.retry < 2) continue;
                        String s = "connection to cached endpoints failed\nremoving endpoints from cache and trying one more time\n" + ex;
                        logger.trace(traceLevels.retryCat, s);
                        continue;
                    }
                }
                throw ex;
            }
            break;
        }
        if (this.getRouterInfo() != null) {
            connection.setAdapter(this.getRouterInfo().getAdapter());
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        return connection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndirectReference)) {
            return false;
        }
        IndirectReference rhs = (IndirectReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        if (!this._adapterId.equals(rhs._adapterId)) {
            return false;
        }
        if (!this._connectionId.equals(rhs._connectionId)) {
            return false;
        }
        return this._locatorInfo == null ? rhs._locatorInfo == null : this._locatorInfo.equals(rhs._locatorInfo);
    }

    static {
        $assertionsDisabled = !IndirectReference.class.desiredAssertionStatus();
    }
}

