/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import java.util.Arrays;
import java.util.Map;

public class DirectReference
extends RoutableReference {
    private EndpointI[] _endpoints;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DirectReference(Instance inst, Communicator com, Identity ident, Map ctx, String fs, int md, boolean sec, EndpointI[] endpts, RouterInfo rtrInfo, boolean collocationOpt) {
        super(inst, com, ident, ctx, fs, md, sec, rtrInfo, collocationOpt);
        this._endpoints = endpts;
    }

    public String getAdapterId() {
        return "";
    }

    public EndpointI[] getEndpoints() {
        return this._endpoints;
    }

    public Reference changeLocator(LocatorPrx newLocator) {
        if (newLocator != null) {
            LocatorInfo newLocatorInfo = this.getInstance().locatorManager().get(newLocator);
            return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), "", null, newLocatorInfo, this.getCollocationOptimization());
        }
        return this;
    }

    public Reference changeCompress(boolean newCompress) {
        DirectReference r = (DirectReference)this.getInstance().referenceFactory().copy(this);
        EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
        for (int i = 0; i < this._endpoints.length; ++i) {
            newEndpoints[i] = this._endpoints[i].compress(newCompress);
        }
        r._endpoints = newEndpoints;
        return r;
    }

    public Reference changeTimeout(int newTimeout) {
        DirectReference r = (DirectReference)this.getInstance().referenceFactory().copy(this);
        EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
        for (int i = 0; i < this._endpoints.length; ++i) {
            newEndpoints[i] = this._endpoints[i].timeout(newTimeout);
        }
        r._endpoints = newEndpoints;
        return r;
    }

    public Reference changeConnectionId(String connectionId) {
        DirectReference r = (DirectReference)this.getInstance().referenceFactory().copy(this);
        EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
        for (int i = 0; i < this._endpoints.length; ++i) {
            newEndpoints[i] = this._endpoints[i].connectionId(connectionId);
        }
        r._endpoints = newEndpoints;
        return r;
    }

    public Reference changeAdapterId(String newAdapterId) {
        if (newAdapterId == null || newAdapterId.length() == 0) {
            return this;
        }
        LocatorInfo locatorInfo = this.getInstance().locatorManager().get(this.getInstance().referenceFactory().getDefaultLocator());
        return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), newAdapterId, this.getRouterInfo(), locatorInfo, this.getCollocationOptimization());
    }

    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        if (Arrays.equals(newEndpoints, this._endpoints)) {
            return this;
        }
        DirectReference r = (DirectReference)this.getInstance().referenceFactory().copy(this);
        r._endpoints = newEndpoints;
        return r;
    }

    public void streamWrite(BasicStream s) throws MarshalException {
        super.streamWrite(s);
        s.writeSize(this._endpoints.length);
        if (this._endpoints.length > 0) {
            for (int i = 0; i < this._endpoints.length; ++i) {
                this._endpoints[i].streamWrite(s);
            }
        } else {
            s.writeString("");
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString());
        for (int i = 0; i < this._endpoints.length; ++i) {
            String endp = this._endpoints[i].toString();
            if (endp == null || endp.length() <= 0) continue;
            s.append(':');
            s.append(endp);
        }
        return s.toString();
    }

    public ConnectionI getConnection(BooleanHolder comp) {
        EndpointI[] filteredEndpoints;
        EndpointI[] endpts = super.getRoutedEndpoints();
        if (endpts.length == 0) {
            endpts = this._endpoints;
        }
        if ((filteredEndpoints = this.filterEndpoints(endpts)).length == 0) {
            NoEndpointException ex = new NoEndpointException();
            ex.proxy = this.toString();
            throw ex;
        }
        OutgoingConnectionFactory factory = this.getInstance().outgoingConnectionFactory();
        ConnectionI connection = factory.create(filteredEndpoints, comp);
        if (this.getRouterInfo() != null) {
            connection.setAdapter(this.getRouterInfo().getAdapter());
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        return connection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DirectReference)) {
            return false;
        }
        DirectReference rhs = (DirectReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        return Arrays.equals(this._endpoints, rhs._endpoints);
    }

    static {
        $assertionsDisabled = !DirectReference.class.desiredAssertionStatus();
    }
}

