/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Properties;
import IceInternal.BasicStream;

public final class DefaultsAndOverrides {
    public final String defaultHost;
    public final String defaultProtocol;
    public final String defaultRouter;
    public final String defaultLocator;
    public final boolean defaultCollocationOptimization;
    public final boolean overrideTimeout;
    public final int overrideTimeoutValue;
    public final boolean overrideConnectTimeout;
    public final int overrideConnectTimeoutValue;
    public final boolean overrideCompress;
    public final boolean overrideCompressValue;

    DefaultsAndOverrides(Properties properties) {
        this.defaultProtocol = properties.getPropertyWithDefault("Ice.Default.Protocol", "tcp");
        String value = properties.getProperty("Ice.Default.Host");
        this.defaultHost = value.length() != 0 ? value : null;
        this.defaultRouter = properties.getProperty("Ice.Default.Router");
        value = properties.getProperty("Ice.Override.Timeout");
        if (value.length() > 0) {
            this.overrideTimeout = true;
            this.overrideTimeoutValue = properties.getPropertyAsInt("Ice.Override.Timeout");
        } else {
            this.overrideTimeout = false;
            this.overrideTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.ConnectTimeout");
        if (value.length() > 0) {
            this.overrideConnectTimeout = true;
            this.overrideConnectTimeoutValue = properties.getPropertyAsInt("Ice.Override.ConnectTimeout");
        } else {
            this.overrideConnectTimeout = false;
            this.overrideConnectTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.Compress");
        if (value.length() > 0) {
            boolean b;
            this.overrideCompress = true;
            boolean bl = b = properties.getPropertyAsInt("Ice.Override.Compress") > 0;
            if (!BasicStream.compressible() && b) {
                System.err.println("warning: bzip2 support not available, Ice.Override.Compress ignored");
                b = false;
            }
            this.overrideCompressValue = b;
        } else {
            this.overrideCompress = !BasicStream.compressible();
            this.overrideCompressValue = false;
        }
        this.defaultLocator = properties.getProperty("Ice.Default.Locator");
        this.defaultCollocationOptimization = properties.getPropertyAsIntWithDefault("Ice.Default.CollocationOptimization", 1) > 0;
    }
}

