/****************************************************************************
**  Copyright (c) 2013, Adel Kara Slimane, the ZeGrapher project <contact@zegrapher.com>
**
**  This file is part of the ZeGrapher project, version 2.0.
**
**  ZeGrapher is free software: you may copy, redistribute and/or modify it
**  under the terms of the GNU General Public License as published by the
**  Free Software Foundation, either version 3 of the License, or (at your
**  option) any later version.
**
**  This file is distributed in the hope that it will be useful, but
**  WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/


#ifndef FENTABLEAUVALEURS_H
#define FENTABLEAUVALEURS_H


#include "informations.h"
#include "valuestable.h"

namespace Ui {
    class FenTableauValeurs;
}

class FenTableauValeurs : public QWidget
{
    Q_OBJECT

public:
    explicit FenTableauValeurs(Informations *info);

protected slots:
    void addValuesTable();
    void removeTable(ValuesTable *table);

protected:
    QHBoxLayout *tablesLayout;
    QList<ValuesTable*> valuesTableList;
    Informations *informations;   
    QWidget *widget;

    /*
    void setCalculator(Calcul *calc);
    void setInfoClass(Informations *info);

public slots:
    void appliquer();
    void setPrecision(int prec);

private slots:    
    void fromCurrentWindow();
    void manual();
    void semiAutomatic();
    void manuelClicked(bool etat);
    void nouvelleFenetreClicked(bool etat);
    void funcSeqItemChanged(QStandardItem *item);
    void parametricItemChanged(QStandardItem *item);   
    bool updateRange();
    void updateWithNewRange();
    void addEntries(QList<QStandardItem *> &liste);
    void manualParEq();
    void fillFromRange();


protected:

    void addFuncValues();
    void addSeqValues();

    Informations *informations;
    Ui::FenTableauValeurs *ui;    
    QStandardItemModel *funcSeqModel;
    QStandardItemModel *parametricModel;
    StructFenetre fenetre;
    Calcul *calculator;
    QStringList funcsNameList;
    QStringList seqsNameList;
    QTableView *tableView;
    short precision, colonne;
    QList <FuncMap> funcMaps;
    QList <double> xValues;
    QFont bold;
    QBrush blueBackground;
    QTimer timer;
    Range fillRange;

    bool funcsState[6];
    bool seqsState[6];
    */
};

#endif // FENTABLEAUVALEURS_H
