/*
 * Written by Oron Peled <oron@actcom.co.il>
 * Copyright (C) 2004-2005, Xorcom
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#  warning "This module is tested only with 2.6 kernels"
#endif

#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/module.h>
#include <zaptel.h>
#include "zap_debug.h"

static const char rcsid[] = "$Id: zap_debug.c 949 2006-02-15 02:24:18Z kpfleming $";

#define	P_(x)	[ x ] = { .value = x, .name = #x, }
static	struct {
	int value;
	char *name;
} poll_names[] = {
	P_(POLLIN),
	P_(POLLPRI),
	P_(POLLOUT),
	P_(POLLERR),
	P_(POLLHUP),
	P_(POLLNVAL),
	P_(POLLRDNORM),
	P_(POLLRDBAND),
	P_(POLLWRNORM),
	P_(POLLWRBAND),
	P_(POLLMSG),
	P_(POLLREMOVE)
};
#undef	P_

void dump_poll(int print_dbg, const char *msg, int poll)
{
	int	i;

	for(i = 0; i < ARRAY_SIZE(poll_names); i++) {
		if(poll & poll_names[i].value)
			DBG("%s: %s\n", msg, poll_names[i].name);
	}
}

#define	E_(x)	[ x ] = { .value = x, .name = #x, }
static	struct {
	int	value;
	char	*name;
} zt_event_names[] = {
	E_(ZT_EVENT_NONE),
	E_(ZT_EVENT_ONHOOK),
	E_(ZT_EVENT_RINGOFFHOOK),
	E_(ZT_EVENT_WINKFLASH),
	E_(ZT_EVENT_ALARM),
	E_(ZT_EVENT_NOALARM),
	E_(ZT_EVENT_ABORT),
	E_(ZT_EVENT_OVERRUN),
	E_(ZT_EVENT_BADFCS),
	E_(ZT_EVENT_DIALCOMPLETE),
	E_(ZT_EVENT_RINGERON),
	E_(ZT_EVENT_RINGEROFF),
	E_(ZT_EVENT_HOOKCOMPLETE),
	E_(ZT_EVENT_BITSCHANGED),
	E_(ZT_EVENT_PULSE_START),
	E_(ZT_EVENT_TIMER_EXPIRED),
	E_(ZT_EVENT_TIMER_PING),
	E_(ZT_EVENT_POLARITY)
};
#undef	E_

char *event2str(int event)
{
	BUG_ON(event > ARRAY_SIZE(zt_event_names));
	return zt_event_names[event].name;
}

#define	S_(x)	[ x ] = { .value = x, .name = #x, }
static	struct {
	int	value;
	char	*name;
} zt_sig_types[] = {
	S_(ZT_SIG_NONE),
	S_(ZT_SIG_FXSLS),
	S_(ZT_SIG_FXSGS),
	S_(ZT_SIG_FXSKS),
	S_(ZT_SIG_FXOLS),
	S_(ZT_SIG_FXOGS),
	S_(ZT_SIG_FXOKS),
	S_(ZT_SIG_EM),
	S_(ZT_SIG_CLEAR),
	S_(ZT_SIG_HDLCRAW),
	S_(ZT_SIG_HDLCFCS),
	S_(ZT_SIG_HDLCNET),
	S_(ZT_SIG_SLAVE),
	S_(ZT_SIG_SF),
	S_(ZT_SIG_CAS),
	S_(ZT_SIG_DACS),
	S_(ZT_SIG_EM_E1),
	S_(ZT_SIG_DACS_RBS)
};
#undef	S_

void dump_sigtype(int print_dbg, const char *msg, int sigtype)
{
	int	i;

	for(i = 0; i < ARRAY_SIZE(zt_sig_types); i++) {
		if(sigtype == zt_sig_types[i].value)
			DBG("%s: %s\n", msg, zt_sig_types[i].name);
	}
}

EXPORT_SYMBOL(dump_poll);
EXPORT_SYMBOL(event2str);
EXPORT_SYMBOL(dump_sigtype);
