#ifndef	XDEFS_H
#define	XDEFS_H
/*
 * Written by Oron Peled <oron@actcom.co.il>
 * Copyright (C) 2004-2005, Xorcom
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef	__KERNEL__

#include <linux/kernel.h>

#define	DBG(fmt, ...)	\
	((print_dbg) && printk(KERN_DEBUG "DBG-%s: %s: " fmt, \
		THIS_MODULE->name, __FUNCTION__, ## __VA_ARGS__))
#define	INFO(fmt, ...)	printk(KERN_INFO "INFO-%s: " fmt, THIS_MODULE->name, ## __VA_ARGS__)
#define	NOTICE(fmt, ...)	printk(KERN_NOTICE "NOTICE-%s: " fmt, THIS_MODULE->name, ## __VA_ARGS__)
#define	ERR(fmt, ...)	printk(KERN_ERR "ERR-%s: " fmt, THIS_MODULE->name, ## __VA_ARGS__)

#else

#include <stdint.h>
typedef uint32_t __u32;

#include <stdio.h>

#define	DBG(fmt, ...)		printf("DBG: %s: " fmt, __FUNCTION__, ## __VA_ARGS__)
#define	INFO(fmt, ...)		printf("INFO: " fmt, ## __VA_ARGS__)
#define	NOTICE(fmt, ...)	printf("NOTICE: " fmt, ## __VA_ARGS__)
#define	ERR(fmt, ...)		printf("ERR: " fmt, ## __VA_ARGS__)
#define	__user

struct list_head { struct list_head *next; struct list_head *prev; };

#endif

typedef char			*charp;
typedef unsigned char		byte;
typedef int			bool;
typedef struct xbus		xbus_t;
typedef	struct xpd		xpd_t;
typedef	struct xpacket_raw	xpacket_raw_t;
typedef	struct xpacket		xpacket_t;
typedef struct xops	xops_t;
typedef	__u32 xpp_line_t;	/* at most 31 lines for E1 */


#define	BIT_SET(x,i)	((x) |= (1 << (i)))
#define	BIT_CLR(x,i)	((x) &= ~(1 << (i)))
#define	IS_SET(x,i)	(((x) & (1 << (i))) != 0)
#define	BIT(i)		(1 << (i))

#undef	SUPPORT_USB1

#ifdef	SUPPORT_USB1
/*
 * packet size <= 64 bytes:
 * 	ZT_CHUNKSIZE * 7 channels + header size <= 64
 */
#define	CHANNELS_PERXPD	7	/* 7 * ZT_CHUNKSIZE + header <= 64 bytes */
#else
#define	CHANNELS_PERXPD	30	/* Depends on xpp_line_t and protocol fields */
#endif


#endif	/* XDEFS_H */
