package Zaptel::Xpp::Xpd;
#
# Written by Oron Peled <oron@actcom.co.il>
# Copyright (C) 2007, Xorcom
# This program is free software; you can redistribute and/or
# modify it under the same terms as Perl itself.
#
#use strict;

my $proc_base = "/proc/xpp";

# Accessors (miniperl does not have Class:Accessor)
sub AUTOLOAD {
	my $self = shift;
	my $name = uc($AUTOLOAD);
	$name =~ s/.*://;   # strip fully-qualified portion
	if (@_) {
		return $self->{$name} = shift;
	} else {
		return $self->{$name};
	}
}

sub zt_registration($$) {
	my $self = shift;
	my $on = shift;
	my $result;

	my $file = "$proc_base/" . $self->fqn . "/zt_registration";
	die "$file is missing" unless -f $file;
	# First query
	open(F, "$file") or die "Failed to open $file for reading: $!";
	$result = <F>;
	chomp $result;
	close F;
	if(defined($on) and $on ne $result) {		# Now change
		open(F, ">$file") or die "Failed to open $file for writing: $!";
		print F ($on)?"1":"0";
		if(!close(F)) {
			if($! == 17) {	# EEXISTS
				# good
			} else {
				undef $result;
			}
		}
	}
	return $result;
}

sub new($$) {
	my $pack = shift or die "Wasn't called as a class method\n";
	my $self = { @_ };
	bless $self, $pack;
	my $dir = "$proc_base/" . $self->fqn;
	$self->{DIR} = $dir;
	my ($name) = glob "$dir/*_info";
	die "Missing info file in $dir" unless $name;
	$name =~ s|^.*/||;	# basename
	die "Bad info file name ($name) in $dir" if $name !~ /(\w+)_info/;
	$self->{TYPE} = uc($1);
	return $self;
}

1;
