/*
 * Tormenta 2  Quad-T1 PCI Driver
 *
 * Written by Mark Spencer <markster@linux-suppot.net>
 *
 * Copyright (C) 2001, Linux Support Services, Inc.
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: tor.h,v 1.2 2003/07/18 18:57:18 steveu Exp $
 */

/*
 * Header file for:
 * BSD Telephony Of Mexico "Tormenta" card LINUX driver, version 1.8X1 3/14/01
 * 
 *   Part of the "Zapata" Computer Telephony Technology.
 *
 *   See http://www.bsdtelephony.com.mx
 *
 *
 *  The technologies, software, hardware, designs, drawings, scheumatics, board
 *  layouts and/or artwork, concepts, methodologies (including the use of all
 *  of these, and that which is derived from the use of all of these), all other
 *  intellectual properties contained herein, and all intellectual property
 *  rights have been and shall continue to be expressly for the benefit of all
 *  mankind, and are perpetually placed in the public domain, and may be used,
 *  copied, and/or modified by anyone, in any manner, for any legal purpose,
 *  without restriction.
 *
 */


#define	NTOR 80  /* max number of Tormenta channels (physical + virtual) */

#ifndef	_MACHINE_TOR_H_
#define	_MACHINE_TOR_H_

#include <linux/ioctl.h>

typedef struct tor_params
{
int	sigtype;  /* read-only */
int rxisoffhook; /* read-only */
int	prewinktime;
int	preflashtime;
int	winktime;
int	flashtime;
int	starttime;
int	rxwinktime;
int	rxflashtime;
int	debouncetime;
} TOR_PARAMS;

typedef struct tor_spaninfo
{
int	spanno;		/* span number */
int	alarms;		/* alarms status */
int	txlevel;	/* what TX level is set to */
int	rxlevel;	/* current RX level */
int	bpvcount;	/* current BPV count */
int	crc4count;	/* current CRC4 error count */
int	ebitcount;	/* current E-bit error count */
int	fascount;	/* current FAS error count */
int	syncsrc;	/* span # of current sync source, or 0 for free run  */
int	numchans;	/* number of configured channels on this span */
} TOR_SPANINFO;

typedef struct tor_maintinfo
{
int	spanno;		/* span number 1-2 */
int	command;	/* command */
} TOR_MAINTINFO;

typedef struct tor_confinfo
{
int	chan;		/* channel number, 0 for current */
int	confno;		/* conference number */
int	confmode;	/* conferencing mode */
} TOR_CONFINFO;

typedef struct tor_gains
{
int	chan;		/* channel number, 0 for current */
unsigned char rxgain[256];	/* Receive gain table */
unsigned char txgain[256];	/* Transmit gain table */
} TOR_GAINS;

struct tor_lineconfig
{
int	lbo[2];		/* line build-outs */
int	lineconfig[2];	/* line config parameters (framing, coding) */
int	psync;		/* primary sync source */
int	ssync;		/* secondary sync source */
} ;

struct tor_chanconfig
{
int	chan;		/* Channel we're applying this to */
int	sigtype;	/* Signal type */
int	master;		/* Master channel if sigtype is TOR_SLAVE */
} ;

/* We use two buffers for output */
#define DEFAULT_NUM_BUFS 2
#define MAX_NUM_BUFS 	 8

#define POLICY_IMMEDIATE	0		/* Start playing/recording immediate */
#define POLICY_WHEN_FULL	1		/* Play/record when buffers are full */

typedef struct tor_bufferinfo
{
int txbufpolicy;	/* Policy for handling receive buffers */
int rxbufpolicy;	/* Policy for handling receive buffers */
int numbufs;		/* How many buffers to use */
int bufsize;		/* How big each buffer is */
int readbufs;		/* How many read buffers are full (read-only) */
int writebufs;		/* How many write buffers are full (read-only) */
} BUFFER_INFO;

typedef struct tor_dialparams
{
int mfv1_tonelen;	/* MF tone length (KP = this * 5/3) */
int dtmf_tonelen;	/* DTMF tone length */
int reserved[4];	/* Reserved for future expansion -- always set to 0 */
} DIAL_PARAMS;

/* Define the max # of outgoing DTMF or MFv1 digits to queue in-kernel */
#define TOR_MAX_DTMF_BUF 256

#define TOR_DIAL_OP_APPEND	1
#define TOR_DIAL_OP_REPLACE	2
#define TOR_DIAL_OP_CANCEL	3

typedef struct tor_dialoperation
{
int op;
char dialstr[TOR_MAX_DTMF_BUF];
} DIAL_OPERATION;

#ifdef TOR_DEVEL
#define TOR_MAJOR 250
#else
#define TOR_MAJOR 196
#endif

#ifndef	ELAST
#define	ELAST 500
#endif

#define	TORMAX	48		/* max physical (real) TOR ports */
#define	NCONF	(TORMAX/2)	/* number of conferences */

#define TOR_CODE	'J'

/*
 * Get Transfer Block Size.
 */
#define TOR_GET_BLOCKSIZE	_IOR (TOR_CODE, 1, int)

/*
 * Set Transfer Block Size.
 */
#define TOR_SET_BLOCKSIZE	_IOW (TOR_CODE, 2, int)

/*
 * Flush Buffer(s) and stop I/O
 */
#define	TOR_FLUSH		_IOW (TOR_CODE, 3, int)

/*
 * Wait for Write to Finish
 */
#define	TOR_SYNC		_IOW (TOR_CODE, 4, int)

/*
 * Get channel parameters
 */
#define TOR_GET_PARAMS		_IOR (TOR_CODE, 5, struct tor_params)

/*
 * Get channel parameters
 */
#define TOR_SET_PARAMS		_IOW (TOR_CODE, 6, struct tor_params)

/*
 * Set Hookswitch Status
 */
#define TOR_HOOK		_IOW (TOR_CODE, 7, int)

/*
 * Get Signalling Event
 */
#define TOR_GETEVENT		_IOR (TOR_CODE, 8, int)

/*
 * Wait for something to happen (IO Mux)
 */
#define TOR_IOMUX		_IOWR (TOR_CODE, 9, int)

/*
 * Get Span Status
 */
#define TOR_SPANSTAT		_IOWR (TOR_CODE, 10, struct tor_spaninfo)

/*
 * Set Maintenance Mode
 */
#define TOR_MAINT		_IOW (TOR_CODE, 11, struct tor_maintinfo)

/*
 * Get Conference Mode
 */
#define TOR_GETCONF		_IOWR (TOR_CODE, 12, struct tor_confinfo)

/*
 * Set Conference Mode
 */
#define TOR_SETCONF		_IOWR (TOR_CODE, 13, struct tor_confinfo)

/*
 * Setup or Remove Conference Link
 */
#define TOR_CONFLINK		_IOW (TOR_CODE, 14, struct tor_confinfo)

/*
 * Display Conference Diagnostic Information on Console
 */
#define TOR_CONFDIAG		_IOR (TOR_CODE, 15, int)

/*
 * Get Channel audio gains
 */
#define TOR_GETGAINS		_IOWR (TOR_CODE, 16, struct tor_gains)

/*
 * Set Channel audio gains
 */
#define TOR_SETGAINS		_IOWR (TOR_CODE, 17, struct tor_gains)

/*
 * Set Line (T1) Configurations and start system
 */
#define	TOR_STARTUP		_IOW (TOR_CODE, 18, struct tor_lineconfig)

/*
 * Set Channel Configuration
 */
#define	TOR_CHANCONFIG		_IOW (TOR_CODE, 19, struct tor_chanconfig)

/*
 * Set Conference to mute mode
 */
#define	TOR_CONFMUTE		_IOW (TOR_CODE, 20, int)

/*
 * Send a particular tone (see TOR_TONE_*)
 */
#define	TOR_SENDTONE		_IOW (TOR_CODE, 21, int)

/*
 * Set your region for tones (see TOR_TONE_ZONE_*)
 */
#define	TOR_SETTONEZONE		_IOW (TOR_CODE, 22, int)

/*
 * Retrieve current region for tones (see TOR_TONE_ZONE_*)
 */
#define	TOR_GETTONEZONE		_IOR (TOR_CODE, 23, int)

/*
 * Master unit only -- set default zone (see TOR_TONE_ZONE_*)
 */
#define	TOR_DEFAULTZONE		_IOW (TOR_CODE, 24, int)

/*
 * Load a tone zone from a tor_tone_def_header, see
 * below...
 */
#define TOR_LOADZONE		_IOW (TOR_CODE, 25, struct tor_tone_def_header)

/*
 * Free a tone zone 
 */
#define TOR_FREEZONE		_IOW (TOR_CODE, 26, int)

/*
 * Set buffer policy 
 */
#define TOR_SET_BUFINFO		_IOW (TOR_CODE, 27, struct tor_bufferinfo)

/*
 * Get current buffer info
 */
#define TOR_GET_BUFINFO		_IOR (TOR_CODE, 28, struct tor_bufferinfo)

/*
 * Get dialing parameters
 */
#define TOR_GET_DIALPARAMS	_IOR (TOR_CODE, 29, struct tor_dialparams)

/*
 * Set dialing parameters
 */
#define TOR_SET_DIALPARAMS	_IOW (TOR_CODE, 30, struct tor_dialparams)

/*
 * Append, replace, or cancel a dial string
 */
#define TOR_DIAL			_IOW (TOR_CODE, 31, struct tor_dialoperation)

/*
 * Set a clear channel into audio mode
 */
#define TOR_AUDIOMODE		_IOW (TOR_CODE, 32, int)

/*
 * Enable or disable echo cancellation on a tormenta channel 
 */
#define TOR_ECHOCANCEL		_IOW (TOR_CODE, 33, int)

/* 
 * Shutdown the card
 */
#define TOR_SHUTDOWN		_IO (TOR_CODE, 100)

#define TOR_TONE_ZONE_MAX		128

#define TOR_TONE_ZONE_DEFAULT 	-1	/* To restore default */

#define TOR_TONE_STOP		-1
#define TOR_TONE_DIALTONE	0
#define TOR_TONE_BUSY		1
#define TOR_TONE_RINGTONE	2
#define TOR_TONE_CONGESTION	3
#define TOR_TONE_CALLWAIT	4
#define TOR_TONE_DIALRECALL	5
#define TOR_TONE_RECORDTONE	6
#define TOR_TONE_INFO		7
#define TOR_TONE_CUST1		8
#define TOR_TONE_CUST2		9
#define TOR_TONE_MAX		16

#define TOR_MAX_CADENCE		16

struct tor_tone_def_header {
	int count;		/* How many samples follow */
	int size;		/* Total size of the *data* of our samples (data only!) */
	int zone;		/* Which zone we are loading */
	int ringcadence[TOR_MAX_CADENCE];	/* Ring cadence in ms (0=on, 1=off, ends with 0 value) */
	char name[40];		/* Informational name of zone */
	/* Immediately follow the tor_tone_def_header by tor_tone_def's */
};

struct tor_tone_def {		/* Structure for zone programming */
	int size;		/* The size of the data we have */
	int tone;		/* See TOR_TONE_* */
	int next;		/* What the next position in the cadence is
				   (They're numbered by the order the appear here) */
	int samples;		/* How many samples to play for this cadence */
	unsigned char data[0];	/* The actual samples */
};

#ifdef __KERNEL__
#endif /* KERNEL */

/* Define the maximum block size */
#define	TOR_MAX_BLOCKSIZE	8192

/* Define the default block size */
#define TOR_DEFAULT_BLOCKSIZE	1024

/* Define the default network block size */
#define TOR_DEFAULT_MTU_MRU	2048

/* Flush and stop the read (input) process */
#define	TOR_FLUSH_READ		1

/* Flush and stop the write (output) process */
#define	TOR_FLUSH_WRITE		2

/* Flush and stop both (input and output) processes */
#define	TOR_FLUSH_BOTH		(TOR_FLUSH_READ | TOR_FLUSH_WRITE)

/* Flush the event queue */
#define	TOR_FLUSH_EVENT		4

/* Flush everything */
#define	TOR_FLUSH_ALL		(TOR_FLUSH_READ | TOR_FLUSH_WRITE | TOR_FLUSH_EVENT)


/* Value for TOR_HOOK, set to ON hook */
#define	TOR_ONHOOK	0

/* Value for TOR_HOOK, set to OFF hook */
#define	TOR_OFFHOOK	1

/* Value for TOR_HOOK, wink (off hook momentarily) */
#define	TOR_WINK	2

/* Value for TOR_HOOK, flash (on hook momentarily) */
#define	TOR_FLASH	3

/* Value for TOR_HOOK, start line */
#define	TOR_START	4

/* Value for TOR_HOOK, ring line (same as start line) */
#define	TOR_RING	TOR_START


/* Ret. Value for GET/WAIT Event, no event */
#define	TOR_EVENT_NONE	0

/* Ret. Value for GET/WAIT Event, Went Onhook */
#define	TOR_EVENT_ONHOOK 1

/* Ret. Value for GET/WAIT Event, Went Offhook or got Ring */
#define	TOR_EVENT_RINGOFFHOOK 2

/* Ret. Value for GET/WAIT Event, Got Wink or Flash */
#define	TOR_EVENT_WINKFLASH 3

/* Ret. Value for GET/WAIT Event, Got Alarm */
#define	TOR_EVENT_ALARM	4

/* Ret. Value for GET/WAIT Event, Got No Alarm (after alarm) */
#define	TOR_EVENT_NOALARM 5

/* Ret. Value for GET/WAIT Event, HDLC Abort frame */
#define TOR_EVENT_ABORT 6

/* Ret. Value for GET/WAIT Event, HDLC Frame overrun */
#define TOR_EVENT_OVERRUN 7

/* Ret. Value for GET/WAIT Event, Bad FCS */
#define TOR_EVENT_BADFCS 8

/* Ret. Value for dial complete */
#define TOR_EVENT_DIALCOMPLETE	9

/* Ret Value for ringer going on */
#define TOR_EVENT_RINGERON 10

/* Ret Value for ringer going off */
#define TOR_EVENT_RINGEROFF 11

/* Ret Value for hook change complete */
#define TOR_EVENT_HOOKCOMPLETE 12

/* Value For signal type, E&M Trunk */
#define	TOR_EM		1

/* Value For signal type, FXS Loopstart Trunk */
#define	TOR_FXSLS	2

/* Value For signal type, FXS Groundstart Trunk */
#define	TOR_FXSGS	3

/* Value For signal type, FXS Kewlstart Trunk */
#define	TOR_FXSKS	4

/* Value For signal type, FXO Loopstart Trunk */
#define	TOR_FXOLS	5

/* Value For signal type, FXS Groundstart Trunk */
#define	TOR_FXOGS	6

/* Value For signal type, FXS Kewlstart Trunk */
#define	TOR_FXOKS	7

/* Value for signal type, Clear Channel (no stuffing or RBS) */
#define TOR_CLEAR	8

/* Value for signal type, HDLC raw */
#define TOR_HDLCRAW	9

/* Value for signal type, HDLC network */
#define TOR_HDLCNET	10

/* Value for signal type, HDLC with FCS calculation/checking */
#define TOR_HDLCFCS	11

/* Value for signal type, Slave channel */
#define TOR_SLAVE	20

/* Value for signal type, flag to indicate pseudo-trunk */
#define	TOR_PSEUDO	0x100

/* Flag Value for IOMUX, read avail */
#define	TOR_IOMUX_READ	1

/* Flag Value for IOMUX, write avail */
#define	TOR_IOMUX_WRITE	2

/* Flag Value for IOMUX, write done */
#define	TOR_IOMUX_WRITEEMPTY	4

/* Flag Value for IOMUX, signalling event avail */
#define	TOR_IOMUX_SIGEVENT	8

/* Flag Value for IOMUX, Do Not Wait if nothing to report */
#define	TOR_IOMUX_NOWAIT	0x100

/* Alarm Condition bits */
#define	TOR_ALARM_NONE		0	/* No alarms */
#define	TOR_ALARM_RECOVER	1	/* Recovering from alarm */
#define	TOR_ALARM_LOOPBACK	2	/* In loopback */
#define	TOR_ALARM_YELLOW	4	/* Yellow Alarm */
#define	TOR_ALARM_RED		8	/* Red Alarm */
#define	TOR_ALARM_BLUE		16	/* Blue Alarm */
#define TOR_ALARM_NOTOPEN	32
/* Maintenance modes */
#define	TOR_MAINT_NONE		0	/* Normal Mode */
#define	TOR_MAINT_LOCALLOOP	1	/* Local Loopback */
#define	TOR_MAINT_REMOTELOOP	2	/* Remote Loopback */
#define	TOR_MAINT_LOOPUP	3	/* send loopup code */
#define	TOR_MAINT_LOOPDOWN	4	/* send loopdown code */

/* Per-span configuration values */
#define	TOR_CONFIG_TXLEVEL	7	/* bits 0-2 are tx level */
#define	TOR_CONFIG_ESF		0x10	/* bit 4 is set for ESF, clear for SF */
#define	TOR_CONFIG_B8ZS		0x20	/* bit 5 is set for B8ZS, clear for D4 */
#define TOR_CONFIG_NOTOPEN	0x40

/* Conference modes */
#define	TOR_CONF_MODE_MASK 0xff		/* mask for modes */
#define	TOR_CONF_NORMAL	0		/* normal mode */
#define	TOR_CONF_MONITOR 1		/* monitor mode (rx of other chan) */
#define	TOR_CONF_MONITORTX 2		/* monitor mode (tx of other chan) */
#define	TOR_CONF_MONITORBOTH 3		/* monitor mode (rx & tx of other chan) */
#define	TOR_CONF_CONF 4			/* conference mode */
#define	TOR_CONF_CONFANN 5		/* conference announce mode */
#define	TOR_CONF_CONFMON 6		/* conference monitor mode */
#define	TOR_CONF_CONFANNMON 7		/* conference announce/monitor mode */
#define	TOR_CONF_REALANDPSEUDO 8	/* real and pseudo port both on conf */
#define	TOR_CONF_FLAG_MASK 0xff00	/* mask for flags */
#define	TOR_CONF_LISTENER 0x100		/* is a listener on the conference */
#define	TOR_CONF_TALKER 0x200		/* is a talker on the conference */
#define	TOR_CONF_PSEUDO_LISTENER 0x400	/* pseudo is a listener on the conference */
#define	TOR_CONF_PSEUDO_TALKER 0x800	/* pseudo is a talker on the conference */


#define	TOR_DEFAULT_WINKTIME	150	/* 150 ms default wink time */
#define	TOR_DEFAULT_FLASHTIME	750	/* 750 ms default flash time */

#define	TOR_DEFAULT_PREWINKTIME	50	/* 50 ms before wink */
#define	TOR_DEFAULT_PREFLASHTIME 50	/* 50 ms before flash */
#define	TOR_DEFAULT_STARTTIME 1500	/* 1500 ms of start */
#define	TOR_DEFAULT_RINGTIME 2000	/* 2000 ms of ring on (start, FXO) */
#if 0
#define	TOR_DEFAULT_RXWINKTIME 250	/* 250ms longest rx wink */
#endif
#define	TOR_DEFAULT_RXWINKTIME 300	/* 300ms longest rx wink (to work with the Atlas) */
#define	TOR_DEFAULT_RXFLASHTIME 1250	/* 1250ms longest rx flash */
#define	TOR_DEFAULT_DEBOUNCETIME 600	/* 600ms of FXS GS signalling debounce */

#define	TOR_LOOPCODE_TIME 10000		/* send loop codes for 10 secs */
#define	TOR_ALARMSETTLE_TIME	5000	/* allow alarms to settle for 5 secs */
#define	TOR_AFTERSTART_TIME 500		/* 500ms after start */

#define TOR_RINGOFFTIME 4000		/* Turn off ringer for 4000 ms */
#define	TOR_KEWLTIME 500		/* 500ms for kewl pulse */

#endif /* !_MACHINE_TOR_H_ */
