
# HPE Synergy by HTTP

## Overview

For Zabbix version: 6.0 and higher  
The template to monitor HPE Synergy by HTTP.
It works without any external scripts and uses the script item.

This template was tested on:

- HPE Synergy, version 12000 Frame with API version 1200

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/6.0/manual/config/templates_out_of_the_box/http) for basic instructions.

1. Link template to the host.
2. Configure macros {$HPE.SYNERGY.API.USERNAME} and {$HPE.SYNERGY.API.PASSWORD}.

## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$HPE.SYNERGY.API.PASSWORD} |<p>Specify password for API.</p> |`` |
|{$HPE.SYNERGY.API.PORT} |<p>The API port.</p> |`443` |
|{$HPE.SYNERGY.API.SCHEME} |<p>The API scheme (http/https).</p> |`https` |
|{$HPE.SYNERGY.API.USERNAME} |<p>Specify user name for API.</p> |`zabbix` |
|{$HPE.SYNERGY.DATA.TIMEOUT} |<p>Response timeout for API.</p> |`15s` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Appliance bays discovery |<p>A list of the appliance bays in the enclosure.</p> |DEPENDENT |hpe.synergy.appliances.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.applianceBays`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Cross bars discovery |<p>SDX cross fabric module connects to all compute devices installed in the system enclosure and brings in the capability of hard partitioning. Crossbar details are relevant only for enclosures with type "SDX".</p> |DEPENDENT |hpe.synergy.crossbars.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.crossBars`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Datacenters discovery |<p>A list of the datacenters.</p> |DEPENDENT |hpe.synergy.datacenters.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.datacenters.members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Devices discovery |<p>A list of device bays in the enclosure.</p> |DEPENDENT |hpe.synergy.devices.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.deviceBays`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Enclosures discovery |<p>A list of enclosures resources.</p> |DEPENDENT |hpe.synergy.enclosures.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Ethernet networks discovery |<p>A list of the ethernet networks.</p> |DEPENDENT |hpe.synergy.ethernet.networks.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["ethernet-networks"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Fabrics discovery |<p>A list of the fabrics.</p> |DEPENDENT |hpe.synergy.fabrics.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.fabrics.members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Fans discovery |<p>A list of the fan bays in the enclosure.</p> |DEPENDENT |hpe.synergy.fans.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.fanBays`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|FC networks discovery |<p>A list of the FC networks.</p> |DEPENDENT |hpe.synergy.fc.networks.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["fc-networks"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Hypervisor managers discovery |<p>A list of the hypervisor managers.</p> |DEPENDENT |hpe.synergy.hypervisor.managers.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["hypervisor-managers"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Interconnects discovery |<p>Interconnects are centrally managed by their containing logical interconnect. The interconnect provides a physical view of detailed downlink and uplink port state and configuration, including the current link state, speed, port role (uplink, downlink, or stacking), current pluggable media, power state, and immediate connected neighbor.</p> |DEPENDENT |hpe.synergy.interconnects.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Logical enclosures discovery |<p>A list of the logical enclosures.</p> |DEPENDENT |hpe.synergy.logical_enclosures.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["logical-enclosures"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Managers discovery |<p>A list of the Synergy Frame Link Module bays.</p> |DEPENDENT |hpe.synergy.frame_link_modules.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.managerBays`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|nPar discovery |<p>Electrically isolated hardware partition (nPar). Partition details are relevant only for enclosures with type "SDX".</p> |DEPENDENT |hpe.synergy.npar.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.partitions`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Power supplies discovery |<p>List of power supply bays in the enclosure.</p> |DEPENDENT |hpe.synergy.ps.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.powerSupplyBays`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Racks discovery |<p>A list of the racks.</p> |DEPENDENT |hpe.synergy.racks.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.racks.members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Server hardware discovery |<p>The server hardware resource is a representation of a physical server.</p> |DEPENDENT |hpe.synergy.server_hardware.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Storage pools discovery |<p>A list of the storage pools.</p> |DEPENDENT |hpe.synergy.storage_pools.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-pools"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Storage systems discovery |<p>A list of the storage systems.</p> |DEPENDENT |hpe.synergy.storage_systems.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-systems"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Storage volumes discovery |<p>A list of the storage volumes.</p> |DEPENDENT |hpe.synergy.storage_volumes.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-volumes"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Uplink sets discovery |<p>A list of the uplink sets.</p> |DEPENDENT |hpe.synergy.uplink_sets.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.["uplink-sets"].members`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|HPE |HPE Synergy: Get data |<p>The JSON with result of API requests.</p> |SCRIPT |hpe.synergy.data.get<p>**Expression**:</p>`The text is too long. Please see the template.` |
|HPE |HPE Synergy: Get errors |<p>A list of errors from API requests.</p> |DEPENDENT |hpe.synergy.data.errors<p>**Preprocessing**:</p><p>- JSONPATH: `$.errors`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |HPE Synergy: Get enclosures |<p>A list of enclosures.</p> |DEPENDENT |hpe.synergy.data.enclosures<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members.[0]`</p> |
|HPE |HPE Synergy: Service ping |<p>Checks if the service is running and accepting TCP connections.</p> |SIMPLE |net.tcp.service["{$HPE.SYNERGY.API.SCHEME}","{HOST.CONN}","{$HPE.SYNERGY.API.PORT}"]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Model |<p>The model name for the appliance.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].model.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Part number |<p>The part number of the appliance.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Powered on |<p>Yes if the appliance is powered on; false otherwise.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",powered_on]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].poweredOn.first()`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Power state |<p>The power state of the appliance bay.</p><p>EFuse - The power state of the bay is that it has been EFused.</p><p>Reset - The power state of the bay is that it has been reset.</p><p>SoftReset - The power state of the bay is that it has been soft reset.</p><p>Unknown - The power state of the bay is unknown.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",bay_power_state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].bayPowerState.first()`</p><p>- STR_REPLACE: `EFuse 0`</p><p>- STR_REPLACE: `SoftReset 1`</p><p>- STR_REPLACE: `Reset 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- IN_RANGE: `0 3 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Presence |<p>Indicates whether an appliance is present in the bay:</p><p>Absent - The device slot is empty.</p><p>PresenceNoOp - The device slot is uninitialized.</p><p>PresenceUnknown - The device presence is unknown.</p><p>Present - The device slot has a device in it.</p><p>Subsumed - The device slot is configured to be part of another device slot. Not applicable for fan or power supply bays.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].devicePresence.first()`</p><p>- STR_REPLACE: `Absent 0`</p><p>- STR_REPLACE: `PresenceNoOp 1`</p><p>- STR_REPLACE: `PresenceUnknown 2`</p><p>- STR_REPLACE: `Present 3`</p><p>- STR_REPLACE: `Subsumed 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Serial number |<p>The serial number of the appliance.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Spare part number |<p>The spare part number of the appliance.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",spare_part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].sparePartNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Status |<p>The hardware status of the appliance:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behaviour.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].applianceBays[?(@.bayNumber == "{#BAY_NUMBER}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: HW version |<p>Hardware version.</p> |DEPENDENT |hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",hw_version]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].crossBars[?(@.bayNumber == "{#BAY_NUMBER}")].hwVersion.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Part number |<p>The part number provided by the manufacturer.</p> |DEPENDENT |hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].crossBars[?(@.bayNumber == "{#BAY_NUMBER}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Presence |<p>Presence in a bay:</p><p>Absent - The device slot is empty.</p><p>PresenceNoOp - The device slot is uninitialized.</p><p>PresenceUnknown - The device presence is unknown.</p><p>Present - The device slot has a device in it.</p><p>Subsumed - The device slot is configured to be part of another device slot. Not applicable for fan or power supply bays.</p> |DEPENDENT |hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].crossBars[?(@.bayNumber == "{#BAY_NUMBER}")].presence.first()`</p><p>- STR_REPLACE: `Absent 0`</p><p>- STR_REPLACE: `PresenceNoOp 1`</p><p>- STR_REPLACE: `PresenceUnknown 2`</p><p>- STR_REPLACE: `Present 3`</p><p>- STR_REPLACE: `Subsumed 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Serial number |<p>Serial number.</p> |DEPENDENT |hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].crossBars[?(@.bayNumber == "{#BAY_NUMBER}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Status |<p>Overall health status of the crossbar:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behaviour.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].crossBars[?(@.bayNumber == "{#BAY_NUMBER}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Datacenter [{#NAME}]: State |<p>The current state of the resource. Valid values include Adding, AddError, Configured, CredentialError, Refreshing, RefreshError, Removing, RemoveError, and Unmanaged.</p> |DEPENDENT |hpe.synergy.datacenter["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.datacenters.members[?(@.name == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `Adding 0`</p><p>- STR_REPLACE: `AddError 1`</p><p>- STR_REPLACE: `Configured 2`</p><p>- STR_REPLACE: `CredentialError 3`</p><p>- STR_REPLACE: `Refreshing 4`</p><p>- STR_REPLACE: `RefreshError 5`</p><p>- STR_REPLACE: `Removing 6`</p><p>- STR_REPLACE: `RemoveError 7`</p><p>- STR_REPLACE: `Unmanaged 8`</p><p>- IN_RANGE: `0 8 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 9`</p> |
|HPE |Datacenter [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.datacenter["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.datacenters.members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Device [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Model |<p>Model name of an unsupported device occupying the bay, if available.</p> |DEPENDENT |hpe.synergy.device["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].deviceBays[?(@.bayNumber == "{#BAY_NUMBER}")].model.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Device [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Power allocated |<p>The power allocated for the enclosed blade.</p> |DEPENDENT |hpe.synergy.device["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",power_allocation]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].deviceBays[?(@.bayNumber == "{#BAY_NUMBER}")].powerAllocationWatts.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Device [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Presence |<p>Indicates whether a device is present:</p><p>Absent - The device slot is empty.</p><p>PresenceNoOp - The device slot is uninitialized.</p><p>PresenceUnknown - The device presence is unknown.</p><p>Present - The device slot has a device in it.</p><p>Subsumed - The device slot is configured to be part of another device slot. Not applicable for fan or power supply bays.</p> |DEPENDENT |hpe.synergy.device["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].deviceBays[?(@.bayNumber == "{#BAY_NUMBER}")].devicePresence.first()`</p><p>- STR_REPLACE: `Absent 0`</p><p>- STR_REPLACE: `PresenceNoOp 1`</p><p>- STR_REPLACE: `PresenceUnknown 2`</p><p>- STR_REPLACE: `Present 3`</p><p>- STR_REPLACE: `Subsumed 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Device [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Serial number |<p>If available, the serial number of any device occupying the bay.</p> |DEPENDENT |hpe.synergy.device["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].deviceBays[?(@.bayNumber == "{#BAY_NUMBER}")].serialNumber.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Enclosure [{#NAME}]: Appliance bays count |<p>The number of appliance bays in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",appliance_bay_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].applianceBayCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Enclosure [{#NAME}]: Device bays count |<p>The number of device bays in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",device_bay_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].deviceBayCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Enclosure [{#NAME}]: Device bays power |<p>The amount of power allocated for the blades in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",device_bay_watts]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].deviceBayWatts.first()`</p> |
|HPE |Enclosure [{#NAME}]: Fan bays count |<p>The number of fan bays in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",fan_bay_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].fanBayCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Enclosure [{#NAME}]: Firmware baseline |<p>The name of the current firmware baseline.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",fw_baseline_name]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].fwBaselineName.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Enclosure [{#NAME}]: Interconnect bays count |<p>The number of interconnect bays in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",interconnect_bay_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].interconnectBayCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Enclosure [{#NAME}]: Interconnect bays power |<p>The amount of power allocated for the interconnects in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",interconnect_bay_watts]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].interconnectBayWatts.first()`</p> |
|HPE |Enclosure [{#NAME}]: Min power supplies |<p>The minimum number of power supplies needed.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",min_ps]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].minimumPowerSupplies.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Enclosure [{#NAME}]: Min power supplies for redundant power feed |<p>The minimum number of power supplies needed to fulfill the redundant line feed power mode.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",min_ps_redundant]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].minimumPowerSuppliesForRedundantPowerFeed.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Enclosure [{#NAME}]: Model |<p>The enclosure model name, eg, "BladeSystem c7000 Enclosure G2".</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].enclosureModel.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Enclosure [{#NAME}]: Part number |<p>The part number of the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Enclosure [{#NAME}]: Power allocated for fans and management devices |<p>The amount of power allocated for the fans and management devices of the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",fans_mgmt_power]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].fansAndManagementDevicesWatts.first()`</p> |
|HPE |Enclosure [{#NAME}]: Power capacity |<p>The power capacity based on power mode.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",power_capacity]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].powerCapacityWatts.first()`</p> |
|HPE |Enclosure [{#NAME}]: Power supply bays count |<p>The number of power supply bays in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",ps_bay_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].powerSupplyBayCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Enclosure [{#NAME}]: Serial number |<p>The serial number of the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Enclosure [{#NAME}]: State |<p>Current resource state of the enclosure:</p><p>Adding - The enclosure is being added.</p><p>Configured - The enclosure is configured and part of a logical enclosure. This is the usual state for an enclosure under full management.</p><p>Configuring - A transient state while the enclosure is being configured for a logical enclosure.</p><p>Interrupted - The previous operation on the enclosure did not complete. The operation should be re-attempted.</p><p>Monitored - The enclosure is being monitored. It is not part of a logical enclosure and only hardware-control operations are available.</p><p>Pending - There are pending operations on the enclosure. Additional operations are denied.</p><p>RemoveFailed - The previous operation to remove the enclosure did not succeed. The operation should be re-attempted.</p><p>Removing - The enclosure is being removed.</p><p>Unmanaged - The enclosure has been discovered, but has not yet been added for management or monitoring.</p><p>Unsupported - The enclosure model or version is not currently supported by HPE OneView. It cannot be configured or monitored.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `Adding 0`</p><p>- STR_REPLACE: `Configured 1`</p><p>- STR_REPLACE: `Configuring 2`</p><p>- STR_REPLACE: `Interrupted 3`</p><p>- STR_REPLACE: `Monitored 4`</p><p>- STR_REPLACE: `Pending 5`</p><p>- STR_REPLACE: `RemoveFailed 6`</p><p>- STR_REPLACE: `Removing 7`</p><p>- STR_REPLACE: `Unmanaged 8`</p><p>- STR_REPLACE: `Unsupported 9`</p><p>- IN_RANGE: `0 9 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 10`</p> |
|HPE |Enclosure [{#NAME}]: State reason |<p>Indicates the reason the resource in its current state:</p><p>Missing - The enclosure is no longer connected into the frame link topology.</p><p>None - No reason is available, or none applies.</p><p>NotAdded - The enclosure has not been added.</p><p>NotOwner - The enclosure reports being managed by something other than this HPE OneView.</p><p>OperationFailed - A prior operation was interrupted.</p><p>Unowned - The enclosure reports not being under management.</p><p>UnsupportedFirmware - The firmware version of the enclosure is not supported by this version of HPE OneView.</p><p>UpdatingFirmware - A firmware update is in progress.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",state_reason]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].stateReason.first()`</p><p>- STR_REPLACE: `Missing 0`</p><p>- STR_REPLACE: `None 1`</p><p>- STR_REPLACE: `NotAdded 2`</p><p>- STR_REPLACE: `NotOwner 3`</p><p>- STR_REPLACE: `OperationFailed 4`</p><p>- STR_REPLACE: `Unowned 5`</p><p>- STR_REPLACE: `UnsupportedFirmware 6`</p><p>- STR_REPLACE: `UpdatingFirmware 7`</p><p>- IN_RANGE: `0 7 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 8`</p> |
|HPE |Enclosure [{#NAME}]: Status |<p>Overall health status of the enclosure.</p><p>The enclosure status reflects the hardware health of the enclosure, all bays, and enclosure components (e.g. enclosure mid-plane, fans, power supplies, Synergy Frame Link Modules, and Synergy Composers). It explicitly does not include the status of other HPE OneView resources such as blades (server hardware), interconnects, and drive enclosures.</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behaviour.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Enclosure [{#NAME}]: Total allocated power |<p>The total amount of power allocated in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",power_total_allocated]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].powerAllocatedWatts.first()`</p> |
|HPE |Enclosure [{#NAME}]: Total available power |<p>The amount of unallocated power in the enclosure.</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",power_total_available]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].powerAvailableWatts.first()`</p> |
|HPE |Enclosure [{#NAME}]: Type |<p>The type of the enclosure, eg, "C7000" or "SY12000" or "SDX".</p> |DEPENDENT |hpe.synergy.enclosure["{#NAME}",type]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#NAME}")].enclosureType.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|HPE |Ethernet network [{#NAME}]: State |<p>The current state of the resource.</p> |DEPENDENT |hpe.synergy.ethernet.network["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["ethernet-networks"].members[?(@.name == "{#NAME}")].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Ethernet network [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.ethernet.network["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["ethernet-networks"].members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Fabric [{#NAME}]: State |<p>The current state of the resource.</p> |DEPENDENT |hpe.synergy.fabric["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.fabrics.members[?(@.name == "{#NAME}")].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Fabric [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.fabric["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.fabrics.members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Model |<p>The common descriptive model of the fan.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].model.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Part number |<p>The part number of the fan.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Presence |<p>Indicates whether a fan is present:</p><p>Absent - The device slot is empty.</p><p>PresenceNoOp - The device slot is uninitialized.</p><p>PresenceUnknown - The device presence is unknown.</p><p>Present - The device slot has a device in it.</p><p>Subsumed - The device slot is configured to be part of another device slot. Not applicable for fan or power supply bays.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].devicePresence.first()`</p><p>- STR_REPLACE: `Absent 0`</p><p>- STR_REPLACE: `PresenceNoOp 1`</p><p>- STR_REPLACE: `PresenceUnknown 2`</p><p>- STR_REPLACE: `Present 3`</p><p>- STR_REPLACE: `Subsumed 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Required |<p>Indicates whether the enclosure configuration requires a fan to be present in the bay.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",required]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].deviceRequired.first()`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Serial number |<p>The serial number of the fan.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Spare part number |<p>The spare part number to be used when ordering an additional or replacement fan of this type.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",spare_part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].sparePartNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: State |<p>Current state of the fan:</p><p>Degraded - Fan is degraded.</p><p>Failed - Fan has failed.</p><p>Misplaced - Fan is present, but not required, in this bay, and the overall fan configuration is not compliant with the enclosure fan placement rules.</p><p>Missing - Fan is required, but is not present.</p><p>OK - Fan bay has no issues.</p><p>Unknown - Unknown fan's state.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].state.first()`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 5`</p><p>- STR_REPLACE: `Degraded 0`</p><p>- STR_REPLACE: `Failed 1`</p><p>- STR_REPLACE: `Misplaced 2`</p><p>- STR_REPLACE: `Missing 3`</p><p>- STR_REPLACE: `OK 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 5`</p> |
|HPE |Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Status |<p>Overall health status of the fan:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behavior.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].fanBays[?(@.bayNumber == "{#BAY_NUMBER}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |FC network [{#NAME}]: State |<p>The current state of the resource.</p> |DEPENDENT |hpe.synergy.fc.network["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["fc-networks"].members[?(@.name == "{#NAME}")].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |FC network [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.fc.network["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["fc-networks"].members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Hypervisor manager [{#NAME}]: State |<p>Current state of the resource. Valid values include Connected, Disconnected, Configuring and Error.</p> |DEPENDENT |hpe.synergy.hypervisor_manager["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["hypervisor-managers"].members[?(@.displayName == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `Connected 0`</p><p>- STR_REPLACE: `Disconnected 1`</p><p>- STR_REPLACE: `Configuring 2`</p><p>- STR_REPLACE: `Error 3`</p><p>- IN_RANGE: `0 3 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 4`</p> |
|HPE |Hypervisor manager [{#NAME}]: State reason |<p>Indicates the reason the resource in its current state.</p> |DEPENDENT |hpe.synergy.hypervisor_manager["{#NAME}",state_reason]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["hypervisor-managers"].members[?(@.displayName == "{#NAME}")].stateReason.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Hypervisor manager [{#NAME}]: Status |<p>Current status of this resource:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behavior.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.hypervisor_manager["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["hypervisor-managers"].members[?(@.displayName == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Interconnect [{#NAME}]: Hardware health |<p>Interconnect hardware health status.</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",hw.health]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].interconnectHardwareHealth.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Interconnect [{#NAME}]: Model |<p>Interconnect model.</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].model.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Interconnect [{#NAME}]: Part number |<p>Interconnect part number.</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Interconnect [{#NAME}]: Port count |<p>Number of ports on the interconnect.</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",port_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].portCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Interconnect [{#NAME}]: Serial number |<p>Interconnect serial number.</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Interconnect [{#NAME}]: Spare part number |<p>Interconnect spare part number.</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",spare_part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].sparePartNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Interconnect [{#NAME}]: State |<p>Current state of the resource</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Interconnect [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behavior.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.interconnect["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.interconnects.members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Logical enclosure [{#NAME}]: State |<p>Current resource state of the logical enclosure:</p><p>Consistent - This is the expected state of the logical enclosure. The logical enclosure configuration is consistent with the enclosure group and the configuration of the hardware resources is consistent with the logical enclosure configuration.</p><p>Creating - The logical enclosure is being created.</p><p>DeleteFailed - The prior attempt to delete the logical enclosure failed. Retry the delete operation potentially with the force option. No other logical enclosure operations are allowed in this state.</p><p>Deleting - The logical enclosure is being deleted.</p><p>Inconsistent - The configuration of the logical enclosure differs from that of the enclosure group, or the configuration of the hardware resources is inconsistent with the logical enclosure configuration. Perform an Update from group, Reapply configuration, or Update firmware action as appropriate to bring the configuration back into consistency.</p><p>Updating - Configuration changes are being applied to the hardware configuration.</p> |DEPENDENT |hpe.synergy.logical_enclosure["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["logical-enclosures"].members[?(@.name == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `Inconsistent 0`</p><p>- STR_REPLACE: `Creating 1`</p><p>- STR_REPLACE: `DeleteFailed 2`</p><p>- STR_REPLACE: `Deleting 3`</p><p>- STR_REPLACE: `Consistent 4`</p><p>- STR_REPLACE: `Updating 5`</p><p>- IN_RANGE: `0 5 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 6`</p> |
|HPE |Logical enclosure [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.logical_enclosure["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["logical-enclosures"].members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Devices count |<p>The number of blades in the partition.</p> |DEPENDENT |hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",device_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].partitions[?(@.partitionID == "{#PARTITION_ID}")].deviceCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p> |
|HPE |Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Health |<p>Indicates the health of the partition and the health of its owned resources (blades and IO bays) as reported by firmware. If a problem is detected with one of the resources, the health of the partition is reported as Degraded. If all of the resources in the partition are operating correctly the health of the partition is reported as OK.</p><p>NparDegrade - One or more resources in the partition are unhealthy.</p><p>NparHealthInvalid - Partition health is invalid.</p><p>NparHealthMax - Delimiter defined by firmware.</p><p>NparOk - All the resources in partition are healthy.</p> |DEPENDENT |hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",health]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].partitions[?(@.partitionID == "{#PARTITION_ID}")].partitionHealth.first()`</p><p>- STR_REPLACE: `NparDegrade 0`</p><p>- STR_REPLACE: `NparHealthInvalid 1`</p><p>- STR_REPLACE: `NparHealthMax 2`</p><p>- STR_REPLACE: `NparOk 3`</p><p>- IN_RANGE: `0 3 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 4`</p> |
|HPE |Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Memory |<p>Total memory of the partition.</p> |DEPENDENT |hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",memory]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].partitions[?(@.partitionID == "{#PARTITION_ID}")].memoryMb.first()`</p><p>- MULTIPLIER: `1048576`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Processors Count |<p>The number of processors in the partition.</p> |DEPENDENT |hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",processor_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].partitions[?(@.partitionID == "{#PARTITION_ID}")].processorCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p> |
|HPE |Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Status |<p>Indicates whether the partition has booted and its current power state:</p><p>ParStatusActive - Partition is active when a 'poweron' operation is initiated on the partition and the firmware boot process is started.</p><p>ParStatusInactive - Partition is in inactive state after it has been created or shut down.</p><p>ParStatusInvalid - Partition status is invalid.</p><p>ParStatusManualRepair - Partition is under manual repair.</p><p>ParStatusMax - Delimiter defined by OA firmware.</p><p>ParStatusUndefined - Partition status is undefined.</p><p>ParStatusUnknown - Partition might report an 'Unknown' state after an OA restart. This state is possible when the firmware is not able to identify the correct partition state due to internal firmware errors at OA startup. The state is persistent and can only be cleared by force powering off the partition from the OA. A partition in this state will not accept any partition operation except parstatus and force poweroff. Any active OS instances continue to run unhindered even when the partition is in an Unknown state.</p> |DEPENDENT |hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].partitions[?(@.partitionID == "{#PARTITION_ID}")].partitionStatus.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `ParStatusActive 0`</p><p>- STR_REPLACE: `ParStatusInactive 1`</p><p>- STR_REPLACE: `ParStatusInvalid 2`</p><p>- STR_REPLACE: `ParStatusManualRepair 3`</p><p>- STR_REPLACE: `ParStatusMax 4`</p><p>- STR_REPLACE: `ParStatusUndefined 5`</p><p>- STR_REPLACE: `ParStatusUnknown 6`</p><p>- IN_RANGE: `0 6 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 6`</p> |
|HPE |Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Model |<p>The common descriptive model of the power supply.</p> |DEPENDENT |hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].powerSupplyBays[?(@.bayNumber == "{#BAY_NUMBER}")].model.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Output capacity |<p>The power supply output capacity.</p> |DEPENDENT |hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",output_capacity]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].powerSupplyBays[?(@.bayNumber == "{#BAY_NUMBER}")].outputCapacityWatts.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Part number |<p>The part number of the power supply.</p> |DEPENDENT |hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].powerSupplyBays[?(@.bayNumber == "{#BAY_NUMBER}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Presence |<p>Indicates whether a power supply is present.</p><p>Absent - The device slot is empty.</p><p>PresenceNoOp - The device slot is uninitialized.</p><p>PresenceUnknown - The device presence is unknown.</p><p>Present - The device slot has a device in it.</p><p>Subsumed - The device slot is configured to be part of another device slot. Not applicable for fan or power supply bays.</p> |DEPENDENT |hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].powerSupplyBays[?(@.bayNumber == "{#BAY_NUMBER}")].devicePresence.first()`</p><p>- STR_REPLACE: `Absent 0`</p><p>- STR_REPLACE: `PresenceNoOp 1`</p><p>- STR_REPLACE: `PresenceUnknown 2`</p><p>- STR_REPLACE: `Present 3`</p><p>- STR_REPLACE: `Subsumed 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Serial number |<p>The unique serial number of the power supply.</p> |DEPENDENT |hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].powerSupplyBays[?(@.bayNumber == "{#BAY_NUMBER}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Spare part number |<p>The spare part number to be used when ordering an additional or replacement power supply of this type.</p> |DEPENDENT |hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",spare_part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].powerSupplyBays[?(@.bayNumber == "{#BAY_NUMBER}")].sparePartNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Status |<p>Overall health status of the power supply:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behavior.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].powerSupplyBays[?(@.bayNumber == "{#BAY_NUMBER}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Rack [{#NAME}]: State |<p>The current state of the resource. Valid values include Adding, AddError, Configured, CredentialError, Refreshing, RefreshError, Removing, RemoveError, and Unmanaged.</p> |DEPENDENT |hpe.synergy.rack["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.racks.members[?(@.name == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `Adding 0`</p><p>- STR_REPLACE: `AddError 1`</p><p>- STR_REPLACE: `Configured 2`</p><p>- STR_REPLACE: `CredentialError 3`</p><p>- STR_REPLACE: `Refreshing 4`</p><p>- STR_REPLACE: `RefreshError 5`</p><p>- STR_REPLACE: `Removing 6`</p><p>- STR_REPLACE: `RemoveError 7`</p><p>- STR_REPLACE: `Unmanaged 8`</p><p>- IN_RANGE: `0 8 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 9`</p> |
|HPE |Rack [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.rack["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.racks.members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Maintenance state |<p>Server Hardware maintenance flag - Disruptive maintenance operations like firmware update can cause many server hardware alerts to be generated in a short period of time. Ex: Network connectivity lost or Server reset detected. When this field is set, predefined alerts for this particular device are suppressed. This field is set only when firmware update is ongoing. The alerts are processed normally once firmware update operation completes. Possible values are Maintenance and Normal.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",maintenance_state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].maintenanceState.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- STR_REPLACE: `Maintenance 0`</p><p>- STR_REPLACE: `Normal 1`</p><p>- IN_RANGE: `0 1 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Maintenance state reason |<p>This field is set to Firmware update when server is put to maintenance.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",maintenance_state_reason]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].maintenanceStateReason.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Memory |<p>Amount of memory installed on this server hardware.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",memory]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].memoryMb.first()`</p><p>- MULTIPLIER: `1048576`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Migration state |<p>The state of an ongoing VCM migration:</p><p>Migrating - The enclosure is in the process of migrating from VCM.</p><p>NotApplicable - The enclosure did not require or has already completed migration.</p><p>Unknown - The migration state is unknown.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",migration_state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].migrationState.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- STR_REPLACE: `Migrating 0`</p><p>- STR_REPLACE: `NotApplicable 1`</p><p>- STR_REPLACE: `Unknown 2`</p><p>- IN_RANGE: `0 2 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Model |<p>The full server hardware model string.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].model.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Part number |<p>The part number for this server hardware.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Power state |<p>Current power state of the server hardware. Values are Unknown, On, Off, PoweringOn, PoweringOff or Resetting.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",power_state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].powerState.first()`</p><p>- STR_REPLACE: `PoweringOff 0`</p><p>- STR_REPLACE: `PoweringOn 1`</p><p>- STR_REPLACE: `Resetting 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Off 4`</p><p>- STR_REPLACE: `On 5`</p><p>- IN_RANGE: `0 5 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Processor cores count |<p>The number of cores available per processor.</p> |DEPENDENT |hpe.synergy.server_hardware.processor["{#LOCATION}",cores_count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].processorCoreCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Processors count |<p>The number of processors installed on this server hardware.</p> |DEPENDENT |hpe.synergy.server_hardware.processor["{#LOCATION}",count]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].processorCount.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Processor speed |<p>Speed of the CPUs.</p> |DEPENDENT |hpe.synergy.server_hardware.processor["{#LOCATION}",speed]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].processorSpeedMhz.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Processor type |<p>Type of CPU installed on this server hardware.</p> |DEPENDENT |hpe.synergy.server_hardware.processor["{#LOCATION}",type]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].processorType.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Serial number |<p>The serial number of the server hardware.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: State |<p>The current resource state of the server hardware. Allowable values are:</p><p>Unknown - Not initialized,</p><p>Adding - Server being added,</p><p>NoProfileApplied - Server successfully added,</p><p>Monitored - Server being monitored,</p><p>Unmanaged - Discovered a supported server,</p><p>Removing - Server being removed,</p><p>RemoveFailed - Unsuccessful server removal,</p><p>Removed - Server successfully removed,</p><p>ApplyingProfile - Profile being applied to server,</p><p>ProfileApplied - Profile successfully applied,</p><p>RemovingProfile - Profile being removed,</p><p>ProfileError - Unsuccessful profile apply or removal,</p><p>Unsupported - Server model or version not currently supported by the appliance,</p><p>UpdatingFirmware - Server firmware update in progress.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].state.first()`</p><p>- STR_REPLACE: `Unknown 0`</p><p>- STR_REPLACE: `Adding 1`</p><p>- STR_REPLACE: `NoProfileApplied 2`</p><p>- STR_REPLACE: `Monitored 3`</p><p>- STR_REPLACE: `Unmanaged 4`</p><p>- STR_REPLACE: `Removing 5`</p><p>- STR_REPLACE: `RemoveFailed 6`</p><p>- STR_REPLACE: `Removed 7`</p><p>- STR_REPLACE: `ApplyingProfile 8`</p><p>- STR_REPLACE: `ProfileApplied 9`</p><p>- STR_REPLACE: `RemovingProfile 10`</p><p>- STR_REPLACE: `ProfileError 11`</p><p>- STR_REPLACE: `Unsupported 12`</p><p>- STR_REPLACE: `UpdatingFirmware 13`</p><p>- IN_RANGE: `0 13 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 0`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: State reason |<p>The reason for the current resource state of the server hardware. This only applies if the state is 'Unmanaged', otherwise it is set to 'NotApplicable'. Allowable values are:</p><p>Unsupported - Server model or version not currently supported by the appliance,</p><p>UpdatingFirmware - Server firmware update in progress,</p><p>NotApplicable - When PhysicalServerState is anything besides 'Unmanaged',</p><p>NotOwner - No claim on server,</p><p>Inventory - Server added by PDU,</p><p>Unconfigured - Discovery data incomplete or iLO configuration failure,</p><p>UnsupportedFirmware - iLO firmware version below minimum support level,</p><p>Interrupted - When PhysicalServerState is a result of an operation that was terminated before completing,</p><p>CommunicationError - Appliance cannot communicate with iLO or OA.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",state_reason]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].stateReason.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Server [{#SERVER_NAME}:{#LOCATION}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational or that a server profile has not been assigned.</p><p>Warning - needs attention soon.</p><p>Critical - needs attention soon.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.server_hardware["{#LOCATION}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["server-hardware"].members[?(@.name == "{#LOCATION}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Storage pool [{#NAME}]: Capacity allocated |<p>Capacity allocated from the storage pool in bytes.</p> |DEPENDENT |hpe.synergy.storage.pools.capacity["{#NAME}",allocated]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-pools"].members[?(@.name == "{#NAME}")].allocatedCapacity.first()`</p> |
|HPE |Storage pool [{#NAME}]: Capacity free |<p>Free capacity available from the storage pool in bytes.</p> |DEPENDENT |hpe.synergy.storage.pools.capacity["{#NAME}",free]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-pools"].members[?(@.name == "{#NAME}")].freeCapacity.first()`</p> |
|HPE |Storage pool [{#NAME}]: Capacity allocated to snapshots |<p>The pool capacity allocated to snapshots in bytes.</p> |DEPENDENT |hpe.synergy.storage.pools.capacity["{#NAME}",snapshot]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-pools"].members[?(@.name == "{#NAME}")].deviceSpecificAttributes.allocatedCapacity.snapshotAllocatedCapacity.first()`</p> |
|HPE |Storage pool [{#NAME}]: State |<p>Current state of the resource:</p><p>AddFailed - An attempt to add the resource failed</p><p>Adding - The resource is in the process of being added</p><p>Configured - The resource is configured</p><p>Connected - The appliance has connected to the resource</p><p>Copying - The resource is in the process of being copied</p><p>CreateFailed - An attempt to create the resource failed</p><p>Creating - The resource is in the process of being created</p><p>DeleteFailed - An attempt to delete the resource failed</p><p>Deleting - The resource is in the process of being deleted</p><p>Discovered - The resource has been discovered by the appliance, but it is not managed by the appliance</p><p>Managed - The resource is managed by the appliance</p><p>Normal - The resource is in a normal state</p><p>UpdateFailed - An attempt to update the resource failed</p><p>Updating - The resource is in the process of being updated</p> |DEPENDENT |hpe.synergy.storage.pools["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-pools"].members[?(@.name == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `AddFailed 0`</p><p>- STR_REPLACE: `Adding 1`</p><p>- STR_REPLACE: `Configured 2`</p><p>- STR_REPLACE: `Connected 3`</p><p>- STR_REPLACE: `Copying 4`</p><p>- STR_REPLACE: `CreateFailed 5`</p><p>- STR_REPLACE: `Creating 6`</p><p>- STR_REPLACE: `DeleteFailed 7`</p><p>- STR_REPLACE: `Deleting 8`</p><p>- STR_REPLACE: `Discovered 9`</p><p>- STR_REPLACE: `Managed 10`</p><p>- STR_REPLACE: `Normal 11`</p><p>- STR_REPLACE: `UpdateFailed 12`</p><p>- STR_REPLACE: `Updating 13`</p><p>- IN_RANGE: `0 13 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 14`</p> |
|HPE |Storage pool [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.storage.pools["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-pools"].members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Storage pool [{#NAME}]: Capacity total |<p>Total capacity of the storage pool in bytes.</p> |DEPENDENT |hpe.synergy.storage.pools.capacity["{#NAME}",total]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-pools"].members[?(@.name == "{#NAME}")].totalCapacity.first()`</p> |
|HPE |Storage system [{#NAME}]: Capacity allocated |<p>Capacity allocated in bytes.</p> |DEPENDENT |hpe.synergy.storage.system.capacity["{#NAME}",allocated]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-systems"].members[?(@.name == "{#NAME}")].allocatedCapacity.first()`</p> |
|HPE |Storage system [{#NAME}]: Capacity free |<p>Free capacity of the storage system in bytes.</p> |DEPENDENT |hpe.synergy.storage.system.capacity["{#NAME}",free]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-systems"].members[?(@.name == "{#NAME}")].freeCapacity.first()`</p> |
|HPE |Storage system [{#NAME}]: State |<p>Current state of the resource:</p><p>AddFailed - An attempt to add the resource failed</p><p>Adding - The resource is in the process of being added</p><p>Configured - The resource is configured</p><p>Connected - The appliance has connected to the resource</p><p>Copying - The resource is in the process of being copied</p><p>CreateFailed - An attempt to create the resource failed</p><p>Creating - The resource is in the process of being created</p><p>DeleteFailed - An attempt to delete the resource failed</p><p>Deleting - The resource is in the process of being deleted</p><p>Discovered - The resource has been discovered by the appliance, but it is not managed by the appliance</p><p>Managed - The resource is managed by the appliance</p><p>Normal - The resource is in a normal state</p><p>UpdateFailed - An attempt to update the resource failed</p><p>Updating - The resource is in the process of being updated</p> |DEPENDENT |hpe.synergy.storage.system["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-systems"].members[?(@.name == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `AddFailed 0`</p><p>- STR_REPLACE: `Adding 1`</p><p>- STR_REPLACE: `Configured 2`</p><p>- STR_REPLACE: `Connected 3`</p><p>- STR_REPLACE: `Copying 4`</p><p>- STR_REPLACE: `CreateFailed 5`</p><p>- STR_REPLACE: `Creating 6`</p><p>- STR_REPLACE: `DeleteFailed 7`</p><p>- STR_REPLACE: `Deleting 8`</p><p>- STR_REPLACE: `Discovered 9`</p><p>- STR_REPLACE: `Managed 10`</p><p>- STR_REPLACE: `Normal 11`</p><p>- STR_REPLACE: `UpdateFailed 12`</p><p>- STR_REPLACE: `Updating 13`</p><p>- IN_RANGE: `0 13 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 14`</p> |
|HPE |Storage system [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.storage.system["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-systems"].members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Storage system [{#NAME}]: Capacity total |<p>Total capacity of the storage system in bytes.</p> |DEPENDENT |hpe.synergy.storage.system.capacity["{#NAME}",total]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-systems"].members[?(@.name == "{#NAME}")].totalCapacity.first()`</p> |
|HPE |Storage volume [{#NAME}]: Capacity allocated |<p>Capacity allocated in bytes.</p> |DEPENDENT |hpe.synergy.storage.volumes.capacity["{#NAME}",allocated]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-volumes"].members[?(@.name == "{#NAME}")].allocatedCapacity.first()`</p> |
|HPE |Storage volume [{#NAME}]: Capacity provisioned |<p>Total provisioned capacity of volume in bytes.</p> |DEPENDENT |hpe.synergy.storage.volumes.capacity["{#NAME}",provisioned]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-volumes"].members[?(@.name == "{#NAME}")].provisionedCapacity.first()`</p> |
|HPE |Storage volume [{#NAME}]: State |<p>Current state of the resource:</p><p>AddFailed - An attempt to add the resource failed</p><p>Adding - The resource is in the process of being added</p><p>Configured - The resource is configured</p><p>Connected - The appliance has connected to the resource</p><p>Copying - The resource is in the process of being copied</p><p>CreateFailed - An attempt to create the resource failed</p><p>Creating - The resource is in the process of being created</p><p>DeleteFailed - An attempt to delete the resource failed</p><p>Deleting - The resource is in the process of being deleted</p><p>Discovered - The resource has been discovered by the appliance, but it is not managed by the appliance</p><p>Managed - The resource is managed by the appliance</p><p>Normal - The resource is in a normal state</p><p>UpdateFailed - An attempt to update the resource failed</p><p>Updating - The resource is in the process of being updated</p> |DEPENDENT |hpe.synergy.storage.volumes["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-volumes"].members[?(@.name == "{#NAME}")].state.first()`</p><p>- STR_REPLACE: `AddFailed 0`</p><p>- STR_REPLACE: `Adding 1`</p><p>- STR_REPLACE: `Configured 2`</p><p>- STR_REPLACE: `Connected 3`</p><p>- STR_REPLACE: `Copying 4`</p><p>- STR_REPLACE: `CreateFailed 5`</p><p>- STR_REPLACE: `Creating 6`</p><p>- STR_REPLACE: `DeleteFailed 7`</p><p>- STR_REPLACE: `Deleting 8`</p><p>- STR_REPLACE: `Discovered 9`</p><p>- STR_REPLACE: `Managed 10`</p><p>- STR_REPLACE: `Normal 11`</p><p>- STR_REPLACE: `UpdateFailed 12`</p><p>- STR_REPLACE: `Updating 13`</p><p>- IN_RANGE: `0 13 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 14`</p> |
|HPE |Storage volume [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.storage.volumes["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["storage-volumes"].members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Firmware version |<p>The firmware version of the manager.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",fw_version]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].fwVersion.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Link port state |<p>The state of the LINK port:</p><p>Disabled - The port is disabled.</p><p>Linked - The port is linked.</p><p>Unlinked - The port is unlinked.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",link_port_state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].linkPortState.first()`</p><p>- STR_REPLACE: `Disabled 0`</p><p>- STR_REPLACE: `Linked 1`</p><p>- STR_REPLACE: `Unlinked 2`</p><p>- IN_RANGE: `0 2 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Link port status |<p>The status of the LINK port:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behavior.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",link_port_status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].linkPortStatus.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: MGMT port state |<p>The state of the MGMT port:</p><p>Active - The port is in active mode.</p><p>Disabled - The port is in disabled mode.</p><p>I3s - The port is configured for OS deployment network traffic.</p><p>Other - The port is in other mode.</p><p>Standby - The port is in standby mode.</p><p>Unknown - The port mode is not known.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",mgmt_port_state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].mgmtPortState.first()`</p><p>- STR_REPLACE: `Active 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `I3s 2`</p><p>- STR_REPLACE: `Other 3`</p><p>- STR_REPLACE: `Standby 4`</p><p>- STR_REPLACE: `Unknown 5`</p><p>- IN_RANGE: `0 5 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 5`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: MGMT port status |<p>The status of the MGMT port:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behavior.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",mgmt_port_status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].mgmtPortStatus.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Model |<p>The model of the link module.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",model]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].model.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Part number |<p>The part number of the link module.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].partNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Presence |<p>Indicates whether a manager is present in the bay:</p><p>Absent - The device slot is empty.</p><p>PresenceNoOp - The device slot is uninitialized.</p><p>PresenceUnknown - The device presence is unknown.</p><p>Present - The device slot has a device in it.</p><p>Subsumed - The device slot is configured to be part of another device slot. Not applicable for fan or power supply bays.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].devicePresence.first()`</p><p>- STR_REPLACE: `Absent 0`</p><p>- STR_REPLACE: `PresenceNoOp 1`</p><p>- STR_REPLACE: `PresenceUnknown 2`</p><p>- STR_REPLACE: `Present 3`</p><p>- STR_REPLACE: `Subsumed 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 2`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Serial number |<p>The serial number of the link module.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",serial_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].serialNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Spare part number |<p>The spare part number of the link module.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",spare_part_number]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].sparePartNumber.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|HPE |Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Status |<p>The health status of the link module:</p><p>Critical - Needs immediate attention.</p><p>Disabled - The resource is currently not operational.</p><p>OK - Indicates normal/informational behavior.</p><p>Unknown - The health status is not yet known or cannot be determined.</p><p>Warning - Needs attention soon.</p> |DEPENDENT |hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.enclosures.members[?(@.name == "{#ENCLOSURE_NAME}")].managerBays[?(@.bayNumber == "{#BAY_NUMBER}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |
|HPE |Uplink set [{#NAME}]: State |<p>Current state of the resource.</p> |DEPENDENT |hpe.synergy.uplink_set["{#NAME}",state]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["uplink-sets"].members[?(@.name == "{#NAME}")].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|HPE |Uplink set [{#NAME}]: Status |<p>Overall health status of the resource. The following are the valid values for the status of the resource:</p><p>OK - indicates normal/informational behavior.</p><p>Disabled - indicates that a resource is not operational.</p><p>Warning - needs attention soon.</p><p>Critical - needs immediate attention.</p><p>Unknown - should be avoided, but there may be rare occasions where status is Unknown.</p> |DEPENDENT |hpe.synergy.uplink_set["{#NAME}",status]<p>**Preprocessing**:</p><p>- JSONPATH: `$.["uplink-sets"].members[?(@.name == "{#NAME}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p><p>- STR_REPLACE: `Critical 0`</p><p>- STR_REPLACE: `Disabled 1`</p><p>- STR_REPLACE: `OK 2`</p><p>- STR_REPLACE: `Unknown 3`</p><p>- STR_REPLACE: `Warning 4`</p><p>- IN_RANGE: `0 4 `</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|HPE Synergy: There are errors in requests to API |<p>Zabbix has received errors in requests to API.</p> |`length(last(/HPE Synergy by HTTP/hpe.synergy.data.errors))>0` |AVERAGE |<p>**Depends on**:</p><p>- HPE Synergy: Service is unavailable</p> |
|HPE Synergy: Service is unavailable |<p>-</p> |`max(/HPE Synergy by HTTP/net.tcp.service["{$HPE.SYNERGY.API.SCHEME}","{HOST.CONN}","{$HPE.SYNERGY.API.PORT}"],5m)=0` |HIGH |<p>Manual close: YES</p> |
|Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has critical status |<p>Appliance [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=0` |HIGH | |
|Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has warning status |<p>Appliance [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=4` |WARNING | |
|Appliance bay [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is disabled |<p>Appliance [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.appliance["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=1` |INFO | |
|Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is subsumed |<p>The device slot is configured to be part of another device slot.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence])=4` |AVERAGE | |
|Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has critical status |<p>Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=0` |HIGH | |
|Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has warning status |<p>Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=4` |WARNING | |
|Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is disabled |<p>Crossbar [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.crossbar["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=1` |INFO | |
|Datacenter [{#NAME}]: Add error |<p>Datacenter [{#NAME}] add failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.datacenter["{#NAME}",state])=1` |AVERAGE | |
|Datacenter [{#NAME}]: Has credential error |<p>Datacenter [{#NAME}] has credential error.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.datacenter["{#NAME}",state])=3` |AVERAGE | |
|Datacenter [{#NAME}]: Has refresh error |<p>Datacenter [{#NAME}] has refresh error.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.datacenter["{#NAME}",state])=5` |AVERAGE | |
|Datacenter [{#NAME}]: Has remove error |<p>Datacenter [{#NAME}] has remove error.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.datacenter["{#NAME}",state])=7` |AVERAGE | |
|Datacenter [{#NAME}]: Has critical status |<p>Datacenter [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.datacenter["{#NAME}",status])=0` |HIGH | |
|Datacenter [{#NAME}]: Has warning status |<p>Datacenter [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.datacenter["{#NAME}",status])=4` |WARNING | |
|Datacenter [{#NAME}]: Is disabled |<p>Datacenter [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.datacenter["{#NAME}",status])=1` |INFO | |
|Device [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is subsumed |<p>The device slot is configured to be part of another device slot.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.device["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence])=4` |AVERAGE | |
|Enclosure [{#NAME}]: Is interrupted |<p>The previous operation on the enclosure did not complete. The operation should be re-attempted.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state])=3 and last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state_reason])>-1` |WARNING | |
|Enclosure [{#NAME}]: Is unsupported |<p>The enclosure model or version is not currently supported by HPE OneView. It cannot be configured or monitored.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state])=9 and last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state_reason])>-1` |AVERAGE | |
|Enclosure [{#NAME}]: Remove failed |<p>The previous operation to remove the enclosure did not succeed. The operation should be re-attempted.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state])=6 and last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state_reason])>-1` |WARNING | |
|Enclosure [{#NAME}]: Is missing |<p>The enclosure is no longer connected into the frame link topology.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state_reason])=0` |AVERAGE | |
|Enclosure [{#NAME}]: Is unowned |<p>The enclosure reports not being under management.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",state_reason])=5` |AVERAGE | |
|Enclosure [{#NAME}]: Has critical status |<p>Enclosure [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",status])=0` |HIGH | |
|Enclosure [{#NAME}]: Has warning status |<p>Enclosure [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",status])=4` |WARNING | |
|Enclosure [{#NAME}]: Is disabled |<p>Enclosure [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.enclosure["{#NAME}",status])=1` |INFO | |
|Ethernet network [{#NAME}]: Has critical status |<p>Ethernet network [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.ethernet.network["{#NAME}",status])=0` |HIGH | |
|Ethernet network [{#NAME}]: Has warning status |<p>Ethernet network [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.ethernet.network["{#NAME}",status])=4` |WARNING | |
|Ethernet network [{#NAME}]: Is disabled |<p>Ethernet network [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.ethernet.network["{#NAME}",status])=1` |INFO | |
|Fabric [{#NAME}]: Has critical status |<p>Fabric [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fabric["{#NAME}",status])=0` |HIGH | |
|Fabric [{#NAME}]: Has warning status |<p>Fabric [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fabric["{#NAME}",status])=4` |WARNING | |
|Fabric [{#NAME}]: Is disabled |<p>Fabric [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fabric["{#NAME}",status])=1` |INFO | |
|Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is degraded |<p>Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] is in degraded state.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",state])=0` |AVERAGE | |
|Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is failed |<p>Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] is in failed state.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",state])=1` |HIGH | |
|Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is misplaced |<p>Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] is misplaced.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",state])=2` |WARNING | |
|Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is missing |<p>Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] is missing.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",state])=3` |AVERAGE | |
|Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has critical status |<p>Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=0` |HIGH | |
|Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has warning status |<p>Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=4` |WARNING | |
|Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is disabled |<p>Fan [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fan["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=1` |INFO | |
|FC network [{#NAME}]: Has critical status |<p>FC network [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fc.network["{#NAME}",status])=0` |HIGH | |
|FC network [{#NAME}]: Has warning status |<p>FC network [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fc.network["{#NAME}",status])=4` |WARNING | |
|FC network [{#NAME}]: Is disabled |<p>FC network [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.fc.network["{#NAME}",status])=1` |INFO | |
|Hypervisor manager [{#NAME}]: Is in error state |<p>Hypervisor manager [{#NAME}] has error.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.hypervisor_manager["{#NAME}",state])=3 and length(last(/HPE Synergy by HTTP/hpe.synergy.hypervisor_manager["{#NAME}",state_reason]))>0` |HIGH | |
|Hypervisor manager [{#NAME}]: Has critical status |<p>Hypervisor manager [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.hypervisor_manager["{#NAME}",status])=0` |HIGH | |
|Hypervisor manager [{#NAME}]: Has warning status |<p>Hypervisor manager [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.hypervisor_manager["{#NAME}",status])=4` |WARNING | |
|Hypervisor manager [{#NAME}]: Is disabled |<p>Hypervisor manager [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.hypervisor_manager["{#NAME}",status])=1` |INFO | |
|Interconnect [{#NAME}]: Has critical status |<p>Interconnect [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.interconnect["{#NAME}",status])=0` |HIGH | |
|Interconnect [{#NAME}]: Has warning status |<p>Interconnect [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.interconnect["{#NAME}",status])=4` |WARNING | |
|Interconnect [{#NAME}]: Is disabled |<p>Interconnect [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.interconnect["{#NAME}",status])=1` |INFO | |
|Logical enclosure [{#NAME}]: Delete failed |<p>Indicator that the deletion of a logical enclosure failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.logical_enclosure["{#NAME}",state])=2` |AVERAGE | |
|Logical enclosure [{#NAME}]: Is inconsistent |<p>The configuration of the logical enclosure differs from that of the enclosure group, or the configuration of the hardware resources is inconsistent with the logical enclosure configuration. Perform an Update from group, Reapply configuration, or Update firmware action as appropriate to bring the configuration back into consistency.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.logical_enclosure["{#NAME}",state])=0` |AVERAGE | |
|Logical enclosure [{#NAME}]: Has critical status |<p>Logical enclosure [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.logical_enclosure["{#NAME}",status])=0` |HIGH | |
|Logical enclosure [{#NAME}]: Has warning status |<p>Logical enclosure [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.logical_enclosure["{#NAME}",status])=4` |WARNING | |
|Logical enclosure [{#NAME}]: Is disabled |<p>Logical enclosure [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.logical_enclosure["{#NAME}",status])=1` |INFO | |
|Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Health is invalid |<p>Partition health is invalid.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",health])=1` |AVERAGE | |
|Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Health is degraded |<p>One or more resources in the partition are unhealthy.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",health])=0` |HIGH | |
|Partition [{#ENCLOSURE_NAME}:{#PARTITION_ID}]: Is invalid |<p>Partition status is invalid.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.partition["{#PARTITION_ID}","{#ENCLOSURE_NAME}",status])=2` |AVERAGE | |
|Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has critical status |<p>Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=0` |HIGH | |
|Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has warning status |<p>Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=4` |WARNING | |
|Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is disabled |<p>Power Supply [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.power_supply["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=1` |INFO | |
|Rack [{#NAME}]: Add error |<p>Rack [{#NAME}] add failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.rack["{#NAME}",state])=1` |AVERAGE | |
|Rack [{#NAME}]: Has credential error |<p>Rack [{#NAME}] has credential error.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.rack["{#NAME}",state])=3` |AVERAGE | |
|Rack [{#NAME}]: Has refresh error |<p>Rack [{#NAME}] has refresh error.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.rack["{#NAME}",state])=5` |AVERAGE | |
|Rack [{#NAME}]: Has remove error |<p>Rack [{#NAME}] has remove error.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.rack["{#NAME}",state])=7` |AVERAGE | |
|Rack [{#NAME}]: Has critical status |<p>Rack [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.rack["{#NAME}",status])=0` |HIGH | |
|Rack [{#NAME}]: Has warning status |<p>Rack [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.rack["{#NAME}",status])=4` |WARNING | |
|Rack [{#NAME}]: Is disabled |<p>Rack [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.rack["{#NAME}",status])=1` |INFO | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Is in maintenance mode |<p>Disruptive maintenance operations like firmware update can cause many server hardware alerts to be generated in a short period of time. Ex: Network connectivity lost or Server reset detected.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",maintenance_state])=0 and length(last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",maintenance_state_reason]))>0` |INFO | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Has profile error |<p>Unsuccessful profile apply or removal.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",state])=11` |AVERAGE | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Is not initialized |<p>Server not initialized.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",state])=0` |WARNING | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Is unsupported |<p>Server model or version not currently supported by the appliance.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",state])=12` |AVERAGE | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Remove failed |<p>The previous operation to remove the server hardware did not succeed. The operation should be re-attempted.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",state])=6` |AVERAGE | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Is unmanaged |<p>Discovered a supported server.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",state])=4 and length(last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",state_reason]))>0` |AVERAGE | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Has critical status |<p>Server [{#SERVER_NAME}:{#LOCATION}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",status])=0` |HIGH | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Has warning status |<p>Server [{#SERVER_NAME}:{#LOCATION}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",status])=4` |WARNING | |
|Server [{#SERVER_NAME}:{#LOCATION}]: Is disabled |<p>Server [{#SERVER_NAME}:{#LOCATION}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.server_hardware["{#LOCATION}",status])=1` |INFO | |
|Storage pool [{#NAME}]: Add error |<p>Storage pool [{#NAME}] add failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.pools["{#NAME}",state])=0` |AVERAGE | |
|Storage pool [{#NAME}]: Create failed |<p>Storage pool [{#NAME}] create failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.pools["{#NAME}",state])=5` |AVERAGE | |
|Storage pool [{#NAME}]: Delete failed |<p>Storage pool [{#NAME}] delete failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.pools["{#NAME}",state])=7` |AVERAGE | |
|Storage pool [{#NAME}]: Update failed |<p>Storage pool [{#NAME}] update failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.pools["{#NAME}",state])=12` |AVERAGE | |
|Storage pool [{#NAME}]: Has critical status |<p>Storage pool [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.pools["{#NAME}",status])=0` |HIGH | |
|Storage pool [{#NAME}]: Has warning status |<p>Storage pool [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.pools["{#NAME}",status])=4` |WARNING | |
|Storage pool [{#NAME}]: Is disabled |<p>Storage pool [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.pools["{#NAME}",status])=1` |INFO | |
|Storage system [{#NAME}]: Add error |<p>Storage system [{#NAME}] add failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.system["{#NAME}",state])=0` |AVERAGE | |
|Storage system [{#NAME}]: Create failed |<p>Storage system [{#NAME}] create failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.system["{#NAME}",state])=5` |AVERAGE | |
|Storage system [{#NAME}]: Delete failed |<p>Storage system [{#NAME}] delete failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.system["{#NAME}",state])=7` |AVERAGE | |
|Storage system [{#NAME}]: Update failed |<p>Storage system [{#NAME}] update failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.system["{#NAME}",state])=12` |AVERAGE | |
|Storage system [{#NAME}]: Has critical status |<p>Storage system [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.system["{#NAME}",status])=0` |HIGH | |
|Storage system [{#NAME}]: Has warning status |<p>Storage system [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.system["{#NAME}",status])=4` |WARNING | |
|Storage system [{#NAME}]: Is disabled |<p>Storage system [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.system["{#NAME}",status])=1` |INFO | |
|Storage volume [{#NAME}]: Add error |<p>Storage volume [{#NAME}] add failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.volumes["{#NAME}",state])=0` |AVERAGE | |
|Storage volume [{#NAME}]: Create failed |<p>Storage volume [{#NAME}] create failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.volumes["{#NAME}",state])=5` |AVERAGE | |
|Storage volume [{#NAME}]: Delete failed |<p>Storage volume [{#NAME}] delete failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.volumes["{#NAME}",state])=7` |AVERAGE | |
|Storage volume [{#NAME}]: Update failed |<p>Storage volume [{#NAME}] update failed.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.volumes["{#NAME}",state])=12` |AVERAGE | |
|Storage volume [{#NAME}]: Has critical status |<p>Storage volume [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.volumes["{#NAME}",status])=0` |HIGH | |
|Storage volume [{#NAME}]: Has warning status |<p>Storage volume [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.volumes["{#NAME}",status])=4` |WARNING | |
|Storage volume [{#NAME}]: Is disabled |<p>Storage volume [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.storage.volumes["{#NAME}",status])=1` |INFO | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Link port has critical status |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] link port status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",link_port_status])=0` |HIGH | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Link port has warning status |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] link port status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",link_port_status])=4` |WARNING | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Link port is disabled |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] link port currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",link_port_status])=1` |INFO | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: MGMT port has critical status |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] mgmt port status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",mgmt_port_status])=0` |HIGH | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: MGMT port has warning status |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] MGMT port status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",mgmt_port_status])=4` |WARNING | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: MGMT port is disabled |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] MGMT port currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",mgmt_port_status])=1` |INFO | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is subsumed |<p>The device slot is configured to be part of another device slot.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",presence])=4` |AVERAGE | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has critical status |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=0` |HIGH | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Has warning status |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=4` |WARNING | |
|Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}]: Is disabled |<p>Manager [{#ENCLOSURE_NAME}:{#BAY_NUMBER}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.manager["{#BAY_NUMBER}","{#ENCLOSURE_NAME}",status])=1` |INFO | |
|Uplink set [{#NAME}]: Has critical status |<p>Uplink set [{#NAME}] status is critical. Needs immediate attention.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.uplink_set["{#NAME}",status])=0` |HIGH | |
|Uplink set [{#NAME}]: Has warning status |<p>Uplink set [{#NAME}] status is warning. Needs attention soon.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.uplink_set["{#NAME}",status])=4` |WARNING | |
|Uplink set [{#NAME}]: Is disabled |<p>Uplink set [{#NAME}] currently not operational.</p> |`last(/HPE Synergy by HTTP/hpe.synergy.uplink_set["{#NAME}",status])=1` |INFO | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

You can also provide feedback, discuss the template or ask for help with it at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/).

