CREATE TABLE acknowledges_tmp (
	acknowledgeid	bigint DEFAULT '0'	NOT NULL,
	userid		bigint DEFAULT '0'	NOT NULL,
	eventid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	message		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (acknowledgeid)
) with OIDS;
CREATE INDEX acknowledges_1 on acknowledges_tmp (userid);
CREATE INDEX acknowledges_2 on acknowledges_tmp (eventid);
CREATE INDEX acknowledges_3 on acknowledges_tmp (clock);

insert into acknowledges_tmp select * from acknowledges;
drop table acknowledges;
alter table acknowledges_tmp rename to acknowledges;
CREATE TABLE actions_tmp (
        actionid                bigint         DEFAULT '0'     NOT NULL,
        name                    varchar(255)            DEFAULT ''      NOT NULL,
        eventsource             integer         DEFAULT '0'     NOT NULL,
        evaltype                integer         DEFAULT '0'     NOT NULL,
        status          integer         DEFAULT '0'     NOT NULL,
        PRIMARY KEY (actionid)
) with OIDS;

CREATE TABLE operations (
        operationid             bigint         DEFAULT '0'     NOT NULL,
        actionid                bigint         DEFAULT '0'     NOT NULL,
        operationtype           integer         DEFAULT '0'     NOT NULL,
        object          integer         DEFAULT '0'     NOT NULL,
        objectid                bigint         DEFAULT '0'     NOT NULL,
        shortdata               varchar(255)            DEFAULT ''      NOT NULL,
        longdata                text            DEFAULT ''      NOT NULL,
        scripts_tmp             text            DEFAULT ''      NOT NULL,
        PRIMARY KEY (operationid)
) with OIDS;
CREATE INDEX operations_1 on operations (actionid);

insert into actions_tmp select actionid,actionid,source,0,status from actions;

insert into operations select actionid,actionid,actiontype,recipient,userid,subject,message,scripts from actions;
update operations set longdata=scripts_tmp where operationtype=1;
alter table operations drop scripts_tmp;

drop table actions;
alter table actions_tmp rename to actions;
CREATE TABLE alerts_tmp (
	alertid		bigint	DEFAULT '0'	NOT NULL,
	actionid	bigint	DEFAULT '0'	NOT NULL,
	triggerid	bigint	DEFAULT '0'	NOT NULL,
	userid		bigint	DEFAULT '0'	NOT NULL,
	clock		integer	DEFAULT '0'	NOT NULL,
	mediatypeid	bigint	DEFAULT '0'	NOT NULL,
	sendto		varchar(100)		DEFAULT ''	NOT NULL,
	subject		varchar(255)		DEFAULT ''	NOT NULL,
	message		text	DEFAULT ''	NOT NULL,
	status		integer	DEFAULT '0'	NOT NULL,
	retries		integer	DEFAULT '0'	NOT NULL,
	error		varchar(128)		DEFAULT ''	NOT NULL,
	nextcheck	integer	DEFAULT '0'	NOT NULL,
	PRIMARY KEY (alertid)
) with OIDS;
CREATE INDEX alerts_1 on alerts_tmp (actionid);
CREATE INDEX alerts_2 on alerts_tmp (clock);
CREATE INDEX alerts_3 on alerts_tmp (triggerid);
CREATE INDEX alerts_4 on alerts_tmp (status,retries);
CREATE INDEX alerts_5 on alerts_tmp (mediatypeid);
CREATE INDEX alerts_6 on alerts_tmp (userid);

insert into alerts_tmp select alertid,actionid,triggerid,userid,clock,mediatypeid,sendto,subject,message,status,retries,error,nextcheck from alerts;
drop table alerts;
alter table alerts_tmp rename to alerts;
CREATE TABLE applications_tmp (
        applicationid	bigint	DEFAULT '0'     NOT NULL,
        hostid          bigint	DEFAULT '0'     NOT NULL,
        name            varchar(255)            DEFAULT ''      NOT NULL,
        templateid	bigint	DEFAULT '0'     NOT NULL,
        PRIMARY KEY (applicationid)
) with OIDS;

CREATE INDEX applications_1 on applications_tmp (templateid);
CREATE UNIQUE INDEX applications_2 on applications_tmp (hostid,name);

insert into applications_tmp select * from applications;
drop table applications;
alter table applications_tmp rename to applications;
CREATE TABLE auditlog_tmp (
	auditid		bigint	DEFAULT '0'	NOT NULL,
	userid		bigint	DEFAULT '0'	NOT NULL,
	clock		integer	DEFAULT '0'	NOT NULL,
	action		integer	DEFAULT '0'	NOT NULL,
	resourcetype	integer		DEFAULT '0'	NOT NULL,
	details		varchar(128)		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (auditid)
) with OIDS;
CREATE INDEX auditlog_1 on auditlog_tmp (userid,clock);
CREATE INDEX auditlog_2 on auditlog_tmp (clock);

insert into auditlog_tmp select * from auditlog;
drop table auditlog;
alter table auditlog_tmp rename to auditlog;
drop table autoreg;
CREATE TABLE conditions_tmp (
	conditionid	bigint DEFAULT '0'	NOT NULL,
	actionid	bigint DEFAULT '0'	NOT NULL,
	conditiontype	integer		DEFAULT '0'	NOT NULL,
	operator	integer		DEFAULT '0'	NOT NULL,
	value		varchar(255)	DEFAULT ''	NOT NULL,
	PRIMARY KEY (conditionid)
) with OIDS;
CREATE INDEX conditions_1 on conditions_tmp (actionid);

insert into conditions_tmp select * from conditions;
drop table conditions;
alter table conditions_tmp rename to conditions;
CREATE TABLE config_tmp (
	configid		bigint	DEFAULT '0'	NOT NULL,
	alert_history		integer	DEFAULT '0'	NOT NULL,
	event_history		integer	DEFAULT '0'	NOT NULL,
	refresh_unsupported	integer	DEFAULT '0'	NOT NULL,
	work_period		varchar(100)		DEFAULT '1-5,00:00-24:00'	NOT NULL,
	alert_usrgrpid		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (configid)
) with OIDS;

insert into config_tmp select 1,alert_history,alarm_history,refresh_unsupported,work_period,0 from config;
drop table config;
alter table config_tmp rename to config;
CREATE TABLE dchecks (
        dcheckid        bigint DEFAULT '0'     NOT NULL,
        druleid         bigint DEFAULT '0'     NOT NULL,
        type            integer         DEFAULT '0'     NOT NULL,
        key_            varchar(255)            DEFAULT '0'     NOT NULL,
        snmp_community  varchar(255)            DEFAULT '0'     NOT NULL,
        ports           varchar(255)            DEFAULT '0'     NOT NULL,
        PRIMARY KEY (dcheckid)
) with OIDS;
CREATE TABLE dhosts (
        dhostid         bigint DEFAULT '0'     NOT NULL,
        druleid         bigint DEFAULT '0'     NOT NULL,
        ip              varchar(15)             DEFAULT ''      NOT NULL,
        status          integer         DEFAULT '0'     NOT NULL,
        lastup          integer         DEFAULT '0'     NOT NULL,
        lastdown        integer         DEFAULT '0'     NOT NULL,
        PRIMARY KEY (dhostid)
) with OIDS;
CREATE TABLE drules (
        druleid         bigint DEFAULT '0'     NOT NULL,
        name            varchar(255)            DEFAULT ''      NOT NULL,
        iprange         varchar(255)            DEFAULT ''      NOT NULL,
        delay           integer         DEFAULT '0'     NOT NULL,
        nextcheck       integer         DEFAULT '0'     NOT NULL,
        status          integer         DEFAULT '0'     NOT NULL,
        PRIMARY KEY (druleid)
) with OIDS;
CREATE TABLE dservices (
        dserviceid      bigint DEFAULT '0'     NOT NULL,
        dhostid         bigint DEFAULT '0'     NOT NULL,
        type            integer         DEFAULT '0'     NOT NULL,
        key_            varchar(255)            DEFAULT '0'     NOT NULL,
        value           varchar(255)            DEFAULT '0'     NOT NULL,
        port            integer         DEFAULT '0'     NOT NULL,
        status          integer         DEFAULT '0'     NOT NULL,
        lastup          integer         DEFAULT '0'     NOT NULL,
        lastdown        integer         DEFAULT '0'     NOT NULL,
        PRIMARY KEY (dserviceid)
) with OIDS;
CREATE TABLE events (
        eventid         bigint          DEFAULT '0'     NOT NULL,
        source          integer         DEFAULT '0'     NOT NULL,
        object          integer         DEFAULT '0'     NOT NULL,
        objectid                bigint          DEFAULT '0'     NOT NULL,
        clock           integer         DEFAULT '0'     NOT NULL,
        value           integer         DEFAULT '0'     NOT NULL,
        acknowledged            integer         DEFAULT '0'     NOT NULL,
        PRIMARY KEY (eventid)
) with OIDS;
CREATE INDEX events_1 on events (object,objectid,clock);
CREATE INDEX events_2 on events (clock);

insert into events select alarmid,0,0,triggerid,clock,value,acknowledged from alarms;
drop table alarms;
CREATE TABLE functions_tmp (
	functionid	bigint	DEFAULT '0'	NOT NULL,
	itemid		bigint	DEFAULT '0'	NOT NULL,
	triggerid	bigint	DEFAULT '0'	NOT NULL,
	lastvalue	varchar(255)			,
	function	varchar(12)		DEFAULT ''	NOT NULL,
	parameter	varchar(255)		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (functionid)
) with OIDS;
CREATE INDEX functions_1 on functions_tmp (triggerid);
CREATE INDEX functions_2 on functions_tmp (itemid,function,parameter);

insert into functions_tmp select * from functions;
drop table functions;
alter table functions_tmp rename to functions;
CREATE TABLE graphs_items_tmp (
	gitemid		bigint	DEFAULT '0'	NOT NULL,
	graphid		bigint	DEFAULT '0'	NOT NULL,
	itemid		bigint	DEFAULT '0'	NOT NULL,
	drawtype	integer		DEFAULT '0'	NOT NULL,
	sortorder	integer		DEFAULT '0'	NOT NULL,
	color		varchar(32)		DEFAULT 'Dark Green'	NOT NULL,
	yaxisside	integer		DEFAULT '1'	NOT NULL,
	calc_fnc	integer		DEFAULT '2'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	periods_cnt	integer		DEFAULT '5'	NOT NULL,
	PRIMARY KEY (gitemid)
) with OIDS;

insert into graphs_items_tmp select * from graphs_items;
drop table graphs_items;
alter table graphs_items_tmp rename to graphs_items;
CREATE TABLE graphs_tmp (
	graphid		bigint	DEFAULT '0'	NOT NULL,
	name		varchar(128)		DEFAULT ''	NOT NULL,
	width		integer	DEFAULT '0'	NOT NULL,
	height		integer	DEFAULT '0'	NOT NULL,
	yaxistype	integer	DEFAULT '0'	NOT NULL,
	yaxismin	numeric(16,4)		DEFAULT '0'	NOT NULL,
	yaxismax	numeric(16,4)		DEFAULT '0'	NOT NULL,
	templateid	bigint DEFAULT '0'	NOT NULL,
	show_work_period	integer		DEFAULT '1'	NOT NULL,
	show_triggers		integer		DEFAULT '1'	NOT NULL,
	graphtype		integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (graphid)
) with OIDS;
CREATE INDEX graphs_graphs_1 on graphs_tmp (name);

insert into graphs_tmp select *,0 from graphs;
drop table graphs;
alter table graphs_tmp rename to graphs;
CREATE TABLE groups_tmp (
	groupid		bigint DEFAULT '0'	NOT NULL,
	name		varchar(64)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (groupid)
) with OIDS;
CREATE INDEX groups_1 on groups_tmp (name);

insert into groups_tmp select * from groups;
drop table groups;
alter table groups_tmp rename to groups;
CREATE TABLE help_items_tmp (
	itemtype	integer		DEFAULT '0'	NOT NULL,
	key_		varchar(255)		DEFAULT ''	NOT NULL,
	description	varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (itemtype,key_)
) with OIDS;

insert into help_items_tmp select * from help_items;
drop table help_items;
alter table help_items_tmp rename to help_items;
CREATE TABLE history_log_tmp (
	id		bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	timestamp	integer		DEFAULT '0'	NOT NULL,
	source		varchar(64)	DEFAULT ''	NOT NULL,
	severity	integer		DEFAULT '0'	NOT NULL,
	value		varchar(255)	DEFAULT ''	NOT NULL,
	PRIMARY KEY (id)
) with OIDS;
CREATE INDEX history_log_1 on history_log_tmp (itemid,clock);

insert into history_log_tmp select * from history_log;
drop table history_log;
alter table history_log_tmp rename to history_log;
CREATE TABLE history_tmp (
	itemid		bigint	DEFAULT '0'	NOT NULL,
	clock		integer	DEFAULT '0'	NOT NULL,
	value		numeric(16,4)	DEFAULT '0.0000'	NOT NULL
) with OIDS;
CREATE INDEX history_1 on history_tmp (itemid,clock);

insert into history_tmp select * from history;
drop table history;
alter table history_tmp rename to history;
CREATE TABLE history_str_tmp (
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	value		varchar(255)		DEFAULT ''	NOT NULL
) with OIDS;
CREATE INDEX history_str_1 on history_str_tmp (itemid,clock);

insert into history_str_tmp select * from history_str;
drop table history_str;
alter table history_str_tmp rename to history_str;
CREATE TABLE history_str_sync (
	id		serial			,
	nodeid		bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	value		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (id)
) with OIDS;
CREATE INDEX history_str_sync_1 on history_str_sync (nodeid,id);
CREATE TABLE history_sync (
	id		serial			,
	nodeid		bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	value		numeric(16,4)		DEFAULT '0.0000'	NOT NULL,
	PRIMARY KEY (id)
) with OIDS;
CREATE INDEX history_sync_1 on history_sync (nodeid,id);
CREATE TABLE history_text_tmp (
	id		bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	value		text		DEFAULT ''	NOT NULL,
	PRIMARY KEY (id)
) with OIDS;
CREATE INDEX history_text_1 on history_text_tmp (itemid,clock);

insert into history_text_tmp select * from history_text;
drop table history_text;
alter table history_text_tmp rename to history_text;
CREATE TABLE history_uint_tmp (
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	value		bigint DEFAULT '0'	NOT NULL
) with OIDS;
CREATE INDEX history_uint_1 on history_uint_tmp (itemid,clock);

insert into history_uint_tmp select * from history_uint;
drop table history_uint;
alter table history_uint_tmp rename to history_uint;
CREATE TABLE history_uint_sync (
	id		serial			,
	nodeid		bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	value		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (id)
) with OIDS;
CREATE INDEX history_uint_sync_1 on history_uint_sync (nodeid,id);
CREATE TABLE hosts_groups_tmp (
	hostgroupid	bigint DEFAULT '0'	NOT NULL,
	hostid		bigint DEFAULT '0'	NOT NULL,
	groupid		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (hostgroupid)
) with OIDS;
CREATE INDEX hosts_groups_tmp_1 on hosts_groups_tmp (hostid,groupid);

insert into hosts_groups_tmp select NULL,hostid,groupid from hosts_groups;
drop table hosts_groups;
alter table hosts_groups_tmp rename to hosts_groups;


CREATE TABLE hosts_groups_tmp (
	hostgroupid	bigint DEFAULT '0'	NOT NULL,
	hostid		bigint DEFAULT '0'	NOT NULL,
	groupid		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (hostgroupid)
) with OIDS;
CREATE INDEX hosts_groups_1 on hosts_groups_tmp (hostid,groupid);

insert into hosts_groups_tmp select * from hosts_groups;
drop table hosts_groups;
alter table hosts_groups_tmp rename to hosts_groups;
CREATE TABLE hosts_profiles_tmp (
	hostid		bigint DEFAULT '0'	NOT NULL,
	devicetype	varchar(64)		DEFAULT ''	NOT NULL,
	name		varchar(64)		DEFAULT ''	NOT NULL,
	os		varchar(64)		DEFAULT ''	NOT NULL,
	serialno	varchar(64)		DEFAULT ''	NOT NULL,
	tag		varchar(64)		DEFAULT ''	NOT NULL,
	macaddress	varchar(64)		DEFAULT ''	NOT NULL,
	hardware	text		DEFAULT ''	NOT NULL,
	software	text		DEFAULT ''	NOT NULL,
	contact		text		DEFAULT ''	NOT NULL,
	location	text		DEFAULT ''	NOT NULL,
	notes		text		DEFAULT ''	NOT NULL,
	PRIMARY KEY (hostid)
) with OIDS;

insert into hosts_profiles_tmp select * from hosts_profiles;
drop table hosts_profiles;
alter table hosts_profiles_tmp rename to hosts_profiles;
CREATE TABLE hosts_tmp (
	hostid		bigint DEFAULT '0'	NOT NULL,
	host		varchar(64)		DEFAULT ''	NOT NULL,
	dns		varchar(64)		DEFAULT ''	NOT NULL,
	useip		integer		DEFAULT '1'	NOT NULL,
	ip		varchar(15)		DEFAULT '127.0.0.1'	NOT NULL,
	port		integer		DEFAULT '0'	NOT NULL,
	status		integer		DEFAULT '0'	NOT NULL,
	disable_until	integer		DEFAULT '0'	NOT NULL,
	error		varchar(128)		DEFAULT ''	NOT NULL,
	available	integer		DEFAULT '0'	NOT NULL,
	errors_from	integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (hostid)
) with OIDS;
CREATE INDEX hosts_1 on hosts_tmp (host);
CREATE INDEX hosts_2 on hosts_tmp (status);

insert into hosts_tmp select hostid,host,host,useip,ip,port,status,disable_until,error,available,errors_from from hosts;
drop table hosts;
alter table hosts_tmp rename to hosts;
CREATE TABLE hosts_templates_tmp (
	hosttemplateid	bigint DEFAULT '0'	NOT NULL,
	hostid		bigint DEFAULT '0'	NOT NULL,
	templateid	bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (hosttemplateid)
) with OIDS;
CREATE UNIQUE INDEX hosts_templates_tmp_1 on hosts_templates_tmp (hostid,templateid);

insert into hosts_templates_tmp select NULL,hostid,templateid from  hosts_templates;
drop table  hosts_templates;
alter table hosts_templates_tmp rename  to hosts_templates;

CREATE TABLE hosts_templates_tmp (
	hosttemplateid	bigint DEFAULT '0'	NOT NULL,
	hostid		bigint DEFAULT '0'	NOT NULL,
	templateid	bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (hosttemplateid)
) with OIDS;
CREATE UNIQUE INDEX hosts_templates_1 on hosts_templates_tmp (hostid,templateid);

insert into hosts_templates_tmp select * from  hosts_templates;
drop table  hosts_templates;
alter table hosts_templates_tmp rename to hosts_templates;
CREATE TABLE housekeeper_tmp (
	housekeeperid	bigint DEFAULT '0'	NOT NULL,
	tablename	varchar(64)		DEFAULT ''	NOT NULL,
	field		varchar(64)		DEFAULT ''	NOT NULL,
	value		bigint		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (housekeeperid)
) with OIDS;

insert into housekeeper_tmp select * from housekeeper;
drop table housekeeper;
alter table housekeeper_tmp rename to housekeeper;
CREATE TABLE httpstepitem (
	httpstepitemid	bigint DEFAULT '0'	NOT NULL,
	httpstepid	bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (httpstepitemid)
) with OIDS;
CREATE UNIQUE INDEX httpstepitem_httpstepitem_1 on httpstepitem (httpstepid,itemid);
CREATE TABLE httpstep (
	httpstepid	bigint DEFAULT '0'	NOT NULL,
	httptestid	bigint DEFAULT '0'	NOT NULL,
	name		varchar(64)		DEFAULT ''	NOT NULL,
	no		integer		DEFAULT '0'	NOT NULL,
	url		varchar(128)		DEFAULT ''	NOT NULL,
	timeout		integer		DEFAULT '30'	NOT NULL,
	posts		text		DEFAULT ''	NOT NULL,
	required	varchar(255)		DEFAULT ''	NOT NULL,
	status_codes	varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (httpstepid)
) with OIDS;
CREATE INDEX httpstep_httpstep_1 on httpstep (httptestid);
CREATE TABLE httptestitem (
	httptestitemid	bigint DEFAULT '0'	NOT NULL,
	httptestid	bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (httptestitemid)
) with OIDS;
CREATE TABLE httptest (
	httptestid	bigint DEFAULT '0'	NOT NULL,
	name		varchar(64)		DEFAULT ''	NOT NULL,
	applicationid	bigint DEFAULT '0'	NOT NULL,
	lastcheck	integer		DEFAULT '0'	NOT NULL,
	nextcheck	integer		DEFAULT '0'	NOT NULL,
	curstate	integer		DEFAULT '0'	NOT NULL,
	curstep		integer		DEFAULT '0'	NOT NULL,
	lastfailedstep	integer		 DEFAULT '0'	NOT NULL,
	delay		integer		DEFAULT '60'	NOT NULL,
	status		integer		DEFAULT '0'	NOT NULL,
	macros		text		DEFAULT ''	NOT NULL,
	agent		varchar(255)		DEFAULT ''	NOT NULL,
	time		numeric(16,4)		DEFAULT '0'	NOT NULL,
	error		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (httptestid)
) with OIDS;
CREATE INDEX httptest_httptest_1 on httptest (httptestid);
CREATE TABLE ids (
        nodeid          integer         DEFAULT '0'     NOT NULL,
        table_name	varchar(64)             DEFAULT ''      NOT NULL,
        field_name	varchar(64)             DEFAULT ''      NOT NULL,
        nextid          bigint DEFAULT '0'     NOT NULL,
        PRIMARY KEY (nodeid,table_name,field_name)
) with OIDS;
CREATE TABLE images_tmp (
	imageid		bigint DEFAULT '0'	NOT NULL,
	imagetype	integer		DEFAULT '0'	NOT NULL,
	name		varchar(64)		DEFAULT '0'	NOT NULL,
	image		bytea	DEFAULT ''	NOT NULL,
	PRIMARY KEY (imageid)
) with OIDS;
CREATE INDEX images_1 on images_tmp (imagetype,name);

insert into images_tmp select * from images;
drop table images;
alter table images_tmp rename to images;
CREATE TABLE items_applications_tmp (
	itemappid	bigint DEFAULT '0'	NOT NULL,
	applicationid	bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (itemappid)
) with OIDS;
CREATE INDEX items_applications_tmp_1 on items_applications_tmp (applicationid,itemid);

insert into items_applications_tmp select NULL,applicationid,itemid from items_applications;
drop table items_applications;
alter table items_applications_tmp rename to items_applications;

CREATE TABLE items_applications_tmp (
	itemappid	bigint DEFAULT '0'	NOT NULL,
	applicationid	bigint DEFAULT '0'	NOT NULL,
	itemid		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (itemappid)
) with OIDS;
CREATE INDEX items_applications_1 on items_applications_tmp (applicationid,itemid);

insert into items_applications_tmp select * from items_applications;
drop table items_applications;
alter table items_applications_tmp rename to items_applications;
CREATE TABLE items_tmp (
	itemid		bigint DEFAULT '0'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	snmp_community	varchar(64)		DEFAULT ''	NOT NULL,
	snmp_oid	varchar(255)		DEFAULT ''	NOT NULL,
	snmp_port	integer		DEFAULT '161'	NOT NULL,
	hostid		bigint DEFAULT '0'	NOT NULL,
	description	varchar(255)		DEFAULT ''	NOT NULL,
	key_		varchar(255)		DEFAULT ''	NOT NULL,
	delay		integer		DEFAULT '0'	NOT NULL,
	history		integer		DEFAULT '90'	NOT NULL,
	trends		integer		DEFAULT '365'	NOT NULL,
	nextcheck	integer		DEFAULT '0'	NOT NULL,
	lastvalue	varchar(255)			NULL,
	lastclock	integer			NULL,
	prevvalue	varchar(255)			NULL,
	status		integer		DEFAULT '0'	NOT NULL,
	value_type	integer		DEFAULT '0'	NOT NULL,
	trapper_hosts	varchar(255)		DEFAULT ''	NOT NULL,
	units		varchar(10)		DEFAULT ''	NOT NULL,
	multiplier	integer		DEFAULT '0'	NOT NULL,
	delta		integer		DEFAULT '0'	NOT NULL,
	prevorgvalue	varchar(255)			NULL,
	snmpv3_securityname		varchar(64)		DEFAULT ''	NOT NULL,
	snmpv3_securitylevel		integer		DEFAULT '0'	NOT NULL,
	snmpv3_authpassphrase		varchar(64)		DEFAULT ''	NOT NULL,
	snmpv3_privpassphrase		varchar(64)		DEFAULT ''	NOT NULL,
	formula		varchar(255)		DEFAULT '0'	NOT NULL,
	error		varchar(128)		DEFAULT ''	NOT NULL,
	lastlogsize	integer		DEFAULT '0'	NOT NULL,
	logtimefmt	varchar(64)		DEFAULT ''	NOT NULL,
	templateid	bigint DEFAULT '0'	NOT NULL,
	valuemapid	bigint DEFAULT '0'	NOT NULL,
	delay_flex	varchar(255)		DEFAULT ''	NOT NULL,
	params		text			DEFAULT ''	NOT NULL,
	PRIMARY KEY (itemid)
) with OIDS;
CREATE UNIQUE INDEX items_1 on items_tmp (hostid,key_);
CREATE INDEX items_2 on items_tmp (nextcheck);
CREATE INDEX items_3 on items_tmp (status);

insert into items_tmp select *,'','' from items;
drop table items;
alter table items_tmp rename to items;
CREATE TABLE mappings_tmp (
	mappingid	bigint DEFAULT '0'	NOT NULL,
	valuemapid	bigint DEFAULT '0'	NOT NULL,
	value		varchar(64)		DEFAULT ''	NOT NULL,
	newvalue	varchar(64)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (mappingid)
) with OIDS;
CREATE INDEX mappings_1 on mappings_tmp (valuemapid);

insert into mappings_tmp select * from mappings;
drop table mappings;
alter table mappings_tmp rename to mappings;
CREATE TABLE media_tmp (
	mediaid		bigint DEFAULT '0'	NOT NULL,
	userid		bigint DEFAULT '0'	NOT NULL,
	mediatypeid	bigint DEFAULT '0'	NOT NULL,
	sendto		varchar(100)		DEFAULT ''	NOT NULL,
	active		integer		DEFAULT '0'	NOT NULL,
	severity	integer		DEFAULT '63'	NOT NULL,
	period		varchar(100)		DEFAULT '1-7,00:00-23:59'	NOT NULL,
	PRIMARY KEY (mediaid)
) with OIDS;
CREATE INDEX media_1 on media_tmp (userid);
CREATE INDEX media_2 on media_tmp (mediatypeid);

insert into media_tmp select * from media;
drop table media;
alter table media_tmp rename to media;
CREATE TABLE media_type_tmp (
	mediatypeid	bigint DEFAULT '0'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	description	varchar(100)		DEFAULT ''	NOT NULL,
	smtp_server	varchar(255)		DEFAULT ''	NOT NULL,
	smtp_helo	varchar(255)		DEFAULT ''	NOT NULL,
	smtp_email	varchar(255)		DEFAULT ''	NOT NULL,
	exec_path	varchar(255)		DEFAULT ''	NOT NULL,
	gsm_modem	varchar(255)		DEFAULT ''	NOT NULL,
	username	varchar(255)		DEFAULT ''	NOT NULL,
	passwd		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (mediatypeid)
) with OIDS;

insert into media_type_tmp select mediatypeid,type,description,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,'','' from media_type;
drop table media_type;
alter table media_type_tmp rename to media_type;
CREATE TABLE node_cksum (
	cksumid		bigint DEFAULT '0'	NOT NULL,
	nodeid		bigint DEFAULT '0'	NOT NULL,
	tablename	varchar(64)		DEFAULT ''	NOT NULL,
	fieldname	varchar(64)		DEFAULT ''	NOT NULL,
	recordid	bigint DEFAULT '0'	NOT NULL,
	cksumtype	integer		DEFAULT '0'	NOT NULL,
	cksum		char(32)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (cksumid)
) with OIDS;
CREATE INDEX node_cksum_cksum_1 on node_cksum (nodeid,tablename,fieldname,recordid,cksumtype);
CREATE TABLE node_configlog (
	conflogid	bigint DEFAULT '0'	NOT NULL,
	nodeid		bigint DEFAULT '0'	NOT NULL,
	tablename	varchar(64)		DEFAULT ''	NOT NULL,
	recordid	bigint DEFAULT '0'	NOT NULL,
	operation	integer		DEFAULT '0'	NOT NULL,
	sync_master	integer		DEFAULT '0'	NOT NULL,
	sync_slave	integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (nodeid,conflogid)
) with OIDS;
CREATE INDEX node_configlog_configlog_1 on node_configlog (conflogid);
CREATE INDEX node_configlog_configlog_2 on node_configlog (nodeid,tablename);
CREATE TABLE nodes (
	nodeid		integer		DEFAULT '0'	NOT NULL,
	name		varchar(64)		DEFAULT '0'	NOT NULL,
	timezone	integer		DEFAULT '0'	NOT NULL,
	ip		varchar(15)		DEFAULT ''	NOT NULL,
	port		integer		DEFAULT '10051'	NOT NULL,
	slave_history	integer		DEFAULT '30'	NOT NULL,
	slave_trends	integer		DEFAULT '365'	NOT NULL,
	event_lastid	bigint DEFAULT '0'	NOT NULL,
	history_lastid	bigint DEFAULT '0'	NOT NULL,
	history_str_lastid	bigint DEFAULT '0'	NOT NULL,
	history_uint_lastid	bigint DEFAULT '0'	NOT NULL,
	nodetype		integer		DEFAULT '0'	NOT NULL,
	masterid		integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (nodeid)
) with OIDS;
-- See actions.sql
CREATE TABLE profiles_tmp (
	profileid	bigint DEFAULT '0'	NOT NULL,
	userid		bigint DEFAULT '0'	NOT NULL,
	idx		varchar(64)		DEFAULT ''	NOT NULL,
	value		varchar(255)		DEFAULT ''	NOT NULL,
	valuetype	integer		DEFAULT 0	NOT NULL,
	PRIMARY KEY (profileid)
) with OIDS;
CREATE UNIQUE INDEX profiles_tmp_1 on profiles_tmp (userid,idx);

insert into profiles_tmp select NULL,userid,idx,value,valuetype from profiles;
drop table profiles;
alter table profiles_tmp rename to profiles;

CREATE TABLE profiles_tmp (
	profileid	bigint DEFAULT '0'	NOT NULL,
	userid		bigint DEFAULT '0'	NOT NULL,
	idx		varchar(64)		DEFAULT ''	NOT NULL,
	value		varchar(255)		DEFAULT ''	NOT NULL,
	valuetype	integer		DEFAULT 0	NOT NULL,
	PRIMARY KEY (profileid)
) with OIDS;
CREATE UNIQUE INDEX profiles_1 on profiles_tmp (userid,idx);

insert into profiles_tmp select * from profiles;
drop table profiles;
alter table profiles_tmp rename to profiles;
CREATE TABLE rights_tmp (
	rightid		bigint DEFAULT '0'	NOT NULL,
	groupid		bigint DEFAULT '0'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	permission	integer		DEFAULT '0'	NOT NULL,
	id		bigint,
	PRIMARY KEY (rightid)
) with OIDS;
CREATE INDEX rights_1 on rights_tmp (groupid);

--insert into rights_tmp select rightid,groupid,type::integer,permission,id from rights;
drop table rights;
alter table rights_tmp rename to rights;
CREATE TABLE screens_items_tmp (
	screenitemid	bigint DEFAULT '0'	NOT NULL,
	screenid	bigint DEFAULT '0'	NOT NULL,
	resourcetype	integer		DEFAULT '0'	NOT NULL,
	resourceid	bigint DEFAULT '0'	NOT NULL,
	width		integer		DEFAULT '320'	NOT NULL,
	height		integer		DEFAULT '200'	NOT NULL,
	x		integer		DEFAULT '0'	NOT NULL,
	y		integer		DEFAULT '0'	NOT NULL,
	colspan		integer		DEFAULT '0'	NOT NULL,
	rowspan		integer		DEFAULT '0'	NOT NULL,
	elements	integer		DEFAULT '25'	NOT NULL,
	valign		integer		DEFAULT '0'	NOT NULL,
	halign		integer		DEFAULT '0'	NOT NULL,
	style		integer		DEFAULT '0'	NOT NULL,
	url		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (screenitemid)
) with OIDS;

insert into screens_items_tmp select NULL,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url from screens_items;
drop table screens_items;
alter table screens_items_tmp rename to screens_items;

CREATE TABLE screens_items_tmp (
	screenitemid	bigint DEFAULT '0'	NOT NULL,
	screenid	bigint DEFAULT '0'	NOT NULL,
	resourcetype	integer		DEFAULT '0'	NOT NULL,
	resourceid	bigint DEFAULT '0'	NOT NULL,
	width		integer		DEFAULT '320'	NOT NULL,
	height		integer		DEFAULT '200'	NOT NULL,
	x		integer		DEFAULT '0'	NOT NULL,
	y		integer		DEFAULT '0'	NOT NULL,
	colspan		integer		DEFAULT '0'	NOT NULL,
	rowspan		integer		DEFAULT '0'	NOT NULL,
	elements	integer		DEFAULT '25'	NOT NULL,
	valign		integer		DEFAULT '0'	NOT NULL,
	halign		integer		DEFAULT '0'	NOT NULL,
	style		integer		DEFAULT '0'	NOT NULL,
	url		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (screenitemid)
) with OIDS;

insert into screens_items_tmp select * from screens_items;
drop table screens_items;
alter table screens_items_tmp rename to screens_items;
CREATE TABLE screens_tmp (
	screenid	bigint DEFAULT '0'	NOT NULL,
	name		varchar(255)		DEFAULT 'Screen'	NOT NULL,
	hsize		integer		DEFAULT '1'	NOT NULL,
	vsize		integer		DEFAULT '1'	NOT NULL,
	PRIMARY KEY (screenid)
) with OIDS;

insert into screens_tmp select * from screens;
drop table screens;
alter table screens_tmp rename to screens;
CREATE TABLE service_alarms_tmp (
	servicealarmid	bigint DEFAULT '0'	NOT NULL,
	serviceid	bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	value		integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (servicealarmid)
) with OIDS;
CREATE INDEX service_alarms_1 on service_alarms_tmp (serviceid,clock);
CREATE INDEX service_alarms_2 on service_alarms_tmp (clock);

insert into service_alarms_tmp select * from service_alarms;
drop table service_alarms;
alter table service_alarms_tmp rename to service_alarms;
CREATE TABLE services_links_tmp (
	linkid		bigint DEFAULT '0'	NOT NULL,
	serviceupid	bigint DEFAULT '0'	NOT NULL,
	servicedownid	bigint DEFAULT '0'	NOT NULL,
	soft		integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (linkid)
) with OIDS;
CREATE INDEX services_links_links_1 on services_links_tmp (servicedownid);
CREATE UNIQUE INDEX services_links_links_2 on services_links_tmp (serviceupid,servicedownid);

insert into services_links_tmp select * from services_links;
drop table services_links;
alter table services_links_tmp rename to services_links;
CREATE TABLE services_tmp (
	serviceid	bigint DEFAULT '0'	NOT NULL,
	name		varchar(128)		DEFAULT ''	NOT NULL,
	status		integer		DEFAULT '0'	NOT NULL,
	algorithm	integer		DEFAULT '0'	NOT NULL,
	triggerid	bigint ,
	showsla		integer		DEFAULT '0'	NOT NULL,
	goodsla		numeric(5,2)		DEFAULT '99.9'	NOT NULL,
	sortorder	integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (serviceid)
) with OIDS;

insert into services_tmp select * from services;
drop table services;
alter table services_tmp rename to services;
CREATE TABLE services_times (
	timeid		bigint DEFAULT '0'	NOT NULL,
	serviceid	bigint DEFAULT '0'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	ts_from		integer		DEFAULT '0'	NOT NULL,
	ts_to		integer		DEFAULT '0'	NOT NULL,
	note		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (timeid)
) with OIDS;
CREATE INDEX services_times_times_1 on services_times (serviceid,type,ts_from,ts_to);
CREATE TABLE sessions_tmp (
	sessionid	varchar(32)		DEFAULT ''	NOT NULL,
	userid		bigint DEFAULT '0'	NOT NULL,
	lastaccess	integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (sessionid)
) with OIDS;

insert into sessions_tmp select * from sessions;
drop table sessions;
alter table sessions_tmp rename to sessions;
CREATE TABLE slideshows (
        slideshowid     bigint DEFAULT '0'     NOT NULL,
        name            varchar(255)            DEFAULT ''      NOT NULL,
        delay           integer         DEFAULT '0'     NOT NULL,
        PRIMARY KEY (slideshowid)
) with OIDS;
CREATE TABLE slides (
        slideid         bigint	DEFAULT '0'     NOT NULL,
        slideshowid     bigint 	DEFAULT '0'     NOT NULL,
        screenid        bigint 	DEFAULT '0'     NOT NULL,
        step            integer         DEFAULT '0'     NOT NULL,
        delay           integer         DEFAULT '0'     NOT NULL,
        PRIMARY KEY (slideid)
) with OIDS;
CREATE INDEX slides_slides_1 on slides (slideshowid);

CREATE TABLE sysmaps_elements_tmp (
	selementid	bigint DEFAULT '0'	NOT NULL,
	sysmapid	bigint DEFAULT '0'	NOT NULL,
	elementid	bigint DEFAULT '0'	NOT NULL,
	elementtype	integer		DEFAULT '0'	NOT NULL,
	iconid_off	bigint DEFAULT '0'	NOT NULL,
	iconid_on	bigint DEFAULT '0'	NOT NULL,
	iconid_unknown	bigint DEFAULT '0'	NOT NULL,
	label		varchar(128)		DEFAULT ''	NOT NULL,
	label_location	integer			NULL,
	x		integer		DEFAULT '0'	NOT NULL,
	y		integer		DEFAULT '0'	NOT NULL,
	url		varchar(255)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (selementid)
) with OIDS;

insert into sysmaps_elements_tmp select s.selementid,s.sysmapid,s.elementid,s.elementtype,i1.imageid,i2.imageid,i1.imageid,s.label,s.label_location,s.x,s.y,s.url from sysmaps_elements s,images i1,images i2 where s.icon=i1.name and s.icon_on=i2.name;
drop table sysmaps_elements;
alter table sysmaps_elements_tmp rename to sysmaps_elements;
CREATE TABLE sysmaps_links_tmp (
	linkid		bigint DEFAULT '0'	NOT NULL,
	sysmapid	bigint DEFAULT '0'	NOT NULL,
	selementid1	bigint DEFAULT '0'	NOT NULL,
	selementid2	bigint DEFAULT '0'	NOT NULL,
	triggerid	bigint ,
	drawtype_off	integer		DEFAULT '0'	NOT NULL,
	color_off	varchar(32)		DEFAULT 'Black'	NOT NULL,
	drawtype_on	integer		DEFAULT '0'	NOT NULL,
	color_on	varchar(32)		DEFAULT 'Red'	NOT NULL,
	PRIMARY KEY (linkid)
) with OIDS;

insert into sysmaps_links_tmp select * from sysmaps_links;
drop table sysmaps_links;
alter table sysmaps_links_tmp rename to sysmaps_links;
CREATE TABLE sysmaps_tmp (
	sysmapid	bigint DEFAULT '0'	NOT NULL,
	name		varchar(128)		DEFAULT ''	NOT NULL,
	width		integer		DEFAULT '0'	NOT NULL,
	height		integer		DEFAULT '0'	NOT NULL,
	backgroundid	bigint DEFAULT '0'	NOT NULL,
	label_type	integer		DEFAULT '0'	NOT NULL,
	label_location	integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (sysmapid)
) with OIDS;
CREATE INDEX sysmaps_1 on sysmaps_tmp (name);

insert into sysmaps_tmp select s.sysmapid,s.name,s.width,s.height,i.imageid,s.label_type,s.label_location from sysmaps s,images i where s.background=i.name;
insert into sysmaps_tmp select s.sysmapid,s.name,s.width,s.height,0,s.label_type,s.label_location from sysmaps s where s.background='';
drop table sysmaps;
alter table sysmaps_tmp rename to sysmaps;
CREATE TABLE trends_tmp (
	itemid		bigint DEFAULT '0'	NOT NULL,
	clock		integer		DEFAULT '0'	NOT NULL,
	num		integer		DEFAULT '0'	NOT NULL,
	value_min	numeric(16,4)		DEFAULT '0.0000'	NOT NULL,
	value_avg	numeric(16,4)		DEFAULT '0.0000'	NOT NULL,
	value_max	numeric(16,4)		DEFAULT '0.0000'	NOT NULL,
	PRIMARY KEY (itemid,clock)
) with OIDS;

insert into trends_tmp select * from trends;
drop table trends;
alter table trends_tmp rename to trends;
CREATE TABLE trigger_depends_tmp (
	triggerdepid		bigint DEFAULT '0'	NOT NULL,
	triggerid_down		bigint DEFAULT '0'	NOT NULL,
	triggerid_up		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (triggerdepid)
) with OIDS;
CREATE INDEX trigger_depends_tmp_1 on trigger_depends_tmp (triggerid_down,triggerid_up);
CREATE INDEX trigger_depends_tmp_2 on trigger_depends_tmp (triggerid_up);

insert into trigger_depends_tmp select NULL,triggerid_down,triggerid_up from trigger_depends;
drop table trigger_depends;
alter table trigger_depends_tmp rename to trigger_depends;

CREATE TABLE trigger_depends_tmp (
	triggerdepid		bigint DEFAULT '0'	NOT NULL,
	triggerid_down		bigint DEFAULT '0'	NOT NULL,
	triggerid_up		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (triggerdepid)
) with OIDS;
CREATE INDEX trigger_depends_1 on trigger_depends_tmp (triggerid_down,triggerid_up);
CREATE INDEX trigger_depends_2 on trigger_depends_tmp (triggerid_up);

insert into trigger_depends_tmp select * from trigger_depends;
drop table trigger_depends;
alter table trigger_depends_tmp rename to trigger_depends;
CREATE TABLE triggers_tmp (
	triggerid	bigint DEFAULT '0'	NOT NULL,
	expression	varchar(255)		DEFAULT ''	NOT NULL,
	description	varchar(255)		DEFAULT ''	NOT NULL,
	url		varchar(255)		DEFAULT ''	NOT NULL,
	status		integer		DEFAULT '0'	NOT NULL,
	value		integer		DEFAULT '0'	NOT NULL,
	priority	integer		DEFAULT '0'	NOT NULL,
	lastchange	integer		DEFAULT '0'	NOT NULL,
	dep_level	integer		DEFAULT '0'	NOT NULL,
	comments	text			,
	error		varchar(128)		DEFAULT ''	NOT NULL,
	templateid	bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (triggerid)
) with OIDS;
CREATE INDEX triggers_1 on triggers_tmp (status);
CREATE INDEX triggers_2 on triggers_tmp (value);

insert into triggers_tmp select * from triggers;
drop table triggers;
alter table triggers_tmp rename to triggers;
CREATE TABLE users_groups_tmp (
	id		bigint DEFAULT '0'	NOT NULL,
	usrgrpid	bigint DEFAULT '0'	NOT NULL,
	userid		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (id)
) with OIDS;
CREATE INDEX users_groups_tmp_1 on users_groups_tmp (usrgrpid,userid);

insert into users_groups_tmp select NULL,usrgrpid,userid from users_groups;
drop table users_groups;
alter table users_groups_tmp rename to users_groups;

CREATE TABLE users_groups_tmp (
	id		bigint DEFAULT '0'	NOT NULL,
	usrgrpid	bigint DEFAULT '0'	NOT NULL,
	userid		bigint DEFAULT '0'	NOT NULL,
	PRIMARY KEY (id)
) with OIDS;
CREATE INDEX users_groups_1 on users_groups_tmp (usrgrpid,userid);

insert into users_groups_tmp select * from users_groups;
drop table users_groups;
alter table users_groups_tmp rename to users_groups;
CREATE TABLE users_tmp (
	userid		bigint DEFAULT '0'	NOT NULL,
	alias		varchar(100)		DEFAULT ''	NOT NULL,
	name		varchar(100)		DEFAULT ''	NOT NULL,
	surname		varchar(100)		DEFAULT ''	NOT NULL,
	passwd		char(32)		DEFAULT ''	NOT NULL,
	url		varchar(255)		DEFAULT ''	NOT NULL,
	autologout	integer		DEFAULT '900'	NOT NULL,
	lang		varchar(5)		DEFAULT 'en_gb'	NOT NULL,
	refresh		integer		DEFAULT '30'	NOT NULL,
	type		integer		DEFAULT '0'	NOT NULL,
	PRIMARY KEY (userid)
) with OIDS;
CREATE INDEX users_1 on users_tmp (alias);

insert into users_tmp select userid,alias,name,surname,passwd,url,autologout,lang,refresh,1 from users;
update users_tmp set type=3 where alias='Admin';
drop table users;
alter table users_tmp rename to users;
CREATE TABLE usrgrp_tmp (
	usrgrpid	bigint DEFAULT '0'	NOT NULL,
	name		varchar(64)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (usrgrpid)
) with OIDS;
CREATE INDEX usrgrp_1 on usrgrp_tmp (name);

insert into usrgrp_tmp select * from usrgrp;
drop table usrgrp;
alter table usrgrp_tmp rename to usrgrp;
CREATE TABLE valuemaps_tmp (
	valuemapid	bigint DEFAULT '0'	NOT NULL,
	name		varchar(64)		DEFAULT ''	NOT NULL,
	PRIMARY KEY (valuemapid)
) with OIDS;
CREATE INDEX valuemaps_1 on valuemaps_tmp (name);

insert into valuemaps_tmp select * from valuemaps;
drop table valuemaps;
alter table valuemaps_tmp rename to valuemaps;
