/*
 * YH - Console Chinese Environment -
 * Copyright (C) 1999 Red Flag Linux (office@sonata.iscas.ac.cn)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/*****************---timer.c----*********************/


#include <stdio.h>
#include <signal.h>

#ifdef OPENSERVER
#include <sys/itimer.h>
#else
#include <sys/time.h>
#endif

int	timercounter;

static void	catch_alrm();


/******************functions********************/

void	settimer(millsec)
int	millsec;
{
	struct sigaction	act;
	struct itimerval	itv;

	act.sa_handler = catch_alrm;
#if (defined(OPENSERVER) || defined(GEMINI))
	act.sa_sigaction = catch_alrm;
#endif
	act.sa_flags = 0;
	memset(&act.sa_mask, 0, sizeof(act.sa_mask));
	sigaction(SIGALRM, &act, NULL);

	itv.it_interval.tv_sec = 0;
	itv.it_interval.tv_usec = millsec * 1000;
	itv.it_value = itv.it_interval;
	setitimer(ITIMER_REAL, &itv, NULL);
}


void	killtimer()
{
	struct itimerval      itv;

	itv.it_interval.tv_sec = 0;
	itv.it_interval.tv_usec = 0;
	itv.it_value = itv.it_interval;
	setitimer(ITIMER_REAL, &itv, NULL);
}


void	delay(millsec)
int	millsec;
{
	settimer(millsec);
	wait(NULL);
	killtimer();
}


static void	catch_alrm()
{
	++timercounter;
}
