/* isl.h
 * Definitions for ISL 
 *
 * $Id: isl.h,v 1.4 2005/08/07 18:58:02 t0mac Exp $ 
 *
 * Yersinia
 * By David Barroso <tomac@wasahero.org> and Alfredo Andres <slay@wasahero.org>
 * Copyright 2005 Alfredo Andres and David Barroso
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __ISL_H
#define __ISL_H__

#include <libnet.h>

#include "terminal-defs.h"
#include "interfaces.h"

 
#define ISL_TYPE_ETHERNET   0x00
#define ISL_TYPE_TOKEN_RING 0x10
#define ISL_TYPE_FDDI       0x20
#define ISL_TYPE_ATM        0x30

#define ISL_DFL_MAC_DST "01:00:0C:00:00:00"
#define ISL_DFL_TYPE    ISL_TYPE_ETHERNET 
#define ISL_DFL_USER    0x00
#define ISL_DFL_SNAP    "\xAA\xAA\x03"

struct isl_data { 
     u_int8_t  mac_source[ETHER_ADDR_LEN];
     u_int8_t  mac_dest[ETHER_ADDR_LEN];
     u_int8_t  type;
     u_int8_t  user;
     u_int16_t len;
     u_int8_t  snap[3];
     u_int8_t  hsa[3];
     u_int16_t vlan;
     u_int8_t  bpdu;
     u_int16_t index;
     u_int16_t res;
     u_int32_t src_ip;
     u_int32_t dst_ip;
     u_int8_t  ip_proto;
};

#define ISL_TOTAL_FIELDS 15

#define ISL_SMAC       0
#define ISL_DMAC       1
#define ISL_TYPE       2
#define ISL_USER       3
#define ISL_LEN        4
#define ISL_SNAP       5 
#define ISL_HSA        6 
#define ISL_VLAN       7
#define ISL_BPDU       8
#define ISL_INDEX      9
#define ISL_RES        10
#define ISL_SRC_IP     11
#define ISL_DST_IP     12
#define ISL_IP_PROTO   13


#define ISL_TYPE_ETHERNET   0x00
#define ISL_TYPE_TOKEN_RING 0x10
#define ISL_TYPE_FDDI       0x20
#define ISL_TYPE_ATM        0x30

static const struct tuple_type_desc isl_type[] = {
     { ISL_TYPE_ETHERNET,     "ETHERNET"   },
     { ISL_TYPE_TOKEN_RING,   "TOKEN RING" },
     { ISL_TYPE_FDDI,         "FDDI"       },
     { ISL_TYPE_ATM,          "ATM"        },
     { 0, NULL }
};

static struct proto_features isl_features[] = {
     { F_LLC_DSAP, 0xaa },
     { F_LLC_SSAP, 0xaa },
     { F_LLC_SNAP, 0x03 },
     { F_DMAC_1, 0x01 },
     { F_DMAC_2, 0x00 },
     { F_DMAC_3, 0x0C },
     { F_DMAC_4, 0x00 },
     { F_DMAC_5, 0x00 },
     { -1, 0 }
};

static const struct tuple_type_desc isl_proto[] = {
     { ETHERTYPE_IP,     "IP"   },
     { ETHERTYPE_VLAN,   ".1Q"  },
     { ETHERTYPE_ARP,    "ARP"  },
     { ETHERTYPE_REVARP, "RARP" },
     { 0x2000,           "CDP"  },
     { 0x2003,           "VTP"  },
     { 0x2004,           "DTP"  },
     { 0x9000,           "LOOP" },
     { 0x010b,           "PVST" },
     { 0x4242,           "STP" },
     { 0, NULL }
};

static struct position_fields isl_fields[] = {
     { ISL_SMAC,       "Source MAC",       1,  1, 12, 17, 0,  0, FIELD_MAC, FIELD_FIRST,  NULL },
     { ISL_DMAC,       "Destination MAC",  1, 39, 55, 17, 0,  0, FIELD_MAC, FIELD_NORMAL, NULL },
     { ISL_TYPE,       "Type",             2,  1, 6,   1, 0,  2, FIELD_DEC, FIELD_NORMAL, isl_type }, 
     { ISL_USER,       "User",             2,  8, 13,  1, 0,  0, FIELD_HEX, FIELD_NORMAL, NULL },
     { ISL_LEN ,       "Len",              2, 15, 19,  4, 0,  0, FIELD_HEX, FIELD_NORMAL, NULL },
     { ISL_SNAP,       "Snap",             2, 24, 29,  6, 0,  7, FIELD_HEX, FIELD_NORMAL, NULL },
     { ISL_HSA ,       "HSA",              2, 37, 41,  6, 0,  7, FIELD_HEX, FIELD_NORMAL, NULL },
     { ISL_VLAN,       "VLAN",             2, 49, 54,  4, 1,  8, FIELD_HEX, FIELD_NORMAL, NULL },   
     { ISL_BPDU,       "BPDU",             2, 60, 65,  1, 0,  8, FIELD_DEC, FIELD_NORMAL, NULL },   
     { ISL_INDEX,      "Index",            2, 67, 73,  4, 0,  0, FIELD_HEX, FIELD_NORMAL, NULL },
     { ISL_RES,        "Res",              3, 1,  5,   4, 0, 50, FIELD_DEC, FIELD_NORMAL, NULL },
     { ISL_SRC_IP,     "Src IP",           3, 11, 18, 15, 1, 17, FIELD_IP,  FIELD_NORMAL, NULL },
     { ISL_DST_IP,     "Dst IP",           3, 35, 42, 15, 1, 33, FIELD_IP,  FIELD_NORMAL, NULL },   
     { ISL_IP_PROTO,   "Prot",             3, 59, 64,  2, 1, 50, FIELD_DEC, FIELD_LAST,   NULL },
     { 0,              NULL,               0,  0,  0,  0, 0,  0, FIELD_NONE,FIELD_NORMAL, NULL }
};

static struct attack isl_attack[] = {
    { 0,                   NULL,                                0,      0,         NULL,                 NULL, 0           }
};

void   isl_register(void);
char **isl_get_printable_packet(struct pcap_data *data);
char  *isl_get_info(u_int8_t, char *);
char **isl_get_printable_store(struct term_node *);
int8_t isl_init_attribs(struct term_node *);
void   isl_help(void);
int8_t isl_parser( struct term_node *, int8_t, char **, void *);

extern void   thread_libnet_error( char *, libnet_t *);
extern int8_t vrfy_bridge_id( char *, u_int8_t * );
extern int8_t thread_create(pthread_t *, void *, void *);
extern void   write_log( u_int16_t mode, char *msg, ... );
extern int8_t attack_th_exit(struct attacks *);
extern void   attack_gen_mac(u_int8_t *);
extern int8_t interfaces_get_packet(u_int8_t *, struct pcap_pkthdr *, u_int8_t *, u_int16_t, time_t);
extern int8_t parser_vrfy_mac(char *, u_int8_t *);
extern int8_t parser_get_inet_aton(char *, struct in_addr *);
extern int8_t parser_get_formated_inet_address(u_int32_t, char *, u_int16_t);
extern int8_t parser_command2index(register const struct attack *, register int8_t);
extern void   parser_basedisplay(u_int8_t, u_int8_t, char *, size_t );

extern struct interface_data interfaces[];
extern struct terminals *terms;

extern int8_t bin_data[];

#endif
/* vim:set tabstop=4:set expandtab:set shiftwidth=4:set textwidth=78: */
