/* commands.h
 * Definitions for Cisco CLI commands
 *
 * $Id: commands.h,v 1.4 2005/07/28 19:29:24 t0mac Exp $ 
 *
 * Yersinia
 * By David Barroso <tomac@wasahero.org> and Alfredo Andres <slay@wasahero.org>
 * Copyright 2005 Alfredo Andres and David Barroso
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __COMMANDS_H__
#define __COMMANDS_H__

#include "terminal-defs.h"
#include "commands-struct.h"
#include "interfaces.h"
#include "attack.h"

#include "xstp.h"
#include "cdp.h"
#include "dhcp.h"
#include "dtp.h"
#include "hsrp.h"
#include "dot1q.h"
#include "vtp.h"


int8_t command_select_comm(struct term_node *, struct words_array *, int8_t, int8_t);
int8_t command_help(struct term_node *);
int8_t command_bad_input(struct term_node *, int8_t);
int8_t command_proto_attacks(struct term_node *, u_int16_t);
int8_t command_run_generic_attack(struct term_node *, u_int8_t, int8_t);
int8_t command_run_proto(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);
int8_t command_run_proto2(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);
int8_t command_cancel_attacks(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_cancel_proto(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);
int8_t command_cancel_proto2(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);
int8_t command_clear_proto(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);

int8_t command_show_proto(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);
int8_t command_show_proto_params(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);
int8_t command_show_proto_stats(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);
int8_t command_show_proto_attacks(struct term_node *, struct words_array *, int16_t, int8_t, int8_t, u_int8_t);

int8_t show_interface_data(struct term_node *, u_int8_t);

extern struct terminals *terms;
extern struct term_types term_type[];
extern struct term_states term_states[];
extern struct interface_data interfaces[];
extern u_int32_t uptime;

/* Extern functions...*/
extern int8_t term_vty_exit(struct term_node *);
extern int8_t term_vty_flush(struct term_node *);
extern int8_t term_vty_write(struct term_node *, char *, u_int16_t);
extern int8_t attack_launch(struct term_node *, u_int16_t, u_int16_t, struct attack_param *, u_int8_t );
extern int8_t attack_init_params(struct term_node *, struct attack_param *, u_int8_t);
extern int8_t init_attribs(struct term_node *);
extern void   parser_str_tolower( char *);
extern int8_t parser_vrfy_mac( char *, u_int8_t * );
extern int8_t parser_vrfy_bridge_id( char *, u_int8_t * );
extern void   write_log( u_int16_t mode, char *msg, ... );

#endif

/* vim:set tabstop=4:set expandtab:set shiftwidth=4:set textwidth=78: */
