/* commands.h
 * Definitions for Cisco CLI commands structures
 *
 * $Id: commands-struct.h,v 1.4 2005/07/28 19:29:24 t0mac Exp $ 
 *
 * Yersinia
 * By David Barroso <tomac@wasahero.org> and Alfredo Andres <slay@wasahero.org>
 * Copyright 2005 Alfredo Andres and David Barroso
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __COMMANDS_STRUCT_H__
#define __COMMANDS_STRUCT_H__

//#include "terminal-defs.h"

struct commands { u_int8_t proto; /* Valid for what protocol? */
                  const char *s;  /* descr */
                  int8_t states[5]; /* Valid for what state? */
                  char *help;     /* Help text  */
                  u_int16_t nparams; /* How many parameters? */
                  char *params;   /* Parameters */
                  int8_t (*command)(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
};


int8_t command_prueba(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_cls(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_exit(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_enable(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_disable(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);

int8_t command_cancel(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);

int8_t command_clear(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);

int8_t command_set(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_stp(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_stp_general(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_stp_defaults(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dtp(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dtp_general(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dtp_defaults(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_cdp(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_cdp_general(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_cdp_defaults(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_hsrp(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_hsrp_general(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_hsrp_defaults(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dot1q(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dot1q_general(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dot1q_defaults(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_vtp(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_vtp_general(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_vtp_defaults(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dhcp(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dhcp_general(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_set_dhcp_defaults(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);

int8_t command_show(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_show_attacks(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_show_history(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_show_users(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_show_interfaces(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_show_version(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);
int8_t command_show_stats(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);

int8_t command_run(struct term_node *, struct words_array *, int16_t, int8_t, int8_t);


struct commands comm_show[]={
 { 255,        "attacks",    { 0, 0, 1, 1, 0 }, "Show running attacks",                           1, "<cr>", command_show_attacks    },
 { PROTO_CDP,  "cdp",        { 0, 0, 1, 1, 0 }, "Cisco Discovery Protocol (CDP) information",     0,  NULL,  NULL        },
 { PROTO_DHCP, "dhcp",       { 0, 0, 1, 1, 0 }, "Dynamic Host Configuration Protocol (DHCP) information",  0,  NULL, NULL        },
 { PROTO_DOT1Q,"dot1q",      { 0, 0, 1, 1, 0 }, "802.1Q information",                             0,  NULL,  NULL     },  
 { PROTO_DTP,  "dtp",        { 0, 0, 1, 1, 0 }, "Dynamic Trunking Protocol (DTP) information",    0,  NULL,  NULL        }, 
 { 255,        "history",    { 0, 0, 1, 1, 0 }, "Display the session command history",            1, "<cr>", command_show_history    }, 
 { PROTO_HSRP, "hsrp",       { 0, 0, 1, 1, 0 }, "Hot Standby Router Protocol (HSRP) information", 0,  NULL,  NULL       },
 { 255,        "interfaces", { 0, 0, 1, 1, 0 }, "Interface status",                               1, "<cr>", command_show_interfaces },  
 { 255,        "stats",      { 0, 0, 1, 1, 0 }, "Show statistics",                                1, "<cr>", command_show_stats      },
 { PROTO_STP,  "stp",        { 0, 0, 1, 1, 0 }, "Spanning Tree Protocol (STP) information",       0,  NULL,  NULL        }, 
 { 255,        "users",      { 0, 0, 1, 1, 0 }, "Display information about terminal lines",       1, "<cr>", command_show_users      },
 { 255,        "version",    { 0, 0, 1, 1, 0 }, "System hardware and software status",            1, "<cr>", command_show_version    },
 { PROTO_VTP,  "vtp",        { 0, 0, 1, 1, 0 }, "Virtual Trunking Protocol (VTP) information",    0,  NULL,  NULL        }, 
 { 255,        NULL,         { 0, 0, 0, 0, 0 },  NULL,                                            0,  NULL,  NULL                    }
};

#define SHOW_ATTACKS 0
#define SHOW_PARAMS  1
#define SHOW_STATS   2
struct commands comm_show_proto[]={
 { 255, "attacks", { 0, 0, 1, 1, 0 }, "Show running protocol attacks",    1, "<cr>", NULL },
 { 255, "params",  { 0, 0, 0, 1, 0 }, "Show protocol params for attacks", 1, "<cr>", NULL }, 
 { 255, "stats",   { 0, 0, 0, 1, 0 }, "Show protocol statistics",         1, "<cr>", NULL },
 { 255, NULL,      { 0, 0, 0, 0, 0 },  NULL,                              0,  NULL,  NULL }
};


struct commands comm_set[]={
 { PROTO_CDP,  "cdp",  { 0, 0, 0, 1, 0 }, "Set cisco discovery params",    0, NULL, command_set_cdp   },
 { PROTO_DHCP, "dhcp", { 0, 0, 0, 1, 0 }, "Set dynamic host params",       0, NULL, command_set_dhcp  },
 { PROTO_DOT1Q,"dot1q",{ 0, 0, 0, 1, 0 }, "Set 802.1Q params",             0, NULL, command_set_dot1q },
 { PROTO_DTP,  "dtp",  { 0, 0, 0, 1, 0 }, "Set dynamic trunking params",   0, NULL, command_set_dtp   }, 
 { PROTO_HSRP, "hsrp", { 0, 0, 0, 1, 0 }, "Set hot standby router params", 0, NULL, command_set_hsrp  },
 { PROTO_STP,  "stp",  { 0, 0, 0, 1, 0 }, "Set spanning tree params",      0, NULL, command_set_stp   },
 { PROTO_VTP,  "vtp",  { 0, 0, 0, 1, 0 }, "Set virtual trunking params",   0, NULL, command_set_vtp   }, 
 { 255,        NULL,   { 0, 0, 0, 0, 0 },  NULL,                           0, NULL, NULL              }
};



struct commands comm_set_dot1q[]={
 { 255, "defaults", { 0, 0, 0, 1, 0 }, "Set all values to default",
              1, " <cr>", command_set_dot1q_defaults },
 { 255, "dest",     { 0, 0, 0, 1, 0 }, "Set destination MAC address", 
              1, " H:H:H:H:H:H    48 bit mac address", command_set_dot1q_general },              
 { 255, "double",   { 0, 0, 0, 1, 0 }, "Set double encapsulated 802.1Q packet", 
              1, " Yes/No    Set it or not", command_set_dot1q_general },              
 { 255, "interface",{ 0, 0, 0, 1, 0 }, "Set network interface to use", 
              1, " WORD    Network interface", command_set_dot1q_general },
 { 255, "iparp",  { 0, 0, 0, 1, 0 }, "Set IP Address for 802.1Q ARP poison attack", 
              1, " A.A.A.A    IPv4 address", command_set_dot1q_general },
 { 255, "ipdest",  { 0, 0, 0, 1, 0 }, "Set 802.1Q IP destination data address", 
              1, " A.A.A.A    IPv4 address", command_set_dot1q_general },
 { 255, "ipsource",{ 0, 0, 0, 1, 0 }, "Set 802.1Q IP source data address", 
              1, " A.A.A.A    IPv4 address", command_set_dot1q_general },
 { 255, "payload",   { 0, 0, 0, 1, 0 }, "Set ICMP payload within 802.1Q data", 
              1, " WORD    ASCII payload", command_set_dot1q_general },
 { 255, "priority1",{ 0, 0, 0, 1, 0 }, "Set 802.1Q vlan1 (outer) priority",
              1, " <0-7>       Priority", command_set_dot1q_general },
 { 255, "priority2",{ 0, 0, 0, 1, 0 }, "Set 802.1Q vlan2 (inner) priority",
              1, " <0-7>       Priority", command_set_dot1q_general },              
 { 255, "source",   { 0, 0, 0, 1, 0 }, "Set source MAC address",       
              1, " H:H:H:H:H:H    48 bit mac address", command_set_dot1q_general },
 { 255, "vlan1",  { 0, 0, 0, 1, 0 }, "Set 802.1Q vlan1 (outer) ID",
              1, " <0-4095>       Outer vlan id", command_set_dot1q_general },
 { 255, "vlan2",  { 0, 0, 0, 1, 0 }, "Set 802.1Q vlan2 (inner) ID",
              1, " <0-4095>       Inner vlan id", command_set_dot1q_general },              
 { 255, "vlanarp", { 0, 0, 0, 1, 0 }, "Set 802.1Q vlan ID for ARP poison attack",
              1, " <0-4095>       ARP poison vlan id", command_set_dot1q_general },              
 { 255, NULL,       { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL      }
};


struct commands comm_set_dtp[]={
 { 255, "defaults", { 0, 0, 0, 1, 0 }, "Set all values to default",
              1, " <cr>", command_set_dtp_defaults },
 { 255, "dest",     { 0, 0, 0, 1, 0 }, "Set destination MAC address", 
              1, " H:H:H:H:H:H    48 bit mac address", command_set_dtp_general },              
 { 255, "domain",   { 0, 0, 0, 1, 0 }, "Set vtp domain name to use", 
              1, " WORD    Domain name", command_set_dtp_general },
 { 255, "interface",{ 0, 0, 0, 1, 0 }, "Set network interface to use", 
              1, " WORD    Network interface", command_set_dtp_general },
 { 255, "neighbor", { 0, 0, 0, 1, 0 }, "Set neighbor id",       
              1, " H:H:H:H:H:H    48 bit neighbor address", command_set_dtp_general },              
 { 255, "source",   { 0, 0, 0, 1, 0 }, "Set source MAC address",       
              1, " H:H:H:H:H:H    48 bit mac address", command_set_dtp_general },
 { 255, "version",  { 0, 0, 0, 1, 0 }, "Set dtp version",
              1, " <0-255>        dynamic trunking version", command_set_dtp_general },
 { 255, NULL,       { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL      }
};


struct commands comm_set_hsrp[]={
 { 255, "defaults", { 0, 0, 0, 1, 0 }, "Set all values to default",
              1, " <cr>", command_set_hsrp_defaults },
 { 255, "dest",     { 0, 0, 0, 1, 0 }, "Set destination MAC address",
              1, " H:H:H:H:H:H    48 bit mac address", command_set_hsrp_general },
 { 255, "dport",   { 0, 0, 0, 1, 0 }, "Set UDP destination port",       
              1, " <0-65535>    UDP destination port", command_set_hsrp_general },
 { 255, "group",  { 0, 0, 0, 1, 0 }, "Set router group",
              1, " <0-255>        Group", command_set_hsrp_general },
 { 255, "hello",  { 0, 0, 0, 1, 0 }, "Set hsrp hello time",
              1, " <0-255>        Seconds", command_set_hsrp_general },
 { 255, "hold",  { 0, 0, 0, 1, 0 }, "Set hsrp hold time",
              1, " <0-255>        Seconds", command_set_hsrp_general },
 { 255, "interface",{ 0, 0, 0, 1, 0 }, "Set network interface to use",
              1, " WORD    Network interface", command_set_hsrp_general },
 { 255, "ipdest",  { 0, 0, 0, 1, 0 }, "Set destination IP address", 
              1, " A.A.A.A    IPv4 address", command_set_hsrp_general },
 { 255, "ipsource",  { 0, 0, 0, 1, 0 }, "Set source IP address", 
              1, " A.A.A.A    IPv4 address", command_set_hsrp_general },
 { 255, "ipvirtual",  { 0, 0, 0, 1, 0 }, "Set virtual IP address", 
              1, " A.A.A.A    IPv4 address", command_set_hsrp_general },
 { 255, "opcode",  { 0, 0, 0, 1, 0 }, "Set hsrp operation code",
              1, " <0-255>        hot standby router code", command_set_hsrp_general },
 { 255, "password", { 0, 0, 0, 1, 0 }, "Set auth password to use",
              1, " WORD    Password", command_set_hsrp_general },
 { 255, "priority",  { 0, 0, 0, 1, 0 }, "Set router priority version",
              1, " <0-255>        Priority", command_set_hsrp_general },
 { 255, "source",   { 0, 0, 0, 1, 0 }, "Set source MAC address",
              1, " H:H:H:H:H:H    48 bit mac address", command_set_hsrp_general },
 { 255, "sport",   { 0, 0, 0, 1, 0 }, "Set UDP source port",       
              1, " <0-65535>    UDP source port", command_set_hsrp_general },
 { 255, "state",  { 0, 0, 0, 1, 0 }, "Set hsrp state",
              1, " <0-255>        State", command_set_hsrp_general },
 { 255, "version",  { 0, 0, 0, 1, 0 }, "Set hsrp version",
              1, " <0-255>        hot standby router version", command_set_hsrp_general },
 { 255, NULL,       { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL      }
};



struct commands comm_set_stp[]={
 { 255, "version",   { 0, 0, 0, 1, 0 }, "Set spanning tree version", 
              2, " stp     Use spanning tree version\x0 rstp    Use rapid spanning tree version", command_set_stp_general  },
 { 255, "interface",{ 0, 0, 0, 1, 0 }, "Set network interface to use", 
              1, " WORD    Network interface", command_set_stp_general },
 { 255, "type",     { 0, 0, 0, 1, 0 }, "Set bpdu type",                
              3, " <0>     Configuration STP\x0 <1>     Configuration RSTP\x0 <2>     Topology Change Notification",
               command_set_stp_general  },
 { 255, "source",   { 0, 0, 0, 1, 0 }, "Set source MAC address",       
              1, " H:H:H:H:H:H    48 bit mac address", command_set_stp_general },
 { 255, "dest",     { 0, 0, 0, 1, 0 }, "Set destination MAC address", 
              1, " H:H:H:H:H:H    48 bit mac address", command_set_stp_general },
 { 255, "flags",    { 0, 0, 0, 1, 0 }, "Set bpdu flags",         
              2, " <0-255>     Decimal flags\x0 <0x00-0xFF> Hexadecimal flags", command_set_stp_general  },
 { 255, "rootid",   { 0, 0, 0, 1, 0 }, "Set root id",            
              1, " WORD    Root id", command_set_stp_general },
 { 255, "cost",     { 0, 0, 0, 1, 0 }, "Set the spanning tree root path cost", 
              2, " <0-65535>     Decimal root path cost\x0 <0x00000000-0xFFFFFFFF> Hexadecimal root path cost", command_set_stp_general },
 { 255, "bridgeid", { 0, 0, 0, 1, 0 }, "Set bridge id",          
              1, " WORD    Bridge id", command_set_stp_general  }, 
 { 255, "portid",   { 0, 0, 0, 1, 0 }, "Set port id",            
              2, " <0-65535>      Decimal port id\x0 <0x0000-0xFFFF> Hexadecimal port id", command_set_stp_general  },
 { 255, "role",     { 0, 0, 0, 1, 0 }, "Set the rapid spanning tree port role",     
              4," unknown  Unknown role\x0 backup   Backup role\x0 root     Root role\x0 design   Designated role",
                     command_set_stp_general },
 { 255, "state",    { 0, 0, 0, 1, 0 }, "Set the rapid spanning tree port state",    
              4," proposal  Proposal state\x0 learning  Learning state\x0 forward   Forwarding state\x0 agree     Agreement state",
                    command_set_stp_general },
 { 255, "message",  { 0, 0, 0, 1, 0 }, "Set message age",
              1, " <0-255> Estimated time in seconds since the root transmitted its config message", command_set_stp_general  },
 { 255, "max-age",   { 0, 0, 0, 1, 0 }, "Set the max age interval for the spanning tree",        
              1, " <0-255> maximum number of seconds the information in a BPDU is valid", command_set_stp_general  },
 { 255, "hello",    { 0, 0, 0, 1, 0 }, "Set the hello interval for the spanning tree",         
              1, " <0-255> number of seconds between generation of config BPDUs", command_set_stp_general  },
 { 255, "forward",  { 0, 0, 0, 1, 0 }, "Set the forward delay for the spanning tree",      
              1, " <0-255> number of seconds for the forward delay timer", command_set_stp_general  },
 { 255, "defaults", { 0, 0, 0, 1, 0 }, "Set all values to default",
              1, " <cr>", command_set_stp_defaults },   
 { 255, NULL,       { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL             }
};


struct commands comm_set_vtp[]={
 { 255, "code",  { 0, 0, 0, 1, 0 }, "Set vtp code",
              1, " <0-255>        virtual trunking code", command_set_vtp_general },
 { 255, "defaults", { 0, 0, 0, 1, 0 }, "Set all values to default",
              1, " <cr>", command_set_vtp_defaults },
 { 255, "dest",     { 0, 0, 0, 1, 0 }, "Set destination MAC address", 
              1, " H:H:H:H:H:H    48 bit mac address", command_set_vtp_general },              
 { 255, "domain",   { 0, 0, 0, 1, 0 }, "Set vtp domain name to use", 
              1, " WORD    Domain name", command_set_vtp_general },
 { 255, "followers",  { 0, 0, 0, 1, 0 }, "Set vtp followers",
              1, " <0-255>        followers", command_set_vtp_general },
 { 255, "interface",{ 0, 0, 0, 1, 0 }, "Set network interface to use", 
              1, " WORD    Network interface", command_set_vtp_general },
 { 255, "revision",   { 0, 0, 0, 1, 0 }, "Set revision number",       
              1, " <0-65535>    Revision number", command_set_vtp_general },              
 { 255, "source",   { 0, 0, 0, 1, 0 }, "Set source MAC address",       
              1, " H:H:H:H:H:H    48 bit mac address", command_set_vtp_general },
 { 255, "startval",   { 0, 0, 0, 1, 0 }, "Set start value",       
              1, " <0-65535>    Start value", command_set_vtp_general },
 { 255, "updater",  { 0, 0, 0, 1, 0 }, "Set updater IP address", 
              1, " A.A.A.A    IPv4 address", command_set_vtp_general },                
 { 255, "version",  { 0, 0, 0, 1, 0 }, "Set vtp version",
              1, " <0-255>        virtual trunking version", command_set_vtp_general },
 { 255, NULL,       { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL      }
};

struct commands comm_set_dhcp[]={
 { 255, "defaults", { 0, 0, 0, 1, 0 }, "Set all values to default",
              1, " <cr>", command_set_dhcp_defaults },
 { 255, "dest",     { 0, 0, 0, 1, 0 }, "Set destination MAC address", 
              1, " H:H:H:H:H:H    48 bit mac address", command_set_dhcp_general },              
 { 255, "dport",   { 0, 0, 0, 1, 0 }, "Set UDP destination port",       
              1, " <0-65535>    UDP destination port", command_set_dhcp_general },
 { 255, "htype",  { 0, 0, 0, 1, 0 }, "Set dhcp htype",
              1, " <0-255>        Htype", command_set_dhcp_general }, 
 { 255, "interface",{ 0, 0, 0, 1, 0 }, "Set network interface to use", 
              1, " WORD    Network interface", command_set_dhcp_general },
 { 255, "ipdest",  { 0, 0, 0, 1, 0 }, "Set destination IP address", 
              1, " A.A.A.A    IPv4 address", command_set_dhcp_general },                
 { 255, "ipsource",  { 0, 0, 0, 1, 0 }, "Set source IP address", 
              1, " A.A.A.A    IPv4 address", command_set_dhcp_general },
 { 255, "opcode",  { 0, 0, 0, 1, 0 }, "Set dhcp opcode",
              1, " <0-255>        Opcode", command_set_dhcp_general }, 
 { 255, "source",   { 0, 0, 0, 1, 0 }, "Set source MAC address",       
              1, " H:H:H:H:H:H    48 bit mac address", command_set_dhcp_general },
 { 255, "sport",   { 0, 0, 0, 1, 0 }, "Set UDP source port",       
              1, " <0-65535>    UDP source port", command_set_dhcp_general },
 { 255, NULL,       { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL      }
};

struct commands comm_set_cdp[]={
 { 255, "checksum",   { 0, 0, 0, 1, 0 }, "Set cdp checksum",       
              1, " <0-65535>    Checksum", command_set_cdp_general },
 { 255, "defaults", { 0, 0, 0, 1, 0 }, "Set all values to default",
              1, " <cr>", command_set_cdp_defaults },
 { 255, "dest",     { 0, 0, 0, 1, 0 }, "Set destination MAC address", 
              1, " H:H:H:H:H:H    48 bit mac address", command_set_cdp_general },              
 { 255, "interface",{ 0, 0, 0, 1, 0 }, "Set network interface to use", 
              1, " WORD    Network interface", command_set_cdp_general },
 { 255, "ttl",  { 0, 0, 0, 1, 0 }, "Set cdp time to live",
              1, " <0-255>        Time To Live seconds", command_set_cdp_general }, 
 { 255, "source",   { 0, 0, 0, 1, 0 }, "Set source MAC address",       
              1, " H:H:H:H:H:H    48 bit mac address", command_set_cdp_general },
 { 255, "version",  { 0, 0, 0, 1, 0 }, "Set dhcp opcode",
              1, " <0-255>        Opcode", command_set_cdp_general }, 
 { 255, NULL,       { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL      }
};




struct commands comm_common[]={
 { 255, "cancel", { 0, 0, 0, 1, 0 }, "Cancel running attack",             0, NULL,   command_cancel  },
 { 255, "clear",  { 0, 0, 0, 1, 0 }, "Clear stats",                       0, NULL,   command_clear   },
 { 255, "cls",    { 0, 0, 1, 1, 0 }, "Clear screen",                      1, "<cr>", command_cls     },
 { 255, "disable",{ 0, 0, 0, 1, 0 }, "Turn off privileged commands",      1, "<cr>", command_disable },
 { 255, "enable", { 0, 0, 1, 0, 0 }, "Go to administration level",        1, "<cr>", command_enable  },
 { 255, "exit",   { 0, 0, 1, 1, 0 }, "Exit from current level",           1, "<cr>", command_exit    },  
 { 255, "prueba", { 0, 0, 0, 1, 0 }, "Test command",                      1, "<cr>", command_prueba  },
 { 255, "run",    { 0, 0, 0, 1, 0 }, "Run attack",                        0, NULL,   command_run     }, 
 { 255, "set",    { 0, 0, 0, 1, 0 }, "Set specific params for protocols", 0, NULL,   command_set     },
 { 255, "show",   { 0, 0, 1, 1, 0 }, "Show running system information",   0, NULL,   command_show    },
 { 255, NULL,     { 0, 0, 0, 0, 0,}, NULL,                                0, NULL,   NULL            }
};

struct commands comm_cancel[]={
 { 255,        "attacks",{ 0, 0, 0, 1, 0 }, "Cancel all attacks",                1, "<cr>", NULL },
 { PROTO_CDP,  "cdp",    { 0, 0, 0, 1, 0 }, "Cancel cisco discovery attacks",    0, NULL, NULL   },
 { PROTO_DHCP, "dhcp",   { 0, 0, 0, 1, 0 }, "Cancel dynamic host attacks",       0, NULL, NULL   },
 { PROTO_DOT1Q,"dot1q",  { 0, 0, 0, 1, 0 }, "Cancel 802.1Q attacks",             0, NULL, NULL   }, 
 { PROTO_DTP,  "dtp",    { 0, 0, 0, 1, 0 }, "Cancel dynamic trunking attacks",   0, NULL, NULL   },
 { PROTO_HSRP, "hsrp",   { 0, 0, 0, 1, 0 }, "Cancel hot standby router attacks", 0, NULL, NULL   },
 { PROTO_STP,  "stp",    { 0, 0, 0, 1, 0 }, "Cancel spanning tree attacks",      0, NULL, NULL   },
 { PROTO_VTP,  "vtp",    { 0, 0, 0, 1, 0 }, "Cancel virtual trunking attacks",   0, NULL, NULL   },
 { 255,        NULL,     { 0, 0, 0, 0, 0 },  NULL,                               0, NULL, NULL   }
};

struct commands comm_cancel_proto[]={
 { 255, "attack", { 0, 0, 0, 1, 0 }, "Cancel protocol attack", 
                                     1, " NUMBER   number of protocol attack", NULL },
 { 255, NULL,     { 0, 0, 0, 0, 0 },  NULL,                    0, NULL, NULL            }
};

struct commands comm_clear[]={
 { PROTO_CDP,  "cdp",     { 0, 0, 0, 1, 0 }, "Clear Cisco Discovery Protocol stats",  1, "<cr>", NULL },
 { PROTO_DHCP, "dhcp",    { 0, 0, 0, 1, 0 }, "Clear Dynamic Host stats",              1, "<cr>", NULL }, 
 { PROTO_DOT1Q,"dot1q",   { 0, 0, 0, 1, 0 }, "Clear 802.1Q stats",                    1, "<cr>", NULL },    
 { PROTO_DTP,  "dtp",     { 0, 0, 0, 1, 0 }, "Clear Dynamic Trunking stats",          1, "<cr>", NULL },  
 { 255,        "global",  { 0, 0, 0, 1, 0 }, "Clear global stats",                    1, "<cr>", NULL },  
 { PROTO_HSRP, "hsrp",    { 0, 0, 0, 1, 0 }, "Clear Hot Standby Router stats",        1, "<cr>", NULL },
 { PROTO_STP,  "stp",     { 0, 0, 0, 1, 0 }, "Clear Spanning Tree stats",             1, "<cr>", NULL },
 { PROTO_VTP,  "vtp",     { 0, 0, 0, 1, 0 }, "Clear VTP stats",                       1, "<cr>", NULL },
 { 255,        NULL,      { 0, 0, 0, 0, 0 },  NULL,                                   1, "<cr>", NULL }
};

struct commands comm_run[]={
 { PROTO_CDP,  "cdp",  { 0, 0, 0, 1, 0 }, "Run cisco discovery attacks",    0, NULL, NULL },
 { PROTO_DHCP, "dhcp", { 0, 0, 0, 1, 0 }, "Run dynamic host attacks",       0, NULL, NULL },
 { PROTO_DOT1Q,"dot1q",{ 0, 0, 0, 1, 0 }, "Run 802.1Q attacks",             0, NULL, NULL },  
 { PROTO_DTP,  "dtp",  { 0, 0, 0, 1, 0 }, "Run dynamic trunking attacks",   0, NULL, NULL }, 
 { PROTO_HSRP, "hsrp", { 0, 0, 0, 1, 0 }, "Run hot standby router attacks", 0, NULL, NULL },
 { PROTO_STP,  "stp",  { 0, 0, 0, 1, 0 }, "Run spanning tree attacks",      0, NULL, NULL },
 { PROTO_VTP,  "vtp",  { 0, 0, 0, 1, 0 }, "Run virtual trunking attacks",   0, NULL, NULL },
 { 255,        NULL,   { 0, 0, 0, 0, 0 },  NULL,                            0, NULL, NULL }
};

struct commands comm_run_proto[]={
 { 255, "attack", { 0, 0, 0, 1, 0 }, "Run protocol attack", 0, NULL, NULL }, 
 { 255, NULL,     { 0, 0, 0, 0, 0 },  NULL,                 0, NULL, NULL }
};

 
#endif

/* vim:set tabstop=4:set expandtab:set shiftwidth=4:set textwidth=78: */
