#!/usr/bin/perl -w
#
# Yarr - Yet Another RSS Reader
# Copyright (C) 2004 Lee Aylward <lee@laylward.com>
# http://yarssr.sourceforge.net
# Licensed under the GPL
#
# TODO: 
# 	-GConf for settings
# 	-Audio notification option
# 	-Menu position to avoid covering panel
# 	-Separate intervals
# 	-Splice simplelist directly
#

use strict;
use XML::RSS qw( parse );
use Gtk2::TrayIcon;
use Gtk2::GladeXML;
use Gtk2::SimpleList;
use Gnome2::VFS;
use Carp;
use Gnome2;

croak("this version of Gnome2 is old, you need > 0.94")
	if $Gnome2::VERSION < 0.94;

# Shut up annoying XML::RSS warnings. (I am evil apparently :)
BEGIN { $SIG{'__WARN__'} = sub {warn $_[0] unless($_[0]=~/1432\.$/) } }
$0 = 'yarssr';

use constant TRUE => 1;
use constant FALSE => 0;
use constant NEW => 2;

my $version = '0.1.5';
my %feeds;
my @feedlist;
my $parser = new XML::RSS;
my $menu;

# Minutes between updates
my $interval = 900000;

# Max number of feeds per site
my $maxfeeds = 6;

# Config file
my $configdir = $ENV{HOME}.'/.yarssr/';
my $config = $ENV{HOME}.'/.yarssr/config';

# Default browser
my $browser = '/usr/bin/mozilla';
my $usegnome = FALSE;

# Gtk 2 stuff
Gtk2->init;
Gnome2::VFS->init;

# Glade setup
my $xml;
{
	local $/ = undef;
	$xml = <DATA>;
}

my $gld = Gtk2::GladeXML->new_from_buffer($xml);
$gld->signal_autoconnect_from_package('main');

# Create windows
my $prefs_window = $gld->get_widget('window_prefs');
$prefs_window->signal_connect('delete-event'=>\&delete_event);
my $add_dialog = $gld->get_widget('add_dialog');
$add_dialog->set_transient_for($prefs_window);
$add_dialog->signal_connect('delete-event'=>\&delete_event);

# SimpleList for displaying feeds
my $feedlist = Gtk2::SimpleList->new (
	'Name'		=> 'text',
	'Enabled'	=> 'bool',
	'Address'	=> 'text',
);

# Add simplelist to scrolled window in prefs window
my $scrolledwindow = $gld->get_widget('scrolledwindow_feeds');
$scrolledwindow->add($feedlist);

# Create tray inon
my $tray = Gtk2::TrayIcon->new("rss");
my $eventbox = Gtk2::EventBox->new;

# Attach event to show menu
$eventbox->signal_connect("button-release-event", \&menu_show);

# Pixmaps
my @pixmap = ( 
'26 24 30 1',
' 	c None',
'.	c #808080',
'+	c #F4F4E9',
'@	c #000000',
'#	c #515151',
'$	c #555551',
'%	c #6F6F6A',
'&	c #A3A39F',
'*	c #939390',
'=	c #929390',
'-	c #848381',
';	c #848480',
'>	c #838381',
',	c #838480',
'\'	c #838380',
')	c #747471',
'!	c #737471',
'~	c #747371',
'{	c #747470',
']	c #F3F3E8',
'^	c #646461',
'/	c #646561',
'(	c #656561',
'_	c #656460',
':	c #646460',
'<	c #656461',
'[	c #6B6B66',
'}	c #E3E3D9',
'|	c #252525',
'1	c #C8C8BF',
'                          ',
'                          ',
' ........................ ',
' .++++++++++++++++++++++. ',
' .++@+@++@@@++@@@++@@@++. ',
' .++@+@++@+@++@+@++@+@++. ',
' .++@@@++@@@++@@+++@@+++. ',
' .+++@+++@+@++@+@++@+@++. ',
' .+++@+++@+@++@+@++@+@++. ',
' .+@@@@@@@@@@@@@@@@@@@@+. ',
' #++++++++++++++++++++++# ',
' #++++++++++++++++++++++# ',
' #+$$$$$$$$$$+%%%%%%%%%+# ',
' #++++++++++++%&&&&&&&%+# ',
' #+$$$$$$$$$$+%******=%+# ',
' #++++++++++++%-;>,\'>\'%+# ',
' #+$$$$$$$$$$+$)!~{~){%+# ',
' #]]]]]]]]]]]]$^/(_:<:[]# ',
' #}%%%%%%%%%%}$$$$$$$$%}# ',
' #|11111111111111111111|# ',
'  ||||||||||||||||||||||  ',
'                          ',
'                          ',
'                          ');

my @pixmap_new = (
'26 24 21 1',
' 	c None',
'.	c #984848',
'+	c #F1D6D6',
'@	c #000000',
'#	c #5C3434',
'$	c #360000',
'%	c #5D0000',
'&	c #A12A2A',
'*	c #911313',
'=	c #901212',
'-	c #820202',
';	c #650000',
'>	c #640000',
',	c #F0D3D3',
'\'	c #490000',
')	c #4B0000',
'!	c #4C0000',
'~	c #580000',
'{	c #E0A9A9',
']	c #1B0909',
'^	c #C56B6B',
'                          ',
'                          ',
' ........................ ',
' .++++++++++++++++++++++. ',
' .++@+@++@@@++@@@++@@@++. ',
' .++@+@++@+@++@+@++@+@++. ',
' #++@@@++@@@++@@+++@@+++. ',
' #+++@+++@+@++@+@++@+@++. ',
' #+++@+++@+@++@+@++@+@++# ',
' #+@@@@@@@@@@@@@@@@@@@@+# ',
' #++++++++++++++++++++++# ',
' #++++++++++++++++++++++# ',
' #+$$$$$$$$$$+%%%%%%%%%+# ',
' #++++++++++++%&&&&&&&%+# ',
' #+$$$$$$$$$$+%******=%+# ',
' #++++++++++++%-------%+# ',
' #+$$$$$$$$$$+$;;>;>;;%+# ',
' #,,,,,,,,,,,,$\')!)\')\'~,# ',
' #{%%%%%%%%%%{$$$$$$$$%{# ',
' #]^^^^^^^^^^^^^^^^^^^^]# ',
'  ]]]]]]]]]]]]]]]]]]]]]]  ',
'                          ',
'                          ',
'                          ');

# Make pixbufs out of pixmaps
my $pixbuf = Gtk2::Gdk::Pixbuf->new_from_xpm_data(@pixmap);
my $pixbuf_new = Gtk2::Gdk::Pixbuf->new_from_xpm_data(@pixmap_new);

my $image = Gtk2::Image->new_from_pixbuf($pixbuf);
$eventbox->add($image);

# Add eventbox to tray
$tray->add($eventbox);
$tray->show_all;

read_config();
update_feed_all();

# Disable Gnome default browser: see NOTES up top
#$usegnome = FALSE;
#my $checkbutton = $gld->get_widget('use_default_browser_checkbox');
#$checkbutton->set_inconsistent(TRUE);

# Create timer with specified interval
my $timer = Glib::Timeout->add($interval,\&update_feed_all);

Gtk2->main;
write_config();

# Subroutines
#
#
sub delete_event
{
	$_[0]->hide;
	add_dialog_clear();
	return TRUE;
}

sub read_config
{
	if (! -e $configdir)
	{
		mkdir $configdir 
			or warn "Failed to make config directory: $!\n";
	}
	if (! -e $configdir.'/icons')
	{
		mkdir $configdir.'/icons'
			or warn "Failed to make icons directory: $!\n";
	}
	if (-e $config) {
		open (CONFIG,"<",$config)
			or warn "Failed to open config file for reading: $!\n";
		while(<CONFIG>)
		{	
			chomp;
			if (/^feed=(.*);(.*);(\d)/) 
			{
				push @feedlist, [$2,$3,$1];
				$feeds{$1} = {
						title => $2,
						enable=> $3,
					};
			}
			elsif (/^interval=(\d+)/)
			{
				$interval = $1;
			}
			elsif (/^maxfeeds=(\d+)/)
			{
				$maxfeeds = $1;
			}
			elsif (/^browser=(.*)/)
			{
				$browser = $1;
			}		
			elsif (/^usegnome=(\d)/)
			{
				$usegnome = $1;
			}
		}
		update_simplelist();
		close(CONFIG)
	}
}

sub write_config
{
	open (CONFIG,">",$config) 
		or warn "Failed to open config file for writing: $!\n";
	print CONFIG "interval=$interval\n";
	print CONFIG "maxfeeds=$maxfeeds\n";
	print CONFIG "browser=$browser\n";
	print CONFIG "usegnome=$usegnome\n";
	for my $url (keys %feeds)
	{
		print CONFIG "feed=".$url.";".$feeds{$url}->{'title'}.
		";".$feeds{$url}->{'enable'}."\n";
	}
	close(CONFIG);
}

sub get_feed_all
{
	for my $url (sort keys %feeds)
	{
		get_feed($url) if ($feeds{$url}->{'enable'} == TRUE);
	}
}

sub get_feed
{
	my ($url,undef) = @_;
	Gtk2->main_iteration while Gtk2->events_pending; 
	my ($content,$type) = get_file($url);

	# Check if we got content
	if ($content)
	{
		# Parse content
		parse_feed($content,$url);
		return;
	}
	else
	{
		# Failed dialog
		warn "Encountered problems downloading $url\n";
		get_feed_failed($url,"An error occured while connecting to $url");
		return;
	}
}

sub get_file
{
	my $url = shift;
	my ($result, $handle, $info);

	($result, $handle) = Gnome2::VFS->open($url, 'read');
	return(FALSE,FALSE) unless ($result eq 'ok');
	
	my $content = '';
	my $bytes_per_iteration = 1024;

	do {
		Gtk2->main_iteration while Gtk2->events_pending; 	
 		my ($tmp_buffer, $tmp_bytes_read);
 		($result, $tmp_bytes_read, $tmp_buffer) =
			$handle->read($bytes_per_iteration);

		$content .= $tmp_buffer;
	} while ($result eq 'ok');
	
	# Get mime type
	($result,$info) = $handle->get_file_info('default');
	my $type = $info->get_mime_type;

	$result = $handle->close();
	return \$content,$type;
}

sub parse_feed
{
	my ($content,$url) = @_;
	
	# Clear old feed contents
	$feeds{$url}->{'contents'} = undef;
	
	# Parse contents with XML::RSS
	$parser->parse($$content);

	# Load parsed data into hash
	for my $item (@{$parser->{'items'}})
	{
		push(@{$feeds{$url}->{'contents'}}, {
			title	=> $item->{'title'},
			url	=> $item->{'link'},
			date	=> $item->{'dc'}{'date'},
		});
	}
}

# Update all of the feeds
#
sub update_feed_all
{
	# Set to red pixmap
	$image->set_from_pixbuf($pixbuf_new);

	# Download all the feeds and recreate the menu
	get_feed_all();
	menu_create();

	# Set to black pixmap
	$image->set_from_pixbuf($pixbuf);

	return TRUE;
}

# Update a single feed
#
sub update_feed
{
	my ($widget, $feed) = @_;
	
	# Set image to red pixmap
	$image->set_from_pixbuf($pixbuf_new);
	
	get_feed($feed); 
	menu_create();	

	# Set image to black pixmap
	$image->set_from_pixbuf($pixbuf);
}

# Draw the menu
#
sub menu_show
{
	$menu->popup(undef, undef, undef, undef, 1, 0);
}

# Create the menu for the tray
#
sub menu_create
{
	# Overwrite any existing menu
	$menu = Gtk2::Menu->new;
	# Create a new menu for each feed
	for my $feed (sort 
		{ lc $feeds{$a}->{'title'} cmp lc $feeds{$b}->{'title'} }
		keys %feeds )
	{
		next if $feeds{$feed}->{'enable'} == FALSE;
		my $favicon = get_favicon($feed);
		my $submenu = Gtk2::Menu->new;
		$submenu->set_title($feed);
		# Create a new menu item for each article in feed
		for my $article (0 .. ($maxfeeds-1))
		{
			next if (not defined 
				$feeds{$feed}->{'contents'}->[$article]{'title'});
				
			my $submenuitem = Gtk2::MenuItem->new(
				$feeds{$feed}->{'contents'}->[$article]{'title'});
				
			$submenuitem->signal_connect('activate',\&url_load, 
				$feeds{$feed}->{'contents'}->[$article]{'url'});
				
			# Attach new menu item to the sub menu
			$submenu->append($submenuitem);
		}
		my $subseparator = Gtk2::SeparatorMenuItem->new;
		$submenu->append($subseparator);
		
		# Update this feed button...
		my $subupdate = Gtk2::MenuItem->new('Update this feed');
		$subupdate->signal_connect('activate',\&update_feed,$feed);
		$submenu->append($subupdate);
		
		# Attach submenu to a new main menu item
		my $menuitem = Gtk2::ImageMenuItem->new($feeds{$feed}->{'title'});

		# Add an icon if the feed has one
		$menuitem->set_image($$favicon) unless ($$favicon eq 'none');
		$menuitem->set_submenu($submenu);
		$menu->append($menuitem);
	}
	# Quit button...
	my $menuquit = Gtk2::MenuItem->new('Quit');
	$menuquit->signal_connect('activate', sub { write_config(); exit 1; });
	
	# Preferences button...
	my $menupref = Gtk2::MenuItem->new('Preferences');
	$menupref->signal_connect('activate',\&prefs_show);
	
	# Update all feeds button...
	my $menuupdate = Gtk2::MenuItem->new('Update');
	$menuupdate->signal_connect('activate',\&update_feed_all);
	
	# Horz. Separator
	my $separator = Gtk2::SeparatorMenuItem->new;
	
	# Attach buttons to menu
	$menu->append($separator);
	$menu->append($menuupdate);
	$menu->append($menupref);
	$menu->append($menuquit);

	# Show menu
	$menu->show_all;
}

# Load a URL in a browser
# 
sub url_load
{
	# Open a URL in the specified browser
	my ($widget, $url) = @_;

	# Check if we should use gnome default
	if ($usegnome == TRUE)
	{
		Gnome2::URL->show($url);
	}
	else
	{
		if (-e $browser and fork == 0)
		{
			exec($browser,$url) or 
				warn "Unable to launch browser!\n";
		}
	}
}

# Preference window
# 
sub prefs_show
{
	update_feedlist();
	update_simplelist();
	my $interval_display = $gld->get_widget('interval_entry');
	my $headings_display = $gld->get_widget('headings_entry');
	my $browser_display = $gld->get_widget('browser_entry');

	# Convert milliseconds to minutes
	my $display_interval = ($interval / 1000) / 60;

	# Fill in current settings
	$interval_display->set_text($display_interval);
	$headings_display->set_text($maxfeeds);
	$browser_display->set_text($browser);

	$prefs_window->show_all;
}

sub on_pref_ok_button_clicked
{
	my $widget = shift;
	
	$prefs_window->hide;

	my $interval_temp = $gld->get_widget('interval_entry');
	my $headings_temp = $gld->get_widget('headings_entry');
	my $browser_temp = $gld->get_widget('browser_entry');
	my $usegnome_temp = $gld->get_widget('use_default_browser_checkbox');
	
	$browser = $browser_temp->get_text;

	# Get text from entry boxes
	my $new_interval = $interval_temp->get_text;
	my $new_maxfeeds = $headings_temp->get_text;
	
	# Get gnome default check button
	if ($usegnome_temp->get_active)
	{
		$usegnome = TRUE;
	}
	else
	{
		$usegnome = FALSE;
	}

	# Convert minutes to milliseconds
	$new_interval = ($new_interval * 1000) * 60;
	
	# Update settings and write to config
	update_interval($new_interval);
	update_maxfeeds($new_maxfeeds);
	update_feeds_enabled();
}

sub on_pref_cancel_button_clicked
{
	my $widget = shift;

	# Reset the use gnome checkbutton to old setting
	my $usegnome_temp = $gld->get_widget('use_default_browser_checkbox');
	$usegnome_temp->set_active($usegnome);

	# Hide windows
	$add_dialog->hide;
	$prefs_window->hide;
}

# Prefernce changes
# 
sub update_maxfeeds
{
	# Check if new value is different from current,
	# if so change setting and update the menus
	my $new_maxfeeds = shift;
	if ($new_maxfeeds != $maxfeeds)
	{
		$maxfeeds = $new_maxfeeds;
		menu_create();
	}
}

sub update_interval
{
	# Check if new interval value is different from
	# the current, if so change settings and recreate
	# timer
	my $newinterval = shift;
	if ($newinterval != $interval)
	{
		$interval = $newinterval;
		Glib::Source->remove($timer);
		$timer = Glib::Timeout->add($interval,\&update_feed_all);
	}
}

sub update_feeds_enabled
{
	my $changed = FALSE;
	for my $row (0 .. (scalar(@{$feedlist->{data}})-1))
	{
		next if (not exists($feedlist->{data}[$row]));
		my $url = $feedlist->{data}[$row][2];
		my $enable = $feedlist->{data}[$row][1];

		# Check if this has has been enabled/disabled
		# or new.
		if ($feeds{$url}->{'enable'} != $enable)
		{
			$feeds{$url}->{'enable'} = $enable;
			$image->set_from_pixbuf($pixbuf_new);

			# Redownload feed if it has been turned on
			get_feed($url) if ($enable == TRUE);
			$changed = TRUE;
		}
	}
	$image->set_from_pixbuf($pixbuf);

	menu_create() if $changed;
}

# Add feed window
# 
sub on_add_button_clicked
{
	$add_dialog->show_all;
}

sub add_dialog_clear
{
	my $name = $gld->get_widget('add_name_entry');
	my $address = $gld->get_widget('add_address_entry');

	# Set the entries to blank
	$name->set_text('');
	$address->set_text('');
}

sub on_add_ok_button_clicked
{
	my $name_temp = $gld->get_widget('add_name_entry');
	my $address_temp = $gld->get_widget('add_address_entry');
	
	# Add entry to the info hash
	$feeds{$address_temp->get_text}->{'title'} = $name_temp->get_text;
	$feeds{$address_temp->get_text}->{'enable'} = NEW;
	
	# Add entry to feedlist array
	update_feedlist();
	update_simplelist();

	# Hide and clear dialog
	$add_dialog->hide;
	add_dialog_clear();
}

sub on_add_cancel_button_clicked
{
	$add_dialog->hide;
	add_dialog_clear();
}

# Get feed failed dialog
#
sub get_feed_failed
{
	my ($url,$error) = @_;

	# Create dialog
	my $dlg = Gtk2::MessageDialog->new (undef, [], 'error', 'none',
		$error);
	
	# Add buttons
	$dlg->add_buttons (
		'gtk-remove'	=> 3,
		'Disable'	=> 2,
		'Retry' 	=> 1
	);
	$dlg->set_default_response ('cancel');
	my $response = $dlg->run;

	if (1 == $response) 
	{
		# Retry
		$dlg->destroy;
		update_feed(undef,$url);
	}
	if (3 == $response)
	{
		# Remove
		remove_feed($url);
	}
	if (2 == $response)
	{
		# Disable
		disable_feed($url);
	}
	$dlg->destroy;
}

sub disable_feed
{
	my $url = shift;
	$feeds{$url}->{'enable'} = FALSE;
}

# Remove feed button
# 
sub on_remove_button_clicked
{
	# Get highlighted rows	
	my @selected = $feedlist->get_selected_indices;

	# Delete rows from feed hash and feed list
	unless ($#feedlist == -1) {
		remove_feed($feedlist[$_][2]) for(@selected);
		update_feedlist();
		update_simplelist();
	}
	menu_create();
}

sub remove_feed
{
	my $url = shift;

	# Delete feed from hash
	delete $feeds{$url};
}	

sub update_simplelist
{
	@{$feedlist->{data}} = @feedlist;
}

sub update_feedlist
{
	# Empty feedlist
	@feedlist = ();
	
	# Fill feedlist with feed info from hash
	for my $feed (sort { lc $feeds{$a}->{'title'} cmp lc $feeds{$b}->{'title'} } keys %feeds)
	{
		push @feedlist, [$feeds{$feed}->{'title'}, 
			$feeds{$feed}->{'enable'},$feed];
	}
}

sub get_favicon
{
	my $url = shift;
	my ($ico, $icofile);

	# Default to none, will get overwritten if there
	# is an icon
	my $image = 'none';

	my $uri = Gnome2::VFS::URI->new($url);
	$ico = 'http://'.$uri->get_host_name.'/favicon.ico';
	$icofile = $configdir.'/icons/'.$feeds{$url}->{'title'}.".ico";

	# Download the icon if we don't have one already
	unless (-e $icofile)
	{
		# Download the icon
		my ($content,$type) = get_file($ico);
		if ($type ne 'text/html' and $content)
		{
			# Write the icon to the config directory
			open(ICO,'>',$icofile) 
				or warn "Could not open icon file: $icofile\n";
			print ICO $$content;
			close(ICO);
		}
	} 
	
	eval
	{
		my $pixbuf = Gtk2::Gdk::Pixbuf->new_from_file($icofile);
	
		# Resize icon if it is too large
		$pixbuf = $pixbuf->scale_simple(16,16,'bilinear')
			if ($pixbuf->get_height != 16);
			
		$image = Gtk2::Image->new_from_pixbuf($pixbuf);
	};

	return \$image;	
}

sub on_use_default_browser_checkbox_toggled
{
	my ($widget, $window) = @_;
	
	my $browser_entry = $gld->get_widget('browser_entry');

	# Check if checkbutton is clicked
	if ($widget->get_active)
	{
		# If so make browser command uneditable
		$browser_entry->set_editable(FALSE);
		$browser_entry->set_visibility(FALSE);
	}
	else
	{
		# If not make browser command editable
		$browser_entry->set_editable(TRUE);
		$browser_entry->set_visibility(TRUE);
	}
}

