#!/usr/bin/env python
# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com

import sys
import os
import re
import gzip


def parseManPage():

    globaldict = {}

    '''
    globaldict = {'sections': {
                    'section whatever 1': {
                                           'options': {
                                                        'option whatever': 'description lines',
                                                        'option whatever1': 'description lines'
                                                      },
                                          },
                    'section whatever 2': {
                                           'options': {
                                                        'option whatever': 'description lines',
                                                        'option whatever1': 'description lines'
                                                      },
                                          },
                              }
                 }
    '''


    filename = '/usr/share/man/man5/xorg.conf.5.gz'#'xorg.conf.5'
    formatting = ['.B', '.BI', '.BR', '.I', '.IB', '.IR', '.RB',
                  '.RI', '.SM', '.SB', '.TP', '.PP', '.RS', '.RE',
                  '.fi', '\\', '.nf', '4', '7', '.ig', ' 11', '*q',
                  'I ',
                  ]
    
    # This one usually marks the beginning of a section
    pattern1 = r'\.SH \".*\"'
    
    # This one usually marks the beginning of an option
    # which is located in the next line
    pattern2 = r'\.TP 7'
    
    # This one usually marks the beginning of an option
    # e.g.
    #     .BI "Option " "\*qRightOf\*q  " \*qmonitor\*q
    pattern3 = r'\.BI \"(.*)\".*\"(.*)\"(.*)'
    
    # This one usually marks the beginning of an option
    # with a different regular expression
    pattern4 = r'\.BI \"(.*)\\\*q\" (.+) \\\*q.*'
    
    pattern5 = r'\.BI \"(.*)\" (.+).*'
    

    pat1 = re.compile(pattern1)
    pat2 = re.compile(pattern2)
    pat3 = re.compile(pattern3)
    pat4 = re.compile(pattern4)
    pat5 = re.compile(pattern5)

    text = gzip.open(filename, 'rb')

    optext = text.readlines()
    section = ''
    option = [False, 0]
    toadd = ''
    description = False
    totoptions = 0
    
    nextOption = None
    
    lineNumber = 0
    for line in optext:
        m1 = pat1.match(line)
        m2 = pat2.match(line)
        m3 = pat3.match(line)
        m4 = pat4.match(line)
        m5 = pat5.match(line)
        
        #print 'LINE', lineNumber
        
        if option[0] == True:
            #print line
            option = [False, 1]
            description = True
            #print '****DESCRIPTION****:\n'
        
        if m1:
            #print '****SECTION****', line
            section = line.strip().replace('.SH ', '').replace('"', '')
            #print globaldict.get(section)
            if globaldict.get(section) == None:
                globaldict[section] = {}
    #        sections.append(line)
            description = False
        
        
        if description == True:
            if section != '':
                #print 'option[1] = ', option[1]
                if option[1] == 0:
                    if toadd != '' and len(globaldict[section]) != 0:
                        for punct in formatting:
                            line = line.replace(punct, '')
                        line = line.replace('\n', ' ')

                        
                        if globaldict[section]['options'].get(toadd) != None:
                            globaldict[section]['options'][toadd] += line
                            #print 'AGGIUNTO', globaldict[section]['options'][toadd]
                        else:
                            #print '2ND'
                            
                            globaldict[section]['options'][toadd] = line

                    #print line
                else:
                    #print '1ST'
                    option[1] = 0
        
        if m2:
            #print 'm2 =', line
            option = [True, 1]
            description = False
            #print '****OPTION****'
            
            # Valid option on next line
            nextOption = lineNumber + 1
            
        elif m3:
#            print 'm3 =', line
            if section != '':
                totoptions += 1
                #print 'm4 =', line
                #line = line.replace('\\*q', '')
                opt = m3.group(1).strip().replace('\\*q', '').replace('"', '')
                val = m3.group(2).strip().replace('\\*q', '').replace('\\', '').replace('\\-', '-')
                valrest = m3.group(3).strip().replace('\\*q', '').replace('\\', '').replace('\\-', '-')
                #print 'opt =', opt
                val = val.split(' ')
                for elem in val:
                    elem = elem.strip()
                val = '"' + '" "'.join(val) + '"'
                #print 'val =', val
                #print 'valrest =', repr(valrest), '\n\n'
                
                if valrest != '':
                    opt += ' ' + val.replace('"', '')
                    val = '"' + valrest + '"'
                
#                print 'opt =', opt
#                print 'val =', val
                toadd = opt + ' ' + val
                if 'option' in opt.lower():
                    #opt = opt.replace('\\*q', '"')
                    opt = opt.replace('\\*q', '')
                    toadd = opt + ' ' + val
                else:
                    opt = opt.replace(' \\*q"', '').replace(' "\\*q', '').replace('\\', '').replace('*q', '')
                    toadd = opt + ' ' + val
                    
                try:
                    a = globaldict[section]['options']
                    del a
                except KeyError:
                    globaldict[section]['options'] = {}
#                print 'toadd =', toadd, '\n\n'
                
                if globaldict[section]['options'].get(toadd) != None:
                    globaldict[section]['options'][toadd] = ''
                #print 'OPTION m3', opt
        elif m4:
            if section != '':
                totoptions += 1
                #print 'm4 =', line
                opt = m4.group(1).strip()
                val = m4.group(2).strip().replace('\\', '').replace('\-', '-')
                
                val = val.split(' ')
                for elem in val:
                    elem = elem.strip()
                val = '"' + '" "'.join(val) + '"'
                
                toadd = opt + ' ' + val
                if 'option' in opt.lower():
                    #opt = opt.replace('\\*q', '"')
                    opt = opt.replace('\\*q', '')
                    toadd = opt + ' ' + val
                else:
                    opt = opt.replace(' \\*q"', '').replace(' "\\*q', '').replace('\\', '')
                    toadd = opt + ' ' + val
                    
                try:
                    a = globaldict[section]['options']
                    del a
                except KeyError:
                    globaldict[section]['options'] = {}
                
                if globaldict[section]['options'].get(toadd) != None:
                    globaldict[section]['options'][toadd] = ''
                #print 'OPTION m4', opt
        
        
        elif m5: 
            if section != '' and lineNumber == nextOption:
                totoptions += 1
                #print 'm4 =', line
                opt = m5.group(1).strip()
                val = m5.group(2).strip().replace('\\', '').replace('\-', '-')
                
                val = val.split(' ')
                for elem in val:
                    elem = elem.strip()
                val = '"' + '" "'.join(val) + '"'
                
                toadd = opt + ' ' + val
                if 'option' in opt.lower():
                    #opt = opt.replace('\\*q', '"')
                    opt = opt.replace('\\*q', '')
                    toadd = opt + ' ' + val
                else:
                    opt = opt.replace(' \\*q"', '').replace(' "\\*q', '').replace('\\', '')
                    toadd = opt + ' ' + val
                    
                try:
                    a = globaldict[section]['options']
                    del a
                except KeyError:
                    globaldict[section]['options'] = {}
                
                if globaldict[section]['options'].get(toadd) != None:
                    globaldict[section]['options'][toadd] = ''
                #print 'OPTION m5', opt
            
        
        lineNumber += 1
    
    text.close()

    #print 'OPTIONS:\n', '\n'.join(options)

    #print 'SECTIONS:\n', '\n'.join(sections)

#    print 'GLOBALDICT', globaldict

#    for section in globaldict:
#        print '\nSection', section
#        if globaldict[section].get('options') != None:
#            for option in globaldict[section]['options']:
#                print '\n', option
#                #print globaldict[section]
#                try:
#                    #print globaldict[section]['options'].get(option)#COMPLETE LINE
#                    print globaldict[section]['options'].get(option)[0: globaldict[section]['options'].get(option).find('.')]#only the first line
#                except KeyError:
#                    pass
    
    return globaldict


def makeXml():
    globaldict = parseManPage()
    newxml = open('myxml.xml', 'w')
    #sep = ''
    lines = []
    lines.append('<?xml version="1.0" encoding="UTF-8" standalone="no"?>')
    lines.append('<xorg-interface>')

    for section in globaldict:
        
        if globaldict[section].get('options') != None:
            
            for option in globaldict[section]['options']:
                splitopt = option.split(' ')
                values = []
                blacklist = [] 
                it = 0
                for elem in splitopt:
                    if '"' in elem:
                        values.append(elem[1:-1])
                        blacklist.append(it)
                    it += 1
                val = ' '.join(values)#splitopt[-1]
                opts = []
                it = 0
                for elem in splitopt:
                    if it not in blacklist:
                        opts.append(elem)
                    it += 1
                opt = ' '.join(opts)#(splitopt[0:-1])
                lines.append('<option name="' + opt + '">')
                lines.append('\t<property name="section">' + section + '</property>')
                lines.append('\t<property name="type">' + val + '</property>')
                try:
                    description = globaldict[section]['options'].get(option).strip().replace(' R ', '').replace('<', '"').replace('>', '"')
                    print 'description =', description
                    line = description[0].upper() + description[1: description.find('.')]
                    #globaldict[section]['options'].get(option)[0: globaldict[section]['options'].get(option).find('.')]
                    lines.append('\t<property name="description">' + line + '</property>')
                    lines.append('\t<property name="fulldescription">\n\t' + description + '\n\t</property>')
                except (KeyError, IndexError):
                    lines.append('\t<property name="description">' + 'N/A' + '</property>')
                    pass
                lines.append(r'</option>')

    lines.append(r'</xorg-interface>')
    a = '\n'.join(lines)
    newxml.write(a)
    newxml.close()

def makeDict(whitelist=None):
    '''Creates a dictionary out of the man page
    
    fullDict = {
                option1: {
                          'section': '',
                          'optionType': '',
                          'valueType': '',
                          'description': '',
                          'fullDescription': '',
                          }
               }
    '''
    globaldict = parseManPage()
    
    fields = ['section',
              'optionType',
              'valueType',
              'description',
              'fullDescription']
    
    fullDict = {}
    
    sectionNames = ('InputDevice',
                    'Device',
                    'Module',
                    'Monitor',
                    'Screen',
                    'ServerLayout',
                    'ServerFlags',
                    'Extensions',
                    'Files', 
                    'DRI', 
                    'VideoAdaptor', 
                    'Vendor', 
                    'Modes',
                    'SubSection')
    
    
    for section in globaldict:
        #print 'SECTION', section
        # Subsections will be composed of 2 words e.g. DISPLAY SUBSECTION
        # while section will be one word only e.g. DEVICE
        sectionName = (section.find('SUBSECTION') == -1) and section.strip().split(' ')[0].lower() or section.lower()
        
        # Skip any section other than the ones in the whitelist
        # provided that whitelist != None
        if whitelist and len(sectionName.split(' ')) == 1 and sectionName not in whitelist:
            continue
        
        if globaldict[section].get('options') != None:
            
            for option in globaldict[section]['options']:
                #print 'OPTION', option
                if option.strip().lower().startswith('option'):
                    cleanOption = option.strip()[6:].strip()
                    optionType = 'Option'
                else:
                    cleanOption = option
                    optionType = ''
                
                
                splitopt = cleanOption.split(' ')
                values = []
                blacklist = [] 
                it = 0
                for elem in splitopt:
                    if '"' in elem:
                        values.append(elem[1:-1])
                        blacklist.append(it)
                    it += 1
                val = ' '.join(values)#splitopt[-1]
                opts = []
                it = 0
                for elem in splitopt:
                    if it not in blacklist:
                        opts.append(elem)
                    it += 1
                opt = ' '.join(opts).strip()#(splitopt[0:-1])
                
                opt = opt.split(' ')[0].strip()
                
                # Try to normalise section name
                for name in sectionNames:
                    if name.lower() == sectionName:
                        sectionName = name
                        break
                
                # NOTE: SubSection won't be normalised
                
                
                # Fill fullDict
                fullDict[opt] = {}.fromkeys(fields, '')
                fullDict[opt]['section'] = sectionName
                
                fullDict[opt]['optionType'] = optionType
                
                fullDict[opt]['valueType'] = val
                
                
                try:
                    description = globaldict[section]['options'].get(option).strip().replace(' R ', '').replace('<', '"').replace('>', '"')
                    fullDescription = description[0].upper() + description[1: description.find('.')]
                except (KeyError, IndexError):
                    description = ''
                    fullDescription = ''
                    
                
                fullDict[opt]['description'] = description
                fullDict[opt]['fullDescription'] = fullDescription
                
    return fullDict




if __name__ == '__main__':
    #makeXml()
    myFilter = ['device', 'screen', 'monitor', 'serverflags', 'display subsection']
#    myFilter = ['monitor']
    superDict = makeDict(myFilter)
    for optione in superDict:
        print '\n%s:' % (optione)
        print superDict[optione]


