#!/bin/sh

(gettextize --version) < /dev/null > /dev/null 2>&1 || {
	echo;
	echo "You must have gettext installed to compile XMMS";
	echo;
	exit;
}

(libtoolize --version) < /dev/null > /dev/null 2>&1 || {
	echo;
	echo "You must have libtool installed to compile XMMS";
	echo;
	exit;
}

(automake --version) < /dev/null > /dev/null 2>&1 || {
	echo;
	echo "You must have automake installed to compile XMMS";
	echo;
	exit;
}

(autoconf --version) < /dev/null > /dev/null 2>&1 || {
	echo;
	echo "You must have autoconf installed to compile XMMS";
	echo;
	exit;
}

echo "Generating configuration files for XMMS, please wait...."
echo;

aclocal $ACLOCAL_FLAGS;
libtoolize --automake --force;
autoheader;
automake --add-missing;
autoconf;

cd libxmms;
aclocal $ACLOCAL_FLAGS;
autoheader;
automake --add-missing;
autoconf;
cd ..;
./configure $@

cd po && ./update.pl --pot && cd ..;


