/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.SecondsDurationValue;

public abstract class CalendarValue
extends AtomicValue
implements Comparable {
    private int tzMinutes = Integer.MIN_VALUE;
    public static final int NO_TIMEZONE = Integer.MIN_VALUE;

    public final boolean hasTimezone() {
        return this.tzMinutes != Integer.MIN_VALUE;
    }

    public final void setTimezoneInMinutes(int n) {
        this.tzMinutes = n;
    }

    public abstract DateTimeValue toDateTime();

    public final int getTimezoneInMinutes() {
        return this.tzMinutes;
    }

    public final String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public abstract GregorianCalendar getCalendar();

    public abstract CalendarValue add(DurationValue var1) throws XPathException;

    public SecondsDurationValue subtract(CalendarValue calendarValue, XPathContext xPathContext) throws XPathException {
        Serializable serializable;
        DateTimeValue dateTimeValue = this.toDateTime();
        DateTimeValue dateTimeValue2 = calendarValue.toDateTime();
        if (dateTimeValue.getTimezoneInMinutes() != dateTimeValue2.getTimezoneInMinutes()) {
            serializable = xPathContext.getConfiguration();
            dateTimeValue = dateTimeValue.normalize((Configuration)serializable);
            dateTimeValue2 = dateTimeValue2.normalize((Configuration)serializable);
        }
        serializable = dateTimeValue.toJulianInstant();
        BigDecimal bigDecimal = dateTimeValue2.toJulianInstant();
        BigDecimal bigDecimal2 = ((BigDecimal)serializable).subtract(bigDecimal);
        return SecondsDurationValue.fromSeconds(bigDecimal2);
    }

    public final CalendarValue removeTimezone() {
        CalendarValue calendarValue = this.copy();
        calendarValue.tzMinutes = Integer.MIN_VALUE;
        return calendarValue;
    }

    public abstract CalendarValue adjustTimezone(int var1);

    public abstract CalendarValue copy();

    public abstract int compareTo(CalendarValue var1, Configuration var2);

    public abstract ComparisonKey getComparisonKey(Configuration var1);

    public final void appendTimezone(FastStringBuffer fastStringBuffer) {
        if (this.hasTimezone()) {
            CalendarValue.appendTimezone(this.getTimezoneInMinutes(), fastStringBuffer);
        }
    }

    public static final void appendTimezone(int n, FastStringBuffer fastStringBuffer) {
        if (n == 0) {
            fastStringBuffer.append("Z");
        } else {
            fastStringBuffer.append(n > 0 ? "+" : "-");
            n = Math.abs(n);
            CalendarValue.appendTwoDigits(fastStringBuffer, n / 60);
            fastStringBuffer.append(':');
            CalendarValue.appendTwoDigits(fastStringBuffer, n % 60);
        }
    }

    static void appendString(FastStringBuffer fastStringBuffer, int n, int n2) {
        String string = "000000000" + n;
        fastStringBuffer.append(string.substring(string.length() - n2));
    }

    static void appendTwoDigits(FastStringBuffer fastStringBuffer, int n) {
        fastStringBuffer.append((char)(n / 10 + 48));
        fastStringBuffer.append((char)(n % 10 + 48));
    }
}

