/*
 Copyright (C) 2000-2006

 Code contributed by Greg Collecutt, Joseph Hope and Paul Cochrane

 This file is part of xmds.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmdselement.cc 1283 2007-01-29 21:42:00Z paultcochrane $
*/

/*! @file xmdselement.cc
  @brief Element parsing classes and methods

  More detailed explanation...
*/

#include<xmlbasics.h>
#include<dom3.h>
#include<xmdsutils.h>
#include<xmdsclasses.h>

// **************************************************************************
// **************************************************************************
//                              xmdsElement public
// **************************************************************************
// **************************************************************************

extern bool debugFlag;

long nxmdsElements=0;  //!< Number of xmds element objects

// **************************************************************************
xmdsElement::xmdsElement(
    const xmdsSimulation *const yourSimulation,
    const bool& yourVerboseMode) :
  mySimulation(yourSimulation),
  myVerbose(yourVerboseMode) {
if(debugFlag) {
  nxmdsElements++;
  printf("xmdsElement::xmdsElement\n");
  printf("nxmdsElements=%li\n",nxmdsElements);
  }
};

// **************************************************************************
xmdsElement::~xmdsElement() {
if(debugFlag) {
  nxmdsElements--;
  printf("xmdsElement::~xmdsElement\n");
  printf("nxmdsElements=%li\n",nxmdsElements);
  }

for(list<const xmdsElement*>::const_iterator ppxmdsElement =
    myChildList.begin(); ppxmdsElement!=myChildList.end();
    ppxmdsElement++) {
  delete *ppxmdsElement;
}
};

// **************************************************************************
// **************************************************************************
//                              xmdsElement protected
// **************************************************************************
// **************************************************************************

// **************************************************************************
void xmdsElement::writeDefines(
  FILE *const outfile) const {
if(debugFlag) {
  printf("xmdsElement::writeDefines\n");
}

for(list<const xmdsElement*>::const_iterator ppxmdsElement =
    myChildList.begin(); ppxmdsElement!=myChildList.end();
    ppxmdsElement++) {
  (*ppxmdsElement)->writeDefines(outfile);
}
};

// **************************************************************************
void xmdsElement::writeGlobals(
  FILE *const outfile) const {
if(debugFlag) {
  printf("xmdsElement::writeGlobals\n");
}

for(list<const xmdsElement*>::const_iterator ppxmdsElement =
    myChildList.begin(); ppxmdsElement!=myChildList.end();
    ppxmdsElement++) {
  (*ppxmdsElement)->writeGlobals(outfile);
}
};

// **************************************************************************
void xmdsElement::writePrototypes(
  FILE *const outfile) const {
if(debugFlag) {
  printf("xmdsElement::writePrototypes\n");
}

for(list<const xmdsElement*>::const_iterator ppxmdsElement =
    myChildList.begin(); ppxmdsElement!=myChildList.end();
    ppxmdsElement++)
{
  (*ppxmdsElement)->writePrototypes(outfile);
}
};

// **************************************************************************
void xmdsElement::writeRoutines(
  FILE *const outfile) const {
if(debugFlag) {
  printf("xmdsElement::writeRoutines\n");
}

for(list<const xmdsElement*>::const_iterator ppxmdsElement =
    myChildList.begin(); ppxmdsElement!=myChildList.end();
    ppxmdsElement++) {
  (*ppxmdsElement)->writeRoutines(outfile);
}
};

// **************************************************************************
void xmdsElement::addChild(
  const xmdsElement *const newChild) {
if(debugFlag) {
  printf("xmdsElement::addChild\n");
}

myChildList.push_back(newChild);
};

// **************************************************************************
const xmdsSimulation* xmdsElement::simulation() const {
return mySimulation;
};

// **************************************************************************
bool xmdsElement::verbose() const {
return myVerbose;
};

/*
 * Local variables:
 * c-indentation-style: bsd
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 *
 * vim: tabstop=2 expandtab shiftwidth=2:
 */
