#include "../config.h"

#if HAVE_LIBMYSQL

#include "askname.h"
#include "cfg.h"
#include "mysql_backend.h"
#include "useful.h"

#ifdef XLC
	#include "widgets.h"
	#include "interface.h"
#else ifdef XLCM
	#include "widgets_xlcm.h"
	#include "interface_xlcm.h"
#endif

#include "fifo.h"

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <stdlib.h>
#include <string.h>

#define MAP_FIELD_LEN	30
struct t_number_map
{
	char num[MAP_FIELD_LEN];
	char name[MAP_FIELD_LEN];
};

struct t_number_map *askname_actual = NULL;
struct tfifo_item *askname_fifo = NULL;

char isname(const char *str)
{
	int i = strlen(str);
	const char *ptr = str;
	for ( ; i--; ptr++ )
		if ( (*ptr <= 'z' && *ptr >= 'a') || (*ptr >= 'Z' && *ptr >= 'A') )
			return 1;
	return 0;
}

struct t_number_map* pop_number()
{
	struct t_number_map *map;
	askname_fifo = fifo_pop(askname_fifo, (void*)&map);
	return map;
}

void push_number(const char *str)
{
	struct t_number_map *new = g_malloc(sizeof(struct t_number_map));
	if ( !new ) return;
	strncpy(new->num, str, sizeof(new->num));
	new->num[sizeof(new->num)-1] = 0;
	*new->name = 0;
	askname_fifo = fifo_push(askname_fifo, new);
}

void drop_actual()
{
	if ( askname_actual )
	{
		g_free(askname_actual);
		askname_actual = NULL;
	}
}

void handle_next_number()
{
	if ( askname_actual ) return; // GUI waiting for input
	if ( !askname_fifo )
	{
		if ( wdg_askname->realized )
			gtk_widget_destroy(wnd_askname);
		return;
	}
	askname_actual = pop_number();
	if ( !wdg_askname->realized )
	{ // popup askname dialog
		wnd_askname = create_wnd_askname ();
		gtk_widget_show(wnd_askname);
	}
	gtk_entry_set_text(wdg_askname->ent_number, askname_actual->num);
	gtk_window_activate_focus(GTK_WINDOW(wnd_askname));
	gtk_widget_grab_focus(GTK_WIDGET(wdg_askname->ent_name));
}

void an_incoming_number(const char *str)
{
	static int notfirst = 0;
	#ifdef ADDRBOOK_DEBUG
		g_print("an_incoming_number('%s')\n", str);
	#endif
	if ( !config->addrbook_ask ) return;
	if ( isname(str) ) return;
	if ( !sqlbe_initialized() || !notfirst )
	{
		notfirst++;
		#ifdef ADDRBOOK_DEBUG
			g_print("Initialising mysql backend...\n");
		#endif
		if ( !sqlbe_initialized() )
			sqlbe_init(
					config->mysql_host,
					config->mysql_user,
					config->mysql_pass,
					config->mysql_db
				);
		#ifdef ADDRBOOK_DEBUG
			g_print("Connecting to mysql database\n");
		#endif
		sqlbe_connect();
	}
	if ( !sqlbe_available() )
	{
		g_print("mysql number to name mapper: mysql not available.\n");
		return;
	}
	if ( !sqlbe_connected() )
		sqlbe_connect();
	push_number(str);
	handle_next_number();
}

void an_ok()
{ // insert mapping into the mysql db.
	#define MQLEN	400
	char query[MQLEN+1];
	char *txt = NULL;

	get_entry_text(wdg_askname->ent_name, &txt);
	if ( txt && *txt )
	{ // insert into mysql db
		strncpy(askname_actual->name, txt, MAP_FIELD_LEN);
		askname_actual->name[MAP_FIELD_LEN-1] = 0;
		snprintf(query, MQLEN, "insert into addrbook (name, phone) values ('%s', '%s')",
					askname_actual->name, askname_actual->num);
		#ifdef ADDRBOOK_DEBUG
			g_print("MySQL query: %s\n", query);
		#endif
		sqlbe_query(query);
		#ifdef ADDRBOOK_DEBUG
			g_print("MySQL entry '%s' -> '%s' made.\n",
					askname_actual->num, askname_actual->name);
		#endif
	}
	if ( txt ) g_free(txt);
	drop_actual(); // entry made, free it

	// handle next number or close dialog
	handle_next_number();
}

void an_cancel()
{ // forget it.
	drop_actual();
	// handle next number or close dialog
	handle_next_number();
}

#endif // HAVE_LIBMYSQL
