#include "config.h"
#include "config.h"
#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <fox-1.6/fx.h>
#include <fox-1.6/fxkeys.h>
#include <fox-1.6/FXPNGIcon.h>

#include "xfedefs.h"
#include "FileList.h"
#include "FileDict.h"
#include "Preferences.h"
#include "FilePanel.h"
#include "XFileExplorer.h"
#include "InputDialog.h"
#include "HistInputDialog.h"
#include "OverwriteBox.h"
#include "DirPanel.h"
#include "icons.h"
#include "File.h"
#include "MessageBox.h"
#include "TextWindow.h"
#include "CommandWindow.h"
#include "Bookmarks.h"
#include "FileDialog.h"
#include "help.h"
#include "DirHistBox.h"

// Size of the location bar
#define LOCATION_BAR_LENGTH 70
#define LOCATION_BAR_HEIGHT 6

// Minimum width of a file or directory panel
#define MIN_PANEL_WIDTH 100


// Global variables
FXString clipboard="";
char OpenHistory[OPEN_WITH_HIST_SIZE][100];
int OpenNum;
FXColor highlightcolor;
FXbool allowPopupScroll=FALSE;
FXbool single_click_diropen=FALSE;
FXbool single_click_fileopen=FALSE;



// External global variables
extern FXMainWindow *mainWindow;
extern char** args;

// Global options
extern FXString startdir;
#if defined(linux)
extern FXStringDict* fsdevices;
extern FXStringDict* updevices;
#endif
extern FXbool iconic;
extern FXbool maximized;




// Helper function to draw a toolbar separator
void toolbarSeparator(FXToolBar* tb)
{
#define SEP_SPACE	1
#define SEP_HEIGHT	15
    new FXFrame(tb,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,SEP_SPACE);
    new FXVerticalSeparator(tb,LAYOUT_SIDE_TOP|LAYOUT_CENTER_Y|SEPARATOR_GROOVE|LAYOUT_FIX_HEIGHT,0,0,0,SEP_HEIGHT);
    new FXFrame(tb,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,SEP_SPACE);
}



// Map
FXDEFMAP(XFileExplorer) XFileExplorerMap[]={
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_TOGGLE_STATUS,XFileExplorer::onCmdToggleStatus),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RUN,XFileExplorer::onCmdRun),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SU,XFileExplorer::onCmdSu),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_COPY,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_RENAME,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_COPYTO,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_MOVE,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_CUT,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_DELETE,XFileExplorer::onCmdFileDelete),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_TRASH,XFileExplorer::onCmdFileTrash),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_SYMLINK,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_QUIT,XFileExplorer::onQuit),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_HELP,XFileExplorer::onCmdHelp),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_ABOUT,XFileExplorer::onCmdAbout),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_ASSOC,XFileExplorer::onCmdFileAssoc),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_REFRESH,XFileExplorer::onCmdRefresh),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_EMPTY_TRASHCAN,XFileExplorer::onCmdEmptyTrashcan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_XTERM,XFileExplorer::onCmdXTerm),
									 FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_CLEAR_LOCATION,XFileExplorer::onCmdClearLocation),
									 FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_GOTO_LOCATION,XFileExplorer::onCmdGotoLocation),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_PREFS,XFileExplorer::onCmdPrefs),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_ONE_PANEL,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TWO_PANELS,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TREE_PANEL,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TREE_TWO_PANELS,XFileExplorer::onCmdShowPanels),
			                         FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RESTART,XFileExplorer::onCmdRestart),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_NEW_WIN,XFileExplorer::onCmdNewWindow),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_BOOKMARK,XFileExplorer::onCmdBookmark),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_ADD_BOOKMARK,XFileExplorer::onCmdBookmark),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_DIR_BACK,XFileExplorer::onCmdDirBack),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_DIR_BACK,XFileExplorer::onUpdDirBack),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_DIR_FORWARD,XFileExplorer::onCmdDirForward),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_DIR_FORWARD,XFileExplorer::onUpdDirForward),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_DIR_BACK_HIST,XFileExplorer::onCmdDirBackHist),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_DIR_BACK_HIST,XFileExplorer::onUpdDirBackHist),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_DIR_FORWARD_HIST,XFileExplorer::onCmdDirForwardHist),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_DIR_FORWARD_HIST,XFileExplorer::onUpdDirForwardHist),
           						     FXMAPFUNC(SEL_KEYPRESS,0,XFileExplorer::onKeyPress),
                                     FXMAPFUNC(SEL_CLOSE,0,XFileExplorer::onQuit),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_TOGGLE_STATUS,XFileExplorer::onUpdToggleStatus),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_ONE_PANEL,XFileExplorer::onUpdShowPanels),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TWO_PANELS,XFileExplorer::onUpdShowPanels),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TREE_PANEL,XFileExplorer::onUpdShowPanels),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TREE_TWO_PANELS,XFileExplorer::onUpdShowPanels),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_GOTO_LOCATION,XFileExplorer::onUpdFileLocation),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_EMPTY_TRASHCAN,XFileExplorer::onUpdEmptyTrashcan),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_FILE_DELETE,XFileExplorer::onUpdFileDelete),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_FILE_TRASH,XFileExplorer::onUpdFileTrash),
                                 };


// Object implementation
FXIMPLEMENT(XFileExplorer,FXMainWindow,XFileExplorerMap,ARRAYNUMBER(XFileExplorerMap))


// Make some windows
XFileExplorer::XFileExplorer(FXApp *app,char *title,FXIcon *bigicon,FXIcon *miniicon):
        FXMainWindow(app,title,bigicon,miniicon,DECOR_ALL,0,0,800,600,0,0)
{

	FXHotKey hotkey;

    bookmarks=new Bookmarks("bookmarks",this,ID_BOOKMARK);

	// Site where to dock
	FXDockSite* docksite=new FXDockSite(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

    // Menu bar
  	FXToolBarShell* dragshell1=new FXToolBarShell(this,FRAME_RAISED);
    menubar=new FXMenuBar(docksite,dragshell1,LAYOUT_DOCK_NEXT|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|FRAME_RAISED);
	new FXToolBarGrip(menubar,menubar,FXMenuBar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);

    // Toolbar
  	FXToolBarShell* dragshell2=new FXToolBarShell(this,FRAME_RAISED);
  	toolbar=new FXToolBar(docksite,dragshell2,LAYOUT_DOCK_NEXT|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|FRAME_RAISED);
  	new FXToolBarGrip(toolbar,toolbar,FXToolBar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);

   	// Location bar
  	FXToolBarShell* dragshell3=new FXToolBarShell(this,FRAME_RAISED);
  	locationbar=new FXToolBar(docksite,dragshell3,LAYOUT_DOCK_NEXT|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|FRAME_RAISED);
  	new FXToolBarGrip(locationbar,locationbar,FXToolBar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);

    // Main splitter
  	FXHorizontalFrame* splitterbox=new FXHorizontalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0, 0,0);
	FXSplitter* mainsplit=new FXSplitter(splitterbox,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);

    // File list background, foreground and highlight colors
	listbackcolor=getApp()->reg().readColorEntry("SETTINGS","listbackcolor",FXRGB(255,255,255));
	listforecolor=getApp()->reg().readColorEntry("SETTINGS","listforecolor",FXRGB(0,0,0));
	highlightcolor=getApp()->reg().readColorEntry("SETTINGS","highlightcolor",FXRGB(238,238,238));
		
	// Directory panel on the left (with minimum size)
    dirpanel=new DirPanel(mainsplit,listbackcolor,listforecolor,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);

	// Sub splitter
    FXSplitter* subsplit=new FXSplitter(mainsplit,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);
	
	// File panels on the right (with minimum size) : remembers size of each field
	lpanel=new FilePanel("LEFT PANEL",subsplit,
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","name_size",200),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","size_size",60),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","type_size",100),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","ext_size",100),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","modd_size",150),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","user_size",50),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","grou_size",50),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","attr_size",100),
					 listbackcolor,listforecolor,
					 LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);
    rpanel=new FilePanel("RIGHT PANEL",subsplit,
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","name_size",200),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","size_size",60),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","type_size",100),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","ext_size",100),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","modd_size",150),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","user_size",50),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","grou_size",50),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","attr_size",100),
					 listbackcolor,listforecolor,
					 LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);
    lpanel->Next(rpanel);
    rpanel->Next(lpanel);
    lpanel->focus();

	// Read and set sort function for left panel
	FXString sort_func=getApp()->reg().readStringEntry("LEFT PANEL","sort_func","ascendingCase");
    if (sort_func=="ascendingCase")
		lpanel->list->setSortFunc(lpanel->list->ascendingCase);        
    if (sort_func=="ascendingCaseMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingCaseMix);        
    else if (sort_func=="descendingCase")
		lpanel->list->setSortFunc(lpanel->list->descendingCase);        
    else if (sort_func=="descendingCaseMix")
		lpanel->list->setSortFunc(lpanel->list->descendingCaseMix);        
    else if (sort_func=="ascending")
		lpanel->list->setSortFunc(lpanel->list->ascending);        
	else if (sort_func=="ascendingMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingMix);        
    else if (sort_func=="descending")
		lpanel->list->setSortFunc(lpanel->list->descending);        
    else if (sort_func=="descendingMix")
		lpanel->list->setSortFunc(lpanel->list->descendingMix);        
	else if (sort_func=="ascendingSize")
		lpanel->list->setSortFunc(lpanel->list->ascendingSize);        
	else if (sort_func=="ascendingSizeMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingSizeMix);        
	else if (sort_func=="descendingSize")
		lpanel->list->setSortFunc(lpanel->list->descendingSize);        
	else if (sort_func=="descendingSizeMix")
		lpanel->list->setSortFunc(lpanel->list->descendingSizeMix);        
	else if (sort_func=="ascendingType")
		lpanel->list->setSortFunc(lpanel->list->ascendingType);        
	else if (sort_func=="ascendingTypeMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingTypeMix);        
	else if (sort_func=="descendingType")
		lpanel->list->setSortFunc(lpanel->list->descendingType);        
	else if (sort_func=="descendingTypeMix")
		lpanel->list->setSortFunc(lpanel->list->descendingTypeMix);        
	else if (sort_func=="ascendingExt")
		lpanel->list->setSortFunc(lpanel->list->ascendingExt);        
	else if (sort_func=="ascendingExtMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingExtMix);        
	else if (sort_func=="descendingExt")
		lpanel->list->setSortFunc(lpanel->list->descendingExt);        
	else if (sort_func=="descendingExtMix")
		lpanel->list->setSortFunc(lpanel->list->descendingExtMix);        
	else if (sort_func=="ascendingTime")
		lpanel->list->setSortFunc(lpanel->list->ascendingTime);        
	else if (sort_func=="ascendingTimeMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingTimeMix);        
	else if (sort_func=="descendingTime")
		lpanel->list->setSortFunc(lpanel->list->descendingTime);        
	else if (sort_func=="descendingTimeMix")
		lpanel->list->setSortFunc(lpanel->list->descendingTimeMix);        
	else if (sort_func=="ascendingUser")
		lpanel->list->setSortFunc(lpanel->list->ascendingUser);        
	else if (sort_func=="ascendingUserMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingUserMix);        
	else if (sort_func=="descendingUser")
		lpanel->list->setSortFunc(lpanel->list->descendingUser);         
	else if (sort_func=="descendingUserMix")
		lpanel->list->setSortFunc(lpanel->list->descendingUserMix);         
	else if (sort_func=="ascendingGroup")
		lpanel->list->setSortFunc(lpanel->list->ascendingGroup);        
	else if (sort_func=="ascendingGroupMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingGroupMix);        
	else if (sort_func=="descendingGroup")
		lpanel->list->setSortFunc(lpanel->list->descendingGroup);        
	else if (sort_func=="descendingGroupMix")
		lpanel->list->setSortFunc(lpanel->list->descendingGroupMix);        
	else if (sort_func=="ascendingPerm")
		lpanel->list->setSortFunc(lpanel->list->ascendingPerm);        
	else if (sort_func=="ascendingPermMix")
		lpanel->list->setSortFunc(lpanel->list->ascendingPermMix);        
	else if (sort_func=="descendingPerm")
		lpanel->list->setSortFunc(lpanel->list->descendingPerm);        
	else if (sort_func=="descendingPermMix")
		lpanel->list->setSortFunc(lpanel->list->descendingPermMix);        
	FXuint ignore_case=getApp()->reg().readUnsignedEntry("LEFT PANEL","ignore_case",1);
	lpanel->list->setIgnoreCase(ignore_case);        
	FXuint dirs_first=getApp()->reg().readUnsignedEntry("LEFT PANEL","dirs_first",1);
	lpanel->list->setDirsFirst(dirs_first);        

	// Read and set sort function for right panel
	sort_func=getApp()->reg().readStringEntry("RIGHT PANEL","sort_func","ascendingCase");
    if (sort_func=="ascendingCase")
		rpanel->list->setSortFunc(rpanel->list->ascendingCase);        
    if (sort_func=="ascendingCaseMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingCaseMix);        
    else if (sort_func=="descendingCase")
		rpanel->list->setSortFunc(rpanel->list->descendingCase);        
    else if (sort_func=="descendingCaseMix")
		rpanel->list->setSortFunc(rpanel->list->descendingCaseMix);        
    else if (sort_func=="ascending")
		rpanel->list->setSortFunc(rpanel->list->ascending);        
	else if (sort_func=="ascendingMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingMix);        
    else if (sort_func=="descending")
		rpanel->list->setSortFunc(rpanel->list->descending);        
    else if (sort_func=="descendingMix")
		rpanel->list->setSortFunc(rpanel->list->descendingMix);        
	else if (sort_func=="ascendingSize")
		rpanel->list->setSortFunc(rpanel->list->ascendingSize);        
	else if (sort_func=="ascendingSizeMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingSizeMix);        
	else if (sort_func=="descendingSize")
		rpanel->list->setSortFunc(rpanel->list->descendingSize);        
	else if (sort_func=="descendingSizeMix")
		rpanel->list->setSortFunc(rpanel->list->descendingSizeMix);        
	else if (sort_func=="ascendingType")
		rpanel->list->setSortFunc(rpanel->list->ascendingType);        
	else if (sort_func=="ascendingTypeMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingTypeMix);        
	else if (sort_func=="descendingType")
		rpanel->list->setSortFunc(rpanel->list->descendingType);        
	else if (sort_func=="descendingTypeMix")
		rpanel->list->setSortFunc(rpanel->list->descendingTypeMix);        
	else if (sort_func=="ascendingExt")
		rpanel->list->setSortFunc(rpanel->list->ascendingExt);        
	else if (sort_func=="ascendingExtMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingExtMix);        
	else if (sort_func=="descendingExt")
		rpanel->list->setSortFunc(rpanel->list->descendingExt);        
	else if (sort_func=="descendingExtMix")
		rpanel->list->setSortFunc(rpanel->list->descendingExtMix);        
	else if (sort_func=="ascendingTime")
		rpanel->list->setSortFunc(rpanel->list->ascendingTime);        
	else if (sort_func=="ascendingTimeMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingTimeMix);        
	else if (sort_func=="descendingTime")
		rpanel->list->setSortFunc(rpanel->list->descendingTime);        
	else if (sort_func=="descendingTimeMix")
		rpanel->list->setSortFunc(rpanel->list->descendingTimeMix);        
	else if (sort_func=="ascendingUser")
		rpanel->list->setSortFunc(rpanel->list->ascendingUser);        
	else if (sort_func=="ascendingUserMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingUserMix);        
	else if (sort_func=="descendingUser")
		rpanel->list->setSortFunc(rpanel->list->descendingUser);         
	else if (sort_func=="descendingUserMix")
		rpanel->list->setSortFunc(rpanel->list->descendingUserMix);         
	else if (sort_func=="ascendingGroup")
		rpanel->list->setSortFunc(rpanel->list->ascendingGroup);        
	else if (sort_func=="ascendingGroupMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingGroupMix);        
	else if (sort_func=="descendingGroup")
		rpanel->list->setSortFunc(rpanel->list->descendingGroup);        
	else if (sort_func=="descendingGroupMix")
		rpanel->list->setSortFunc(rpanel->list->descendingGroupMix);        
	else if (sort_func=="ascendingPerm")
		rpanel->list->setSortFunc(rpanel->list->ascendingPerm);        
	else if (sort_func=="ascendingPermMix")
		rpanel->list->setSortFunc(rpanel->list->ascendingPermMix);        
	else if (sort_func=="descendingPerm")
		rpanel->list->setSortFunc(rpanel->list->descendingPerm);        
	else if (sort_func=="descendingPermMix")
		rpanel->list->setSortFunc(rpanel->list->descendingPermMix);        
	ignore_case=getApp()->reg().readUnsignedEntry("RIGHT PANEL","ignore_case",1);
	rpanel->list->setIgnoreCase(ignore_case);        
	dirs_first=getApp()->reg().readUnsignedEntry("RIGHT PANEL","dirs_first",1);
	rpanel->list->setDirsFirst(dirs_first);        

    FXButton *btn=NULL;
    FXToggleButton *tgbtn=NULL;

    // Add some toolbar buttons
    btn=new FXButton(toolbar,_("\tGo back (Ctrl-Backspace)"),dirbackicon,this,XFileExplorer::ID_DIR_BACK,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
	hotkey=(CONTROLMASK<<16) | KEY_BackSpace;
	btn->addHotKey(hotkey);

	btnbackhist=new FXArrowButton(toolbar,this,XFileExplorer::ID_DIR_BACK_HIST,LAYOUT_FILL_Y|FRAME_RAISED|FRAME_THICK|ARROW_DOWN|ARROW_TOOLBAR);
	
    btn=new FXButton(toolbar,_("\tGo forward (Shift-Backspace)"),dirforwardicon,this,XFileExplorer::ID_DIR_FORWARD,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
	hotkey=(SHIFTMASK<<16) | KEY_BackSpace;
	btn->addHotKey(hotkey);

	btnforwardhist=new FXArrowButton(toolbar,this,XFileExplorer::ID_DIR_FORWARD_HIST,LAYOUT_FILL_Y|FRAME_RAISED|FRAME_THICK|ARROW_DOWN|ARROW_TOOLBAR);

	btn=new FXButton(toolbar,_("\tGo up (Backspace)"),dirupicon,lpanel->current,FilePanel::ID_DIRECTORY_UP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    btn->addHotKey(KEY_BackSpace);

	toolbarSeparator(toolbar);

	new FXButton(toolbar,_("\tGo home (Ctrl-H)"),homeicon,lpanel->current,FilePanel::ID_GO_HOME,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
	new FXButton(toolbar,_("\tPanel refresh (Ctrl-R)"),reloadicon,this,XFileExplorer::ID_REFRESH,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

	toolbarSeparator(toolbar);

    new FXButton(toolbar,_("\tCreate new file (F2)"),newfileicon,lpanel->current,FilePanel::ID_NEW_FILE,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    new FXButton(toolbar,_("\tCreate new folder (F7)"),newfoldericon,lpanel->current,FilePanel::ID_NEW_DIR,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

	toolbarSeparator(toolbar);
	
    btn=new FXButton(toolbar,_("\tCopy selected files to clipboard (Ctrl-C, F5)"),copy_clpicon,lpanel->current,FilePanel::ID_COPY_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    btn->addHotKey(KEY_F5);

    new FXButton(toolbar,_("\tCut selected files to clipboard (Ctrl-X)"),cut_clpicon,lpanel->current,FilePanel::ID_CUT_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    new FXButton(toolbar,_("\tPaste from clipboard (Ctrl-V)"),paste_clpicon,lpanel->current,FilePanel::ID_PASTE_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    new FXButton(toolbar,_("\tShow properties of selected files (F9)"),attribicon,lpanel->current,FilePanel::ID_PROPERTIES,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);

	toolbarSeparator(toolbar);

	btntrash=new FXButton(toolbar,_("\tMove selected files to trash can (Del, F8)"),filedeleteicon,this,XFileExplorer::ID_FILE_TRASH,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
	btntrash->addHotKey(KEY_Delete);
	btntrash->addHotKey(KEY_F8);
	btndel=new FXButton(toolbar,_("\tDelete selected files (Shift-Del)"),filedelete_permicon,this,XFileExplorer::ID_FILE_DELETE,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
		
	toolbarSeparator(toolbar);

    new FXButton(toolbar,_("\tLaunch Xfe as root (Shift-F3)"),minixferooticon,this,XFileExplorer::ID_SU,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    new FXButton(toolbar,_("\tExecute command (Ctrl-E)"),runicon,this,XFileExplorer::ID_RUN,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    new FXButton(toolbar,_("\tTerminal (Ctrl-T)"),shellicon,this,XFileExplorer::ID_XTERM,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

/*
#if defined(linux)
	toolbarSeparator(toolbar);

    // Mount and unmount buttons
    btn=new FXButton(toolbar,_("\tMount (Ctrl-M)"),maphosticon,lpanel->current,FilePanel::ID_MOUNT,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey=(CONTROLMASK<<16) | KEY_m;
    btn->addHotKey(hotkey);

    btn=new FXButton(toolbar,_("\tUnmount (Ctrl-U)"),unmaphosticon,lpanel->current,FilePanel::ID_UMOUNT,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey=(CONTROLMASK<<16) | KEY_u;
    btn->addHotKey(hotkey);
#endif
*/

	toolbarSeparator(toolbar);

	// Show one panel
   	btn=new FXButton(toolbar,_("\tShow one panel (Ctrl-F1)"),onepanelicon,this,XFileExplorer::ID_SHOW_ONE_PANEL,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (CONTROLMASK<<16) | KEY_F1;
   	btn->addHotKey(hotkey);

	// Show tree and panel
   	new FXButton(toolbar,_("\tShow tree and panel (Ctrl-F2)"),treeonepanelicon,this,XFileExplorer::ID_SHOW_TREE_PANEL,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (CONTROLMASK<<16) | KEY_F2;
   	btn->addHotKey(hotkey);

	// Show two panels
   	new FXButton(toolbar,_("\tShow two panels (Ctrl-F3)"),twopanelsicon,this,XFileExplorer::ID_SHOW_TWO_PANELS,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (CONTROLMASK<<16) | KEY_F3;
   	btn->addHotKey(hotkey);

	// Show tree and two panels
   	btn = new FXButton(toolbar,_("\tShow tree and two panels (Ctrl-F4)"),treetwopanelsicon,this,XFileExplorer::ID_SHOW_TREE_TWO_PANELS,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (CONTROLMASK<<16) | KEY_F4;
   	btn->addHotKey(hotkey);

	// Show or hide hidden files (button not shown : just to add the shortcut)   
    tgbtn=new FXToggleButton(toolbar,_("\tHide hidden files (Ctrl-F6)"),_("\tShow hidden files (Ctrl-F6)"),hidehiddenicon,showhiddenicon,lpanel->current,FilePanel::ID_TOGGLE_HIDDEN,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    tgbtn->hide();
	hotkey=(CONTROLMASK<<16) | KEY_F6;
    tgbtn->addHotKey(hotkey);

	// Show or hide thumbnails (button not shown : just to add the shortcut)   
   	tgbtn=new FXToggleButton(toolbar,_("\tHide thumbnails (Ctrl-F7)"),_("\tShow thumbnails (Ctrl-F7)"),showthumbicon,hidethumbicon,lpanel->current,FilePanel::ID_TOGGLE_THUMBNAILS,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    tgbtn->hide();
	hotkey=KEY_F7;
   	tgbtn->addHotKey(hotkey);

	toolbarSeparator(toolbar);

    // Switch display modes
    btn=new FXButton(toolbar,_("\tBig icons (F10)"),bigiconsicon,lpanel->current,FilePanel::ID_SHOW_BIG_ICONS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
   	btn->addHotKey(KEY_F10);
    btn=new FXButton(toolbar,_("\tSmall icons (F11)"),smalliconsicon,lpanel->current,FilePanel::ID_SHOW_MINI_ICONS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
   	btn->addHotKey(KEY_F11);
    btn=new FXButton(toolbar,_("\tFull file list (F12)"),detailsicon,lpanel->current,FilePanel::ID_SHOW_DETAILS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
    btn->addHotKey(KEY_F12);

	toolbarSeparator(toolbar);

    // Quit button
    btn=new FXButton(toolbar,_("\tQuit (Ctrl-Q, Ctrl-W)"),quiticon,this,XFileExplorer::ID_QUIT,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
    hotkey=(CONTROLMASK<<16) | KEY_w;
    btn->addHotKey(hotkey);

  	// Location bar
  	new FXLabel(locationbar,_("Location:"));
  	new FXButton(locationbar,_("\tClear Location bar\tClear Location bar."),locationicon,this,ID_CLEAR_LOCATION,BUTTON_TOOLBAR|LAYOUT_CENTER_Y|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
	address=new FXComboBox(locationbar,LOCATION_BAR_LENGTH,this,ID_GOTO_LOCATION,TEXTFIELD_NORMAL|JUSTIFY_LEFT|LAYOUT_CENTER_Y);
	address->setNumVisible(5);
 	new FXButton(locationbar,_("\tGo\tGo to location."),entericon,this,ID_GOTO_LOCATION,BUTTON_TOOLBAR|LAYOUT_CENTER_Y|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);

    // Menus

    // File menu	
	filemenu=new FXMenuPane(this);
    new FXMenuCommand(filemenu,_("New &file...\tF2"),newfileicon,lpanel->current,FilePanel::ID_NEW_FILE);
    new FXMenuCommand(filemenu,_("New fo&lder...\tF7"),newfoldericon,lpanel->current,FilePanel::ID_NEW_DIR);
    new FXMenuCommand(filemenu,_("Go &home\tCtrl-H"),homeicon,lpanel->current,FilePanel::ID_GO_HOME);
    new FXMenuCommand(filemenu,_("&Refresh\tCtrl-R"),reloadicon,this,XFileExplorer::ID_REFRESH);
    new FXMenuSeparator(filemenu);
    new FXMenuCommand(filemenu,_("&Open...\tCtrl-O"),fileopenicon,lpanel->current,FilePanel::ID_OPEN);
    new FXMenuCommand(filemenu,_("Re&name...\tCtrl-N"),renameiticon,lpanel->current,FilePanel::ID_FILE_RENAME);
    new FXMenuCommand(filemenu,_("&Copy to...\tCtrl-K"),copy_clpicon,lpanel->current,FilePanel::ID_FILE_COPYTO);
    new FXMenuCommand(filemenu,_("&Move to...\tCtrl-D"),moveiticon,lpanel->current,FilePanel::ID_FILE_MOVE);
    new FXMenuCommand(filemenu,_("&Symlink...\tCtrl-S"),minilinkicon,lpanel->current,FilePanel::ID_FILE_SYMLINK);
    new FXMenuCommand(filemenu,_("Mo&ve to trash\tDel"),filedeleteicon,this,XFileExplorer::ID_FILE_TRASH);
    new FXMenuCommand(filemenu,_("&Delete\tShift-Del"),filedelete_permicon,this,XFileExplorer::ID_FILE_DELETE);
    new FXMenuCommand(filemenu,_("&Properties...\tF9"),attribicon,lpanel->current,FilePanel::ID_PROPERTIES);
    new FXMenuSeparator(filemenu);
    new FXMenuCommand(filemenu,_("&Quit\tCtrl-Q"),quiticon,this,XFileExplorer::ID_QUIT);
	filemenutitle=new FXMenuTitle(menubar,_("&File"),NULL,filemenu);
	
	// Edit menu
    editmenu=new FXMenuPane(this);
    new FXMenuCommand(editmenu,_("&Copy\tCtrl-C"),copy_clpicon,lpanel->current,FilePanel::ID_COPY_CLP);
    new FXMenuCommand(editmenu,_("C&ut\tCtrl-X"),cut_clpicon,lpanel->current,FilePanel::ID_CUT_CLP);
    new FXMenuCommand(editmenu,_("&Paste\tCtrl-V"),paste_clpicon,lpanel->current,FilePanel::ID_PASTE_CLP);
    new FXMenuSeparator(editmenu);
    new FXMenuCommand(editmenu,_("&Select all\tCtrl-A"),selallicon,lpanel->current,FilePanel::ID_SELECT_ALL);
    new FXMenuCommand(editmenu,_("&Deselect all\tCtrl-Z"),deselicon,lpanel->current,FilePanel::ID_DESELECT_ALL);
    new FXMenuCommand(editmenu,_("&Invert selection\tCtrl-I"),invselicon,lpanel->current,FilePanel::ID_SELECT_INVERSE);
    new FXMenuSeparator(editmenu);
    new FXMenuCommand(editmenu,_("P&references"),prefsicon,this,XFileExplorer::ID_PREFS);
    editmenutitle=new FXMenuTitle(menubar,_("&Edit"),NULL,editmenu);

    // Bookmarks menu
    bookmarksmenu=new FXMenuPane(this);
    new FXMenuCommand(bookmarksmenu,_("&Add bookmark\tCtrl-B"),setbookicon,this,ID_ADD_BOOKMARK);
    FXMenuSeparator* sep1=new FXMenuSeparator(bookmarksmenu);
    sep1->setTarget(bookmarks);
    sep1->setSelector(Bookmarks::ID_ANYBOOKMARKS);

    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_1);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_2);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_3);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_4);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_5);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_6);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_7);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_8);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_9);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_10);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_11);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_12);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_13);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_14);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_15);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_16);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_17);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_18);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_19);
    new FXMenuCommand(bookmarksmenu,FXString::null,NULL,bookmarks,Bookmarks::ID_BOOKMARK_20);

    sep1=new FXMenuSeparator(bookmarksmenu);
    sep1->setTarget(bookmarks);
    sep1->setSelector(Bookmarks::ID_ANYBOOKMARKS);
    new FXMenuCommand(bookmarksmenu,_("&Clear bookmarks"),clrbookicon,bookmarks,Bookmarks::ID_CLEAR);
    bookmarksmenutitle=new FXMenuTitle(menubar,_("&Bookmarks"),NULL,bookmarksmenu);

    // View menu
    viewmenu=new FXMenuPane(this);
    new FXMenuCheck(viewmenu,_("&Tool&bar"),toolbar,FXWindow::ID_TOGGLESHOWN);
	new FXMenuCheck(viewmenu,_("&Location bar"),locationbar,FXWindow::ID_TOGGLESHOWN);
    new FXMenuCheck(viewmenu,_("&Status bar"),this,XFileExplorer::ID_TOGGLE_STATUS);
    new FXMenuSeparator(viewmenu);
    new FXMenuRadio(viewmenu,_("&One panel\tCtrl-F1"),this,XFileExplorer::ID_SHOW_ONE_PANEL);
    new FXMenuRadio(viewmenu,_("T&ree and panel\tCtrl-F2"),this,XFileExplorer::ID_SHOW_TREE_PANEL);
    new FXMenuRadio(viewmenu,_("Two &panels\tCtrl-F3"),this,XFileExplorer::ID_SHOW_TWO_PANELS);
    new FXMenuRadio(viewmenu,_("Tr&ee and two panels\tCtrl-F4"),this,XFileExplorer::ID_SHOW_TREE_TWO_PANELS);
    new FXMenuSeparator(viewmenu);
    new FXMenuCheck(viewmenu,_("&Hidden folders\tCtrl-F5"),dirpanel,DirPanel::ID_TOGGLE_HIDDEN);
    viewmenutitle=new FXMenuTitle(menubar,_("&View"),NULL,viewmenu);

    // Left View Menu Pane
    lpanelmenu=new FXMenuPane(this);
    new FXMenuCommand(lpanelmenu,_("&Filter..."),filtericon,lpanel,FilePanel::ID_FILTER);
    new FXMenuCheck(lpanelmenu,_("&Hidden files"),lpanel->list,FileList::ID_TOGGLE_HIDDEN);
    new FXMenuCheck(lpanelmenu,_("&Thumbnails"),lpanel->list,FileList::ID_TOGGLE_THUMBNAILS);
    new FXMenuSeparator(lpanelmenu);
    new FXMenuRadio(lpanelmenu,_("&Big icons"),lpanel->list,FXIconList::ID_SHOW_BIG_ICONS);
    new FXMenuRadio(lpanelmenu,_("&Small icons"),lpanel->list,FXIconList::ID_SHOW_MINI_ICONS);
    new FXMenuRadio(lpanelmenu,_("F&ull file list"),lpanel->list,FXIconList::ID_SHOW_DETAILS);
    new FXMenuSeparator(lpanelmenu);
    new FXMenuRadio(lpanelmenu,_("&Rows"),lpanel->list,FileList::ID_ARRANGE_BY_ROWS);
    new FXMenuRadio(lpanelmenu,_("&Columns"),lpanel->list,FileList::ID_ARRANGE_BY_COLUMNS);
    new FXMenuSeparator(lpanelmenu);
    new FXMenuRadio(lpanelmenu,_("&Name"),lpanel->list,FileList::ID_SORT_BY_NAME);
    new FXMenuRadio(lpanelmenu,_("Si&ze"),lpanel->list,FileList::ID_SORT_BY_SIZE);
    new FXMenuRadio(lpanelmenu,_("T&ype"),lpanel->list,FileList::ID_SORT_BY_TYPE);
    new FXMenuRadio(lpanelmenu,_("E&xtension"),lpanel->list,FileList::ID_SORT_BY_EXT);
    new FXMenuRadio(lpanelmenu,_("Ti&me"),lpanel->list,FileList::ID_SORT_BY_TIME);
    new FXMenuSeparator(lpanelmenu);
  	new FXMenuCheck(lpanelmenu,_("I&gnore case"),lpanel->list,FileList::ID_SORT_CASE);
  	new FXMenuCheck(lpanelmenu,_("&Directories first"),lpanel->list,FileList::ID_DIRS_FIRST);
    lpanelmenutitle=new FXMenuTitle(menubar,_("&Left panel"),NULL,lpanelmenu);

    // Right View Menu Pane
    rpanelmenu=new FXMenuPane(this);
    new FXMenuCommand(rpanelmenu,_("&Filter"),filtericon,rpanel,FilePanel::ID_FILTER);
    new FXMenuCheck(rpanelmenu,_("&Hidden files"),rpanel->list,FileList::ID_TOGGLE_HIDDEN);
    new FXMenuCheck(rpanelmenu,_("&Thumbnails"),rpanel->list,FileList::ID_TOGGLE_THUMBNAILS);
    new FXMenuSeparator(rpanelmenu);
    new FXMenuRadio(rpanelmenu,_("&Big icons"),rpanel->list,FXIconList::ID_SHOW_BIG_ICONS);
    new FXMenuRadio(rpanelmenu,_("&Small icons"),rpanel->list,FXIconList::ID_SHOW_MINI_ICONS);
    new FXMenuRadio(rpanelmenu,_("F&ull file list"),rpanel->list,FXIconList::ID_SHOW_DETAILS);
    new FXMenuSeparator(rpanelmenu);
    new FXMenuRadio(rpanelmenu,_("&Rows"),rpanel->list,FileList::ID_ARRANGE_BY_ROWS);
    new FXMenuRadio(rpanelmenu,_("&Columns"),rpanel->list,FileList::ID_ARRANGE_BY_COLUMNS);
    new FXMenuSeparator(rpanelmenu);
    new FXMenuRadio(rpanelmenu,_("&Name"),rpanel->list,FileList::ID_SORT_BY_NAME);
    new FXMenuRadio(rpanelmenu,_("Si&ze"),rpanel->list,FileList::ID_SORT_BY_SIZE);
    new FXMenuRadio(rpanelmenu,_("T&ype"),rpanel->list,FileList::ID_SORT_BY_TYPE);
    new FXMenuRadio(rpanelmenu,_("E&xtension"),rpanel->list,FileList::ID_SORT_BY_EXT);
    new FXMenuRadio(rpanelmenu,_("Ti&me"),rpanel->list,FileList::ID_SORT_BY_TIME);
    new FXMenuSeparator(rpanelmenu);
  	new FXMenuCheck(rpanelmenu,_("I&gnore case"),rpanel->list,FileList::ID_SORT_CASE);
  	new FXMenuCheck(rpanelmenu,_("&Directories first"),rpanel->list,FileList::ID_DIRS_FIRST);
    rpanelmenutitle=new FXMenuTitle(menubar,_("&Right panel"),NULL,rpanelmenu);


	// Tools menu
	toolsmenu=new FXMenuPane(this);
    new FXMenuCommand(toolsmenu,_("New &window\tF3"),minixfeicon,this,XFileExplorer::ID_NEW_WIN);
    new FXMenuCommand(toolsmenu,_("New &root window\tShift-F3"),minixferooticon,this,XFileExplorer::ID_SU);
    new FXMenuSeparator(toolsmenu);
    new FXMenuCommand(toolsmenu,_("E&xecute command...\tCtrl-E"),runicon,this,ID_RUN);
    new FXMenuCommand(toolsmenu,_("&Terminal\tCtrl-T"),minishellicon,this,XFileExplorer::ID_XTERM);
#if defined(linux)
	new FXMenuSeparator(toolsmenu);
    new FXMenuCommand(toolsmenu,_("&Mount\tCtrl-M"),maphosticon,lpanel->current,FilePanel::ID_MOUNT);
    new FXMenuCommand(toolsmenu,_("&Unmount\tCtrl-U"),unmaphosticon,lpanel->current,FilePanel::ID_UMOUNT);
#endif
	toolsmenutitle=new FXMenuTitle(menubar,_("&Tools"),NULL,toolsmenu);

	// Trash menu
	trashmenu=new FXMenuPane(this);
    new FXMenuCommand(trashmenu,_("&Go to trash\tCtrl-F8"),totrashicon,lpanel->current,FilePanel::ID_GO_TRASH);
    new FXMenuCommand(trashmenu,_("&Empty trash can\tCtrl-Del"),trash_fullicon,this,XFileExplorer::ID_EMPTY_TRASHCAN);
	trashmenutitle=new FXMenuTitle(menubar,_("T&rash"),NULL,trashmenu);

	// Help menu
    helpmenu=new FXMenuPane(this);
    new FXMenuCommand(helpmenu,_("&Help\tF1"),helpicon,this,ID_HELP);
    new FXMenuCommand(helpmenu,_("&About X File Explorer"),NULL,this,ID_ABOUT);
    helpmenutitle=new FXMenuTitle(menubar,_("&Help"),NULL,helpmenu);

  	// Install some other key accelerators for compatibility with Midnight Commander
	//getAccelTable()->addAccel(FXSEL(0,KEY_F3),lpanel->current,FXSEL(SEL_COMMAND,FilePanel::ID_VIEW));
	getAccelTable()->addAccel(FXSEL(0,KEY_F4),lpanel->current,FXSEL(SEL_COMMAND,FilePanel::ID_EDIT));
	getAccelTable()->addAccel(FXSEL(0,KEY_F6),lpanel->current,FXSEL(SEL_COMMAND,FilePanel::ID_FILE_MOVE));

    // Make a tool tip
    new FXToolTip(app,0);

}
    
// Save configuration when quitting
void XFileExplorer::saveConfig()
{
	// Get autosave flag
    FXbool auto_save_layout=getApp()->reg().readUnsignedEntry("OPTIONS","auto_save_layout",TRUE);

	if(auto_save_layout==TRUE)
    {
		getApp()->reg().writeUnsignedEntry("LEFT PANEL","name_size",lpanel->list->getHeaderSize(0));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","size_size",lpanel->list->getHeaderSize(1));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","type_size",lpanel->list->getHeaderSize(2));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","ext_size",lpanel->list->getHeaderSize(3));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","modd_size",lpanel->list->getHeaderSize(4));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","user_size",lpanel->list->getHeaderSize(5));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","grou_size",lpanel->list->getHeaderSize(6));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","attr_size",lpanel->list->getHeaderSize(7));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","liststyle",lpanel->list->getListStyle());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","hiddenfiles",lpanel->list->showHiddenFiles());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","showthumbnails",lpanel->list->showThumbnails());
        
		// Get and write sort function for left panel
		FXString sort_func;
		if (lpanel->list->getSortFunc()==lpanel->list->ascendingCase)
			sort_func="ascendingCase";
		if (lpanel->list->getSortFunc()==lpanel->list->ascendingCaseMix)
			sort_func="ascendingCaseMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingCase)
			sort_func="descendingCase";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingCaseMix)
			sort_func="descendingCaseMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascending)
			sort_func="ascending";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingMix)
			sort_func="ascendingMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descending)
			sort_func="descending";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingMix)
			sort_func="descendingMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingSize)
			sort_func="ascendingSize";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingSizeMix)
			sort_func="ascendingSizeMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingSize)
			sort_func="descendingSize";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingSizeMix)
			sort_func="descendingSizeMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingType)
			sort_func="ascendingType";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingTypeMix)
			sort_func="ascendingTypeMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingType)
			sort_func="descendingType";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingTypeMix)
			sort_func="descendingTypeMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingExt)
			sort_func="ascendingExt";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingExtMix)
			sort_func="ascendingExtMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingExt)
			sort_func="descendingExt";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingExtMix)
			sort_func="descendingExtMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingTime)
			sort_func="ascendingTime";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingTimeMix)
			sort_func="ascendingTimeMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingTime)
			sort_func="descendingTime";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingTimeMix)
			sort_func="descendingTimeMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingUser)
			sort_func="ascendingUser";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingUserMix)
			sort_func="ascendingUserMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingUser)
			sort_func="descendingUser";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingUserMix)
			sort_func="descendingUserMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingGroup)
			sort_func="ascendingGroup";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingGroupMix)
			sort_func="ascendingGroupMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingGroup)
			sort_func="descendingGroup";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingGroupMix)
			sort_func="descendingGroupMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingPerm)
			sort_func="ascendingPerm";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingPermMix)
			sort_func="ascendingPermMix";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingPerm)
			sort_func="descendingPerm";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingPermMix)
			sort_func="descendingPermMix";
		else
			sort_func="ascendingCase";
		getApp()->reg().writeStringEntry("LEFT PANEL","sort_func",sort_func.text());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","ignore_case",lpanel->list->getIgnoreCase());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","dirs_first",lpanel->list->getDirsFirst());

		getApp()->reg().writeUnsignedEntry("RIGHT PANEL","name_size",rpanel->list->getHeaderSize(0));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","size_size",rpanel->list->getHeaderSize(1));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","type_size",rpanel->list->getHeaderSize(2));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","ext_size",rpanel->list->getHeaderSize(3));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","modd_size",rpanel->list->getHeaderSize(4));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","user_size",rpanel->list->getHeaderSize(5));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","grou_size",rpanel->list->getHeaderSize(6));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","attr_size",rpanel->list->getHeaderSize(7));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","liststyle",rpanel->list->getListStyle());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","panel_width",(FXuint)rpanel_width);
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","panel_tree_width",(FXuint)rpanel_tree_width);
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","hiddenfiles",rpanel->list->showHiddenFiles());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","showthumbnails",rpanel->list->showThumbnails());

		// Get and write sort function for right panel
		if (rpanel->list->getSortFunc()==rpanel->list->ascendingCase)
			sort_func="ascendingCase";
		if (rpanel->list->getSortFunc()==rpanel->list->ascendingCaseMix)
			sort_func="ascendingCaseMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingCase)
			sort_func="descendingCase";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingCaseMix)
			sort_func="descendingCaseMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascending)
			sort_func="ascending";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingMix)
			sort_func="ascendingMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descending)
			sort_func="descending";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingMix)
			sort_func="descendingMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingSize)
			sort_func="ascendingSize";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingSizeMix)
			sort_func="ascendingSizeMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingSize)
			sort_func="descendingSize";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingSizeMix)
			sort_func="descendingSizeMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingType)
			sort_func="ascendingType";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingTypeMix)
			sort_func="ascendingTypeMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingType)
			sort_func="descendingType";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingTypeMix)
			sort_func="descendingTypeMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingExt)
			sort_func="ascendingExt";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingExtMix)
			sort_func="ascendingExtMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingExt)
			sort_func="descendingExt";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingExtMix)
			sort_func="descendingExtMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingTime)
			sort_func="ascendingTime";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingTimeMix)
			sort_func="ascendingTimeMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingTime)
			sort_func="descendingTime";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingTimeMix)
			sort_func="descendingTimeMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingUser)
			sort_func="ascendingUser";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingUserMix)
			sort_func="ascendingUserMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingUser)
			sort_func="descendingUser";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingUserMix)
			sort_func="descendingUserMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingGroup)
			sort_func="ascendingGroup";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingGroupMix)
			sort_func="ascendingGroupMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingGroup)
			sort_func="descendingGroup";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingGroupMix)
			sort_func="descendingGroupMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingPerm)
			sort_func="ascendingPerm";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingPermMix)
			sort_func="ascendingPermMix";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingPerm)
			sort_func="descendingPerm";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingPermMix)
			sort_func="descendingPermMix";
		else
			sort_func="ascendingCase";
		getApp()->reg().writeStringEntry("RIGHT PANEL","sort_func",sort_func.text());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","ignore_case",rpanel->list->getIgnoreCase());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","dirs_first",rpanel->list->getDirsFirst());

        // Global options
		getApp()->reg().writeUnsignedEntry("OPTIONS","width",(FXuint)getWidth());
        getApp()->reg().writeUnsignedEntry("OPTIONS","height",(FXuint)getHeight());
        getApp()->reg().writeIntEntry("OPTIONS","xpos",getX());
        getApp()->reg().writeIntEntry("OPTIONS","ypos",getY());
        getApp()->reg().writeUnsignedEntry("OPTIONS","toolbar",(FXuint)toolbar->shown());
		getApp()->reg().writeUnsignedEntry("OPTIONS","locationbar",(FXuint)locationbar->shown());
        getApp()->reg().writeUnsignedEntry("OPTIONS","status",(FXuint)lpanel->statusbar->shown());
        getApp()->reg().writeUnsignedEntry("OPTIONS","panel_view",(FXuint)panel_view);
        getApp()->reg().writeUnsignedEntry("OPTIONS","tree_width",(FXuint)dirpanel->getWidth());
        getApp()->reg().writeUnsignedEntry("OPTIONS","tree_hidden_dir",dirpanel->list->showHiddenFiles());
        getApp()->reg().writeUnsignedEntry("OPTIONS","single_click_diropen",single_click_diropen);
        getApp()->reg().writeUnsignedEntry("OPTIONS","single_click_fileopen",single_click_fileopen);


        FXString history="";
        for(int i=0;i<RunHistSize;i++)
        {
            history+=RunHistory[i];
            history+=":";
        }
        if(RunHistory)
            getApp()->reg().writeStringEntry("HISTORY","run",history.text());

        history="";
        for(int i=0;i<OpenNum;i++)
        {
            history+=OpenHistory[i];
            history+=":";
        }
        if(OpenNum)
            getApp()->reg().writeStringEntry("HISTORY","open",history.text());
    }
	getApp()->reg().write();
}

// Make application
void XFileExplorer::create()
{
    panel_view=getApp()->reg().readUnsignedEntry("OPTIONS","panel_view",TREE_PANEL);
    width=getApp()->reg().readUnsignedEntry("OPTIONS","width",600);
    height=getApp()->reg().readUnsignedEntry("OPTIONS","height",500);
    xpos=getApp()->reg().readIntEntry("OPTIONS","xpos",0);
    ypos=getApp()->reg().readIntEntry("OPTIONS","ypos",0);
    position(xpos,ypos,width,height);

    FXMainWindow::create();
	FXint window_width=getWidth();
    FXint dirpanel_width=getApp()->reg().readUnsignedEntry("OPTIONS","tree_width",200);
	dirpanel->setWidth(dirpanel_width);
    rpanel_width=getApp()->reg().readUnsignedEntry("RIGHT PANEL","panel_width",200);
    rpanel_tree_width=getApp()->reg().readUnsignedEntry("RIGHT PANEL","panel_tree_width",200);
	switch(panel_view)
	{
	case ONE_PANEL:
        //lpanel->hideLocation();
		rpanel->hide();
        dirpanel->hide();
		lpanel->setWidth(window_width-8);
		rpanel->setWidth(rpanel_width);
		// Handle drag corner 
		rpanel->showCorner(FALSE);
		lpanel->showCorner(TRUE);
		break;
	case TWO_PANELS:
        //lpanel->showLocation();
        //rpanel->showLocation();
		dirpanel->hide();
		lpanel->setWidth(window_width-8-rpanel_width);
		rpanel->setWidth(rpanel_width);
		// Handle drag corner 
		rpanel->showCorner(TRUE);
		lpanel->showCorner(FALSE);
		break;
	case TREE_PANEL:
        //lpanel->hideLocation();
		rpanel->hide();
		lpanel->setWidth(window_width-8-dirpanel_width);
		rpanel->setWidth(rpanel_tree_width);
		// Handle drag corner 
		rpanel->showCorner(FALSE);
		lpanel->showCorner(TRUE);
		break;
	case TREE_TWO_PANELS:
		//lpanel->showLocation();
		//rpanel->showLocation();
		lpanel->setWidth(window_width-12-dirpanel_width-rpanel_tree_width);
		rpanel->setWidth(rpanel_tree_width);
		// Handle drag corner 
		rpanel->showCorner(TRUE);
		lpanel->showCorner(FALSE);
		break;
	}

    if(!getApp()->reg().readUnsignedEntry("OPTIONS","toolbar",TRUE))
        toolbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    if(!getApp()->reg().readUnsignedEntry("OPTIONS","locationbar",TRUE))
        locationbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    if(!getApp()->reg().readUnsignedEntry("OPTIONS","status",TRUE))
        handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_TOGGLE_STATUS),NULL);

	// Wheel scrolling
    FXint wheellines=getApp()->reg().readUnsignedEntry("SETTINGS","wheellines",5);
	getApp()->setWheelLines(wheellines);
	
    // Open left or right panel in starting directory (if specified) or in current directory
    if (startdir=="")
        startdir=FXSystem::getCurrentDirectory();
    lpanel->list->setDirectory(startdir);
	lpanel->pathlink->setText(startdir);
    rpanel->list->setDirectory(startdir);
	rpanel->pathlink->setText(startdir);
	dirpanel->list->setDirectory(startdir,TRUE);
    
	// Set file panels list style
	liststyle=getApp()->reg().readUnsignedEntry("LEFT PANEL","liststyle",(FXuint)FXIconList::ID_SHOW_DETAILS);
	lpanel->list->setListStyle(liststyle|ICONLIST_AUTOSIZE);
    liststyle=getApp()->reg().readUnsignedEntry("RIGHT PANEL","liststyle",(FXuint)FXIconList::ID_SHOW_DETAILS);
    rpanel->list->setListStyle(liststyle|ICONLIST_AUTOSIZE);

	// Show or hide hidden files listed in panels
    FXbool hiddenfiles;
	hiddenfiles=getApp()->reg().readUnsignedEntry("LEFT PANEL","hiddenfiles",0);
    lpanel->list->showHiddenFiles(hiddenfiles);
    hiddenfiles=getApp()->reg().readUnsignedEntry("RIGHT PANEL","hiddenfiles",0);
    rpanel->list->showHiddenFiles(hiddenfiles);
	
	// Show or hide hidden directories listed in dirpanel
    FXbool tree_hidden_dir;
	tree_hidden_dir=getApp()->reg().readUnsignedEntry("OPTIONS","tree_hidden_dir",0);
    dirpanel->list->showHiddenFiles(tree_hidden_dir);

    // Display thumbnails or not
    FXbool showthumbnails;
	showthumbnails=getApp()->reg().readUnsignedEntry("LEFT PANEL","showthumbnails",0);
    lpanel->list->showThumbnails(showthumbnails);
    showthumbnails=getApp()->reg().readUnsignedEntry("RIGHT PANEL","showthumbnails",0);
    rpanel->list->showThumbnails(showthumbnails);
	
    // History
    FXString history=getApp()->reg().readStringEntry("HISTORY","run","");
   	int i;
    FXString histent;
    if(history != "")
    {
        for(i=0;;i++)
        {
            histent=history.section(':',i);
            if(::streq(histent.text(),""))
                break;
            strlcpy(RunHistory[i],histent.text(),histent.length()+1);
        }
        RunHistSize=i;
    }
    else
        RunHistSize=0;
    history=getApp()->reg().readStringEntry("HISTORY","open","");
    histent="";
    if(history != "")
    {
        for(i=0;;i++)
        {
            histent=history.section(':',i);
            if(::streq(histent.text(),""))
                break;
			strlcpy(OpenHistory[i],histent.text(),histent.length()+1);
        }
        OpenNum=i;
    }
    else
        OpenNum=0;

    getApp()->forceRefresh();

	// Running as root?
    FXbool root_warn=getApp()->reg().readUnsignedEntry("OPTIONS","root_warn",TRUE);
	if(getuid()==0 && root_warn)
        MessageBox::information(this,BOX_OK,_("Warning"),_("Running Xfe as root!"));

	// Show window
    show();

#if defined(linux)
	// Warning message if a mount point is down
	FXbool mount_warn=getApp()->reg().readUnsignedEntry("OPTIONS","mount_warn",TRUE);
	if (mount_warn)
	{
		FXint d;
		for (d=updevices->first(); d<updevices->size(); d=updevices->next(d))
		{
			if(::streq(updevices->data(d),"down"))
				MessageBox::warning(this,BOX_OK,_("Warning"),_("Mount point %s is not responding..."),updevices->key(d));
		}
	}
#endif

	int mask;
	FXString homelocation=getenv("HOME");
    if(homelocation=="")
        homelocation=ROOTDIR;

	// If no Xfe local configuration exists (i.e. at first call or after a purge of the configuration files),
	// copy the global xferc file to the local configuration directory, and read / write the registry
	FXString configpath=homelocation+PATHSEPSTRING LOCALPATH PATHSEPSTRING CONFIGNAME;
	if (!::exists(configpath))
	{
		// Create ~/.xfe directory if it doesn't exist	
		FXString configlocation=homelocation+PATHSEPSTRING LOCALPATH;
		if (!::exists(configlocation))
		{
			// Create the .xfe directory according to the umask
			mask=umask(0);
			umask(mask);
			FXint ret=::mkdir(configlocation.text(),511 & ~mask);
			if (ret==-1)
				MessageBox::error(this,BOX_OK,_("Error"),"Cannot create .xfe directory '%s': %s",configlocation.text(),strerror(errno));
		}
		
		// Copy the global xfrec file (three possible locations) to the local configuration file
		if (::exists("/usr/share/xfe/xferc"))
			FXFile::copy("/usr/share/xfe/xferc",configpath,FALSE);		
		else if (::exists("/usr/local/share/xfe/xferc"))
			FXFile::copy("/usr/local/share/xfe/xferc",configpath,FALSE);
		else if (::exists("/opt/local/share/xfe/xferc"))
			FXFile::copy("/opt/local/share/xfe/xferc",configpath,FALSE);

		// If nothing is found, display a file dialog to let the user choose the right place
		else
		{
			FileDialog browse(this,_("No global xferc file found! Please select a configuration file..."),0,0,0,600,400);

			const FXchar *patterns[]=
			{
				_("XFE configuration file"),     "*xferc*",NULL
			};
			browse.setFilename(ROOTDIR);
			browse.setPatternList(patterns);
			if(browse.execute())
			{
				FXString path=browse.getFilename();
				FXFile::copy(path,configpath,FALSE);
			}
		}

		// Read and write the registry
		getApp()->reg().read();
		getApp()->reg().write();
	}

    // Create trash can directory if it doesn't exist
	trashlocation=homelocation+PATHSEPSTRING+TRASHPATH;
	if (!::exists(trashlocation))
	{
		// Create the trash can directory according to the umask
		mask=umask(0);
		umask(mask);
		FXint ret=::mkdir(trashlocation.text(),511 & ~mask);
		if (ret==-1)
         	MessageBox::error(this,BOX_OK,_("Error"),"Cannot create trash can directory '%s': %s",trashlocation.text(),strerror(errno));
    		// And what to do after that?
	}

	// Eventually start iconic or maximized
	if (iconic)
		minimize();
	if (maximized)
		maximize();			
}

// Destructor
XFileExplorer::~XFileExplorer()
{
    delete menubar;
	delete locationbar;
	delete address;
	delete filemenu;
	delete toolsmenu;
	delete trashmenu;
	delete editmenu;
	delete bookmarksmenu;
	delete viewmenu;
	delete lpanelmenu;
	delete rpanelmenu;
	delete helpmenu;
	delete filemenutitle;
	delete trashmenutitle;
	delete editmenutitle;
	delete bookmarksmenutitle;
	delete viewmenutitle;
	delete lpanelmenutitle;
	delete rpanelmenutitle;
	delete helpmenutitle;
    delete toolbar;
    delete dirpanel;
    delete lpanel;
    delete rpanel;
    delete bookmarks;	
	delete btntrash;
	delete btndel;
	delete btnbackhist;
	delete btnforwardhist;
}


// If Tab pressed, cycle through the panels 
long XFileExplorer::onKeyPress(FXObject* sender,FXSelector sel,void* ptr)
{
    FXEvent* event=(FXEvent*)ptr;
	FXint current;
    
	// Tab was pressed : cycle through the panels
	if(event->code==KEY_Tab)
    {
		if (dirpanel->shown())
		{
			if (dirpanel->hasFocus())
			{
				lpanel->list->setFocus();
				current=lpanel->list->getCurrentItem();
				if (current<0)
					current=0;
				lpanel->list->setCurrentItem(current);
				lpanel->list->selectItem(current);
			}
			else if ( (rpanel->shown()) && (lpanel->list->hasFocus()) )
			{
				rpanel->list->setFocus();
				current=rpanel->list->getCurrentItem();
				if (current<0)
					current=0;
				rpanel->list->setCurrentItem(current);
				rpanel->list->selectItem(current);			
			}			
			else
			{
				dirpanel->list->setFocus();
				current=lpanel->list->getCurrentItem();
				if (current<0)
					current=0;				
				lpanel->list->deselectItem(current);
			}
		}
		else if (rpanel->shown())
		{
			if (lpanel->current==rpanel)
			{
				lpanel->focus();
				current=lpanel->list->getCurrentItem();
				if (current<0)
					current=0;
				lpanel->list->selectItem(current);
			}
			else
			{
				rpanel->focus();
				current=rpanel->list->getCurrentItem();
				if (current<0)
					current=0;
				rpanel->list->selectItem(current);
			}
		}
		return 1;
	}

	// Shift-F10 was pressed : open popup menu
	else if(event->state&SHIFTMASK && event->code==KEY_F10)
    {
		lpanel->current->handle(sender,FXSEL(SEL_COMMAND,FilePanel::ID_MENU),NULL);
        return 1;
    }

	// Any other key was pressed : handle the pressed key in the usual way
    else
	{
		if(FXTopWindow::onKeyPress(sender,sel,ptr))
        	return 1;
		else
			return 0;
	}

}


// Handle quitting
long XFileExplorer::onQuit(FXObject*,FXSelector,void*)
{
    FXbool confirm_quit=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_quit",TRUE);
	if(confirm_quit)
        if(BOX_CLICKED_CANCEL==MessageBox::question(this,BOX_QUIT_CANCEL,_("Quitting Xfe"),_("Do you really want to quit Xfe?")))
            return 1;
    saveConfig();
	while(waitpid(-1,NULL,WNOHANG)>0);
	getApp()->exit(0);
    return 1;
}


// Directory back
long  XFileExplorer::onCmdDirBack(FXObject*,FXSelector s,void* p)
{
	StringList *backhist, *forwardhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	backhist=lpanel->current->list->backhist;
	forwardhist=lpanel->current->list->forwardhist;

	// Get the previous directory
	item=backhist->getFirst();
	if (item)
		pathname=backhist->getString(item);
	
	// Update the history
	backhist->removeFirstItem();
	forwardhist->insertFirstItem(lpanel->current->list->getDirectory());
	
	// Go to to the previous directory
	lpanel->current->list->setDirectory(pathname,FALSE);
	lpanel->current->updatePathLinker();
	dirpanel->list->setDirectory(pathname,TRUE);

    return 1;
}


// Update directory back
long  XFileExplorer::onUpdDirBack(FXObject* sender, FXSelector sel, void* ptr)
{
	StringList *backhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	backhist=lpanel->current->list->backhist;
	
	// Gray out the button if no item in history 
	FXint num=backhist->getNumItems();
	if (backhist->getNumItems()==0)
		sender->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),ptr);	
	else
		sender->handle(this,FXSEL(SEL_COMMAND,ID_ENABLE),ptr);

    return 1;
}


// Directory forward
long  XFileExplorer::onCmdDirForward(FXObject*,FXSelector s,void* p)
{
	StringList *backhist, *forwardhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	backhist=lpanel->current->list->backhist;
	forwardhist=lpanel->current->list->forwardhist;

	// Get the next directory
	item=forwardhist->getFirst();
	if (item)
		pathname=forwardhist->getString(item);
	
	// Update the history
	forwardhist->removeFirstItem();
	backhist->insertFirstItem(lpanel->current->list->getDirectory());
	
	// Go to to the next directory
	lpanel->current->list->setDirectory(pathname,FALSE);
	lpanel->current->updatePathLinker();
	dirpanel->list->setDirectory(pathname,TRUE);

    return 1;
}


// Update directory forward
long  XFileExplorer::onUpdDirForward(FXObject* sender, FXSelector sel, void* ptr)
{
	StringList *forwardhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	forwardhist=lpanel->current->list->forwardhist;
	
	// Gray out the button if no item in history 
	FXint num=forwardhist->getNumItems();
	if (forwardhist->getNumItems()==0)
		sender->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),ptr);
	else
		sender->handle(this,FXSEL(SEL_COMMAND,ID_ENABLE),ptr);

    return 1;
}


// Directory back history
long  XFileExplorer::onCmdDirBackHist(FXObject *sender,FXSelector sel,void* ptr)
{
	StringList *backhist, *forwardhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	backhist=lpanel->current->list->backhist;
	forwardhist=lpanel->current->list->forwardhist;

	// Get all string items and display them in a list box
	FXint num=backhist->getNumItems();
	if (num>0)
	{
		FXString *dirs= new FXString[num];
		FXString strlist="";
		
		// Get string items
		item=backhist->getFirst();
		FXint nb=0;
		for(FXint i=0; i<=num-1; i++)
		{
			if (item)
			{
				FXString str=backhist->getString(item);
				FXbool flag=TRUE;
				for (FXint j=0; j<=nb-1; j++)
				{
					if (str==dirs[j])
					{
						flag=FALSE;
						break;
					}
				}
				if (flag)
				{
					dirs[nb]=str;
					strlist=strlist+str+"\n";
					nb++;
				}
				item=backhist->getNext(item);
			}
		}
		
		// Display list box
		FXint pos=DirHistBox::box(btnbackhist,DECOR_NONE,strlist,this->getX()+40,this->getY()+60);
		
		// If an item was selected
		if (pos!=-1)
		{
		
			// Update back history
			if (pos==num-1)
				backhist->removeAllItems();
			else
			{
				item=backhist->getItemAtPos(pos+1);
				backhist->removeAllItemsBefore(item);
			}
			
			// Update forward history
			forwardhist->insertFirstItem(lpanel->current->list->getDirectory());
			if (pos>0)
			{
				for (FXint i=0; i<=pos-1; i++)
					forwardhist->insertFirstItem(dirs[i]);
			}
	
			// Go to to the selected directory
			pathname=dirs[pos];
			lpanel->current->list->setDirectory(pathname,FALSE);
			lpanel->current->updatePathLinker();
			dirpanel->list->setDirectory(pathname,TRUE);
		}
		delete[]dirs;
	}

    return 1;
}


// Update directory back
long  XFileExplorer::onUpdDirBackHist(FXObject* sender, FXSelector sel, void* ptr)
{
	StringList *backhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	backhist=lpanel->current->list->backhist;
	
	// Gray out the button if no item in history 
	FXint num=backhist->getNumItems();
	if (backhist->getNumItems()==0)
		sender->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),ptr);	
	else
		sender->handle(this,FXSEL(SEL_COMMAND,ID_ENABLE),ptr);

    return 1;
}


// Directory forward history
long  XFileExplorer::onCmdDirForwardHist(FXObject *sender,FXSelector sel,void* ptr)
{
	StringList *backhist, *forwardhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	backhist=lpanel->current->list->backhist;
	forwardhist=lpanel->current->list->forwardhist;

	// Get all string items and display them in a list box
	FXint num=forwardhist->getNumItems();
	if (num>0)
	{
		FXString *dirs= new FXString[num];
		FXString strlist="";
		
		// Get string items
		item=forwardhist->getFirst();
		FXint nb=0;
		for(FXint i=0; i<=num-1; i++)
		{
			if (item)
			{
				FXString str=forwardhist->getString(item);
				FXbool flag=TRUE;
				for (FXint j=0; j<=nb-1; j++)
				{
					if (str==dirs[j])
					{
						flag=FALSE;
						break;
					}
				}
				if (flag)
				{
					dirs[nb]=str;
					strlist=strlist+str+"\n";
					nb++;
				}
				item=forwardhist->getNext(item);
			}
		}
		
		// Display list box
		FXint pos=DirHistBox::box(btnforwardhist,DECOR_NONE,strlist,this->getX()+85,this->getY()+60);
		
		// If an item was selected
		if (pos!=-1)
		{
			// Update forward history
			if (pos==num-1)
				forwardhist->removeAllItems();
			else
			{
				item=forwardhist->getItemAtPos(pos+1);
				forwardhist->removeAllItemsBefore(item);
			}
			
			// Update back history
			backhist->insertFirstItem(lpanel->current->list->getDirectory());
			if (pos>0)
			{
				for (FXint i=0; i<=pos-1; i++)
					backhist->insertFirstItem(dirs[i]);
			}
	
			// Go to to the selected directory
			pathname=dirs[pos];
			lpanel->current->list->setDirectory(pathname,FALSE);
			lpanel->current->updatePathLinker();
			dirpanel->list->setDirectory(pathname,TRUE);
		}
		delete[]dirs;
	}

    return 1;
}


// Update directory forward
long  XFileExplorer::onUpdDirForwardHist(FXObject* sender, FXSelector sel, void* ptr)
{
	StringList *forwardhist;
	StringItem *item;
	FXString pathname;

	// Get the filelist history
	forwardhist=lpanel->current->list->forwardhist;
	
	// Gray out the button if no item in history 
	FXint num=forwardhist->getNumItems();
	if (forwardhist->getNumItems()==0)
		sender->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),ptr);
	else
		sender->handle(this,FXSEL(SEL_COMMAND,ID_ENABLE),ptr);

    return 1;
}


// Handle bookmarks
long  XFileExplorer::onCmdBookmark(FXObject*, FXSelector s, void* p)
{
    if(FXSELID(s) == ID_ADD_BOOKMARK)
        bookmarks->appendBookmark(lpanel->current->list->getDirectory());
	
	// Handle location address fields
	else if(FXSELID(s) == ID_BOOKMARK)
	{
        lpanel->current->list->setDirectory((FXchar*)p);
		lpanel->current->updatePathLinker();
        dirpanel->list->setDirectory((FXchar*)p,TRUE);
        FXString item;
		FXint i=0;
		FXint count=address->getNumItems();
		if(!count)
		{
			count++;
			address->insertItem(0,address->getText());
		}
        while(i < count)
		{
        	item=address->getItem(i++);
        	if(::streq((char*)p,(const char*)&item[0]))
			{
				i--;
				break;
			}
        }
        if(i==count) 
			address->insertItem(0,(FXchar*)p);
    }
    return 1;
}


// Goto location entered into the text field;
long XFileExplorer::onCmdGotoLocation(FXObject*,FXSelector,void*)
{
	FXString path=FXPath::absolute(lpanel->current->list->getDirectory(),address->getText());
	FXString dir=path;

	// Go up to the lowest directory which still exists
	while(!FXPath::isTopDirectory(dir) && !::isDirectory(dir))
    	dir=FXPath::upLevel(dir);

	// Move to this existing directory
	lpanel->current->list->setDirectory(dir);
	lpanel->current->updatePathLinker();
	dirpanel->list->setDirectory(dir,TRUE);
	address->setText(path);
	
	return 1;
}


// Clear location bar
long XFileExplorer::onCmdClearLocation(FXObject*,FXSelector,void*)
{
  address->setText(FXString::null);
  return 1;
}

// Restart the application when required
long  XFileExplorer::onCmdRestart(FXObject*,FXSelector,void*)
{
    saveConfig();

    if(fork() == 0)
        execvp("xfe",args);
    else
        _exit(0);
    return 1;
}

// Start a new Xfe session
long  XFileExplorer::onCmdNewWindow(FXObject*,FXSelector,void*)
{
	system("xfe &");
    return 1;
}

// Run Terminal
long  XFileExplorer::onCmdXTerm(FXObject*,FXSelector,void*)
{
    FXString xterm=getApp()->reg().readStringEntry("PROGS","xterm","xterm -sb");
	chdir(lpanel->current->list->getDirectory().text());
    FXString cmd=xterm;
    cmd += " &";
    system(cmd.text());
    lpanel->current->list->setFocus();
    return 1;
}


// Help menu
long XFileExplorer::onCmdHelp(FXObject*,FXSelector,void*)
{
    // Display help window
	TextWindow *helpwindow=new TextWindow(this,_("Help"),35,90);			

    // Set text font
	FXString fontspec;
	fontspec=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
	if(!fontspec.empty())
	{
    	FXFont* font=new FXFont(getApp(),fontspec);
        helpwindow->setFont(font);
	}

	helpwindow->setText(helptext);
	helpwindow->execute(PLACEMENT_CURSOR);
	delete helpwindow;
    lpanel->current->list->setFocus();
    return 1;
}

// About menu
long XFileExplorer::onCmdAbout(FXObject*,FXSelector,void*)
{
    FXString msg=_("X File Explorer Version ");
	msg = msg + VERSION + _("\n\nCopyright (C) 2002-2007 Roland Baudin (roland65@free.fr)\n\nBased on X WinCommander by Maxim Baranov\n");
    MessageBox about(this,_("About X File Explorer"),msg.text(),xfeicon,BOX_OK|DECOR_TITLE|DECOR_BORDER);
    about.execute(PLACEMENT_OWNER);
    lpanel->current->list->setFocus();
    return 1;
}


// Handle file association (called by Properties.cc)
long XFileExplorer::onCmdFileAssoc(FXObject*,FXSelector s,void *p)
{
	char **str=(char**)p;
    char* ext=str[0];
    char* cmd=str[1];

	// ext=extension, cmd=associated command
	// replace : to allow immediate association in Xfe
    FileDict *associations=lpanel->list->getAssociations();
	associations->replace(ext,cmd);
    associations=rpanel->list->getAssociations();
    associations->replace(ext,cmd);

    return 1;
}


// FilePanel and DirPanel refresh
long XFileExplorer::onCmdRefresh(FXObject*,FXSelector,void*)
{
	getApp()->beginWaitCursor();
#if defined(linux)
	dirpanel->list->onMtdevicesRefresh(0,0,0);
	dirpanel->list->onUpdevicesRefresh(0,0,0);
#endif
	lpanel->current->onRefresh(0,0,0);
	dirpanel->list->onRefresh(0,0,0);
	getApp()->endWaitCursor();
	return 1;
}


// Update file location
long XFileExplorer::onUpdFileLocation(FXObject* sender,FXSelector,void*)
{
	static FXString prevdir=FXString::null;
	FXString currentdir=lpanel->current->list->getDirectory();
	if (currentdir != prevdir)
	{
		address->setText(currentdir);
		prevdir=currentdir;
	}
	return 1;
}


// Switch between the two possible panel views
long XFileExplorer::onCmdShowPanels(FXObject* sender,FXSelector sel,void* ptr)
{
	// Get directory tree and window widths
	FXint dirpanel_width=dirpanel->getWidth();
	FXint window_width=getWidth();

    switch(FXSELID(sel))
    {
    case ID_SHOW_ONE_PANEL:
		panel_view=ONE_PANEL;
		//lpanel->hideLocation();
		lpanel->setWidth(window_width-8);
		rpanel->setWidth(rpanel_width);
		if (dirpanel->shown())
    		dirpanel->handle(sender,FXSEL(SEL_COMMAND,DirPanel::ID_TOGGLE_TREE),ptr);
		if (rpanel->shown())
			rpanel->handle(sender,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),ptr);	
		// Handle drag corner 
		rpanel->showCorner(FALSE);
		lpanel->showCorner(TRUE);
        break;

	case ID_SHOW_TWO_PANELS:
		panel_view=TWO_PANELS;
		//lpanel->showLocation();
		//rpanel->showLocation();
		lpanel->setWidth(window_width-8-rpanel_width);
		rpanel->setWidth(rpanel_width);
		if (dirpanel->shown())
    		dirpanel->handle(sender,FXSEL(SEL_COMMAND,DirPanel::ID_TOGGLE_TREE),ptr);
		if (!rpanel->shown())
			rpanel->handle(sender,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),ptr);	
		// Handle drag corner 
		rpanel->showCorner(TRUE);
		lpanel->showCorner(FALSE);
        break;
    
	case ID_SHOW_TREE_PANEL:
		panel_view=TREE_PANEL;
		//lpanel->hideLocation();
		lpanel->setWidth(window_width-8-dirpanel_width);
		rpanel->setWidth(rpanel_tree_width);
		if (!dirpanel->shown())
    		dirpanel->handle(sender,FXSEL(SEL_COMMAND,DirPanel::ID_TOGGLE_TREE),ptr);
		if (rpanel->shown())
			rpanel->handle(sender,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),ptr);	
		// Handle drag corner 
		rpanel->showCorner(FALSE);
		lpanel->showCorner(TRUE);
		break;
    
	case ID_SHOW_TREE_TWO_PANELS:
		panel_view=TREE_TWO_PANELS;
		//lpanel->showLocation();
		//rpanel->showLocation();
		lpanel->setWidth(window_width-12-dirpanel_width-rpanel_tree_width);
		rpanel->setWidth(rpanel_tree_width);
		if (!dirpanel->shown())
    		dirpanel->handle(sender,FXSEL(SEL_COMMAND,DirPanel::ID_TOGGLE_TREE),ptr);
		if (!rpanel->shown())
			rpanel->handle(sender,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),ptr);	
		// Handle drag corner 
		lpanel->showCorner(FALSE);
		rpanel->showCorner(TRUE);
        break;
    }
	return 1;
}


// Update sender
long XFileExplorer::onUpdShowPanels(FXObject* sender,FXSelector sel,void* ptr)
{
	FXuint msg=FXWindow::ID_UNCHECK;
    switch(FXSELID(sel))
    {
    case ID_SHOW_ONE_PANEL:
		if (!dirpanel->shown() && !rpanel->shown())
		{
			//lpanel->hideLocation();
            msg = FXWindow::ID_CHECK;		
			rpanel_width=rpanel->getWidth();
        	if(rpanelmenutitle->shown())
        	{
				lpanel->focus();
            	rpanelmenutitle->hide();
            	lpanelmenutitle->setText(_("&Panel"));
				lpanel->show();
				lpanel->repaint();
				lpanel->focus();
        	}
		}
        break;
    
	case ID_SHOW_TWO_PANELS:
		if (!dirpanel->shown() && rpanel->shown())
		{
			//lpanel->showLocation();
			//rpanel->showLocation();
            msg=FXWindow::ID_CHECK;
			rpanel_width=rpanel->getWidth();
        	if(!rpanelmenutitle->shown())
        	{
            	rpanelmenutitle->show();
            	rpanelmenutitle->setText(_("&Right panel"));
            	lpanelmenutitle->setText(_("&Left panel"));
				lpanel->repaint();
				lpanel->focus();
        	}
		}
        break;
    
	case ID_SHOW_TREE_PANEL:
 		if (dirpanel->shown() && !rpanel->shown())
		{
			//lpanel->hideLocation();
           	msg=FXWindow::ID_CHECK;		
			rpanel_tree_width=rpanel->getWidth();
        	if(rpanelmenutitle->shown())
        	{
				lpanel->focus();
            	rpanelmenutitle->hide();
            	lpanelmenutitle->setText(_("&Panel"));
				lpanel->repaint();
				lpanel->focus();
				
       	 	}
		}
        break;
    
	case ID_SHOW_TREE_TWO_PANELS:
 		if (dirpanel->shown() && rpanel->shown())
		{
			//lpanel->showLocation();
			//rpanel->showLocation();
            msg = FXWindow::ID_CHECK;
			rpanel_tree_width=rpanel->getWidth();
        	if(!rpanelmenutitle->shown())
        	{
           	 	rpanelmenutitle->show();
            	rpanelmenutitle->setText(_("&Right panel"));
            	lpanelmenutitle->setText(_("&Left panel"));
				lpanel->repaint();
				lpanel->focus();
        	}
		}
        break;
    }
    sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);

    return 1;
}


// Preferences
long XFileExplorer::onCmdPrefs(FXObject*,FXSelector s,void *p)
{
    PreferencesBox *prefs=new PreferencesBox(this,listbackcolor,listforecolor,highlightcolor);
    prefs->execute(PLACEMENT_SCREEN);
    delete prefs;
    lpanel->current->list->setFocus();
    return 1;
}


long XFileExplorer::onCmdToggleStatus(FXObject*,FXSelector s,void *p)
{
    dirpanel->statusbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    lpanel->statusbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    rpanel->statusbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    return 1;
}


long XFileExplorer::onUpdToggleStatus(FXObject *o,FXSelector s,void *p)
{
    FXMenuCheck *cmd =(FXMenuCheck*)o;
    if(lpanel->statusbar->shown())
        cmd->setCheck(TRUE);
    else
        cmd->setCheck(FALSE);
    return 1;
}


// Run shell command or X program
long XFileExplorer::onCmdRun(FXObject*,FXSelector,void*)
{
    int i;
    chdir(lpanel->current->list->getDirectory().text());
    HistInputDialog* dialog;
    FXString command="";
    dialog=new HistInputDialog(this,command,_("Execute the command :"),_("Execute command"),"", NULL,1, _("Console mode"));
    for(int i=0;i<RunHistSize;i++)
        dialog->appendItem(RunHistory[i]);
    dialog->CursorEnd();
    if(dialog->execute())
    {
        command=dialog->getText();
        if(command != "")
        {
			// Execute command in command window
			if (dialog->getOption())
			{
    			// Make and show command window
				CommandWindow *cmdwin=new CommandWindow(getApp(),_("Command log"),command,30,80);			
				cmdwin->create();
				
				// The CommandWindow object will delete itself when closed!
			}
			
			// Execute silently in background
			else
			{
				command+=" &";
				system(command.text());
			}
        }
		// Update history list
		RunHistSize=dialog->getHistorySize();
        RunHistSize++;
        command=dialog->getText();
        if(RunHistSize>RUN_HIST_SIZE)
            RunHistSize=RUN_HIST_SIZE;
        for(i=0;i<RunHistSize-1;i++)
            if(::streq(RunHistory[i],command.text()))
                break;
        if(i==RunHistSize-1)
        {
            strlcpy(RunHistory[0],command.text(),command.length()+1);
            for(i=1;i<RunHistSize;i++)
                strlcpy(RunHistory[i],dialog->getHistoryItem(i-1).text(),dialog->getHistoryItem(i-1).length()+1);
        }
        else
            RunHistSize--;
    }
    delete dialog;
    lpanel->current->list->setFocus();
    return 1;
}


// Run an Xfe as root
long XFileExplorer::onCmdSu(FXObject*,FXSelector,void*)
{
	// Wait cursor
	getApp()->beginWaitCursor();

	// Use su -c to launch xfe as root
	chdir(lpanel->current->list->getDirectory().text());
	FXString command = "xterm -title ";
	FXString title = _("Enter the root password :");
	FXString sucmd = SUCMD;
	command += "'" + title + "'" + sucmd + "&";
	FXint ret=system(command.text());
	if (ret!=0)
	{
        MessageBox::error(getApp(),BOX_OK,_("Error"),_("An error has occurred! \nPlease note that the root mode requires a working xterm installed on your system."));
		getApp()->endWaitCursor();
		return 0;
	}
 	// Wait cursor
	getApp()->endWaitCursor();
    return 1;
}


// Empty trash can
long XFileExplorer::onCmdEmptyTrashcan(FXObject*,FXSelector sel,void* ptr)
{
    // Confirmation message
	FXString message=_("Do you really want to empty the trash can?\n\nAll items will be definitively lost!");
    MessageBox box(this,_("Empty trash can"),message,trash_full_bigicon,BOX_OK_CANCEL|DECOR_TITLE|DECOR_BORDER);
 	if(box.execute(PLACEMENT_CURSOR) != BOX_CLICKED_OK)
    	return 0;

	// Wait cursor
	getApp()->beginWaitCursor();

	// Delete trash can folder	
   	File* f=new File(this,_("File delete"),DELETE);
   	f->create();
	f->remove(trashlocation);
	delete f;
	
	// Re-create the trash can directory
	if (!::exists(trashlocation))
	{
		FXint ret=::mkdir(trashlocation.text(),0755);
		if (ret==-1)
         	MessageBox::error(this,BOX_OK,_("Error"),"Cannot create trash can directory '%s': %s",trashlocation.text(),strerror(errno));
	}
 
 	// Wait cursor
	getApp()->endWaitCursor();
	
	onCmdRefresh(0,0,0);
	
	return 1;
}

// File trash
long XFileExplorer::onCmdFileTrash(FXObject* o,FXSelector sel,void* ptr)
{
	lpanel->current->handle(o,FXSEL(SEL_COMMAND,FilePanel::ID_FILE_TRASH),ptr);	
	return 1;
}


// File delete
long XFileExplorer::onCmdFileDelete(FXObject* o,FXSelector sel,void* ptr)
{
	lpanel->current->handle(o,FXSEL(SEL_COMMAND,FilePanel::ID_FILE_DELETE),ptr);
	return 1;
}


// Update the empty trash can and trash menus
long XFileExplorer::onUpdEmptyTrashcan(FXObject* o,FXSelector,void* ptr)
{

	FXbool use_trash_can=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_can",TRUE);
	if (use_trash_can)
	{
		// Update the empty trash can menu
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);

		// Update the trash menu title
		helpmenutitle->setText("");
		trashmenutitle->setText(_("&Trash"));
		trashmenutitle->show();
		helpmenutitle->setText(_("&Help"));
	}
	else
	{
		// Update the empty trash can menu
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);

		// Update the trash menu title
		trashmenutitle->hide();
		trashmenutitle->setText("");
		helpmenutitle->setText("");
		helpmenutitle->setText(_("&Help"));
	}

    return 1;
}


// Update the file delete menu item
long XFileExplorer::onUpdFileDelete(FXObject* o,FXSelector,void*)
{
	FXbool use_trash_can=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_can",TRUE);
	FXbool use_trash_bypass=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_bypass",FALSE);
	if (!use_trash_can | use_trash_bypass)
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
	return 1;
}


// Update the move to trash menu item
long XFileExplorer::onUpdFileTrash(FXObject* o,FXSelector,void*)
{
	FXbool use_trash_can=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_can",TRUE);
	if (use_trash_can)
	{
		// Update the hot keys
		btntrash->addHotKey(KEY_Delete);
		btntrash->addHotKey(KEY_F8);
		
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	}
	else
	{
		// Update the hot keys
		btndel->addHotKey(KEY_Delete);
		btndel->addHotKey(KEY_F8);
		
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
	}
   return 1;
}


// Copy/Move/Rename/Symlink File(s) 
long XFileExplorer::onCmdFileMan(FXObject*,FXSelector sel,void* ptr)
{
	FXbool ret;
	
	
    FXString command, message, title, target;
	File *f=NULL;
	FXbool dirman=FALSE;

    lpanel->current->list->setFocus();

	FXbool ask_before_copy=getApp()->reg().readUnsignedEntry("OPTIONS","ask_before_copy",TRUE);
	
	// Extract target directory, number of sources and sources names
	FXString str=(char*)ptr;

	FXString targetdir=str.section('\n',0);
	int num=FXUIntVal(str.section('\n',1));
	FXString src=str.after('\n',2);

    FXIcon *icon=NULL;
    chdir(targetdir.text());
    
	// No selected files
	if(num==0)
        return 0;
		
	// We were called from DirPanel::onCmdDirMan
	if (num==-1)
	{
		dirman=TRUE;
		num=1;
	}
		
	// Name and directory of the first source file
	FXString source=src.section('\n',0);
	FXString name=FXPath::name(source);
	FXString dir=FXPath::directory(source);

	// Initialise target name	
	if (targetdir!=ROOTDIR)
		target=targetdir+PATHSEPSTRING;
	else
		target=targetdir;

    // Configure the command, title, message, etc.
	if(FXSELID(sel)==ID_FILE_COPY)
    {
        command="copy";
        title=_("Copy");
        icon=copy_bigicon;
        if(num==1)
        {
            message=_("Copy ");
            message+=source;
		}
        else
            message=_("Copy ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_RENAME)
    {
        command="rename";
        title=_("Rename");
        icon=move_bigicon;
        if(num==1)
        {
            message=_("Rename ");
			message+=name;
            target=name;
			title=_("Rename");
        }
        else
			return 0;
    }
	if(FXSELID(sel)==ID_FILE_COPYTO)
    {
        command="copy";
        title=_("Copy to");
        icon=copy_bigicon;
        if(num==1)
        {
            message=_("Copy ");
            message+=source;
		}
        else
            message=_("Copy ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_MOVE)
    {
        command="move";
        title=_("Move");
        icon=move_bigicon;
        if(num==1)
        {
            message=_("Move ");
            message+=source;
            title=_("Move");
        }
        else
            message=_("Move ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_CUT)
    {
        command="move";
        title=_("Move");
        icon=move_bigicon;
        if(num==1)
        {
            message=_("Move ");
            message+=source;
            title=_("Move");
        }
        else
            message=_("Move ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_SYMLINK)
    {
        command="symlink";
        title=_("Symlink");
        icon=link_bigicon;
        if(num==1)
        {
            message=_("Symlink ");
            message+=source;
        }
        else
            message=_("Symlink ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
	
    // File operation dialog, if needed
	if(ask_before_copy || source==target ||  FXSELID(sel)==ID_FILE_COPYTO || FXSELID(sel)==ID_FILE_MOVE ||  FXSELID(sel)==ID_FILE_RENAME || FXSELID(sel)==ID_FILE_SYMLINK)
	{    	
		InputDialog* dialog;
		dialog=new InputDialog(this,target,message,title,_("To:"),icon);
		dialog->CursorEnd();
		int rc=1;
		rc=dialog->execute(PLACEMENT_CURSOR);
		target=dialog->getText();
		delete dialog;
		if (!rc)
			return 0;
	}
	
	// Update target and target parent directory
	target=::filePath(target);
	if (!::isDirectory(target))
		targetdir=FXPath::directory(target);
	else
		targetdir=target;	

    // Target directory not writable
    if(!::isWritable(targetdir))
    {
        MessageBox::error(this,BOX_OK_SU,_("Error"), _("Can't write to %s : Permission denied"), targetdir.text());
        return 0;
    }

	// Multiple sources and non existent destination
	if (num>1 & !::exists(target))
	{
        MessageBox::error(this,BOX_OK,_("Error"),_("Folder %s does'nt exist"),target.text());
        return 0;
	}
		
	// Multiple sources and target is a file
	if (num>1 & ::isFile(target))
	{ 			
        MessageBox::error(this,BOX_OK,_("Error"),_("%s is not a folder"),target.text());
        return 0;
	}

	// Target is a directory and is not writable
    if(::isDirectory(target) & !::isWritable(target))
    {
        MessageBox::error(this,BOX_OK_SU,_("Error"),_("Can't write to %s : Permission denied"), target.text());
        return 0;
    }
	
	// Target is a file and its parent directory is not writable
	if (::isFile(target) & !::isWritable(targetdir))
	{
        MessageBox::error(this,BOX_OK_SU,_("Error"),_("Can't write to %s : Permission denied"),targetdir.text());
        return 0;
	}

	// Target parent directory doesn't exist
	if (!::exists(targetdir))
	{
		MessageBox::error(this,BOX_OK,_("Error"),_("Folder %s does'nt exist"),targetdir.text());
        return 0;
	}
		
	// Target parent directory is not a directory
	if (!::isDirectory(targetdir))
	{
		MessageBox::error(this,BOX_OK,_("Error"),_("%s is not a folder"),targetdir.text());
        return 0;
	}
		
	// One source
    if(num==1)
	{
		// An empty source file name corresponds to the ".." file
		// Don't perform any file operation on it!
		if (source=="")
			return 0;
		
		// Wait cursor
		getApp()->beginWaitCursor();

		// File object
        if(command=="copy")
        {
			f=new File(this,_("File copy"),COPY);
        	f->create();
			ret=f->copy(source,target);
			
			// An error has occurred
			if (ret==0 && !f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,BOX_OK,_("Error"),_("An error has occurred during the copy file operation!"));
			}
					
			// If action is cancelled in progress dialog
			if (f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,BOX_OK,_("Error"),_("Copy file operation cancelled!"));
			}
        }
        else if(command=="rename")
        {
			f=new File(this,_("File rename"),RENAME);
        	f->create();
			f->rename(source,target);
        }
        else if(command=="move")
        {
			f=new File(this,_("File move"),MOVE);
        	f->create();
			ret=f->move(source,target);

			// An error has occurred
			if (ret==0 && !f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,BOX_OK,_("Error"),_("An error has occurred during the move file operation!"));
			}
					
			// If action is cancelled in progress dialog
			if (f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,BOX_OK,_("Error"),_("Move file operation cancelled!"));
			}
        }
        else if(command=="symlink")
        {
			f=new File(this,_("Symlink"),SYMLINK);
        	f->create();
			f->symlink(source,target);
		}
       	else
           	exit(-1);
									
		getApp()->endWaitCursor();
		delete f;

		// We were called from DirPanel::onCmdDirMan => set directory to the new one in DirList and FileList
		if (dirman)
		{
			((XFileExplorer*) mainWindow)->dirpanel->list->setDirectory(target,TRUE);
			lpanel->current->list->setDirectory(target);
			lpanel->current->updatePathLinker();
		}
	}
	
	// Multiple sources
	// Note : rename and symlink are not used in this case!
    else if(num>1)
    {
		// Wait cursor
		getApp()->beginWaitCursor();

		// File object
        if (command=="copy")
			f=new File(this,_("File copy"),COPY);
		else if (command=="move")
			f=new File(this,_("File move"),MOVE);
		f->create();
			
		// Loop on the multiple files
		for(int i=0;i<num;i++)
        {
			// Individual source file
			source=src.section('\n',i);

			// An empty file name corresponds to the ".." file (why?)
			// Don't perform any file operation on it! 
			if (source!="")
			{
            	if(command=="copy")
				{
					ret=f->copy(source,target);
					
					// An error has occurred
					if (ret==0 && !f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,BOX_OK,_("Error"),_("An error has occurred during the copy file operation!"));
						break;
					}
					
					// If action is cancelled in progress dialog
					if (f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,BOX_OK,_("Error"),_("Copy file operation cancelled!"));
						break;
					}
				}
            	else if(command=="move")
            	{
					ret=f->move(source,target);
				
					// An error has occurred
					if (ret==0 && !f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,BOX_OK,_("Error"),_("An error has occurred during the move file operation!"));
						break;
					}
					
					// If action is cancelled in progress dialog
					if (f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,BOX_OK,_("Error"),_("Move file operation cancelled!"));
						break;
					}
           	 	}
            	else
                	exit(-1);
			}
		}
		
		getApp()->endWaitCursor();		
		delete f;
	}	
	
	// Force panel refresh
	lpanel->current->onRefresh(0,0,0);
    return 1;
}
