#ifndef DIRPANEL_H
#define DIRPANEL_H
#include "DirList.h"
#include "Properties.h"


class DirPanel : public FXVerticalFrame
{
    FXDECLARE(DirPanel)
    friend class XFileExplorer;
	friend class FilePanel;
	friend class PathLinker;
	friend class PreferencesBox;
protected:
	DirList	*list;
	FXPacker *statusbar;
    FXLabel	*status;
	FXString homelocation;
	FXString trashlocation;

public:
DirPanel(FXComposite *p,FXColor listbackcolor=FXRGB(255,255,255),FXColor listforecolor=FXRGB(0,0,0),FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
    DirPanel()
    {}
    virtual void create();
    ~DirPanel();
    enum {
        ID_DIR_PANEL=FXVerticalFrame::ID_LAST,
		ID_EXPANDTREE,
		ID_TOGGLE_HIDDEN,
		ID_COLLAPSEDIR,
		ID_COLLAPSETREE,
		ID_PROPERTIES,
		ID_ARCHIVE,
		ID_DIR_COPY,
		ID_DIR_COPYTO,
		ID_DIR_MOVE,
		ID_DIR_RENAME,
		ID_DIR_SYMLINK,
		ID_DIR_DELETE,
		ID_DIR_TRASH,
		ID_NEW_DIR,
		ID_XTERM,
		ID_COPY_CLP,
		ID_CUT_CLP,
		ID_PASTE_CLP,
        ID_TOGGLE_TREE,
		ID_TITLE,
		ID_DIRSIZE_REFRESH,
#if defined(linux)
        ID_MOUNT,
        ID_UMOUNT,
#endif
        ID_LAST,
    	};
	long exploreUp(DirItem *item, const DirItem *rootitem, const FXint task);
	long exploreDown(DirItem *item, const DirItem *rootitem, const FXint task);
public:
	long onCmdToggleHidden(FXObject*,FXSelector,void*);
	long onUpdToggleHidden(FXObject* sender,FXSelector,void*);
	long onPopupMenu(FXObject*,FXSelector,void*);
	long onExpandTree(FXObject*,FXSelector,void*);
	long onCollapseTree(FXObject*,FXSelector,void*);
	long onCmdProperties(FXObject*,FXSelector,void*);
	long onCmdAddToArch(FXObject*,FXSelector,void*);
	long onCmdDirMan(FXObject*,FXSelector,void*);
	long onCmdDirDelete(FXObject*,FXSelector,void*);
	long onCmdDirTrash(FXObject*,FXSelector,void*);
	long onCmdNewDir(FXObject*,FXSelector,void*);
	long onCmdXTerm(FXObject*,FXSelector,void*);
	long onCmdClp(FXObject*,FXSelector,void*);
	long onCmdPaste(FXObject*,FXSelector,void*);
	long onUpdPaste(FXObject*,FXSelector,void*);
	long onCmdDirectory(FXObject*,FXSelector,void*);
	long onCmdToggleTree(FXObject*,FXSelector sel,void*);
	long onCmdDirsizeRefresh(FXObject*,FXSelector,void*);
	long onUpdToggleTree(FXObject*,FXSelector,void*);
	long onUpdMount(FXObject*,FXSelector,void*);
	long onUpdUnmount(FXObject*,FXSelector,void*);
	long onUpdMenu(FXObject*,FXSelector,void*);
	long onUpdDirTrash(FXObject*,FXSelector,void*);
	long onUpdDirDelete(FXObject*,FXSelector,void*);
	long onUpdTitle(FXObject*,FXSelector,void*);
	long onUpdStatus(FXObject*,FXSelector,void*);
	long onExpand(FXObject*,FXSelector,void*);
#if defined(linux)
	long onCmdMount(FXObject*,FXSelector sel,void*);
#endif
};
#endif
