#ifndef COMMANDWINDOW_H
#define COMMANDWINDOW_H


class CommandWindow : public FXDialogBox
{
    FXDECLARE(CommandWindow)
protected:

    FXint         pid;                 // Proccess ID of child (valid if busy).
    FXint         pipes[2];            // Pipes to communicate with child process.
    FXChore      *wchore;		       // Chore to watch process.
    FXText       *text;

    FXString command;                  // Command string
	FXbool killed;                     // True if the cancel button was pressed
	FXbool closed;                     // True if the closed button was pressed

private:
    CommandWindow()
    {}
    CommandWindow(const CommandWindow&);
public:
    enum{
        ID_CLOSE=FXDialogBox::ID_LAST,
        ID_WATCHPROCESS,
        ID_KILLPROCESS,
        ID_LAST
    };
public:
    long onCmdKillProcess(FXObject*,FXSelector,void*);
    long onUpdKillProcess(FXObject*,FXSelector,void*);
    long onWatchProcess(FXObject*,FXSelector,void*);
	long onUpdClose(FXObject* sender,FXSelector,void*);
    virtual void create();
    virtual ~CommandWindow();
    FXint execCmd(FXString);
    CommandWindow(FXWindow *owner, const FXString& name,  FXString strcmd, FXint nblines, FXint nbcols);
    CommandWindow(FXApp *a, const FXString& name,  FXString strcmd, FXint nblines, FXint nbcols);
	long CommandWindow::onCmdClose(FXObject*,FXSelector,void*);
	void CommandWindow::setText(const FXchar*);
	void CommandWindow::appendText(const FXchar* str);
	void CommandWindow::scrollToLastLine(void);
	FXint CommandWindow::getLength(void);
};

#endif
