#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include <fox/fx.h>
#include <fox/fxkeys.h>
#include <fox/FXPNGIcon.h>

#include "FileList.h"
#include "FileDict.h"
#include "DirListBox.h"
#include "Preferences.h"
#include "FilePanel.h"
#include "XFileExplorer.h"
#include "InputDialog.h"
#include "HistInputDialog.h"
#include "OverwriteBox.h"
#include "DirPanel.h"
#include "icons.h"
#include "File.h"
#include "MessageBox.h"
#include "TextWindow.h"
#include "CommandWindow.h"
#include "help.h"

#ifndef OPEN_WITH_HIST_SIZE
#define OPEN_WITH_HIST_SIZE 30
#endif

#define LOCATION_BAR_LENGTH 70
#define LOCATION_BAR_HEIGHT 6

// Maximum length of a file name
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

// Minimum width of a file or directory panel
#define MIN_PANEL_WIDTH 100

// Global variables
extern char** args;
extern FXString startdir;
extern FXbool confirm_quit;
extern FXbool warn_if_root;
extern FXbool confirm_del;
extern FXbool confirm_overwrite;
extern FXbool ask_before_copy;

FXString xterm;
FXString cfm;
FXString editor;
FXString viewer;
FXString homelocation;
FXString clipboard="";
char OpenHistory[OPEN_WITH_HIST_SIZE][100];
int OpenNum;

FXuint liststyle;
FXuint width;
FXuint height;


// Helper function to draw a toolbar separator
void toolbarSeparator(FXHorizontalFrame* tb)
{
#define SEP_SPACE	10
#define SEP_HEIGHT	15
    new FXFrame(tb,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,SEP_SPACE,20);
    new FXVerticalSeparator(tb,LAYOUT_SIDE_TOP|LAYOUT_CENTER_Y|SEPARATOR_GROOVE|LAYOUT_FIX_HEIGHT,0,0,0,SEP_HEIGHT);
    new FXFrame(tb,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,SEP_SPACE,20);
}

// This function is taken from the FXSplitter class
// and hacked to set a minimum splitter width when moving splitter to right
// It replaces the normal function...
void FXSplitter::moveHSplit(FXint pos)
{
    register FXint smin,smax;
    register FXuint hints;
    FXASSERT(window);
    hints=window->getLayoutHints();
    if(options&SPLITTER_REVERSED)
    {
        smin=barsize;
        smax=window->getX()+window->getWidth();
        if((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smax-=window->getDefaultWidth();
    }
    else
    {
        smin=window->getX();
        smax=width-barsize;
        if((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smin+=window->getDefaultWidth();
    }
	// !!! Hack to limit the width to a minimum value !!!
	smax=smax-MIN_PANEL_WIDTH;
    split=pos;
    if(split<smin)
        split=smin;
    if(split>smax)
        split=smax;
}


// Map
FXDEFMAP(XFileExplorer) XFileExplorerMap[]={
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_TOGGLE_STATUS,XFileExplorer::onCmdToggleStatus),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RUN,XFileExplorer::onCmdRun),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SELECT_ALL,XFileExplorer::onCmdSelect),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_DESELECT_ALL,XFileExplorer::onCmdSelect),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SELECT_INVERSE,XFileExplorer::onCmdSelect),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_COPY,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_RENAME,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_MOVE,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_CUT,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_SLINK,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_QUIT,XFileExplorer::onQuit),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_HELP,XFileExplorer::onCmdHelp),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_ABOUT,XFileExplorer::onCmdAbout),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_XTERM,XFileExplorer::onCmdXTerm),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_CFM,XFileExplorer::onCmdCfm),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_AUTO_SAVE,XFileExplorer::onCmdAutoSave),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_ASSOC,XFileExplorer::onCmdFileAssoc),
									 FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_CLEAR_LOCATION,XFileExplorer::onCmdClearLocation),
									 FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_GOTO_LOCATION,XFileExplorer::onCmdGotoLocation),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_MENU,XFileExplorer::onCmdMenu),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_PREFS,XFileExplorer::onCmdPrefs),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RELOAD_PREFS,XFileExplorer::onCmdReloadPrefs),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_BIG_ICONS,XFileExplorer::onCmdShow),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_MINI_ICONS,XFileExplorer::onCmdShow),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_DETAILS,XFileExplorer::onCmdShow),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_TOGGLE_HIDDEN,XFileExplorer::onCmdToggleHidden),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_ONE_PANEL,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TWO_PANELS,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TREE_PANEL,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TREE_TWO_PANELS,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RESTART,XFileExplorer::onCmdRestart),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_BOOKMARK,XFileExplorer::onCmdBookmark),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_ADD_BOOKMARK,XFileExplorer::onCmdBookmark),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_EXTRACT,XFileExplorer::onCmdExtract),
            						 FXMAPFUNC(SEL_KEYPRESS,0,XFileExplorer::onTabPress),
#if defined(linux)
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RPM_INSTALL,XFileExplorer::onCmdRpmInstall),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RPM_UNINSTALL,XFileExplorer::onCmdRpmUninstall),
#endif
                                     FXMAPFUNC(SEL_CLOSE,0,XFileExplorer::onQuit),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_TOGGLE_STATUS,XFileExplorer::onUpdToggleStatus),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_BIG_ICONS,XFileExplorer::onUpdShow),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_MINI_ICONS,XFileExplorer::onUpdShow),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_DETAILS,XFileExplorer::onUpdShow),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_TOGGLE_HIDDEN,XFileExplorer::onUpdToggleHidden),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_ONE_PANEL,XFileExplorer::onUpdShowPanels),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TWO_PANELS,XFileExplorer::onUpdShowPanels),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TREE_PANEL,XFileExplorer::onUpdShowPanels),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TREE_TWO_PANELS,XFileExplorer::onUpdShowPanels),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_GOTO_LOCATION,XFileExplorer::onUpdFileLocation),
                                 };


// Object implementation
FXIMPLEMENT(XFileExplorer,FXMainWindow,XFileExplorerMap,ARRAYNUMBER(XFileExplorerMap))


// Make some windows
XFileExplorer::XFileExplorer(FXApp *app,char *title,FXIcon *bigicon,FXIcon *miniicon):
        FXMainWindow(app,title,bigicon,miniicon,DECOR_ALL,2,2,600,480, 2,2)
{
    FXHotKey hotkey;

    bookmarks = new FXRecentFiles("bookmarks",this,ID_BOOKMARK);

	// Create some icons
	FXIcon *homeicon=new FXPNGIcon(app,home);
	FXIcon *dirupicon=new FXPNGIcon(app,dirup);
    FXIcon *quiticon=new FXPNGIcon(app,mini_stop);
	FXIcon *reloadicon=new FXPNGIcon(app,reload);
	FXIcon *largeicon=new FXPNGIcon(app,bigicons);
	FXIcon *smallicon=new FXPNGIcon(app,smallicons);
	FXIcon *detailicon=new FXPNGIcon(app,details);
	FXIcon *showhiddenicon=new FXPNGIcon(app,showhidden);
	FXIcon *hidehiddenicon=new FXPNGIcon(app,hidehidden);
	FXIcon *onepanelicon=new FXPNGIcon(app,onepanel);
	FXIcon *twopanelsicon=new FXPNGIcon(app,twopanels);
	FXIcon *xtermicon=new FXPNGIcon(app,shell);
	FXIcon *treeonepanelicon=new FXPNGIcon(app,treeonepanel);
	FXIcon *treetwopanelsicon=new FXPNGIcon(app,treetwopanels);
	FXIcon *setbookicon=new FXPNGIcon(app,setbook);
	FXIcon *clrbookicon=new FXPNGIcon(app,clrbook);
	FXIcon *runicon=new FXPNGIcon(app,run);
	FXIcon *selallicon=new FXPNGIcon(app,selall);
	FXIcon *invselicon=new FXPNGIcon(app,invsel);
	FXIcon *deselicon=new FXPNGIcon(app,desel);
	FXIcon *prefsicon=new FXPNGIcon(app,prefs);
	FXIcon *helpicon=new FXPNGIcon(app,help);

	// These icons are already declared in the class header		
    archicon=new FXPNGIcon(app,arch);
    attricon=new FXPNGIcon(app,attrib);
    newfoldericon=new FXPNGIcon(app,newfolder);
    minidocicon=new FXPNGIcon(app,minidoc);
	delicon=new FXPNGIcon(app,filedelete);	
	copyicon=new FXPNGIcon(app,copy_clp);	
	cuticon=new FXPNGIcon(app,cut_clp);	
	pasteicon=new FXPNGIcon(app,paste_clp);	
	renameicon=new FXPNGIcon(app,renameit);
	moveicon=new FXPNGIcon(app,moveit);
	symlinkicon=new FXPNGIcon(app,minilink);
	mapicon=new FXPNGIcon(app,maphost);	
	unmapicon=new FXPNGIcon(app,unmaphost);	
	minixtermicon=new FXPNGIcon(app,minishell);
	minicfmicon=new FXPNGIcon(app,minimc);
	minirpmicon=new FXPNGIcon(app,minirpm);
  	locationicon=new FXPNGIcon(app,location);
  	entericon=new FXPNGIcon(app,enter);
	filtericon=new FXPNGIcon(app,filter);
	viewicon=new FXPNGIcon(app,fileview);
	editicon=new FXPNGIcon(app,filedit);

    // Menu bar
    FXHorizontalFrame* menuframe=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0, 0,0);
    menubar=new FXMenubar(menuframe,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

    // Separator
    new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);

    // Toolbar
    FXHorizontalFrame* toolbarcontainer=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0, 0,0);
    new FXToolbarTab(toolbarcontainer,NULL,0,FRAME_RAISED);
    toolbar=new FXHorizontalFrame(toolbarcontainer,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 4,4,2,2, 0,0);

    // Separator
	new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);

   	// Location bar
	FXHorizontalFrame* locationcontainer=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0, 0,0);
	new FXToolbarTab(locationcontainer,NULL,0,FRAME_RAISED);
	locationbar=new FXHorizontalFrame(locationcontainer,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 4,4,2,2, 0,0);

    // Main splitter
	FXSplitter* mainsplit=new FXSplitter(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);

    // Directory panel on the left (with minimum size)
    dirpanel=new DirPanel(mainsplit,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);

	// Sub splitter
    FXSplitter* subsplit=new FXSplitter(mainsplit,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);

    // File panels on the right (with minimum size) : remembers size of each field
	lpanel=new FilePanel("LEFT PANEL",subsplit,
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","name_size",200),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","size_size",60),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","type_size",100),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","modd_size",150),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","user_size",50),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","grou_size",50),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","attr_size",100),
					 LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);
    rpanel=new FilePanel("RIGHT PANEL",subsplit,
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","name_size",200),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","size_size",60),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","type_size",100),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","modd_size",150),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","user_size",50),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","grou_size",50),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","attr_size",100),
					 LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);
    lpanel->Next(rpanel);
    rpanel->Next(lpanel);
    lpanel->focus();

	// Read and set sort function for left panel
	FXString sort_func=getApp()->reg().readStringEntry("LEFT PANEL","sort_func","cmpFName");
    if (sort_func=="cmpFName")
		lpanel->list->setSortFunc(lpanel->list->cmpFName);        
	else if (sort_func=="cmpRName")
		lpanel->list->setSortFunc(lpanel->list->cmpRName);        
	else if (sort_func=="cmpFSize")
		lpanel->list->setSortFunc(lpanel->list->cmpFSize);        
	else if (sort_func=="cmpRSize")
		lpanel->list->setSortFunc(lpanel->list->cmpRSize);        
	else if (sort_func=="cmpFType")
		lpanel->list->setSortFunc(lpanel->list->cmpFType);        
	else if (sort_func=="cmpRType")
		lpanel->list->setSortFunc(lpanel->list->cmpRType);        
	else if (sort_func=="cmpFTime")
		lpanel->list->setSortFunc(lpanel->list->cmpFTime);        
	else if (sort_func=="cmpRTime")
		lpanel->list->setSortFunc(lpanel->list->cmpRTime);        
	else if (sort_func=="cmpFUser")
		lpanel->list->setSortFunc(lpanel->list->cmpFUser);        
	else if (sort_func=="cmpRUser")
		lpanel->list->setSortFunc(lpanel->list->cmpRUser);         
	else if (sort_func=="cmpFGroup")
		lpanel->list->setSortFunc(lpanel->list->cmpFGroup);        
	else if (sort_func=="cmpRGroup")
		lpanel->list->setSortFunc(lpanel->list->cmpRGroup);        

	// Read and set sort function for right panel
	sort_func=getApp()->reg().readStringEntry("RIGHT PANEL","sort_func","cmpFName");
    if (sort_func=="cmpFName")
		rpanel->list->setSortFunc(rpanel->list->cmpFName);        
	else if (sort_func=="cmpRName")
		rpanel->list->setSortFunc(rpanel->list->cmpRName);        
	else if (sort_func=="cmpFSize")
		rpanel->list->setSortFunc(rpanel->list->cmpFSize);        
	else if (sort_func=="cmpRSize")
		rpanel->list->setSortFunc(rpanel->list->cmpRSize);        
	else if (sort_func=="cmpFType")
		rpanel->list->setSortFunc(rpanel->list->cmpFType);        
	else if (sort_func=="cmpRType")
		rpanel->list->setSortFunc(rpanel->list->cmpRType);        
	else if (sort_func=="cmpFTime")
		rpanel->list->setSortFunc(rpanel->list->cmpFTime);        
	else if (sort_func=="cmpRTime")
		rpanel->list->setSortFunc(rpanel->list->cmpRTime);        
	else if (sort_func=="cmpFUser")
		rpanel->list->setSortFunc(rpanel->list->cmpFUser);        
	else if (sort_func=="cmpRUser")
		rpanel->list->setSortFunc(rpanel->list->cmpRUser);         
	else if (sort_func=="cmpFGroup")
		rpanel->list->setSortFunc(rpanel->list->cmpFGroup);        
	else if (sort_func=="cmpRGroup")
		rpanel->list->setSortFunc(rpanel->list->cmpRGroup);        

    FXButton *btn = NULL;
    FXToggleButton *tgbtn = NULL;

    // Spacer
    new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,5,20);

    // Add some toolbar buttons
    btn = new FXButton(toolbar,_("\tGo up (Backspace)"),dirupicon,lpanel->current,FilePanel::ID_DIRECTORY_UP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    btn->addHotKey(KEY_BackSpace);

    btn = new FXButton(toolbar,_("\tGo home (Ctrl-H)"),homeicon,lpanel->current,FilePanel::ID_GO_HOME,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey = (0004<<16) | KEY_h;
    btn->addHotKey(hotkey);

	toolbarSeparator(toolbar);

    btn = new FXButton(toolbar,_("\tExecute command (Ctrl-E)"),runicon,this,XFileExplorer::ID_RUN,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey = (0004<<16) | KEY_e;
    btn->addHotKey(hotkey);

    btn = new FXButton(toolbar,_("\tTerminal (Ctrl-T)"),xtermicon,this,XFileExplorer::ID_XTERM,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey = (0004<<16) | KEY_t;
    btn->addHotKey(hotkey);

    btn = new FXButton(toolbar,_("\tPanel refresh (Ctrl-R)"),reloadicon,lpanel,FilePanel::ID_REFRESH,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey = (0004<<16) | KEY_r;
    btn->addHotKey(hotkey);

	toolbarSeparator(toolbar);

    btn = new FXButton(toolbar,_("\tCreate new file (F2)"),minidocicon,lpanel->current,FilePanel::ID_NEW_FILE,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    btn->addHotKey(KEY_F2);

    btn = new FXButton(toolbar,_("\tCreate new folder (F7)"),newfoldericon,lpanel->current,FilePanel::ID_NEW_DIR,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    btn->addHotKey(KEY_F7);

	toolbarSeparator(toolbar);
	
    btn = new FXButton(toolbar,_("\tCopy selected files to clipboard (Ctrl-C, F5)"),copyicon,lpanel->current,FilePanel::ID_COPY_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (0004<<16) | KEY_c;
    btn->addHotKey(hotkey);
    btn->addHotKey(KEY_F5);

    btn = new FXButton(toolbar,_("\tCut selected files to clipboard (Ctrl-X)"),cuticon,lpanel->current,FilePanel::ID_CUT_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (0004<<16) | KEY_x;
    btn->addHotKey(hotkey);

    btn = new FXButton(toolbar,_("\tPaste from clipboard (Ctrl-V)"),pasteicon,lpanel->current,FilePanel::ID_PASTE_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (0004<<16) | KEY_v;
    btn->addHotKey(hotkey);

    btn = new FXButton(toolbar,_("\tDelete selected files (Del, F8)"),delicon,lpanel->current,FilePanel::ID_FILE_DEL,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = KEY_Delete;
    btn->addHotKey(hotkey);
    hotkey = (0004<<16) | KEY_Delete;  // Ctrl-Del : for compatibility with previous versions
    btn->addHotKey(hotkey);
    btn->addHotKey(KEY_F8);

    btn = new FXButton(toolbar,_("\tShow properties of selected files (F9)"),attricon,lpanel->current,FilePanel::ID_PROPERTIES,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    btn->addHotKey(KEY_F9);

#if defined(linux)
	toolbarSeparator(toolbar);

    // Mount and unmount buttons
    btn = new FXButton(toolbar,_("\tMount (Ctrl-M)"),mapicon,lpanel,FilePanel::ID_MOUNT,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey = (0004<<16) | KEY_m;
    btn->addHotKey(hotkey);

    btn = new FXButton(toolbar,_("\tUnmount (Ctrl-U)"),unmapicon,lpanel,FilePanel::ID_UMOUNT,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey = (0004<<16) | KEY_u;
    btn->addHotKey(hotkey);
#endif

	toolbarSeparator(toolbar);

	// Show tree and one panel
   	btn = new FXButton(toolbar,_("\tShow tree and one panel (Ctrl-F1)"),treeonepanelicon,this,XFileExplorer::ID_SHOW_TREE_PANEL,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (0004<<16) | KEY_F1;
   	btn->addHotKey(hotkey);

	// Show tree and two panels
   	btn = new FXButton(toolbar,_("\tShow tree and two panels (Ctrl-F2)"),treetwopanelsicon,this,XFileExplorer::ID_SHOW_TREE_TWO_PANELS,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (0004<<16) | KEY_F2;
   	btn->addHotKey(hotkey);

	// Show one panel
   	btn = new FXButton(toolbar,_("\tShow one panel (Ctrl-F3)"),onepanelicon,this,XFileExplorer::ID_SHOW_ONE_PANEL,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (0004<<16) | KEY_F3;
   	btn->addHotKey(hotkey);

	// Show two panels
   	btn = new FXButton(toolbar,_("\tShow two panels (Ctrl-F4)"),twopanelsicon,this,XFileExplorer::ID_SHOW_TWO_PANELS,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey = (0004<<16) | KEY_F4;
   	btn->addHotKey(hotkey);

	// Show or hide hidden files (button not shown at the moment!)   
   	tgbtn = new FXToggleButton(toolbar,_("\tHide hidden files (Ctrl-F5)"),_("\tShow hidden files (Ctrl-F5)"),hidehiddenicon,showhiddenicon,this,ID_TOGGLE_HIDDEN,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    tgbtn->hide();
	hotkey = (0004<<16) | KEY_F5;
   	tgbtn->addHotKey(hotkey);

	toolbarSeparator(toolbar);

    // Switch display modes
    new FXButton(toolbar,_("\tBig icons"),largeicon,this,ID_SHOW_BIG_ICONS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
    new FXButton(toolbar,_("\tBrief file list"),smallicon,this,ID_SHOW_MINI_ICONS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
    new FXButton(toolbar,_("\tFull file list"),detailicon,this,ID_SHOW_DETAILS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);

	toolbarSeparator(toolbar);

    // Quit button
    btn = new FXButton(toolbar,_("\tQuit (Ctrl-Q, F10)"),quiticon,this,XFileExplorer::ID_QUIT,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
    hotkey = (0004<<16) | KEY_q;
    btn->addHotKey(hotkey);
    btn->addHotKey(KEY_F10);

  	// Location bar
  	new FXLabel(locationbar,_("Location:"));
  	new FXButton(locationbar,_("\tClear Location bar\tClear Location bar."),locationicon,this,ID_CLEAR_LOCATION,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
  	address=new FXComboBox(locationbar,LOCATION_BAR_LENGTH,LOCATION_BAR_HEIGHT,this,ID_GOTO_LOCATION,TEXTFIELD_NORMAL|JUSTIFY_LEFT|LAYOUT_CENTER_Y);
 	new FXButton(locationbar,_("\tGo\tGo to location."),entericon,this,ID_GOTO_LOCATION,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);

    // Menus

    // File menu
    FXMenuPane* commenu=new FXMenuPane(this);
    new FXMenuCommand(commenu,_("New file...\tF2"),minidocicon,lpanel->current,FilePanel::ID_NEW_FILE);
    new FXMenuCommand(commenu,_("New folder...\tF7"),newfoldericon,lpanel->current,FilePanel::ID_NEW_DIR);
    new FXMenuCommand(commenu,_("Execute...\tCtrl-E"),runicon,this,ID_RUN);
    new FXMenuCommand(commenu,_("Go home\tCtrl-H"),homeicon,lpanel->current,FilePanel::ID_GO_HOME);
    new FXMenuCommand(commenu,_("Terminal\tCtrl-T"),minixtermicon,this,XFileExplorer::ID_XTERM);
    new FXMenuCommand(commenu,_("Console File Man.\tCtrl-K"),minicfmicon,this,XFileExplorer::ID_CFM);
    new FXMenuCommand(commenu,_("Refresh\tCtrl-R"),reloadicon,lpanel->current,FilePanel::ID_REFRESH);
    new FXMenuSeparator(commenu);
    new FXMenuCommand(commenu,_("Rename...\tCtrl-N"),renameicon,lpanel->current,FilePanel::ID_FILE_RENAME);
    new FXMenuCommand(commenu,_("Move...\tCtrl-D"),moveicon,lpanel->current,FilePanel::ID_FILE_MOVE);
    new FXMenuCommand(commenu,_("Symbolic link...\tCtrl-S"),symlinkicon,lpanel->current,FilePanel::ID_FILE_SLINK);
    new FXMenuCommand(commenu,_("Delete\tDel"),delicon,lpanel->current,FilePanel::ID_FILE_DEL);
    new FXMenuCommand(commenu,_("Properties...\tF9"),attricon,lpanel->current,FilePanel::ID_PROPERTIES);
    new FXMenuSeparator(commenu);
    new FXMenuCommand(commenu,_("Quit\tCtrl-Q"),quiticon,this,XFileExplorer::ID_QUIT);
    new FXMenuTitle(menubar,_("File"),NULL,commenu);

    // Edit menu
    FXMenuPane* editmenu=new FXMenuPane(this);
    new FXMenuCommand(editmenu,_("Copy\tCtrl-C"),copyicon,lpanel->current,FilePanel::ID_COPY_CLP);
    new FXMenuCommand(editmenu,_("Cut\tCtrl-X"),cuticon,lpanel->current,FilePanel::ID_CUT_CLP);
    new FXMenuCommand(editmenu,_("Paste\tCtrl-V"),pasteicon,lpanel->current,FilePanel::ID_PASTE_CLP);
    new FXMenuSeparator(editmenu);
    new FXMenuCommand(editmenu,_("Select all\tCtrl-A"),selallicon,this,ID_SELECT_ALL);
    new FXMenuCommand(editmenu,_("Deselect all\tCtrl-Z"),deselicon,this,ID_DESELECT_ALL);
    new FXMenuCommand(editmenu,_("Invert selection\tCtrl-I"),invselicon,this,ID_SELECT_INVERSE);
    new FXMenuSeparator(editmenu);
    new FXMenuCommand(editmenu,_("Preferences"),prefsicon,this,XFileExplorer::ID_PREFS);
    new FXMenuTitle(menubar,_("Edit"),NULL,editmenu);

    // Bookmarks menu
    FXMenuPane* bookmarksmenu=new FXMenuPane(this);
    new FXMenuCommand(bookmarksmenu,_("Add bookmark\tCtrl-B"),setbookicon,this,ID_ADD_BOOKMARK);
    FXMenuSeparator* sep1=new FXMenuSeparator(bookmarksmenu);
    sep1->setTarget(bookmarks);
    sep1->setSelector(FXRecentFiles::ID_ANYFILES);

    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_1);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_2);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_3);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_4);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_5);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_6);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_7);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_8);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_9);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,FXRecentFiles::ID_FILE_10);

    sep1=new FXMenuSeparator(bookmarksmenu);
    sep1->setTarget(bookmarks);
    sep1->setSelector(FXRecentFiles::ID_ANYFILES);
    new FXMenuCommand(bookmarksmenu,_("Clear bookmarks"),clrbookicon,bookmarks,FXRecentFiles::ID_CLEAR);
    new FXMenuTitle(menubar,_("Bookmarks"),NULL,bookmarksmenu);

    // View menu
    FXMenuPane* viewmenu=new FXMenuPane(this);
    new FXMenuCommand(viewmenu,_("Toolbar"),NULL,toolbar,FXWindow::ID_TOGGLESHOWN);
	new FXMenuCommand(viewmenu,_("Location bar"),NULL,locationbar,FXWindow::ID_TOGGLESHOWN);
    new FXMenuCommand(viewmenu,_("Status"),NULL,this,XFileExplorer::ID_TOGGLE_STATUS);
    new FXMenuCommand(viewmenu,_("Tree and one panel\tCtrl-F1"),NULL,this,XFileExplorer::ID_SHOW_TREE_PANEL);
    new FXMenuCommand(viewmenu,_("Tree and two panels\tCtrl-F2"),NULL,this,XFileExplorer::ID_SHOW_TREE_TWO_PANELS);
    new FXMenuCommand(viewmenu,_("One panel\tCtrl-F3"),NULL,this,XFileExplorer::ID_SHOW_ONE_PANEL);
    new FXMenuCommand(viewmenu,_("Two panels\tCtrl-F4"),NULL,this,XFileExplorer::ID_SHOW_TWO_PANELS);
    new FXMenuCommand(viewmenu,_("Hidden folders\tCtrl-F6"),NULL,dirpanel,DirPanel::ID_TOGGLE_HIDDEN);
    FXMenuCommand* autosave=new FXMenuCommand(viewmenu,_("Auto save layout"),NULL,this,XFileExplorer::ID_AUTO_SAVE);
    new FXMenuTitle(menubar,_("View"),NULL,viewmenu);

    // Left View Menu Pane
    leftviewmenu=new FXMenuPane(this);
    new FXMenuCommand(leftviewmenu,_("Filter..."),filtericon,lpanel,FilePanel::ID_FILTER);
    new FXMenuSeparator(leftviewmenu);
    new FXMenuCommand(leftviewmenu,_("Hidden files"),NULL,lpanel->list,FileList::ID_TOGGLE_HIDDEN);
    new FXMenuCommand(leftviewmenu,_("Full file list"),NULL,lpanel->list,FXIconList::ID_SHOW_DETAILS);
    new FXMenuCommand(leftviewmenu,_("Brief file list"),NULL,lpanel->list,FXIconList::ID_SHOW_MINI_ICONS);
    new FXMenuCommand(leftviewmenu,_("Big icons"),NULL,lpanel->list,FXIconList::ID_SHOW_BIG_ICONS);
    new FXMenuSeparator(leftviewmenu);
    new FXMenuCommand(leftviewmenu,_("Rows"),NULL,lpanel->list,FXIconList::ID_ARRANGE_BY_ROWS);
    new FXMenuCommand(leftviewmenu,_("Columns"),NULL,lpanel->list,FXIconList::ID_ARRANGE_BY_COLUMNS);
    new FXMenuSeparator(leftviewmenu);
    new FXMenuCommand(leftviewmenu,_("Name"),NULL,lpanel->list,FileList::ID_SORT_BY_NAME);
    new FXMenuCommand(leftviewmenu,_("Type"),NULL,lpanel->list,FileList::ID_SORT_BY_TYPE);
    new FXMenuCommand(leftviewmenu,_("Size"),NULL,lpanel->list,FileList::ID_SORT_BY_SIZE);
    new FXMenuCommand(leftviewmenu,_("Time"),NULL,lpanel->list,FileList::ID_SORT_BY_TIME);
    lmenutitle = new FXMenuTitle(menubar,_("Left panel"),NULL,leftviewmenu);

    // Right View Menu Pane
    rightviewmenu=new FXMenuPane(this);
    new FXMenuCommand(rightviewmenu,_("Filter"),filtericon,rpanel,FilePanel::ID_FILTER);
    new FXMenuSeparator(rightviewmenu);
    new FXMenuCommand(rightviewmenu,_("Hidden files"),NULL,rpanel->list,FileList::ID_TOGGLE_HIDDEN);
    new FXMenuCommand(rightviewmenu,_("Full file list"),NULL,rpanel->list,FXIconList::ID_SHOW_DETAILS);
    new FXMenuCommand(rightviewmenu,_("Brief file list"),NULL,rpanel->list,FXIconList::ID_SHOW_MINI_ICONS);
    new FXMenuCommand(rightviewmenu,_("Big icons"),NULL,rpanel->list,FXIconList::ID_SHOW_BIG_ICONS);
    new FXMenuSeparator(rightviewmenu);
    new FXMenuCommand(rightviewmenu,_("Rows"),NULL,rpanel->list,FXIconList::ID_ARRANGE_BY_ROWS);
    new FXMenuCommand(rightviewmenu,_("Columns"),NULL,rpanel->list,FXIconList::ID_ARRANGE_BY_COLUMNS);
    new FXMenuSeparator(rightviewmenu);
    new FXMenuCommand(rightviewmenu,_("Name"),NULL,rpanel->list,FileList::ID_SORT_BY_NAME);
    new FXMenuCommand(rightviewmenu,_("Type"),NULL,rpanel->list,FileList::ID_SORT_BY_TYPE);
    new FXMenuCommand(rightviewmenu,_("Size"),NULL,rpanel->list,FileList::ID_SORT_BY_SIZE);
    new FXMenuCommand(rightviewmenu,_("Time"),NULL,rpanel->list,FileList::ID_SORT_BY_TIME);
    rmenutitle = new FXMenuTitle(menubar,_("Right panel"),NULL,rightviewmenu);

    // Help menu
    FXMenuPane* helpmenu=new FXMenuPane(this);
    new FXMenuTitle(menubar,_("Help"),NULL,helpmenu);
    new FXMenuCommand(helpmenu,_("Help\tF1"),helpicon,this,ID_HELP);
    new FXMenuCommand(helpmenu,_("About X File Explorer"),NULL,this,ID_ABOUT);

  	// Install some other key accelerators for compatibility with Midnight Commander
	getAccelTable()->addAccel(MKUINT(KEY_F3,0),lpanel->current,MKUINT(FilePanel::ID_VIEW,SEL_COMMAND));
	getAccelTable()->addAccel(MKUINT(KEY_F4,0),lpanel->current,MKUINT(FilePanel::ID_EDIT,SEL_COMMAND));
	getAccelTable()->addAccel(MKUINT(KEY_F6,0),lpanel->current,MKUINT(FilePanel::ID_FILE_MOVE,SEL_COMMAND));

    // Make a tool tip
    new FXTooltip(app,0);
    
	// Get autosave flag
    auto_save_layout=getApp()->reg().readUnsignedEntry("OPTIONS","auto_save_layout",TRUE);
    if (auto_save_layout==TRUE)
		autosave->handle(this,MKUINT(FXWindow::ID_CHECK,SEL_COMMAND),NULL);
}

// Save configuration when quitting
void XFileExplorer::saveConfig()
{
    if(auto_save_layout==TRUE)
    {
		getApp()->reg().writeUnsignedEntry("LEFT PANEL","name_size",lpanel->list->getHeaderSize(0));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","size_size",lpanel->list->getHeaderSize(1));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","type_size",lpanel->list->getHeaderSize(2));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","modd_size",lpanel->list->getHeaderSize(3));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","user_size",lpanel->list->getHeaderSize(4));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","grou_size",lpanel->list->getHeaderSize(5));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","attr_size",lpanel->list->getHeaderSize(6));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","liststyle",lpanel->list->getListStyle());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","hiddenfiles",lpanel->list->showHiddenFiles());
        
		// Get and write sort function for left panel
		FXString sort_func;
		if (lpanel->list->getSortFunc()==lpanel->list->cmpFName)
			sort_func="cmpFName";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpRName)
			sort_func="cmpRName";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpFSize)
			sort_func="cmpFSize";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpRSize)
			sort_func="cmpRSize";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpFType)
			sort_func="cmpFType";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpRType)
			sort_func="cmpRType";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpFTime)
			sort_func="cmpFTime";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpRTime)
			sort_func="cmpRTime";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpFUser)
			sort_func="cmpFUser";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpRUser)
			sort_func="cmpRUser";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpFGroup)
			sort_func="cmpFGroup";
		else if (lpanel->list->getSortFunc()==lpanel->list->cmpRGroup)
			sort_func="cmpRGroup";
		else
			sort_func="cmpFName";
		getApp()->reg().writeStringEntry("LEFT PANEL","sort_func",sort_func.text());

		getApp()->reg().writeUnsignedEntry("RIGHT PANEL","name_size",rpanel->list->getHeaderSize(0));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","size_size",rpanel->list->getHeaderSize(1));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","type_size",rpanel->list->getHeaderSize(2));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","modd_size",rpanel->list->getHeaderSize(3));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","user_size",rpanel->list->getHeaderSize(4));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","grou_size",rpanel->list->getHeaderSize(5));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","attr_size",rpanel->list->getHeaderSize(6));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","liststyle",rpanel->list->getListStyle());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","panel_width",(FXuint)rpanel_width);
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","panel_tree_width",(FXuint)rpanel_tree_width);
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","hiddenfiles",rpanel->list->showHiddenFiles());

		// Get and write sort function for right panel
		if (rpanel->list->getSortFunc()==rpanel->list->cmpFName)
			sort_func="cmpFName";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpRName)
			sort_func="cmpRName";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpFSize)
			sort_func="cmpFSize";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpRSize)
			sort_func="cmpRSize";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpFType)
			sort_func="cmpFType";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpRType)
			sort_func="cmpRType";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpFTime)
			sort_func="cmpFTime";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpRTime)
			sort_func="cmpRTime";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpFUser)
			sort_func="cmpFUser";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpRUser)
			sort_func="cmpRUser";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpFGroup)
			sort_func="cmpFGroup";
		else if (rpanel->list->getSortFunc()==rpanel->list->cmpRGroup)
			sort_func="cmpRGroup";
		else
			sort_func="cmpFName";
		getApp()->reg().writeStringEntry("RIGHT PANEL","sort_func",sort_func.text());

        getApp()->reg().writeUnsignedEntry("OPTIONS","width",(FXuint)getWidth());
        getApp()->reg().writeUnsignedEntry("OPTIONS","height",(FXuint)getHeight());
        getApp()->reg().writeUnsignedEntry("OPTIONS","toolbar",(FXuint)toolbar->shown());
		getApp()->reg().writeUnsignedEntry("OPTIONS","locationbar",(FXuint)locationbar->shown());
        getApp()->reg().writeUnsignedEntry("OPTIONS","status",(FXuint)lpanel->status->shown());
        getApp()->reg().writeUnsignedEntry("OPTIONS","panel_view",(FXuint)panel_view);
        getApp()->reg().writeUnsignedEntry("OPTIONS","root_warn",(FXuint)warn_if_root);
        getApp()->reg().writeUnsignedEntry("OPTIONS","tree_width",(FXuint)dirpanel->getWidth());
        getApp()->reg().writeUnsignedEntry("OPTIONS","tree_hidden_dir",dirpanel->list->showHiddenFiles());

        FXString history="";
        for(int i=0;i<RunHistSize;i++)
        {
            history+=RunHistory[i];
            history+=":";
        }
        if(RunHistory)
            getApp()->reg().writeStringEntry("HISTORY","run",history.text());

        history="";
        for(int i=0;i<OpenNum;i++)
        {
            history+=OpenHistory[i];
            history+=":";
        }
        if(OpenNum)
            getApp()->reg().writeStringEntry("HISTORY","open",history.text());
    }
    getApp()->reg().writeUnsignedEntry("OPTIONS","auto_save_layout",auto_save_layout);
    getApp()->reg().write();
}

// If Tab pressed, cycle through the panels 
long XFileExplorer::onTabPress(FXObject* sender,FXSelector sel,void* ptr)
{
    FXEvent* event=(FXEvent*)ptr;
    
	// Tab was pressed : cycle through the panels
	if(event->code==KEY_Tab)
    {
		// Do it only in two panels mode
		if (rpanel->shown())
		{
			if (lpanel->current==rpanel)
				lpanel->focus();
			else
				rpanel->focus();
		}			
        return 1;
    }
	
	// Tab was not pressed : handle the pressed key in the usual way
    if(FXTopWindow::onKeyPress(sender,sel,ptr))
        return 1;
    return 0;
}

// Handle quitting
long XFileExplorer::onQuit(FXObject*,FXSelector,void*)
{
    if(confirm_quit)
        if(MBOX_CLICKED_NO==MessageBox::question(this,MBOX_YES_NO,_("Quitting Xfe"),_("Do you really want to quit Xfe?")))
            return 1;
    saveConfig();
    exit(0);
    return 1;
}


// Make application
void XFileExplorer::create()
{
    panel_view=getApp()->reg().readUnsignedEntry("OPTIONS","panel_view",TREE_PANEL);
    width=getApp()->reg().readUnsignedEntry("OPTIONS","width",600);
    height=getApp()->reg().readUnsignedEntry("OPTIONS","height",500);
    position(0,0,width,height);

    FXMainWindow::create();

	FXint window_width=getWidth();
    FXint dirpanel_width=getApp()->reg().readUnsignedEntry("OPTIONS","tree_width",200);
	dirpanel->setWidth(dirpanel_width);
    rpanel_width=getApp()->reg().readUnsignedEntry("RIGHT PANEL","panel_width",200);
    rpanel_tree_width=getApp()->reg().readUnsignedEntry("RIGHT PANEL","panel_tree_width",200);
	switch(panel_view)
	{
	case ONE_PANEL:
        rpanel->hide();
        dirpanel->hide();
		lpanel->setWidth(window_width-8);
		rpanel->setWidth(rpanel_width);
		break;
	case TWO_PANELS:
        dirpanel->hide();
		lpanel->setWidth(window_width-8-rpanel_width);
		rpanel->setWidth(rpanel_width);
		break;
	case TREE_PANEL:
        rpanel->hide();
		lpanel->setWidth(window_width-8-dirpanel_width);
		rpanel->setWidth(rpanel_tree_width);
		break;
	case TREE_TWO_PANELS:
		lpanel->setWidth(window_width-12-dirpanel_width-rpanel_tree_width);
		rpanel->setWidth(rpanel_tree_width);
		break;
	}

    if(!getApp()->reg().readUnsignedEntry("OPTIONS","toolbar",TRUE))
        toolbar->handle(this,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),NULL);
    if(!getApp()->reg().readUnsignedEntry("OPTIONS","locationbar",TRUE))
        locationbar->handle(this,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),NULL);
    if(!getApp()->reg().readUnsignedEntry("OPTIONS","status",TRUE))
        handle(this,MKUINT(XFileExplorer::ID_TOGGLE_STATUS,SEL_COMMAND),NULL);

	// Wheel scrolling
    FXint wheellines=getApp()->reg().readUnsignedEntry("SETTINGS","wheellines",5);
	getApp()->setWheelLines(wheellines);
	
    // Open left or right panel in starting directory (if specified) or in current directory
    if (startdir=="")
        startdir=FXFile::getCurrentDirectory();

    liststyle=getApp()->reg().readUnsignedEntry("LEFT PANEL","liststyle",(FXuint)FXIconList::ID_SHOW_DETAILS);
    lpanel->list->setDirectory(startdir);
    lpanel->label->setText(startdir);
    lpanel->list->setListStyle(liststyle);
    dirpanel->list->setDirectory(startdir);

    liststyle=getApp()->reg().readUnsignedEntry("RIGHT PANEL","liststyle",(FXuint)FXIconList::ID_SHOW_DETAILS);
    rpanel->list->setDirectory(startdir);
    rpanel->label->setText(startdir);
    rpanel->list->setListStyle(liststyle);

	// Show or hide hidden files listed in panels
    FXbool hiddenfiles;
	hiddenfiles=getApp()->reg().readUnsignedEntry("LEFT PANEL","hiddenfiles",0);
    lpanel->list->showHiddenFiles(hiddenfiles);
    hiddenfiles=getApp()->reg().readUnsignedEntry("RIGHT PANEL","hiddenfiles",0);
    rpanel->list->showHiddenFiles(hiddenfiles);
	
	// Show or hide hidden directories listed in dirpanel
    FXbool tree_hidden_dir;
	tree_hidden_dir=getApp()->reg().readUnsignedEntry("OPTIONS","tree_hidden_dir",0);
    dirpanel->list->showHiddenFiles(tree_hidden_dir);

    // Get external programs settings
	editor=getApp()->reg().readStringEntry("PROGS","editor","nedit ");
    viewer=getApp()->reg().readStringEntry("PROGS","viewer","xfv ");
    xterm=getApp()->reg().readStringEntry("PROGS","xterm","xterm -sb");
    cfm=getApp()->reg().readStringEntry("PROGS","cfm","xterm -e mc -x");

    warn_if_root=getApp()->reg().readUnsignedEntry("OPTIONS","root_warn",TRUE);
    confirm_quit=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_quit",TRUE);
    confirm_del=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete",TRUE);
    confirm_overwrite=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_overwrite",TRUE);
    ask_before_copy=getApp()->reg().readUnsignedEntry("OPTIONS","ask_before_copy",TRUE);
    FXString history=getApp()->reg().readStringEntry("HISTORY","run","");

   	int i;
    FXString histent;
    if(history != "")
    {
        for(i=0;;i++)
        {
            histent=history.extract(i,':');
            if(strcmp(histent.text(),"") == 0)
                break;
            strcpy(RunHistory[i],histent.text());
        }
        RunHistSize=i;
    }
    else
        RunHistSize=0;

    history=getApp()->reg().readStringEntry("HISTORY","open","");
    histent="";
    if(history != "")
    {
        for(i=0;;i++)
        {
            histent=history.extract(i,':');
            if(strcmp(histent.text(),"") == 0)
                break;
			strcpy(OpenHistory[i],histent.text());
        }
        OpenNum=i;
    }
    else
        OpenNum=0;

    getApp()->forceRefresh();
	// Running as root?
    if(getuid()==0 && warn_if_root)
        MessageBox::information(this,MBOX_OK,_("Warning"),_("Running Xfe as root!"));
    show();
}

// Destructor
XFileExplorer::~XFileExplorer()
{
	delete attricon;
	delete archicon;
	delete newfoldericon;
	delete minidocicon;
	delete delicon;
	delete copyicon;
	delete cuticon;
	delete pasteicon;
	delete symlinkicon;
	delete renameicon;
	delete moveicon;
	delete mapicon;
	delete unmapicon;
	delete minixtermicon;
	delete minicfmicon;
	delete locationicon;
	delete entericon;
	delete filtericon;
	delete viewicon;
	delete editicon;
	
    delete menubar;
    delete toolbar;
    delete status;
    delete dirpanel;
    delete lpanel;
    delete rpanel;
    delete leftviewmenu;
    delete rightviewmenu;
    delete rmenutitle;
    delete lmenutitle;
    delete bookmarks;	
}


// Handle bookmarks
long  XFileExplorer::onCmdBookmark(FXObject*,FXSelector s,void* p)
{
    if(SELID(s) == ID_ADD_BOOKMARK)
        bookmarks->appendFile(lpanel->current->list->getDirectory());
	
	// Handle location address fields
	else if(SELID(s) == ID_BOOKMARK)
	{
        lpanel->current->list->setDirectory((FXchar*)p);
        dirpanel->list->setDirectory((FXchar*)p);
        FXString item;
		FXint i=0;
		FXint count=address->getNumItems();
		if(!count)
		{
			count++;
			address->insertItem(0,address->getText());
		}
        while(i < count)
		{
        	item=address->retrieveItem(i++);
        	if(!strcmp((char*)p,(const char*)&item[0]))
			{
				i--;
				break;
			}
        }
        if(i==count) 
			address->insertItem(0,(FXchar*)p);
    }
    return 1;
}


// Goto location entered into the text field;
long XFileExplorer::onCmdGotoLocation(FXObject*,FXSelector,void*)
{
	FXString path=FXFile::absolute(lpanel->current->list->getDirectory(),address->getText());
	FXString dir=path;

	// Go up to the lowest directory which still exists
	while(!FXFile::isTopDirectory(dir) && !isDirectory(dir))
    	dir=FXFile::upLevel(dir);

	// Move to this existing directory
	lpanel->current->list->setDirectory(dir);
	dirpanel->list->setDirectory(dir);
	address->setText(path);
	
	return 1;
}


// Clear location bar
long XFileExplorer::onCmdClearLocation(FXObject*,FXSelector,void*)
{
  address->setText(FXString::null);
  return 1;
}

// Restart the application when required
long  XFileExplorer::onCmdRestart(FXObject*,FXSelector,void*)
{
    saveConfig();
    if(fork() == 0)
        execvp("xfe",args);
    else
        exit(0);
    return 1;
}


// Run Terminal
long  XFileExplorer::onCmdXTerm(FXObject*,FXSelector,void*)
{
    chdir(lpanel->current->list->getDirectory().text());
    FXString cmd = xterm;
    cmd += " &";
    system(cmd.text());
    lpanel->current->list->setFocus();
    return 0;
}


// Run Console file manager
long  XFileExplorer::onCmdCfm(FXObject*,FXSelector,void*)
{
    chdir(lpanel->current->list->getDirectory().text());
    FXString cmd = cfm;
    cmd += " &";
    system(cmd.text());
    lpanel->current->list->setFocus();
    return 0;
}

// Help menu
long XFileExplorer::onCmdHelp(FXObject*,FXSelector,void*)
{
    // Display help window
	TextWindow *helpwindow=new TextWindow(this,_("Help"),35,90);			
	helpwindow->setText(helptext);
	helpwindow->execute();
	delete helpwindow;
    lpanel->current->list->setFocus();
    return 1;
}

// About menu
long XFileExplorer::onCmdAbout(FXObject*,FXSelector,void*)
{
    FXPNGIcon icon(getApp(),FileManager);
    char msg[1000];
    sprintf(msg,_("XFE, X File Explorer Version %s\n\nCopyright (C) 2002-2004 Roland Baudin (roland65@free.fr)\n\nBased on X WinCommander by Maxim Baranov\n"),VERSION);
    MessageBox about(this,_("About X File Explorer"),msg,&icon,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
    about.execute();
    lpanel->current->list->setFocus();
    return 1;
}


// Update file location
long XFileExplorer::onUpdFileLocation(FXObject* sender,FXSelector,void*)
{
	static FXString prevdir=NULL;
	FXString currentdir=lpanel->current->list->getDirectory();
	if (currentdir != prevdir)
	{
		address->setText(currentdir);
		prevdir=currentdir;
	}
	return 1;
}


// Handle show commands
long XFileExplorer::onCmdShow(FXObject* sender,FXSelector sel,void* ptr)
{
    switch(SELID(sel))
    {
    case ID_SHOW_BIG_ICONS:
        lpanel->current->list->handle(sender,MKUINT(FileList::ID_SHOW_BIG_ICONS,SEL_COMMAND),ptr);
        break;
    case ID_SHOW_MINI_ICONS:
        lpanel->current->list->handle(sender,MKUINT(FileList::ID_SHOW_MINI_ICONS,SEL_COMMAND),ptr);
        break;
    case ID_SHOW_DETAILS:
        lpanel->current->list->handle(sender,MKUINT(FileList::ID_SHOW_DETAILS,SEL_COMMAND),ptr);
        break;
    }
    return 1;
}

// Update show commands
long XFileExplorer::onUpdShow(FXObject* sender,FXSelector sel,void* ptr)
{	
    FXuint msg = FXWindow::ID_UNCHECK;
    FXuint style = lpanel->current->list->getListStyle() & ~ICONLIST_COLUMNS;
		
    switch(SELID(sel))
    {
    case ID_SHOW_BIG_ICONS:
        if(style == ICONLIST_BIG_ICONS)
            msg = FXWindow::ID_CHECK;
        break;
    case ID_SHOW_MINI_ICONS:
        if(style == ICONLIST_MINI_ICONS)
            msg = FXWindow::ID_CHECK;
        break;
    case ID_SHOW_DETAILS:
        if(style == ICONLIST_DETAILED)
            msg = FXWindow::ID_CHECK;
        break;
    }
    sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
    return 1;
}


// Handle toggle hidden command
long XFileExplorer::onCmdToggleHidden(FXObject* sender,FXSelector sel,void* ptr)
{
	lpanel->current->list->handle(sender,MKUINT(FileList::ID_TOGGLE_HIDDEN,SEL_COMMAND),ptr);
    return 1;
}

// Update toggle hidden command
long XFileExplorer::onUpdToggleHidden(FXObject* sender,FXSelector sel,void* ptr)
{	
    FXuint msg = FXWindow::ID_UNCHECK;
	FXbool hidden = lpanel->current->list->showHiddenFiles();
		
	if(hidden == FALSE)
		msg = FXWindow::ID_CHECK;
    sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
    return 1;
}

// Switch between the four possible panel views
long XFileExplorer::onCmdShowPanels(FXObject* sender,FXSelector sel,void* ptr)
{
	// Get directory tree and window widths
	FXint dirpanel_width=dirpanel->getWidth();
	FXint window_width=getWidth();

    switch(SELID(sel))
    {
    case ID_SHOW_ONE_PANEL:
		panel_view=ONE_PANEL;
		lpanel->setWidth(window_width-8);
		rpanel->setWidth(rpanel_width);
		if (dirpanel->shown())
    		dirpanel->handle(sender,MKUINT(DirPanel::ID_TOGGLE_TREE,SEL_COMMAND),ptr);
		if (rpanel->shown())
			rpanel->handle(sender,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),ptr);	
        break;
    case ID_SHOW_TWO_PANELS:
		panel_view=TWO_PANELS;
		lpanel->setWidth(window_width-8-rpanel_width);
		rpanel->setWidth(rpanel_width);
		if (dirpanel->shown())
    		dirpanel->handle(sender,MKUINT(DirPanel::ID_TOGGLE_TREE,SEL_COMMAND),ptr);
		if (!rpanel->shown())
			rpanel->handle(sender,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),ptr);	
        break;
    case ID_SHOW_TREE_PANEL:
		panel_view=TREE_PANEL;
		lpanel->setWidth(window_width-8-dirpanel_width);
		rpanel->setWidth(rpanel_tree_width);
		if (!dirpanel->shown())
    		dirpanel->handle(sender,MKUINT(DirPanel::ID_TOGGLE_TREE,SEL_COMMAND),ptr);
		if (rpanel->shown())
			rpanel->handle(sender,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),ptr);	
        break;
    case ID_SHOW_TREE_TWO_PANELS:
		panel_view=TREE_TWO_PANELS;
		lpanel->setWidth(window_width-12-dirpanel_width-rpanel_tree_width);
		rpanel->setWidth(rpanel_tree_width);
		if (!dirpanel->shown())
    		dirpanel->handle(sender,MKUINT(DirPanel::ID_TOGGLE_TREE,SEL_COMMAND),ptr);
		if (!rpanel->shown())
			rpanel->handle(sender,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),ptr);	
        break;
    }
	return 1;
}

// Update sender
long XFileExplorer::onUpdShowPanels(FXObject* sender,FXSelector sel,void* ptr)
{
    FXuint msg = FXWindow::ID_UNCHECK;
		
    switch(SELID(sel))
    {
    case ID_SHOW_ONE_PANEL:
		if (!dirpanel->shown() && !rpanel->shown())
		{
            msg = FXWindow::ID_CHECK;		
			rpanel_width=rpanel->getWidth();
        	if(rmenutitle->shown())
        	{
            	lpanel->focus();
            	rmenutitle->hide();
            	lmenutitle->setText(_("Panel"));
            	lpanel->focus();
        	}
		}
        break;
    
	case ID_SHOW_TWO_PANELS:
		if (!dirpanel->shown() && rpanel->shown())
		{
            msg = FXWindow::ID_CHECK;
			rpanel_width=rpanel->getWidth();
        	if(!rmenutitle->shown())
        	{
            	rmenutitle->show();
            	rmenutitle->setText(_("Right panel"));
            	lmenutitle->setText(_("Left panel"));
            	lpanel->focus();
        	}
		}
        break;
    
	case ID_SHOW_TREE_PANEL:
 		if (dirpanel->shown() && !rpanel->shown())
		{
           	msg = FXWindow::ID_CHECK;		
			rpanel_tree_width=rpanel->getWidth();
        	if(rmenutitle->shown())
        	{
            	lpanel->focus();
            	rmenutitle->hide();
            	lmenutitle->setText(_("Panel"));
            	lpanel->focus();
       	 	}
		}
        break;
    
	case ID_SHOW_TREE_TWO_PANELS:
 		if (dirpanel->shown() && rpanel->shown())
		{
            msg = FXWindow::ID_CHECK;
			rpanel_tree_width=rpanel->getWidth();
        	if(!rmenutitle->shown())
        	{
           	 	rmenutitle->show();
            	rmenutitle->setText(_("Right panel"));
            	lmenutitle->setText(_("Left panel"));
            	lpanel->focus();
        	}
		}
        break;
    }
    sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
    return 1;
}


// Handle item selection
long XFileExplorer::onCmdSelect(FXObject* sender,FXSelector sel,void* ptr)
{
    switch(SELID(sel))
    {
    case ID_SELECT_ALL:
        lpanel->current->list->handle(sender,MKUINT(FileList::ID_SELECT_ALL,SEL_COMMAND),ptr);
        return 1;
    case ID_DESELECT_ALL:
        lpanel->current->list->handle(sender,MKUINT(FileList::ID_DESELECT_ALL,SEL_COMMAND),ptr);
        return 1;
    case ID_SELECT_INVERSE:
        lpanel->current->list->handle(sender,MKUINT(FileList::ID_SELECT_INVERSE,SEL_COMMAND),ptr);
        return 1;
    }
    return 1;
}


// Toggle autosave flag
long XFileExplorer::onCmdAutoSave(FXObject* sender,FXSelector,void*)
{
    if(auto_save_layout==TRUE)
    {
        auto_save_layout=FALSE;
        sender->handle(this,MKUINT(FXWindow::ID_UNCHECK,SEL_COMMAND),NULL);
    }
    else
    {
        auto_save_layout=TRUE;
        sender->handle(this,MKUINT(FXWindow::ID_CHECK,SEL_COMMAND),NULL);
    }
    return 1;
}


// Handle context menu
long XFileExplorer::onCmdMenu(FXObject*,FXSelector s,void *p)
{
    // Popup menu pane
    static FXMenuPane *menu = NULL;
    if(menu)
        delete menu;
    menu = new FXMenuPane(this);
    FXint x,y;
    FXuint state;
    getRoot()->getCursorPosition(x,y,state);

    FXint num, itm;	
	num=lpanel->current->list->getNumSelectedItems(&itm);

    // No selection
	if(num == 0 || lpanel->current->ctrlkey)
    {
	    new FXMenuCommand(menu,_("Terminal"),minixtermicon,this,XFileExplorer::ID_XTERM);
    	new FXMenuCommand(menu,_("New file..."),minidocicon,lpanel->current,FilePanel::ID_NEW_FILE);
    	new FXMenuCommand(menu,_("New folder..."),newfoldericon,lpanel->current,FilePanel::ID_NEW_DIR);
        new FXMenuCommand(menu,_("Filter..."),filtericon,rpanel->current,FilePanel::ID_FILTER);
        new FXMenuSeparator(menu);
        new FXMenuCommand(menu,_("Hidden files"),NULL,rpanel->current->list,FileList::ID_TOGGLE_HIDDEN);
        new FXMenuCommand(menu,_("Full file list"),NULL,rpanel->current->list,FXIconList::ID_SHOW_DETAILS);
        new FXMenuCommand(menu,_("Brief file list"),NULL,rpanel->current->list,FXIconList::ID_SHOW_MINI_ICONS);
        new FXMenuCommand(menu,_("Big icons"),NULL,rpanel->current->list,FXIconList::ID_SHOW_BIG_ICONS);
        new FXMenuSeparator(menu);
        new FXMenuCommand(menu,_("Rows"),NULL,rpanel->current->list,FXIconList::ID_ARRANGE_BY_ROWS);
        new FXMenuCommand(menu,_("Columns"),NULL,rpanel->current->list,FXIconList::ID_ARRANGE_BY_COLUMNS);
        new FXMenuSeparator(menu);
        new FXMenuCommand(menu,_("Name"),NULL,rpanel->current->list,FileList::ID_SORT_BY_NAME);
        new FXMenuCommand(menu,_("Type"),NULL,rpanel->current->list,FileList::ID_SORT_BY_TYPE);
        new FXMenuCommand(menu,_("Size"),NULL,rpanel->current->list,FileList::ID_SORT_BY_SIZE);
        new FXMenuCommand(menu,_("Time"),NULL,rpanel->current->list,FileList::ID_SORT_BY_TIME);
        if(!clipboard.empty())
        {
            new FXMenuSeparator(menu);
            new FXMenuCommand(menu,_("Paste"),NULL,lpanel->current,FilePanel::ID_PASTE_CLP);
        }
    }
    // Non empty selection
	else
    {
        FXbool ar = FALSE;
        if(lpanel->current->list->retrieveItem (itm) && lpanel->current->list->isItemFile(itm))
        {
            new FXMenuCommand(menu,_("Open with..."),NULL,lpanel->current,FilePanel::ID_OPEN_WITH);
			FXString name = lpanel->current->list->getItemText(itm).extract(0,'\t');
			char *ext = strrchr(name.text(),'.');
			if(ext)
			{
				if(!strcmp(ext, ".gz") || !strcmp(ext,".tgz") ||
					!strcmp(ext,".tar") || !strcmp(ext,".bz2") ||
                    !strcmp(ext,".zip") || !strcmp(ext,"ZIP") ||
					!strcmp(ext,".Z"))
				{
					ar = TRUE;
					new FXMenuCommand(menu,_("Extract to..."),archicon,this,ID_EXTRACT);
				}
#if defined(linux)
			else if(!strcmp(ext,".rpm"))
			{
				ar = TRUE;
				new FXMenuCommand(menu,_("View"),minirpmicon,lpanel->current,FilePanel::ID_VIEW);
				new FXMenuCommand(menu,_("Install/Upgrade"),minirpmicon,this,ID_RPM_INSTALL);
				new FXMenuCommand(menu,_("Uninstall"),minirpmicon,this,ID_RPM_UNINSTALL);
			}
#endif
			}
			if(!ar) // Not archive nor rpm
			{
				new FXMenuCommand(menu,_("View"),viewicon,lpanel->current,FilePanel::ID_VIEW);
				new FXMenuCommand(menu,_("Edit"),editicon,lpanel->current,FilePanel::ID_EDIT);
			}
        }
        if(!ar)
            new FXMenuCommand(menu,_("Add to archive..."),archicon,lpanel->current,FilePanel::ID_ADD_TO_ARCH);
#if defined(linux)
        if (!ar)
			new FXMenuCommand(menu,_("Rpm query"),minirpmicon,lpanel->current,FilePanel::ID_RPM_QUERY);
#endif
        new FXMenuSeparator(menu);
        new FXMenuCommand(menu,_("Copy"),copyicon,lpanel->current,FilePanel::ID_COPY_CLP);
        new FXMenuCommand(menu,_("Cut"),cuticon,lpanel->current,FilePanel::ID_CUT_CLP);
        if(!clipboard.empty())
            new FXMenuCommand(menu,_("Paste"),pasteicon,lpanel->current,FilePanel::ID_PASTE_CLP);
        new FXMenuSeparator(menu);
        new FXMenuCommand(menu,_("Rename..."),renameicon,lpanel->current,FilePanel::ID_FILE_RENAME);
        new FXMenuCommand(menu,_("Move..."),moveicon,lpanel->current,FilePanel::ID_FILE_MOVE);
        new FXMenuCommand(menu,_("Symbolic link..."),symlinkicon,lpanel->current,FilePanel::ID_FILE_SLINK);
        new FXMenuCommand(menu,_("Delete"),delicon,lpanel->current,FilePanel::ID_FILE_DEL);
        new FXMenuSeparator(menu);
        new FXMenuCommand(menu,_("Properties..."),attricon,lpanel->current,FilePanel::ID_PROPERTIES);
    }
    menu->create();
    menu->popup(NULL,x,y);
    return 1;
}


// Preferences
long XFileExplorer::onCmdPrefs(FXObject*,FXSelector s,void *p)
{
    PreferencesBox *prefs = new PreferencesBox(this);
    prefs->execute();
    delete prefs;
    lpanel->current->list->setFocus();
    return 1;
}


// Reload preferences
long XFileExplorer::onCmdReloadPrefs(FXObject*,FXSelector s,void *p)
{
    editor=getApp()->reg().readStringEntry("PROGS","editor","nedit");
    viewer=getApp()->reg().readStringEntry("PROGS","viewer","xfv");
    xterm=getApp()->reg().readStringEntry("PROGS","xterm","xterm -sb");
    cfm=getApp()->reg().readStringEntry("PROGS","cfm","xterm -e mc -x");

    confirm_quit=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_quit",TRUE);
    confirm_del=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete",TRUE);
    confirm_overwrite=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_overwrite",TRUE);
    ask_before_copy=getApp()->reg().readUnsignedEntry("OPTIONS","ask_before_copy",TRUE);

    FileDict *newdict=new FileDict(getApp());
    FileDict *olddict=lpanel->list->getAssociations();
    if(olddict)
    {
        delete olddict;
        lpanel->list->setAssociations(newdict);
    }
    newdict=new FileDict(getApp());
    olddict=rpanel->list->getAssociations();
    if(olddict)
    {
        delete olddict;
        rpanel->list->setAssociations(newdict);
    }

    return 1;
}


long XFileExplorer::onCmdToggleStatus(FXObject*,FXSelector s,void *p)
{
    dirpanel->status->handle(this,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),NULL);
    lpanel->status->handle(this,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),NULL);
    rpanel->status->handle(this,MKUINT(FXWindow::ID_TOGGLESHOWN,SEL_COMMAND),NULL);
    return 1;
}


long XFileExplorer::onUpdToggleStatus(FXObject *o,FXSelector s,void *p)
{
    FXMenuCommand *cmd =(FXMenuCommand*)o;
    if(lpanel->status->shown())
        cmd->check();
    else
        cmd->uncheck();
    return 1;
}


// Handle file association
long XFileExplorer::onCmdFileAssoc(FXObject*,FXSelector s,void *p)
{
	char **str = (char**)p;
    char* ext = str[0];
    char* cmd = str[1];
	
	// ext=extension, cmd=associated command
	// replace : to allow immediate association in Xfe
    FileDict *associations = lpanel->list->getAssociations();
    associations->replace(ext,cmd);
    associations = rpanel->list->getAssociations();
    associations->replace(ext,cmd);

    return 1;
}


// Extract archive
long XFileExplorer::onCmdExtract(FXObject*,FXSelector,void*)
{
    FXString name, cmd, dir, cdir;
    DirListBox dirlistbox(this);
	File *f;

    cdir = lpanel->current->list->getDirectory();
    dir = getApp()->reg().readStringEntry("HISTORY","last_extract_dir",cdir.text());
    dirlistbox.create();
    dirlistbox.setPath(dir);

    FXint num, itm;	
	num=lpanel->current->list->getNumSelectedItems(&itm);
    if (lpanel->current->list->retrieveItem (itm))
        if(dirlistbox.execute())
        {
            dir = dirlistbox.getPath();
            if(!access(dir.text(),W_OK))
            {
                getApp()->reg().writeStringEntry("HISTORY","last_extract_dir",dir.text());
                name = lpanel->current->list->getItemText(itm).text();
                name = "\"" + cdir + PATHSEPSTRING + name.extract(0,'\t') + "\"";

                FileAssoc* assoc = lpanel->current->list->getItemAssoc(itm);
                cmd = assoc->command;
                cmd = cmd.extract(1,',');// get extract command
                if(!cmd.empty())
                {
                    int i = cmd.findf('%');
                    if(i < 0)
                        cmd = cmd + " " + name;
                    else
                    {
                        cmd.remove(i,2);
                        cmd.insert(i,name);
                    }					
									
					// Wait cursor
					getApp()->beginWaitCursor();
					
					// File object
   					f=new File(getApp(),_("Extract archive"),EXTRACT);
   					f->create();
				   
				   	// Extract archive
					f->extract(name,dir,cmd);
 
					getApp()->endWaitCursor();
					delete f; 
                }
                else
                    MessageBox::error(this,MBOX_OK,_("Error"),_("Extract command isn't specified"));
            }
            else
                MessageBox::error(this,MBOX_OK,_("Error"),_("Can't write to %s: Permission denied"),dir.text());
        }
    
	// Force panel refresh
	lpanel->current->onRefresh(0,0,0);
	
    return 1;
}

#if defined(linux)
// Install/Upgrade RPM package
long XFileExplorer::onCmdRpmInstall(FXObject*,FXSelector,void*)
{
    FXString name, path, cmd, dir, cdir;
	File *f;

    cdir = lpanel->current->list->getDirectory();

    FXint num, itm;	
	num=lpanel->current->list->getNumSelectedItems(&itm);
    if (lpanel->current->list->retrieveItem (itm))
	{
        name = lpanel->current->list->getItemText(itm).text();
		name=name.extract(0,'\t');
		path = "\"" + cdir + PATHSEPSTRING + name + "\"";

		// Upgrade command
		cmd = "rpm -Uvh " + path;
                   
		// Wait cursor
		getApp()->beginWaitCursor();
		
		// File object
		f=new File(getApp(),_("RPM Install/Upgrade"),RPM_INSTALL);
		f->create();
				   
		// Install/Upgrade RPM package
		f->rpmInstall(name,cmd);

		getApp()->endWaitCursor();
		delete f; 
      }
    
	// Force panel refresh
	lpanel->current->onRefresh(0,0,0);
	
	return 1;
}

// Uninstall RPM package based on its name (package version is ignored)
long XFileExplorer::onCmdRpmUninstall(FXObject*,FXSelector,void*)
{
    FXString name, cmd, dir, cdir;
	File *f;

    cdir = lpanel->current->list->getDirectory();

    FXint num, itm;	
	num=lpanel->current->list->getNumSelectedItems(&itm);
    if (lpanel->current->list->retrieveItem (itm))
	{
        name = lpanel->current->list->getItemText(itm).text();
		name=name.extract(0,'\t');
		name=name.extract(0,'-');

		// Uninstall command
		cmd = "rpm -e " + name;
                   
		// Wait cursor
		getApp()->beginWaitCursor();

		// File object
		f=new File(getApp(),_("RPM Uninstall"),RPM_UNINSTALL);
		f->create();

		// Uninstall RPM package
		f->rpmUninstall(name,cmd);

		getApp()->endWaitCursor();
		delete f; 
      }
    
	// Force panel refresh
	lpanel->current->onRefresh(0,0,0);
	
	return 1;
}

#endif

// Run shell command or X program
long XFileExplorer::onCmdRun(FXObject*,FXSelector,void*)
{
    int i;
    chdir(lpanel->current->list->getDirectory().text());
    HistInputDialog* dialog;
    FXString command="";
    dialog = new HistInputDialog(this,command,_("Execute Command :"),_("Execute"),"", NULL,1, _("Console mode"));
    for(int i=0;i<RunHistSize;i++)
        dialog->appendItem(RunHistory[i]);
    dialog->CursorEnd();
    if(dialog->execute())
    {
        command=dialog->getText();
        if(command != "")
        {
			// Execute command in command window
			if (dialog->getOption())
			{
    			// Make and show command window
				CommandWindow *cmdwin=new CommandWindow(getApp(),_("Command log"),command,30,80);			
				cmdwin->create();
				
				// The CommandWindow object will delete itself when closed!
			}
			
			// Execute silently in background
			else
			{
				command+=" &";
				system(command.text());
			}
        }
		// Update history list
		RunHistSize=dialog->getHistorySize();
        RunHistSize++;
        command=dialog->getText();
        if(RunHistSize>RUN_HIST_SIZE)
            RunHistSize=RUN_HIST_SIZE;
        for(i=0;i<RunHistSize-1;i++)
            if(!strcmp(RunHistory[i],command.text()))
                break;
        if(i==RunHistSize-1)
        {
            strcpy(RunHistory[0],command.text());
            for(i=1;i<RunHistSize;i++)
                strcpy(RunHistory[i],dialog->getHistoryItem(i-1).text());
        }
        else
            RunHistSize--;
    }
    delete dialog;
    lpanel->current->list->setFocus();
    return 1;
}


// Copy/Move/Rename/SymLink File(s) 
long XFileExplorer::onCmdFileMan(FXObject*,FXSelector sel,void* ptr)
{
    FXString command, message, title;
	File *f=NULL;
	FXbool dirman=FALSE;

    clipboard = "";
    lpanel->current->list->setFocus();

	// Extract target directory, number of sources and sources names
	FXString str=(char*)ptr;
	FXString targetdir=str.extract(0,'\n');
	int num=FXUIntVal(str.extract(1,'\n'));
	FXString src=str.after('\n',2);

    const unsigned char *ic=::copy_big;
    FXIcon *icon=NULL;
    chdir(targetdir.text());
    
	// No selected files
	if(num==0)
        return 0;
		
	// We were called from DirPanel::onCmdDirMan
	if (num==-1)
	{
		dirman=TRUE;
		num=1;
	}
		
	// Name and directory of the first source file
	FXString source=src.extract(0,'\n');
	FXString name=FXFile::name(source);
	FXString dir=FXFile::directory(source);

	// Initialise target name
	FXString target=targetdir;
	
    // Target directory not writable
    if(!FXFile::isWritable(targetdir))
    {
        MessageBox::error(this,MBOX_OK,_("Error"), _("Cant write to %s : Permission denied"), targetdir.text());
        return 0;
    }

    // Configure the command, title, message, etc.
	if(SELID(sel)==ID_FILE_COPY)
    {
        command="copy";
        title=_("Copy");
        ic=::copy_big;
        if(num==1)
        {
            message=_("Copy ");
            message+=source;
			if (target==FXFile::directory(source))
				target=source;
		}
        else
            message=_("Copy ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(SELID(sel)==ID_FILE_RENAME)
    {
        command="rename";
        title=_("Rename");
        ic=move_big;
        if(num==1)
        {
            message=_("Rename ");
			message+=name;
            target=name;
			title=_("Rename");
        }
        else
			return 0;
    }
    if(SELID(sel)==ID_FILE_MOVE)
    {
        command="move";
        title=_("Move");
        ic=move_big;
        if(num==1)
        {
            message=_("Move ");
            message+=source;
            title=_("Move");
        }
        else
            message=_("Move ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(SELID(sel)==ID_FILE_CUT)
    {
        command="move";
        title=_("Move");
        ic=move_big;
        if(num==1)
        {
            message=_("Move ");
            message+=source;
            title=_("Move");
			if (target==FXFile::directory(source))
				target=source;
        }
        else
            message=_("Move ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(SELID(sel)==ID_FILE_SLINK)
    {
        command="symlink";
        title=_("SymLink");
        ic=link_big;
        if(num==1)
        {
            message=_("SymLink ");
            message+=source;
        }
        else
            message=_("SymLink ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
	
    // File operation dialog, if needed
	if(ask_before_copy || source==target || SELID(sel)==ID_FILE_MOVE ||  SELID(sel)==ID_FILE_RENAME || SELID(sel)==ID_FILE_SLINK)
	{
    	InputDialog* dialog;
    	icon = new FXPNGIcon(getApp(),ic);
    	dialog = new InputDialog(this,target,message,title,_("To:"),icon);
    	dialog->CursorEnd();
	    int rc=1;
        rc=dialog->execute();
	    target=dialog->getText();
		delete dialog;
		delete icon;
		if (!rc)
			return 0;
	}    

	// Update target and target parent directory
	target=::filePath(target,targetdir);
	targetdir=FXFile::directory(target);

	// Multiple sources and non existent destination
	if (num>1 & !exists(dequote(target)))
	{
        MessageBox::error(this,MBOX_OK,_("Error"),_("Folder %s does'nt exist"),target.text());
        return 0;
	}
		
	// Multiple sources and target is a file
	if (num>1 & isFile(target))
	{ 			
        MessageBox::error(this,MBOX_OK,_("Error"),_("%s is not a folder"),target.text());
        return 0;
	}

	// Target is a directory and is not writable
    if(isDirectory(target) & !FXFile::isWritable(target))
    {
        MessageBox::error(this,MBOX_OK,_("Error"),_("Cant write to %s : Permission denied"), target.text());
        return 0;
    }
	
	// Target is a file and its parent directory is not writable
	if (isFile(target) & !FXFile::isWritable(targetdir))
	{
        MessageBox::error(this,MBOX_OK,_("Error"),_("Can't write to %s : Permission denied"),targetdir.text());
        return 0;
	}

	// Target parent directory doesn't exist
	if (!exists(dequote(targetdir)))
	{
		MessageBox::error(this,MBOX_OK,_("Error"),_("Folder %s does'nt exist"),targetdir.text());
        return 0;
	}
		
	// Target parent directory is not a directory
	if (!isDirectory(targetdir))
	{
		MessageBox::error(this,MBOX_OK,_("Error"),_("%s is not a folder"),targetdir.text());
        return 0;
	}
		
	// One source
    if(num==1)
	{
		// An empty source file name corresponds to the ".." file
		// Don't perform any file operation on it!
		if (source=="")
			return 0;
		
		// Wait cursor
		getApp()->beginWaitCursor();

		// File object
        if(command=="copy")
        {
			f=new File(getApp(),_("File copy"),COPY);
        	f->create();
			f->copy(source,target);
			
			// If action is cancelled in progress dialog
			if (f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,MBOX_OK,_("Error"),_("Copy file operation cancelled!"));
			}
        }
        else if(command=="rename")
        {
			f=new File(getApp(),_("File rename"),RENAME);
        	f->create();
			f->rename(source,target);
        }
        else if(command=="move")
        {
			f=new File(getApp(),_("File move"),MOVE);
        	f->create();
			f->move(source,target);

			// If action is cancelled in progress dialog
			if (f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,MBOX_OK,_("Error"),_("Move file operation cancelled!"));
			}
        }
        else if(command=="symlink")
        {
			f=new File(getApp(),_("Symbolic link"),SLINK);
        	f->create();
			f->symlink(source,target);
		}
       	else
           	exit(-1);
									
		getApp()->endWaitCursor();
		delete f;

		// We were called from DirPanel::onCmdDirMan => set directory to the new one in DirList and FileList
		if (dirman)
		{
			((XFileExplorer*) getApp()->getMainWindow())->dirpanel->list->setDirectory(target);
			lpanel->current->list->setDirectory(target);
		}
	}
	
	// Multiple sources
	// Note : rename and symlink are not used in this case!
    else if(num>1)
    {

		// Wait cursor
		getApp()->beginWaitCursor();

		// File object
        if (command=="copy")
			f=new File(getApp(),_("File copy"),COPY);
		else if (command=="move")
			f=new File(getApp(),_("File move"),MOVE);
		f->create();
			
		
		// Loop on the multiple files
		for(int i=0;i<num;i++)
        {
			// Individual source file
			source=src.extract(i,'\n');

			// An empty file name corresponds to the ".." file (why?)
			// Don't perform any file operation on it! 
			if (source!="")
			{
            	if(command=="copy")
				{
					f->copy(source,target);
				
					// If action is cancelled in progress dialog
					if (f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,MBOX_OK,_("Error"),_("Copy file operation cancelled!"));
						break;
					}
				}
            	else if(command=="move")
            	{
					f->move(source,target);
				
					// If action is cancelled in progress dialog
					if (f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,MBOX_OK,_("Error"),_("Move file operation cancelled!"));
						break;
					}
           	 	}
            	else
                	exit(-1);
			}
		}
		
		getApp()->endWaitCursor();		
		delete f;
	}	

	// Force panel refresh
	lpanel->current->onRefresh(0,0,0);
    return 1;
}
