#ifndef FILEPANEL_H
#define FILEPANEL_H
#include "Properties.h"
#include "FileList.h"

// Clipboard operations
enum
{	
	COPY_CLP,
	CUT_CLP,
};

class FilePanel : public FXVerticalFrame
{
    FXDECLARE(FilePanel)
    friend class XFileExplorer;
    friend class DirPanel;
protected:
    FilePanel*		current;
    FileList*	  	list;
    FilePanel*		next;
    FXLabel*		label;
    FXLabel*		status;
    FXString 		name;
	FXbool			ctrlkey;
	FXbool			selmult;

public:
    FilePanel(FXchar*,FXComposite*, FXuint name_size=200, FXuint size_size=60, FXuint type_size=100, 
	      FXuint modd_size=150, FXuint user_size=50, FXuint grou_size=50, FXuint attr_size=100,
 		  FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
    FilePanel()
    {}
    virtual void create();
    ~FilePanel();
    void focus();
    void unfocus();
    void Next(FilePanel*);
	void updateLocation();
    enum {
        ID_FILE_PANEL=FXVerticalFrame::ID_LAST,
        ID_DIRECTORY_UP,
        ID_VIEW,
        ID_EDIT,
        ID_PROPERTIES,
        ID_FILE_COPY,
        ID_FILE_MOVE,
        ID_FILE_RENAME,
        ID_FILE_SLINK,
        ID_FILE_DEL,
        ID_NEW_DIR,
        ID_NEW_FILE,
        ID_ADD_TO_ARCH,
        ID_GO_HOME,
        ID_COPY_CLP,
        ID_CUT_CLP,
        ID_PASTE_CLP,
        ID_OPEN_WITH,
        ID_FILTER,
        ID_STATUS,
        ID_LABEL,
        ID_REFRESH,
#if defined(linux)
        ID_MOUNT,
        ID_UMOUNT,
		ID_RPM_QUERY,
#endif
        ID_LAST,
    };
public:
    long onUpdStatus(FXObject*,FXSelector,void*);
    long onUpdLabel(FXObject*,FXSelector,void*);
    long onLabelClcked(FXObject*,FXSelector,void*);
    long onCmdItemDblClcked(FXObject*,FXSelector,void*);
    long onCmdItemFilter(FXObject*,FXSelector,void*);
    long onCmdClp(FXObject*,FXSelector,void*);
    long onCmdPaste(FXObject*,FXSelector,void*);
    long onCmdItemClcked(FXObject*,FXSelector,void*);
    long onCmdDirectoryUp(FXObject*,FXSelector,void*);
    long onCmdGoHome(FXObject*,FXSelector,void*);
    long onCmdEdit(FXObject*,FXSelector,void*);
    long onCmdProperties(FXObject*,FXSelector,void*);
    long onCmdFileMan(FXObject*,FXSelector,void*);
    long onCmdFileDel(FXObject*,FXSelector,void*);
    long onCmdNewDir(FXObject*,FXSelector,void*);
    long onCmdNewFile(FXObject*,FXSelector,void*);
    long onCmdOpenWith(FXObject*,FXSelector,void*);
    long onRefresh(FXObject*,FXSelector,void*);
    long onPopupMenu(FXObject*,FXSelector,void*);
    long onUpdUp(FXObject*,FXSelector,void*);
    long onUpdPaste(FXObject*,FXSelector,void*);
    long onCmdAddToArch(FXObject*,FXSelector,void*);
	long onUpdMenu(FXObject*,FXSelector,void*);
	long onUpdSelMult(FXObject*,FXSelector,void*);
#if defined(linux)
    long onCmdMount(FXObject*,FXSelector,void*);
    long onUpdMount(FXObject*,FXSelector,void*);
    long onCmdRpmQuery(FXObject*,FXSelector,void*);
#endif
};
#endif
