#!/usr/bin/env python
#
#   XenMan   -  Copyright (c) 2007 Jd & Hap Hazard
#   ======
#
# XenMan is a Xen management tool with a GTK based graphical interface
# that allows for performing the standard set of domain operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify certain aspects such as the creation of
# domains, as well as making the consoles available directly within the
# tool's user interface.
#
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# and for details, please consult it at:
#
#    http://www.fsf.org/licensing/licenses/lgpl.txt
#


#
# constants definitions
#

# config properties
prop_disks_dir = 'disks_dir'
prop_snapshots_dir = 'snapshots_dir'
prop_xenconf_dir = 'xenconf_dir'
prop_cache_dir = 'cache_dir'
prop_kernel = 'kernel'
prop_ramdisk = 'ramdisk'
prop_dom0_kernel = 'dom0_kernel'
#prop_staging_location = 'staging_location'
#prop_staging_path_kernel = 'staging_path_kernel'
#prop_staging_path_ramdisk = 'staging_path_ramdisk'
prop_snapshot_file_ext = 'snapshot_file_ext'
#prop_bootloader = 'bootloader'
prop_lvm = 'lvm_enabled'
prop_domfiles = "vms"
prop_isRemote = 'is_remote'
prop_image_store="image_store"
prop_log_dir='log_dir'
prop_exec_path = 'exec_path'
prop_default_computed_options="default_computed_options"

# node specific properties
prop_protocol = "protocol"
prop_xen_port = "xen_port"
prop_login = "login"

# ManagedNode environment identifiers
prop_env_SYSTEM = 'SYSTEM'
prop_env_RELEASE = 'RELEASE'
prop_env_VER = 'VERSION'
prop_env_MACHINE_TYPE = 'MACHINE'
prop_env_NODE_NAME = 'NODE'
prop_env_PROCESSOR = 'PROCESSOR'
prop_env_KERNEL = 'RELEASE'

#client config properties
prop_gnome_vfs_enabled = "gnome_vfs_enabled"      # by default True
prop_init_confirmation = 'confirm_dialog'
prop_browser = "html_browser"       # Location of browser
prop_imagestore_default = 'default_image'

# Global identifiers
LOCALHOST = 'localhost'
DEFAULT_LOG_DIR="/var/log/xenman"
