#ifndef parse_h
#define parse_h

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include "globals.h"
#include "request.h"
#include "base64.h"
#include "helper.h"

extern FILE *xproxyLog;

// If a full request is available, parseRequest parses the request and returns FULL_REQUEST (if successful) or BAD_REQUEST (if malformed request).  If full request is not available, parseRequest does not take out any data from the socket buffer.

RequestHeaderState parseRequest(Request *request);

bool parseAllHeaders(Socket *socket, HTTPState *state);

// parseHeader parses one header.  If successful, it returns true; otherwise, false.

bool parseHeader(HTTPState *state, char *headerName, char *headerValue);

// If a full response header is available, parseResponse starts parsing the response; subsequently, it will receive the response body as well.  If a full response has been received (headers plus body), FULL_RESPONSE is returned; otherwise, it returns PARTIAL_REQUEST.  If an error is encounter, the function returns BAD_RESPONSE, but it's not known if the entire response has been read from the socket.

ResponseHeaderState parseResponse(Request *request, bool *recvBytesCalled);

ResponseHeaderState parseChunkedResponse(Request *request, bool *recvBytesCalled);

#endif parse_h
