/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

#include "mod_dav_xdelta.h"

static const command_rec dav_xdelta_cmds[] =
{
    /* per server options */
    AP_INIT_TAKE1("XdeltaFSPath", dav_xdelta_cmd_fspath, NULL, ACCESS_CONF,
                  "specify the FSPATH for the Xdelta database"),

    { NULL }
};

static void dav_xdelta_register_hooks (apr_pool_t *p)
{
    dav_hook_gather_propsets      (dav_xdelta_gather_propsets, NULL, NULL, APR_HOOK_MIDDLE);
    dav_hook_find_liveprop        (dav_xdelta_find_liveprop, NULL, NULL, APR_HOOK_MIDDLE);
    dav_hook_insert_all_liveprops (dav_xdelta_insert_all_liveprops, NULL, NULL, APR_HOOK_MIDDLE);

    /* register the namespace URIs */
    dav_register_liveprop_group (p, &dav_xdelta_liveprop_group);

    /* register the repository provider */
    dav_register_provider (p, "xdelta", & dav_xdelta_provider);
}

module AP_MODULE_DECLARE_DATA dav_xdelta =
{
    STANDARD20_MODULE_STUFF,
    NULL,			     /* dir config creater */
    NULL,			     /* dir merger --- default is to override */
    dav_xdelta_create_server_config, /* server config */
    NULL,                            /* merge server config */
    dav_xdelta_cmds,		     /* command table */
    dav_xdelta_register_hooks,       /* register hooks */
};
