/* -*-Mode: C;-*-
 *
 * Copyright (C) 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el,v 1.11 2001/12/08 03:17:21 jmacd Exp $
 */

#include "edsio.h"

#include "xdelta.h"

#ifndef _XD_EDSIO_H_
#define _XD_EDSIO_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "edsio_edsio.h"

/* Initialize this library. */

gboolean xd_edsio_init (void);

/* Types defined here. */

/* XdStringEventCode.
 */

typedef struct _XdStringEventCode XdStringEventCode;
struct _XdStringEventCode { gint code; };

typedef struct _XdStringEvent XdStringEvent;
struct _XdStringEvent { gint code; const char* srcfile; guint srcline; const char* version; };

/* XdHandleIntIntEventCode.
 */

typedef struct _XdHandleIntIntEventCode XdHandleIntIntEventCode;
struct _XdHandleIntIntEventCode { gint code; };

typedef struct _XdHandleIntIntEvent XdHandleIntIntEvent;
struct _XdHandleIntIntEvent { gint code; const char* srcfile; guint srcline; FileHandle* stream; int expected; int received; };

/* XdHandleStringStringEventCode.
 */

typedef struct _XdHandleStringStringEventCode XdHandleStringStringEventCode;
struct _XdHandleStringStringEventCode { gint code; };

typedef struct _XdHandleStringStringEvent XdHandleStringStringEvent;
struct _XdHandleStringStringEvent { gint code; const char* srcfile; guint srcline; FileHandle* stream; const char* expected; const char* received; };

/* XdIntEventCode.
 */

typedef struct _XdIntEventCode XdIntEventCode;
struct _XdIntEventCode { gint code; };

typedef struct _XdIntEvent XdIntEvent;
struct _XdIntEvent { gint code; const char* srcfile; guint srcline; int index; };

/* XdVoidEventCode.
 */

typedef struct _XdVoidEventCode XdVoidEventCode;
struct _XdVoidEventCode { gint code; };

typedef struct _XdVoidEvent XdVoidEvent;
struct _XdVoidEvent { gint code; const char* srcfile; guint srcline; };

typedef struct _SerialXdeltaInstruction SerialXdeltaInstruction;
typedef struct _SerialXdeltaControl SerialXdeltaControl;
typedef struct _SerialXdeltaChecksum SerialXdeltaChecksum;
/* Functions declared here. */

/* Serial Types */

enum _SerialXdType {

  ST_XdeltaChecksum = (1<<(1+EDSIO_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaControl = (1<<(7+EDSIO_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaInstruction = (1<<(8+EDSIO_LIBRARY_OFFSET_BITS))+3
};



/* XdeltaChecksum Structure
 */

struct _SerialXdeltaChecksum {
  guint16 high;
  guint16 low;
};

void     serializeio_print_xdeltachecksum_obj        (SerialXdeltaChecksum* obj, guint indent_spaces);

gboolean unserialize_xdeltachecksum                  (SerialSource *source, SerialXdeltaChecksum**);
gboolean unserialize_xdeltachecksum_internal         (SerialSource *source, SerialXdeltaChecksum** );
gboolean unserialize_xdeltachecksum_internal_noalloc (SerialSource *source, SerialXdeltaChecksum* );
gboolean serialize_xdeltachecksum                    (SerialSink *sink, guint16 high, guint16 low);
gboolean serialize_xdeltachecksum_obj                (SerialSink *sink, const SerialXdeltaChecksum* obj);
gboolean serialize_xdeltachecksum_internal           (SerialSink *sink, guint16 high, guint16 low);
gboolean serialize_xdeltachecksum_obj_internal (SerialSink *sink, SerialXdeltaChecksum* obj);
guint    serializeio_count_xdeltachecksum            (guint16 high, guint16 low);
guint    serializeio_count_xdeltachecksum_obj        (SerialXdeltaChecksum const* obj);

/* XdeltaControl Structure
 */

struct _SerialXdeltaControl {
  guint32 length;
  guint32 src_types_len;
  guint32* src_types;
  guint32 inst_len;
  SerialXdeltaInstruction* inst;
  GArray    *inst_array;
};

void     serializeio_print_xdeltacontrol_obj        (SerialXdeltaControl* obj, guint indent_spaces);

gboolean unserialize_xdeltacontrol                  (SerialSource *source, SerialXdeltaControl**);
gboolean unserialize_xdeltacontrol_internal         (SerialSource *source, SerialXdeltaControl** );
gboolean unserialize_xdeltacontrol_internal_noalloc (SerialSource *source, SerialXdeltaControl* );
gboolean serialize_xdeltacontrol                    (SerialSink *sink, guint32 length, guint32 src_types_len, guint32 const* src_types, guint32 inst_len, SerialXdeltaInstruction const* inst);
gboolean serialize_xdeltacontrol_obj                (SerialSink *sink, const SerialXdeltaControl* obj);
gboolean serialize_xdeltacontrol_internal           (SerialSink *sink, guint32 length, guint32 src_types_len, guint32 const* src_types, guint32 inst_len, SerialXdeltaInstruction const* inst);
gboolean serialize_xdeltacontrol_obj_internal (SerialSink *sink, SerialXdeltaControl* obj);
guint    serializeio_count_xdeltacontrol            (guint32 length, guint32 src_types_len, guint32 const* src_types, guint32 inst_len, SerialXdeltaInstruction const* inst);
guint    serializeio_count_xdeltacontrol_obj        (SerialXdeltaControl const* obj);

/* XdeltaInstruction Structure
 */

struct _SerialXdeltaInstruction {
  guint32 index;
  guint32 offset;
  guint32 length;
  guint32 output_start;
};

void     serializeio_print_xdeltainstruction_obj        (SerialXdeltaInstruction* obj, guint indent_spaces);

gboolean unserialize_xdeltainstruction                  (SerialSource *source, SerialXdeltaInstruction**);
gboolean unserialize_xdeltainstruction_internal         (SerialSource *source, SerialXdeltaInstruction** );
gboolean unserialize_xdeltainstruction_internal_noalloc (SerialSource *source, SerialXdeltaInstruction* );
gboolean serialize_xdeltainstruction                    (SerialSink *sink, guint32 index, guint32 offset, guint32 length);
gboolean serialize_xdeltainstruction_obj                (SerialSink *sink, const SerialXdeltaInstruction* obj);
gboolean serialize_xdeltainstruction_internal           (SerialSink *sink, guint32 index, guint32 offset, guint32 length);
gboolean serialize_xdeltainstruction_obj_internal (SerialSink *sink, SerialXdeltaInstruction* obj);
guint    serializeio_count_xdeltainstruction            (guint32 index, guint32 offset, guint32 length);
guint    serializeio_count_xdeltainstruction_obj        (SerialXdeltaInstruction const* obj);

void xd_generate_void_event_internal (XdVoidEventCode code, const char* srcfile, gint srcline);
#define xd_generate_void_event(ecode) xd_generate_void_event_internal((ecode),__FILE__,__LINE__)

extern const XdVoidEventCode EC_XdTooFewSources;
#define EC_XdTooFewSourcesValue ((0<<EDSIO_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdTooManySources;
#define EC_XdTooManySourcesValue ((1<<EDSIO_LIBRARY_OFFSET_BITS)+3)

void xd_generate_int_event_internal (XdIntEventCode code, const char* srcfile, gint srcline, int index);
#define xd_generate_int_event(ecode, index) xd_generate_int_event_internal((ecode),__FILE__,__LINE__, (index))

extern const XdIntEventCode EC_XdOutOfRangeSourceIndex;
#define EC_XdOutOfRangeSourceIndexValue ((2<<EDSIO_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdInvalidControl;
#define EC_XdInvalidControlValue ((3<<EDSIO_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdInvalidRsyncCache;
#define EC_XdInvalidRsyncCacheValue ((4<<EDSIO_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdIncompatibleDelta;
#define EC_XdIncompatibleDeltaValue ((5<<EDSIO_LIBRARY_OFFSET_BITS)+3)

void xd_generate_handlestringstring_event_internal (XdHandleStringStringEventCode code, const char* srcfile, gint srcline, FileHandle* stream, const char* expected, const char* received);
#define xd_generate_handlestringstring_event(ecode, stream, expected, received) xd_generate_handlestringstring_event_internal((ecode),__FILE__,__LINE__, (stream), (expected), (received))

extern const XdHandleStringStringEventCode EC_XdStreamChecksumFailed;
#define EC_XdStreamChecksumFailedValue ((6<<EDSIO_LIBRARY_OFFSET_BITS)+3)

void xd_generate_handleintint_event_internal (XdHandleIntIntEventCode code, const char* srcfile, gint srcline, FileHandle* stream, int expected, int received);
#define xd_generate_handleintint_event(ecode, stream, expected, received) xd_generate_handleintint_event_internal((ecode),__FILE__,__LINE__, (stream), (expected), (received))

extern const XdHandleIntIntEventCode EC_XdStreamLengthFailed;
#define EC_XdStreamLengthFailedValue ((7<<EDSIO_LIBRARY_OFFSET_BITS)+3)

void xd_generate_string_event_internal (XdStringEventCode code, const char* srcfile, gint srcline, const char* version);
#define xd_generate_string_event(ecode, version) xd_generate_string_event_internal((ecode),__FILE__,__LINE__, (version))

extern const XdStringEventCode EC_XdBackwardCompatibilityMode;
#define EC_XdBackwardCompatibilityModeValue ((8<<EDSIO_LIBRARY_OFFSET_BITS)+3)

#ifdef __cplusplus
}
#endif

#endif /* _XD_EDSIO_H_ */

