#include "xccom-iface.h"

#include <stdio.h>
#include <xcircuit.h>
#include <prototypes.h>

extern Clientdata areastruct;

float xccom_get_zoom()
{
	return *(areastruct.vscale);
}

void xccom_put_zoom(int type, float value)
{
	XPoint newpos, wpoint;

	newpos = UGetCursorPos();
	user_to_window(newpos, &wpoint);

	switch (type) {
		case 0:	zoomview(NULL, NULL, NULL); break;
		case 1: zoominrefresh(wpoint.x, wpoint.y); break;
		case 2: zoomoutrefresh(wpoint.x, wpoint.y); break;
		case 4:
			{
				float save = areastruct.zoomfactor;
				value /= *areastruct.vscale;
				if (value < 1.0f) {
					areastruct.zoomfactor = 1.0f/value;
					zoomoutrefresh(wpoint.x, wpoint.y);
				} else {
					areastruct.zoomfactor = value;
					zoominrefresh(wpoint.x, wpoint.y);
				}
				areastruct.zoomfactor = save;
				break;
			}
		default: break;
	}
}

extern IXCircuit *xc;

IXCircuit* xccom_get_application()
{
	IXCircuit_AddRef(xc);
	return xc;
}
